/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopGameSessionPlacementRequest extends GameLiftRequest implements
        ToCopyableBuilder<StopGameSessionPlacementRequest.Builder, StopGameSessionPlacementRequest> {
    private static final SdkField<String> PLACEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StopGameSessionPlacementRequest::placementId)).setter(setter(Builder::placementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACEMENT_ID_FIELD));

    private final String placementId;

    private StopGameSessionPlacementRequest(BuilderImpl builder) {
        super(builder);
        this.placementId = builder.placementId;
    }

    /**
     * <p>
     * Unique identifier for a game session placement to cancel.
     * </p>
     * 
     * @return Unique identifier for a game session placement to cancel.
     */
    public String placementId() {
        return placementId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(placementId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopGameSessionPlacementRequest)) {
            return false;
        }
        StopGameSessionPlacementRequest other = (StopGameSessionPlacementRequest) obj;
        return Objects.equals(placementId(), other.placementId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StopGameSessionPlacementRequest").add("PlacementId", placementId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlacementId":
            return Optional.ofNullable(clazz.cast(placementId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopGameSessionPlacementRequest, T> g) {
        return obj -> g.apply((StopGameSessionPlacementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopGameSessionPlacementRequest> {
        /**
         * <p>
         * Unique identifier for a game session placement to cancel.
         * </p>
         * 
         * @param placementId
         *        Unique identifier for a game session placement to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementId(String placementId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String placementId;

        private BuilderImpl() {
        }

        private BuilderImpl(StopGameSessionPlacementRequest model) {
            super(model);
            placementId(model.placementId);
        }

        public final String getPlacementId() {
            return placementId;
        }

        @Override
        public final Builder placementId(String placementId) {
            this.placementId = placementId;
            return this;
        }

        public final void setPlacementId(String placementId) {
            this.placementId = placementId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopGameSessionPlacementRequest build() {
            return new StopGameSessionPlacementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
