/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.gameliftstreams.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.gameliftstreams.model.ExportFilesMetadata;
import software.amazon.awssdk.services.gameliftstreams.model.GameLaunchArgListCopier;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.Protocol;
import software.amazon.awssdk.services.gameliftstreams.model.StreamSessionStatus;
import software.amazon.awssdk.services.gameliftstreams.model.StreamSessionStatusReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStreamSessionResponse
extends GameLiftStreamsResponse
implements ToCopyableBuilder<Builder, GetStreamSessionResponse> {
    private static final SdkField<Map<String, String>> ADDITIONAL_ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalEnvironmentVariables").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::additionalEnvironmentVariables)).setter(GetStreamSessionResponse.setter(Builder::additionalEnvironmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalEnvironmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_LAUNCH_ARGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalLaunchArgs").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::additionalLaunchArgs)).setter(GetStreamSessionResponse.setter(Builder::additionalLaunchArgs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalLaunchArgs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::applicationArn)).setter(GetStreamSessionResponse.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::arn)).setter(GetStreamSessionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Integer> CONNECTION_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConnectionTimeoutSeconds").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::connectionTimeoutSeconds)).setter(GetStreamSessionResponse.setter(Builder::connectionTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTimeoutSeconds").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::createdAt)).setter(GetStreamSessionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::description)).setter(GetStreamSessionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ExportFilesMetadata> EXPORT_FILES_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportFilesMetadata").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::exportFilesMetadata)).setter(GetStreamSessionResponse.setter(Builder::exportFilesMetadata)).constructor(ExportFilesMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFilesMetadata").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::lastUpdatedAt)).setter(GetStreamSessionResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::location)).setter(GetStreamSessionResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<String> LOG_FILE_LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogFileLocationUri").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::logFileLocationUri)).setter(GetStreamSessionResponse.setter(Builder::logFileLocationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFileLocationUri").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::protocolAsString)).setter(GetStreamSessionResponse.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<Integer> SESSION_LENGTH_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionLengthSeconds").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::sessionLengthSeconds)).setter(GetStreamSessionResponse.setter(Builder::sessionLengthSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionLengthSeconds").build()}).build();
    private static final SdkField<String> SIGNAL_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SignalRequest").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::signalRequest)).setter(GetStreamSessionResponse.setter(Builder::signalRequest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalRequest").build()}).build();
    private static final SdkField<String> SIGNAL_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SignalResponse").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::signalResponse)).setter(GetStreamSessionResponse.setter(Builder::signalResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalResponse").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::statusAsString)).setter(GetStreamSessionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::statusReasonAsString)).setter(GetStreamSessionResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> STREAM_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamGroupId").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::streamGroupId)).setter(GetStreamSessionResponse.setter(Builder::streamGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamGroupId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::userId)).setter(GetStreamSessionResponse.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> WEB_SDK_PROTOCOL_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebSdkProtocolUrl").getter(GetStreamSessionResponse.getter(GetStreamSessionResponse::webSdkProtocolUrl)).setter(GetStreamSessionResponse.setter(Builder::webSdkProtocolUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebSdkProtocolUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ENVIRONMENT_VARIABLES_FIELD, ADDITIONAL_LAUNCH_ARGS_FIELD, APPLICATION_ARN_FIELD, ARN_FIELD, CONNECTION_TIMEOUT_SECONDS_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, EXPORT_FILES_METADATA_FIELD, LAST_UPDATED_AT_FIELD, LOCATION_FIELD, LOG_FILE_LOCATION_URI_FIELD, PROTOCOL_FIELD, SESSION_LENGTH_SECONDS_FIELD, SIGNAL_REQUEST_FIELD, SIGNAL_RESPONSE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, STREAM_GROUP_ID_FIELD, USER_ID_FIELD, WEB_SDK_PROTOCOL_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetStreamSessionResponse.memberNameToFieldInitializer();
    private final Map<String, String> additionalEnvironmentVariables;
    private final List<String> additionalLaunchArgs;
    private final String applicationArn;
    private final String arn;
    private final Integer connectionTimeoutSeconds;
    private final Instant createdAt;
    private final String description;
    private final ExportFilesMetadata exportFilesMetadata;
    private final Instant lastUpdatedAt;
    private final String location;
    private final String logFileLocationUri;
    private final String protocol;
    private final Integer sessionLengthSeconds;
    private final String signalRequest;
    private final String signalResponse;
    private final String status;
    private final String statusReason;
    private final String streamGroupId;
    private final String userId;
    private final String webSdkProtocolUrl;

    private GetStreamSessionResponse(BuilderImpl builder) {
        super(builder);
        this.additionalEnvironmentVariables = builder.additionalEnvironmentVariables;
        this.additionalLaunchArgs = builder.additionalLaunchArgs;
        this.applicationArn = builder.applicationArn;
        this.arn = builder.arn;
        this.connectionTimeoutSeconds = builder.connectionTimeoutSeconds;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.exportFilesMetadata = builder.exportFilesMetadata;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.location = builder.location;
        this.logFileLocationUri = builder.logFileLocationUri;
        this.protocol = builder.protocol;
        this.sessionLengthSeconds = builder.sessionLengthSeconds;
        this.signalRequest = builder.signalRequest;
        this.signalResponse = builder.signalResponse;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.streamGroupId = builder.streamGroupId;
        this.userId = builder.userId;
        this.webSdkProtocolUrl = builder.webSdkProtocolUrl;
    }

    public final boolean hasAdditionalEnvironmentVariables() {
        return this.additionalEnvironmentVariables != null && !(this.additionalEnvironmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalEnvironmentVariables() {
        return this.additionalEnvironmentVariables;
    }

    public final boolean hasAdditionalLaunchArgs() {
        return this.additionalLaunchArgs != null && !(this.additionalLaunchArgs instanceof SdkAutoConstructList);
    }

    public final List<String> additionalLaunchArgs() {
        return this.additionalLaunchArgs;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final String arn() {
        return this.arn;
    }

    public final Integer connectionTimeoutSeconds() {
        return this.connectionTimeoutSeconds;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final ExportFilesMetadata exportFilesMetadata() {
        return this.exportFilesMetadata;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String location() {
        return this.location;
    }

    public final String logFileLocationUri() {
        return this.logFileLocationUri;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Integer sessionLengthSeconds() {
        return this.sessionLengthSeconds;
    }

    public final String signalRequest() {
        return this.signalRequest;
    }

    public final String signalResponse() {
        return this.signalResponse;
    }

    public final StreamSessionStatus status() {
        return StreamSessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final StreamSessionStatusReason statusReason() {
        return StreamSessionStatusReason.fromValue(this.statusReason);
    }

    public final String statusReasonAsString() {
        return this.statusReason;
    }

    public final String streamGroupId() {
        return this.streamGroupId;
    }

    public final String userId() {
        return this.userId;
    }

    public final String webSdkProtocolUrl() {
        return this.webSdkProtocolUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalEnvironmentVariables() ? this.additionalEnvironmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalLaunchArgs() ? this.additionalLaunchArgs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportFilesMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFileLocationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionLengthSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.webSdkProtocolUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamSessionResponse)) {
            return false;
        }
        GetStreamSessionResponse other = (GetStreamSessionResponse)((Object)obj);
        return this.hasAdditionalEnvironmentVariables() == other.hasAdditionalEnvironmentVariables() && Objects.equals(this.additionalEnvironmentVariables(), other.additionalEnvironmentVariables()) && this.hasAdditionalLaunchArgs() == other.hasAdditionalLaunchArgs() && Objects.equals(this.additionalLaunchArgs(), other.additionalLaunchArgs()) && Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.connectionTimeoutSeconds(), other.connectionTimeoutSeconds()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.exportFilesMetadata(), other.exportFilesMetadata()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.logFileLocationUri(), other.logFileLocationUri()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.sessionLengthSeconds(), other.sessionLengthSeconds()) && Objects.equals(this.signalRequest(), other.signalRequest()) && Objects.equals(this.signalResponse(), other.signalResponse()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReasonAsString(), other.statusReasonAsString()) && Objects.equals(this.streamGroupId(), other.streamGroupId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.webSdkProtocolUrl(), other.webSdkProtocolUrl());
    }

    public final String toString() {
        return ToString.builder((String)"GetStreamSessionResponse").add("AdditionalEnvironmentVariables", this.hasAdditionalEnvironmentVariables() ? this.additionalEnvironmentVariables() : null).add("AdditionalLaunchArgs", this.hasAdditionalLaunchArgs() ? this.additionalLaunchArgs() : null).add("ApplicationArn", (Object)this.applicationArn()).add("Arn", (Object)this.arn()).add("ConnectionTimeoutSeconds", (Object)this.connectionTimeoutSeconds()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("ExportFilesMetadata", (Object)this.exportFilesMetadata()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Location", (Object)this.location()).add("LogFileLocationUri", (Object)this.logFileLocationUri()).add("Protocol", (Object)this.protocolAsString()).add("SessionLengthSeconds", (Object)this.sessionLengthSeconds()).add("SignalRequest", (Object)(this.signalRequest() == null ? null : "*** Sensitive Data Redacted ***")).add("SignalResponse", (Object)(this.signalResponse() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReasonAsString()).add("StreamGroupId", (Object)this.streamGroupId()).add("UserId", (Object)this.userId()).add("WebSdkProtocolUrl", (Object)this.webSdkProtocolUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalEnvironmentVariables": {
                return Optional.ofNullable(clazz.cast(this.additionalEnvironmentVariables()));
            }
            case "AdditionalLaunchArgs": {
                return Optional.ofNullable(clazz.cast(this.additionalLaunchArgs()));
            }
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ConnectionTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.connectionTimeoutSeconds()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ExportFilesMetadata": {
                return Optional.ofNullable(clazz.cast(this.exportFilesMetadata()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "LogFileLocationUri": {
                return Optional.ofNullable(clazz.cast(this.logFileLocationUri()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "SessionLengthSeconds": {
                return Optional.ofNullable(clazz.cast(this.sessionLengthSeconds()));
            }
            case "SignalRequest": {
                return Optional.ofNullable(clazz.cast(this.signalRequest()));
            }
            case "SignalResponse": {
                return Optional.ofNullable(clazz.cast(this.signalResponse()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReasonAsString()));
            }
            case "StreamGroupId": {
                return Optional.ofNullable(clazz.cast(this.streamGroupId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "WebSdkProtocolUrl": {
                return Optional.ofNullable(clazz.cast(this.webSdkProtocolUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AdditionalEnvironmentVariables", ADDITIONAL_ENVIRONMENT_VARIABLES_FIELD);
        map.put("AdditionalLaunchArgs", ADDITIONAL_LAUNCH_ARGS_FIELD);
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("ConnectionTimeoutSeconds", CONNECTION_TIMEOUT_SECONDS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ExportFilesMetadata", EXPORT_FILES_METADATA_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("LogFileLocationUri", LOG_FILE_LOCATION_URI_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("SessionLengthSeconds", SESSION_LENGTH_SECONDS_FIELD);
        map.put("SignalRequest", SIGNAL_REQUEST_FIELD);
        map.put("SignalResponse", SIGNAL_RESPONSE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("StreamGroupId", STREAM_GROUP_ID_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("WebSdkProtocolUrl", WEB_SDK_PROTOCOL_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStreamSessionResponse, T> g) {
        return obj -> g.apply((GetStreamSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftStreamsResponse.BuilderImpl
    implements Builder {
        private Map<String, String> additionalEnvironmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private List<String> additionalLaunchArgs = DefaultSdkAutoConstructList.getInstance();
        private String applicationArn;
        private String arn;
        private Integer connectionTimeoutSeconds;
        private Instant createdAt;
        private String description;
        private ExportFilesMetadata exportFilesMetadata;
        private Instant lastUpdatedAt;
        private String location;
        private String logFileLocationUri;
        private String protocol;
        private Integer sessionLengthSeconds;
        private String signalRequest;
        private String signalResponse;
        private String status;
        private String statusReason;
        private String streamGroupId;
        private String userId;
        private String webSdkProtocolUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamSessionResponse model) {
            super(model);
            this.additionalEnvironmentVariables(model.additionalEnvironmentVariables);
            this.additionalLaunchArgs(model.additionalLaunchArgs);
            this.applicationArn(model.applicationArn);
            this.arn(model.arn);
            this.connectionTimeoutSeconds(model.connectionTimeoutSeconds);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.exportFilesMetadata(model.exportFilesMetadata);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.location(model.location);
            this.logFileLocationUri(model.logFileLocationUri);
            this.protocol(model.protocol);
            this.sessionLengthSeconds(model.sessionLengthSeconds);
            this.signalRequest(model.signalRequest);
            this.signalResponse(model.signalResponse);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.streamGroupId(model.streamGroupId);
            this.userId(model.userId);
            this.webSdkProtocolUrl(model.webSdkProtocolUrl);
        }

        public final Map<String, String> getAdditionalEnvironmentVariables() {
            if (this.additionalEnvironmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalEnvironmentVariables;
        }

        public final void setAdditionalEnvironmentVariables(Map<String, String> additionalEnvironmentVariables) {
            this.additionalEnvironmentVariables = EnvironmentVariablesCopier.copy(additionalEnvironmentVariables);
        }

        @Override
        public final Builder additionalEnvironmentVariables(Map<String, String> additionalEnvironmentVariables) {
            this.additionalEnvironmentVariables = EnvironmentVariablesCopier.copy(additionalEnvironmentVariables);
            return this;
        }

        public final Collection<String> getAdditionalLaunchArgs() {
            if (this.additionalLaunchArgs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalLaunchArgs;
        }

        public final void setAdditionalLaunchArgs(Collection<String> additionalLaunchArgs) {
            this.additionalLaunchArgs = GameLaunchArgListCopier.copy(additionalLaunchArgs);
        }

        @Override
        public final Builder additionalLaunchArgs(Collection<String> additionalLaunchArgs) {
            this.additionalLaunchArgs = GameLaunchArgListCopier.copy(additionalLaunchArgs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLaunchArgs(String ... additionalLaunchArgs) {
            this.additionalLaunchArgs(Arrays.asList(additionalLaunchArgs));
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getConnectionTimeoutSeconds() {
            return this.connectionTimeoutSeconds;
        }

        public final void setConnectionTimeoutSeconds(Integer connectionTimeoutSeconds) {
            this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        }

        @Override
        public final Builder connectionTimeoutSeconds(Integer connectionTimeoutSeconds) {
            this.connectionTimeoutSeconds = connectionTimeoutSeconds;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ExportFilesMetadata.Builder getExportFilesMetadata() {
            return this.exportFilesMetadata != null ? this.exportFilesMetadata.toBuilder() : null;
        }

        public final void setExportFilesMetadata(ExportFilesMetadata.BuilderImpl exportFilesMetadata) {
            this.exportFilesMetadata = exportFilesMetadata != null ? exportFilesMetadata.build() : null;
        }

        @Override
        public final Builder exportFilesMetadata(ExportFilesMetadata exportFilesMetadata) {
            this.exportFilesMetadata = exportFilesMetadata;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getLogFileLocationUri() {
            return this.logFileLocationUri;
        }

        public final void setLogFileLocationUri(String logFileLocationUri) {
            this.logFileLocationUri = logFileLocationUri;
        }

        @Override
        public final Builder logFileLocationUri(String logFileLocationUri) {
            this.logFileLocationUri = logFileLocationUri;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getSessionLengthSeconds() {
            return this.sessionLengthSeconds;
        }

        public final void setSessionLengthSeconds(Integer sessionLengthSeconds) {
            this.sessionLengthSeconds = sessionLengthSeconds;
        }

        @Override
        public final Builder sessionLengthSeconds(Integer sessionLengthSeconds) {
            this.sessionLengthSeconds = sessionLengthSeconds;
            return this;
        }

        public final String getSignalRequest() {
            return this.signalRequest;
        }

        public final void setSignalRequest(String signalRequest) {
            this.signalRequest = signalRequest;
        }

        @Override
        public final Builder signalRequest(String signalRequest) {
            this.signalRequest = signalRequest;
            return this;
        }

        public final String getSignalResponse() {
            return this.signalResponse;
        }

        public final void setSignalResponse(String signalResponse) {
            this.signalResponse = signalResponse;
        }

        @Override
        public final Builder signalResponse(String signalResponse) {
            this.signalResponse = signalResponse;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(StreamSessionStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final String getStreamGroupId() {
            return this.streamGroupId;
        }

        public final void setStreamGroupId(String streamGroupId) {
            this.streamGroupId = streamGroupId;
        }

        @Override
        public final Builder streamGroupId(String streamGroupId) {
            this.streamGroupId = streamGroupId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getWebSdkProtocolUrl() {
            return this.webSdkProtocolUrl;
        }

        public final void setWebSdkProtocolUrl(String webSdkProtocolUrl) {
            this.webSdkProtocolUrl = webSdkProtocolUrl;
        }

        @Override
        public final Builder webSdkProtocolUrl(String webSdkProtocolUrl) {
            this.webSdkProtocolUrl = webSdkProtocolUrl;
            return this;
        }

        @Override
        public GetStreamSessionResponse build() {
            return new GetStreamSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftStreamsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStreamSessionResponse> {
        public Builder additionalEnvironmentVariables(Map<String, String> var1);

        public Builder additionalLaunchArgs(Collection<String> var1);

        public Builder additionalLaunchArgs(String ... var1);

        public Builder applicationArn(String var1);

        public Builder arn(String var1);

        public Builder connectionTimeoutSeconds(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder exportFilesMetadata(ExportFilesMetadata var1);

        default public Builder exportFilesMetadata(Consumer<ExportFilesMetadata.Builder> exportFilesMetadata) {
            return this.exportFilesMetadata((ExportFilesMetadata)((ExportFilesMetadata.Builder)ExportFilesMetadata.builder().applyMutation(exportFilesMetadata)).build());
        }

        public Builder lastUpdatedAt(Instant var1);

        public Builder location(String var1);

        public Builder logFileLocationUri(String var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder sessionLengthSeconds(Integer var1);

        public Builder signalRequest(String var1);

        public Builder signalResponse(String var1);

        public Builder status(String var1);

        public Builder status(StreamSessionStatus var1);

        public Builder statusReason(String var1);

        public Builder statusReason(StreamSessionStatusReason var1);

        public Builder streamGroupId(String var1);

        public Builder userId(String var1);

        public Builder webSdkProtocolUrl(String var1);
    }
}

