/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.LocationState;
import software.amazon.awssdk.services.gameliftstreams.model.LocationStatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddStreamGroupLocationsResponse
extends GameLiftStreamsResponse
implements ToCopyableBuilder<Builder, AddStreamGroupLocationsResponse> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(AddStreamGroupLocationsResponse.getter(AddStreamGroupLocationsResponse::identifier)).setter(AddStreamGroupLocationsResponse.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<List<LocationState>> LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Locations").getter(AddStreamGroupLocationsResponse.getter(AddStreamGroupLocationsResponse::locations)).setter(AddStreamGroupLocationsResponse.setter(Builder::locations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, LOCATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddStreamGroupLocationsResponse.memberNameToFieldInitializer();
    private final String identifier;
    private final List<LocationState> locations;

    private AddStreamGroupLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.locations = builder.locations;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final boolean hasLocations() {
        return this.locations != null && !(this.locations instanceof SdkAutoConstructList);
    }

    public final List<LocationState> locations() {
        return this.locations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocations() ? this.locations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddStreamGroupLocationsResponse)) {
            return false;
        }
        AddStreamGroupLocationsResponse other = (AddStreamGroupLocationsResponse)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && this.hasLocations() == other.hasLocations() && Objects.equals(this.locations(), other.locations());
    }

    public final String toString() {
        return ToString.builder((String)"AddStreamGroupLocationsResponse").add("Identifier", (Object)this.identifier()).add("Locations", this.hasLocations() ? this.locations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Locations": {
                return Optional.ofNullable(clazz.cast(this.locations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Locations", LOCATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddStreamGroupLocationsResponse, T> g) {
        return obj -> g.apply((AddStreamGroupLocationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftStreamsResponse.BuilderImpl
    implements Builder {
        private String identifier;
        private List<LocationState> locations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddStreamGroupLocationsResponse model) {
            super(model);
            this.identifier(model.identifier);
            this.locations(model.locations);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final List<LocationState.Builder> getLocations() {
            List<LocationState.Builder> result = LocationStatesCopier.copyToBuilder(this.locations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocations(Collection<LocationState.BuilderImpl> locations) {
            this.locations = LocationStatesCopier.copyFromBuilder(locations);
        }

        @Override
        public final Builder locations(Collection<LocationState> locations) {
            this.locations = LocationStatesCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(LocationState ... locations) {
            this.locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Consumer<LocationState.Builder> ... locations) {
            this.locations(Stream.of(locations).map(c -> (LocationState)((LocationState.Builder)LocationState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AddStreamGroupLocationsResponse build() {
            return new AddStreamGroupLocationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftStreamsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddStreamGroupLocationsResponse> {
        public Builder identifier(String var1);

        public Builder locations(Collection<LocationState> var1);

        public Builder locations(LocationState ... var1);

        public Builder locations(Consumer<LocationState.Builder> ... var1);
    }
}

