/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddStreamGroupLocationsResponse extends GameLiftStreamsResponse implements
        ToCopyableBuilder<AddStreamGroupLocationsResponse.Builder, AddStreamGroupLocationsResponse> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(AddStreamGroupLocationsResponse::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<List<LocationState>> LOCATIONS_FIELD = SdkField
            .<List<LocationState>> builder(MarshallingType.LIST)
            .memberName("Locations")
            .getter(getter(AddStreamGroupLocationsResponse::locations))
            .setter(setter(Builder::locations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocationState> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocationState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            LOCATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final List<LocationState> locations;

    private AddStreamGroupLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.locations = builder.locations;
    }

    /**
     * <p>
     * This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource
     * Name (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
     * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
     * <code>sg-1AB2C3De4</code>.
     * </p>
     * 
     * @return This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
     *         Resource Name (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
     *         <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
     *         <code>sg-1AB2C3De4</code>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Locations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLocations() {
        return locations != null && !(locations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This value is set of locations, including their name, current status, and capacities.
     * </p>
     * <p>
     * A location can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale the
     * capacity of, or remove this location yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale the
     * capacity of, or remove this location.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code> field
     * describes the error. You can remove this location and try to add it again.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
     * provisioned capacity for this location in this stream group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocations} method.
     * </p>
     * 
     * @return This value is set of locations, including their name, current status, and capacities. </p>
     *         <p>
     *         A location can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale
     *         the capacity of, or remove this location yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale
     *         the capacity of, or remove this location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code>
     *         field describes the error. You can remove this location and try to add it again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
     *         provisioned capacity for this location in this stream group.
     *         </p>
     *         </li>
     */
    public final List<LocationState> locations() {
        return locations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocations() ? locations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddStreamGroupLocationsResponse)) {
            return false;
        }
        AddStreamGroupLocationsResponse other = (AddStreamGroupLocationsResponse) obj;
        return Objects.equals(identifier(), other.identifier()) && hasLocations() == other.hasLocations()
                && Objects.equals(locations(), other.locations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddStreamGroupLocationsResponse").add("Identifier", identifier())
                .add("Locations", hasLocations() ? locations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Locations":
            return Optional.ofNullable(clazz.cast(locations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Locations", LOCATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddStreamGroupLocationsResponse, T> g) {
        return obj -> g.apply((AddStreamGroupLocationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftStreamsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AddStreamGroupLocationsResponse> {
        /**
         * <p>
         * This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
         * Resource Name (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
         * <code>sg-1AB2C3De4</code>.
         * </p>
         * 
         * @param identifier
         *        This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
         *        Resource Name (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
         *        <code>sg-1AB2C3De4</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * This value is set of locations, including their name, current status, and capacities.
         * </p>
         * <p>
         * A location can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale the
         * capacity of, or remove this location yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale the
         * capacity of, or remove this location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code>
         * field describes the error. You can remove this location and try to add it again.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
         * provisioned capacity for this location in this stream group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param locations
         *        This value is set of locations, including their name, current status, and capacities. </p>
         *        <p>
         *        A location can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from,
         *        scale the capacity of, or remove this location yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale
         *        the capacity of, or remove this location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The
         *        <code>StatusReason</code> field describes the error. You can remove this location and try to add it
         *        again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release
         *        all provisioned capacity for this location in this stream group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(Collection<LocationState> locations);

        /**
         * <p>
         * This value is set of locations, including their name, current status, and capacities.
         * </p>
         * <p>
         * A location can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale the
         * capacity of, or remove this location yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale the
         * capacity of, or remove this location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code>
         * field describes the error. You can remove this location and try to add it again.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
         * provisioned capacity for this location in this stream group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param locations
         *        This value is set of locations, including their name, current status, and capacities. </p>
         *        <p>
         *        A location can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from,
         *        scale the capacity of, or remove this location yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale
         *        the capacity of, or remove this location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The
         *        <code>StatusReason</code> field describes the error. You can remove this location and try to add it
         *        again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release
         *        all provisioned capacity for this location in this stream group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(LocationState... locations);

        /**
         * <p>
         * This value is set of locations, including their name, current status, and capacities.
         * </p>
         * <p>
         * A location can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale the
         * capacity of, or remove this location yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale the
         * capacity of, or remove this location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code>
         * field describes the error. You can remove this location and try to add it again.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
         * provisioned capacity for this location in this stream group.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gameliftstreams.model.LocationState.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.gameliftstreams.model.LocationState#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gameliftstreams.model.LocationState.Builder#build()} is called
         * immediately and its result is passed to {@link #locations(List<LocationState>)}.
         * 
         * @param locations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gameliftstreams.model.LocationState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locations(java.util.Collection<LocationState>)
         */
        Builder locations(Consumer<LocationState.Builder>... locations);
    }

    static final class BuilderImpl extends GameLiftStreamsResponse.BuilderImpl implements Builder {
        private String identifier;

        private List<LocationState> locations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddStreamGroupLocationsResponse model) {
            super(model);
            identifier(model.identifier);
            locations(model.locations);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final List<LocationState.Builder> getLocations() {
            List<LocationState.Builder> result = LocationStatesCopier.copyToBuilder(this.locations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocations(Collection<LocationState.BuilderImpl> locations) {
            this.locations = LocationStatesCopier.copyFromBuilder(locations);
        }

        @Override
        public final Builder locations(Collection<LocationState> locations) {
            this.locations = LocationStatesCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(LocationState... locations) {
            locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Consumer<LocationState.Builder>... locations) {
            locations(Stream.of(locations).map(c -> LocationState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AddStreamGroupLocationsResponse build() {
            return new AddStreamGroupLocationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
