/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamSessionConnectionRequest extends GameLiftStreamsRequest implements
        ToCopyableBuilder<CreateStreamSessionConnectionRequest.Builder, CreateStreamSessionConnectionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateStreamSessionConnectionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(CreateStreamSessionConnectionRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<String> STREAM_SESSION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamSessionIdentifier").getter(getter(CreateStreamSessionConnectionRequest::streamSessionIdentifier))
            .setter(setter(Builder::streamSessionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("StreamSessionIdentifier").build())
            .build();

    private static final SdkField<String> SIGNAL_REQUEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SignalRequest").getter(getter(CreateStreamSessionConnectionRequest::signalRequest))
            .setter(setter(Builder::signalRequest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalRequest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            IDENTIFIER_FIELD, STREAM_SESSION_IDENTIFIER_FIELD, SIGNAL_REQUEST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String identifier;

    private final String streamSessionIdentifier;

    private final String signalRequest;

    private CreateStreamSessionConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.identifier = builder.identifier;
        this.streamSessionIdentifier = builder.streamSessionIdentifier;
        this.signalRequest = builder.signalRequest;
    }

    /**
     * <p>
     * A unique identifier that represents a client request. The request is idempotent, which ensures that an API
     * request completes only once. When users send a request, Amazon GameLift Streams automatically populates this
     * field.
     * </p>
     * 
     * @return A unique identifier that represents a client request. The request is idempotent, which ensures that an
     *         API request completes only once. When users send a request, Amazon GameLift Streams automatically
     *         populates this field.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a> or
     * ID that uniquely identifies the stream group resource. Example ARN:
     * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
     * <code>sg-1AB2C3De4</code>.
     * </p>
     * <p>
     * The stream group that you want to run this stream session with. The stream group must be in <code>ACTIVE</code>
     * status.
     * </p>
     * 
     * @return <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
     *         (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
     *         <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
     *         <code>sg-1AB2C3De4</code>. </p>
     *         <p>
     *         The stream group that you want to run this stream session with. The stream group must be in
     *         <code>ACTIVE</code> status.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a> or
     * ID that uniquely identifies the stream session resource. Example ARN:
     * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamsession/sg-1AB2C3De4/ABC123def4567</code>. Example ID:
     * <code>ABC123def4567</code>.
     * </p>
     * <p>
     * The stream session must be in <code>PENDING_CLIENT_RECONNECTION</code> or <code>ACTIVE</code> status.
     * </p>
     * 
     * @return <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
     *         (ARN)</a> or ID that uniquely identifies the stream session resource. Example ARN:
     *         <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamsession/sg-1AB2C3De4/ABC123def4567</code>.
     *         Example ID: <code>ABC123def4567</code>. </p>
     *         <p>
     *         The stream session must be in <code>PENDING_CLIENT_RECONNECTION</code> or <code>ACTIVE</code> status.
     */
    public final String streamSessionIdentifier() {
        return streamSessionIdentifier;
    }

    /**
     * <p>
     * A WebRTC ICE offer string to use when initializing a WebRTC connection. The offer is a very long JSON string.
     * Provide the string as a text value in quotes. The offer must be newly generated, not the same offer provided to
     * <code>StartStreamSession</code>.
     * </p>
     * 
     * @return A WebRTC ICE offer string to use when initializing a WebRTC connection. The offer is a very long JSON
     *         string. Provide the string as a text value in quotes. The offer must be newly generated, not the same
     *         offer provided to <code>StartStreamSession</code>.
     */
    public final String signalRequest() {
        return signalRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(streamSessionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(signalRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamSessionConnectionRequest)) {
            return false;
        }
        CreateStreamSessionConnectionRequest other = (CreateStreamSessionConnectionRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(streamSessionIdentifier(), other.streamSessionIdentifier())
                && Objects.equals(signalRequest(), other.signalRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStreamSessionConnectionRequest").add("ClientToken", clientToken())
                .add("Identifier", identifier()).add("StreamSessionIdentifier", streamSessionIdentifier())
                .add("SignalRequest", signalRequest() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "StreamSessionIdentifier":
            return Optional.ofNullable(clazz.cast(streamSessionIdentifier()));
        case "SignalRequest":
            return Optional.ofNullable(clazz.cast(signalRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("StreamSessionIdentifier", STREAM_SESSION_IDENTIFIER_FIELD);
        map.put("SignalRequest", SIGNAL_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamSessionConnectionRequest, T> g) {
        return obj -> g.apply((CreateStreamSessionConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftStreamsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateStreamSessionConnectionRequest> {
        /**
         * <p>
         * A unique identifier that represents a client request. The request is idempotent, which ensures that an API
         * request completes only once. When users send a request, Amazon GameLift Streams automatically populates this
         * field.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier that represents a client request. The request is idempotent, which ensures that an
         *        API request completes only once. When users send a request, Amazon GameLift Streams automatically
         *        populates this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a>
         * or ID that uniquely identifies the stream group resource. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
         * <code>sg-1AB2C3De4</code>.
         * </p>
         * <p>
         * The stream group that you want to run this stream session with. The stream group must be in
         * <code>ACTIVE</code> status.
         * </p>
         * 
         * @param identifier
         *        <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
         *        (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
         *        <code>sg-1AB2C3De4</code>. </p>
         *        <p>
         *        The stream group that you want to run this stream session with. The stream group must be in
         *        <code>ACTIVE</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a>
         * or ID that uniquely identifies the stream session resource. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamsession/sg-1AB2C3De4/ABC123def4567</code>. Example
         * ID: <code>ABC123def4567</code>.
         * </p>
         * <p>
         * The stream session must be in <code>PENDING_CLIENT_RECONNECTION</code> or <code>ACTIVE</code> status.
         * </p>
         * 
         * @param streamSessionIdentifier
         *        <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
         *        (ARN)</a> or ID that uniquely identifies the stream session resource. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamsession/sg-1AB2C3De4/ABC123def4567</code>.
         *        Example ID: <code>ABC123def4567</code>. </p>
         *        <p>
         *        The stream session must be in <code>PENDING_CLIENT_RECONNECTION</code> or <code>ACTIVE</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSessionIdentifier(String streamSessionIdentifier);

        /**
         * <p>
         * A WebRTC ICE offer string to use when initializing a WebRTC connection. The offer is a very long JSON string.
         * Provide the string as a text value in quotes. The offer must be newly generated, not the same offer provided
         * to <code>StartStreamSession</code>.
         * </p>
         * 
         * @param signalRequest
         *        A WebRTC ICE offer string to use when initializing a WebRTC connection. The offer is a very long JSON
         *        string. Provide the string as a text value in quotes. The offer must be newly generated, not the same
         *        offer provided to <code>StartStreamSession</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalRequest(String signalRequest);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftStreamsRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String identifier;

        private String streamSessionIdentifier;

        private String signalRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamSessionConnectionRequest model) {
            super(model);
            clientToken(model.clientToken);
            identifier(model.identifier);
            streamSessionIdentifier(model.streamSessionIdentifier);
            signalRequest(model.signalRequest);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getStreamSessionIdentifier() {
            return streamSessionIdentifier;
        }

        public final void setStreamSessionIdentifier(String streamSessionIdentifier) {
            this.streamSessionIdentifier = streamSessionIdentifier;
        }

        @Override
        public final Builder streamSessionIdentifier(String streamSessionIdentifier) {
            this.streamSessionIdentifier = streamSessionIdentifier;
            return this;
        }

        public final String getSignalRequest() {
            return signalRequest;
        }

        public final void setSignalRequest(String signalRequest) {
            this.signalRequest = signalRequest;
        }

        @Override
        public final Builder signalRequest(String signalRequest) {
            this.signalRequest = signalRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamSessionConnectionRequest build() {
            return new CreateStreamSessionConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
