/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamSessionConnectionResponse extends GameLiftStreamsResponse implements
        ToCopyableBuilder<CreateStreamSessionConnectionResponse.Builder, CreateStreamSessionConnectionResponse> {
    private static final SdkField<String> SIGNAL_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SignalResponse").getter(getter(CreateStreamSessionConnectionResponse::signalResponse))
            .setter(setter(Builder::signalResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNAL_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String signalResponse;

    private CreateStreamSessionConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.signalResponse = builder.signalResponse;
    }

    /**
     * <p>
     * The WebRTC answer string that the stream server generates in response to the <code>SignalRequest</code>.
     * </p>
     * 
     * @return The WebRTC answer string that the stream server generates in response to the <code>SignalRequest</code>.
     */
    public final String signalResponse() {
        return signalResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(signalResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamSessionConnectionResponse)) {
            return false;
        }
        CreateStreamSessionConnectionResponse other = (CreateStreamSessionConnectionResponse) obj;
        return Objects.equals(signalResponse(), other.signalResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStreamSessionConnectionResponse")
                .add("SignalResponse", signalResponse() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SignalResponse":
            return Optional.ofNullable(clazz.cast(signalResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SignalResponse", SIGNAL_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamSessionConnectionResponse, T> g) {
        return obj -> g.apply((CreateStreamSessionConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftStreamsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateStreamSessionConnectionResponse> {
        /**
         * <p>
         * The WebRTC answer string that the stream server generates in response to the <code>SignalRequest</code>.
         * </p>
         * 
         * @param signalResponse
         *        The WebRTC answer string that the stream server generates in response to the
         *        <code>SignalRequest</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalResponse(String signalResponse);
    }

    static final class BuilderImpl extends GameLiftStreamsResponse.BuilderImpl implements Builder {
        private String signalResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamSessionConnectionResponse model) {
            super(model);
            signalResponse(model.signalResponse);
        }

        public final String getSignalResponse() {
            return signalResponse;
        }

        public final void setSignalResponse(String signalResponse) {
            this.signalResponse = signalResponse;
        }

        @Override
        public final Builder signalResponse(String signalResponse) {
            this.signalResponse = signalResponse;
            return this;
        }

        @Override
        public CreateStreamSessionConnectionResponse build() {
            return new CreateStreamSessionConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
