/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the stream session's exported files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportFilesMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportFilesMetadata.Builder, ExportFilesMetadata> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ExportFilesMetadata::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(ExportFilesMetadata::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<String> OUTPUT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputUri").getter(getter(ExportFilesMetadata::outputUri)).setter(setter(Builder::outputUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_REASON_FIELD, OUTPUT_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String statusReason;

    private final String outputUri;

    private ExportFilesMetadata(BuilderImpl builder) {
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.outputUri = builder.outputUri;
    }

    /**
     * <p>
     * The result of the <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ExportStreamSessionFiles.html"
     * >ExportStreamSessionFiles</a> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExportFilesStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The result of the <a
     *         href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ExportStreamSessionFiles.html"
     *         >ExportStreamSessionFiles</a> operation.
     * @see ExportFilesStatus
     */
    public final ExportFilesStatus status() {
        return ExportFilesStatus.fromValue(status);
    }

    /**
     * <p>
     * The result of the <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ExportStreamSessionFiles.html"
     * >ExportStreamSessionFiles</a> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExportFilesStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The result of the <a
     *         href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ExportStreamSessionFiles.html"
     *         >ExportStreamSessionFiles</a> operation.
     * @see ExportFilesStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A short description of the reason the export is in <code>FAILED</code> status.
     * </p>
     * 
     * @return A short description of the reason the export is in <code>FAILED</code> status.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The S3 bucket URI where Amazon GameLift Streams uploaded the set of compressed exported files for a stream
     * session. Amazon GameLift Streams generates a ZIP file name based on the stream session metadata. Alternatively,
     * you can provide a custom file name with a <code>.zip</code> file extension.
     * </p>
     * <p>
     * Example 1: If you provide an S3 URI called <code>s3://amzn-s3-demo-destination-bucket/MyGame_Session1.zip</code>,
     * then Amazon GameLift Streams will save the files at that location.
     * </p>
     * <p>
     * Example 2: If you provide an S3 URI called
     * <code>s3://amzn-s3-demo-destination-bucket/MyGameSessions_ExportedFiles/</code>, then Amazon GameLift Streams
     * will save the files at
     * <code>s3://amzn-s3-demo-destination-bucket/MyGameSessions_ExportedFiles/YYYYMMDD-HHMMSS-appId-sg-Id-sessionId.zip</code>
     * or another similar name.
     * </p>
     * 
     * @return The S3 bucket URI where Amazon GameLift Streams uploaded the set of compressed exported files for a
     *         stream session. Amazon GameLift Streams generates a ZIP file name based on the stream session metadata.
     *         Alternatively, you can provide a custom file name with a <code>.zip</code> file extension.</p>
     *         <p>
     *         Example 1: If you provide an S3 URI called
     *         <code>s3://amzn-s3-demo-destination-bucket/MyGame_Session1.zip</code>, then Amazon GameLift Streams will
     *         save the files at that location.
     *         </p>
     *         <p>
     *         Example 2: If you provide an S3 URI called
     *         <code>s3://amzn-s3-demo-destination-bucket/MyGameSessions_ExportedFiles/</code>, then Amazon GameLift
     *         Streams will save the files at
     *         <code>s3://amzn-s3-demo-destination-bucket/MyGameSessions_ExportedFiles/YYYYMMDD-HHMMSS-appId-sg-Id-sessionId.zip</code>
     *         or another similar name.
     */
    public final String outputUri() {
        return outputUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(outputUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportFilesMetadata)) {
            return false;
        }
        ExportFilesMetadata other = (ExportFilesMetadata) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(outputUri(), other.outputUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportFilesMetadata").add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("OutputUri", outputUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "OutputUri":
            return Optional.ofNullable(clazz.cast(outputUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("OutputUri", OUTPUT_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportFilesMetadata, T> g) {
        return obj -> g.apply((ExportFilesMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportFilesMetadata> {
        /**
         * <p>
         * The result of the <a
         * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ExportStreamSessionFiles.html"
         * >ExportStreamSessionFiles</a> operation.
         * </p>
         * 
         * @param status
         *        The result of the <a href=
         *        "https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ExportStreamSessionFiles.html"
         *        >ExportStreamSessionFiles</a> operation.
         * @see ExportFilesStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportFilesStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The result of the <a
         * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ExportStreamSessionFiles.html"
         * >ExportStreamSessionFiles</a> operation.
         * </p>
         * 
         * @param status
         *        The result of the <a href=
         *        "https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ExportStreamSessionFiles.html"
         *        >ExportStreamSessionFiles</a> operation.
         * @see ExportFilesStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportFilesStatus
         */
        Builder status(ExportFilesStatus status);

        /**
         * <p>
         * A short description of the reason the export is in <code>FAILED</code> status.
         * </p>
         * 
         * @param statusReason
         *        A short description of the reason the export is in <code>FAILED</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The S3 bucket URI where Amazon GameLift Streams uploaded the set of compressed exported files for a stream
         * session. Amazon GameLift Streams generates a ZIP file name based on the stream session metadata.
         * Alternatively, you can provide a custom file name with a <code>.zip</code> file extension.
         * </p>
         * <p>
         * Example 1: If you provide an S3 URI called
         * <code>s3://amzn-s3-demo-destination-bucket/MyGame_Session1.zip</code>, then Amazon GameLift Streams will save
         * the files at that location.
         * </p>
         * <p>
         * Example 2: If you provide an S3 URI called
         * <code>s3://amzn-s3-demo-destination-bucket/MyGameSessions_ExportedFiles/</code>, then Amazon GameLift Streams
         * will save the files at
         * <code>s3://amzn-s3-demo-destination-bucket/MyGameSessions_ExportedFiles/YYYYMMDD-HHMMSS-appId-sg-Id-sessionId.zip</code>
         * or another similar name.
         * </p>
         * 
         * @param outputUri
         *        The S3 bucket URI where Amazon GameLift Streams uploaded the set of compressed exported files for a
         *        stream session. Amazon GameLift Streams generates a ZIP file name based on the stream session
         *        metadata. Alternatively, you can provide a custom file name with a <code>.zip</code> file
         *        extension.</p>
         *        <p>
         *        Example 1: If you provide an S3 URI called
         *        <code>s3://amzn-s3-demo-destination-bucket/MyGame_Session1.zip</code>, then Amazon GameLift Streams
         *        will save the files at that location.
         *        </p>
         *        <p>
         *        Example 2: If you provide an S3 URI called
         *        <code>s3://amzn-s3-demo-destination-bucket/MyGameSessions_ExportedFiles/</code>, then Amazon GameLift
         *        Streams will save the files at
         *        <code>s3://amzn-s3-demo-destination-bucket/MyGameSessions_ExportedFiles/YYYYMMDD-HHMMSS-appId-sg-Id-sessionId.zip</code>
         *        or another similar name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUri(String outputUri);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String statusReason;

        private String outputUri;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportFilesMetadata model) {
            status(model.status);
            statusReason(model.statusReason);
            outputUri(model.outputUri);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExportFilesStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getOutputUri() {
            return outputUri;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        @Override
        public ExportFilesMetadata build() {
            return new ExportFilesMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
