/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings that define a stream group's stream capacity for a location. When configuring a location for
 * the first time, you must specify a numeric value for at least one of the two capacity types. To update the capacity
 * for an existing stream group, call <a
 * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_UpdateStreamGroup.html"
 * >UpdateStreamGroup</a>. To add a new location and specify its capacity, call <a
 * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_AddStreamGroupLocations.html"
 * >AddStreamGroupLocations</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LocationConfiguration.Builder, LocationConfiguration> {
    private static final SdkField<String> LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationName").getter(getter(LocationConfiguration::locationName)).setter(setter(Builder::locationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationName").build()).build();

    private static final SdkField<Integer> ALWAYS_ON_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AlwaysOnCapacity").getter(getter(LocationConfiguration::alwaysOnCapacity))
            .setter(setter(Builder::alwaysOnCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlwaysOnCapacity").build()).build();

    private static final SdkField<Integer> ON_DEMAND_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OnDemandCapacity").getter(getter(LocationConfiguration::onDemandCapacity))
            .setter(setter(Builder::onDemandCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_NAME_FIELD,
            ALWAYS_ON_CAPACITY_FIELD, ON_DEMAND_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String locationName;

    private final Integer alwaysOnCapacity;

    private final Integer onDemandCapacity;

    private LocationConfiguration(BuilderImpl builder) {
        this.locationName = builder.locationName;
        this.alwaysOnCapacity = builder.alwaysOnCapacity;
        this.onDemandCapacity = builder.onDemandCapacity;
    }

    /**
     * <p>
     * A location's name. For example, <code>us-east-1</code>. For a complete list of locations that Amazon GameLift
     * Streams supports, refer to <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions, quotas, and
     * limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
     * </p>
     * 
     * @return A location's name. For example, <code>us-east-1</code>. For a complete list of locations that Amazon
     *         GameLift Streams supports, refer to <a
     *         href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions,
     *         quotas, and limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
     */
    public final String locationName() {
        return locationName;
    }

    /**
     * <p>
     * The streaming capacity that is allocated and ready to handle stream requests without delay. You pay for this
     * capacity whether it's in use or not. Best for quickest time from streaming request to streaming session. Default
     * is 1 when creating a stream group or adding a location.
     * </p>
     * 
     * @return The streaming capacity that is allocated and ready to handle stream requests without delay. You pay for
     *         this capacity whether it's in use or not. Best for quickest time from streaming request to streaming
     *         session. Default is 1 when creating a stream group or adding a location.
     */
    public final Integer alwaysOnCapacity() {
        return alwaysOnCapacity;
    }

    /**
     * <p>
     * The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and then
     * de-allocate when the session has terminated. This offers a cost control measure at the expense of a greater
     * startup time (typically under 5 minutes). Default is 0 when creating a stream group or adding a location.
     * </p>
     * 
     * @return The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and then
     *         de-allocate when the session has terminated. This offers a cost control measure at the expense of a
     *         greater startup time (typically under 5 minutes). Default is 0 when creating a stream group or adding a
     *         location.
     */
    public final Integer onDemandCapacity() {
        return onDemandCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(locationName());
        hashCode = 31 * hashCode + Objects.hashCode(alwaysOnCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationConfiguration)) {
            return false;
        }
        LocationConfiguration other = (LocationConfiguration) obj;
        return Objects.equals(locationName(), other.locationName())
                && Objects.equals(alwaysOnCapacity(), other.alwaysOnCapacity())
                && Objects.equals(onDemandCapacity(), other.onDemandCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LocationConfiguration").add("LocationName", locationName())
                .add("AlwaysOnCapacity", alwaysOnCapacity()).add("OnDemandCapacity", onDemandCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationName":
            return Optional.ofNullable(clazz.cast(locationName()));
        case "AlwaysOnCapacity":
            return Optional.ofNullable(clazz.cast(alwaysOnCapacity()));
        case "OnDemandCapacity":
            return Optional.ofNullable(clazz.cast(onDemandCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocationName", LOCATION_NAME_FIELD);
        map.put("AlwaysOnCapacity", ALWAYS_ON_CAPACITY_FIELD);
        map.put("OnDemandCapacity", ON_DEMAND_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LocationConfiguration, T> g) {
        return obj -> g.apply((LocationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocationConfiguration> {
        /**
         * <p>
         * A location's name. For example, <code>us-east-1</code>. For a complete list of locations that Amazon GameLift
         * Streams supports, refer to <a
         * href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions, quotas,
         * and limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
         * </p>
         * 
         * @param locationName
         *        A location's name. For example, <code>us-east-1</code>. For a complete list of locations that Amazon
         *        GameLift Streams supports, refer to <a
         *        href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions,
         *        quotas, and limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationName(String locationName);

        /**
         * <p>
         * The streaming capacity that is allocated and ready to handle stream requests without delay. You pay for this
         * capacity whether it's in use or not. Best for quickest time from streaming request to streaming session.
         * Default is 1 when creating a stream group or adding a location.
         * </p>
         * 
         * @param alwaysOnCapacity
         *        The streaming capacity that is allocated and ready to handle stream requests without delay. You pay
         *        for this capacity whether it's in use or not. Best for quickest time from streaming request to
         *        streaming session. Default is 1 when creating a stream group or adding a location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alwaysOnCapacity(Integer alwaysOnCapacity);

        /**
         * <p>
         * The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and then
         * de-allocate when the session has terminated. This offers a cost control measure at the expense of a greater
         * startup time (typically under 5 minutes). Default is 0 when creating a stream group or adding a location.
         * </p>
         * 
         * @param onDemandCapacity
         *        The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and
         *        then de-allocate when the session has terminated. This offers a cost control measure at the expense of
         *        a greater startup time (typically under 5 minutes). Default is 0 when creating a stream group or
         *        adding a location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandCapacity(Integer onDemandCapacity);
    }

    static final class BuilderImpl implements Builder {
        private String locationName;

        private Integer alwaysOnCapacity;

        private Integer onDemandCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(LocationConfiguration model) {
            locationName(model.locationName);
            alwaysOnCapacity(model.alwaysOnCapacity);
            onDemandCapacity(model.onDemandCapacity);
        }

        public final String getLocationName() {
            return locationName;
        }

        public final void setLocationName(String locationName) {
            this.locationName = locationName;
        }

        @Override
        public final Builder locationName(String locationName) {
            this.locationName = locationName;
            return this;
        }

        public final Integer getAlwaysOnCapacity() {
            return alwaysOnCapacity;
        }

        public final void setAlwaysOnCapacity(Integer alwaysOnCapacity) {
            this.alwaysOnCapacity = alwaysOnCapacity;
        }

        @Override
        public final Builder alwaysOnCapacity(Integer alwaysOnCapacity) {
            this.alwaysOnCapacity = alwaysOnCapacity;
            return this;
        }

        public final Integer getOnDemandCapacity() {
            return onDemandCapacity;
        }

        public final void setOnDemandCapacity(Integer onDemandCapacity) {
            this.onDemandCapacity = onDemandCapacity;
        }

        @Override
        public final Builder onDemandCapacity(Integer onDemandCapacity) {
            this.onDemandCapacity = onDemandCapacity;
            return this;
        }

        @Override
        public LocationConfiguration build() {
            return new LocationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
