/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a location and its corresponding stream capacity and status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocationState implements SdkPojo, Serializable, ToCopyableBuilder<LocationState.Builder, LocationState> {
    private static final SdkField<String> LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationName").getter(getter(LocationState::locationName)).setter(setter(Builder::locationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LocationState::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> ALWAYS_ON_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AlwaysOnCapacity").getter(getter(LocationState::alwaysOnCapacity))
            .setter(setter(Builder::alwaysOnCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlwaysOnCapacity").build()).build();

    private static final SdkField<Integer> ON_DEMAND_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OnDemandCapacity").getter(getter(LocationState::onDemandCapacity))
            .setter(setter(Builder::onDemandCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandCapacity").build()).build();

    private static final SdkField<Integer> REQUESTED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RequestedCapacity").getter(getter(LocationState::requestedCapacity))
            .setter(setter(Builder::requestedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedCapacity").build()).build();

    private static final SdkField<Integer> ALLOCATED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedCapacity").getter(getter(LocationState::allocatedCapacity))
            .setter(setter(Builder::allocatedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedCapacity").build()).build();

    private static final SdkField<Integer> IDLE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IdleCapacity").getter(getter(LocationState::idleCapacity)).setter(setter(Builder::idleCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_NAME_FIELD,
            STATUS_FIELD, ALWAYS_ON_CAPACITY_FIELD, ON_DEMAND_CAPACITY_FIELD, REQUESTED_CAPACITY_FIELD, ALLOCATED_CAPACITY_FIELD,
            IDLE_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String locationName;

    private final String status;

    private final Integer alwaysOnCapacity;

    private final Integer onDemandCapacity;

    private final Integer requestedCapacity;

    private final Integer allocatedCapacity;

    private final Integer idleCapacity;

    private LocationState(BuilderImpl builder) {
        this.locationName = builder.locationName;
        this.status = builder.status;
        this.alwaysOnCapacity = builder.alwaysOnCapacity;
        this.onDemandCapacity = builder.onDemandCapacity;
        this.requestedCapacity = builder.requestedCapacity;
        this.allocatedCapacity = builder.allocatedCapacity;
        this.idleCapacity = builder.idleCapacity;
    }

    /**
     * <p>
     * A location's name. For example, <code>us-east-1</code>. For a complete list of locations that Amazon GameLift
     * Streams supports, refer to <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions, quotas, and
     * limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
     * </p>
     * 
     * @return A location's name. For example, <code>us-east-1</code>. For a complete list of locations that Amazon
     *         GameLift Streams supports, refer to <a
     *         href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions,
     *         quotas, and limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
     */
    public final String locationName() {
        return locationName;
    }

    /**
     * <p>
     * This value is set of locations, including their name, current status, and capacities.
     * </p>
     * <p>
     * A location can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale the
     * capacity of, or remove this location yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale the
     * capacity of, or remove this location.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code> field
     * describes the error. You can remove this location and try to add it again.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
     * provisioned capacity for this location in this stream group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamGroupLocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return This value is set of locations, including their name, current status, and capacities. </p>
     *         <p>
     *         A location can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale
     *         the capacity of, or remove this location yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale
     *         the capacity of, or remove this location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code>
     *         field describes the error. You can remove this location and try to add it again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
     *         provisioned capacity for this location in this stream group.
     *         </p>
     *         </li>
     * @see StreamGroupLocationStatus
     */
    public final StreamGroupLocationStatus status() {
        return StreamGroupLocationStatus.fromValue(status);
    }

    /**
     * <p>
     * This value is set of locations, including their name, current status, and capacities.
     * </p>
     * <p>
     * A location can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale the
     * capacity of, or remove this location yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale the
     * capacity of, or remove this location.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code> field
     * describes the error. You can remove this location and try to add it again.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
     * provisioned capacity for this location in this stream group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamGroupLocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return This value is set of locations, including their name, current status, and capacities. </p>
     *         <p>
     *         A location can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale
     *         the capacity of, or remove this location yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale
     *         the capacity of, or remove this location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code>
     *         field describes the error. You can remove this location and try to add it again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
     *         provisioned capacity for this location in this stream group.
     *         </p>
     *         </li>
     * @see StreamGroupLocationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The streaming capacity that is allocated and ready to handle stream requests without delay. You pay for this
     * capacity whether it's in use or not. Best for quickest time from streaming request to streaming session. Default
     * is 1 when creating a stream group or adding a location.
     * </p>
     * 
     * @return The streaming capacity that is allocated and ready to handle stream requests without delay. You pay for
     *         this capacity whether it's in use or not. Best for quickest time from streaming request to streaming
     *         session. Default is 1 when creating a stream group or adding a location.
     */
    public final Integer alwaysOnCapacity() {
        return alwaysOnCapacity;
    }

    /**
     * <p>
     * The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and then
     * de-allocate when the session has terminated. This offers a cost control measure at the expense of a greater
     * startup time (typically under 5 minutes). Default is 0 when creating a stream group or adding a location.
     * </p>
     * 
     * @return The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and then
     *         de-allocate when the session has terminated. This offers a cost control measure at the expense of a
     *         greater startup time (typically under 5 minutes). Default is 0 when creating a stream group or adding a
     *         location.
     */
    public final Integer onDemandCapacity() {
        return onDemandCapacity;
    }

    /**
     * <p>
     * This value is the total number of compute resources that you request for a stream group. This includes resources
     * that Amazon GameLift Streams has either already provisioned or is working to provision. You request capacity for
     * each location in a stream group.
     * </p>
     * 
     * @return This value is the total number of compute resources that you request for a stream group. This includes
     *         resources that Amazon GameLift Streams has either already provisioned or is working to provision. You
     *         request capacity for each location in a stream group.
     */
    public final Integer requestedCapacity() {
        return requestedCapacity;
    }

    /**
     * <p>
     * This value is the number of compute resources that a stream group has provisioned and is ready to stream. It
     * includes resources that are currently streaming and resources that are idle and ready to respond to stream
     * requests.
     * </p>
     * 
     * @return This value is the number of compute resources that a stream group has provisioned and is ready to stream.
     *         It includes resources that are currently streaming and resources that are idle and ready to respond to
     *         stream requests.
     */
    public final Integer allocatedCapacity() {
        return allocatedCapacity;
    }

    /**
     * <p>
     * This value is the amount of allocated capacity that is not currently streaming. It represents the stream group's
     * availability to respond to new stream requests, but not including on-demand capacity.
     * </p>
     * 
     * @return This value is the amount of allocated capacity that is not currently streaming. It represents the stream
     *         group's availability to respond to new stream requests, but not including on-demand capacity.
     */
    public final Integer idleCapacity() {
        return idleCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(locationName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(alwaysOnCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(requestedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(idleCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationState)) {
            return false;
        }
        LocationState other = (LocationState) obj;
        return Objects.equals(locationName(), other.locationName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(alwaysOnCapacity(), other.alwaysOnCapacity())
                && Objects.equals(onDemandCapacity(), other.onDemandCapacity())
                && Objects.equals(requestedCapacity(), other.requestedCapacity())
                && Objects.equals(allocatedCapacity(), other.allocatedCapacity())
                && Objects.equals(idleCapacity(), other.idleCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LocationState").add("LocationName", locationName()).add("Status", statusAsString())
                .add("AlwaysOnCapacity", alwaysOnCapacity()).add("OnDemandCapacity", onDemandCapacity())
                .add("RequestedCapacity", requestedCapacity()).add("AllocatedCapacity", allocatedCapacity())
                .add("IdleCapacity", idleCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationName":
            return Optional.ofNullable(clazz.cast(locationName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AlwaysOnCapacity":
            return Optional.ofNullable(clazz.cast(alwaysOnCapacity()));
        case "OnDemandCapacity":
            return Optional.ofNullable(clazz.cast(onDemandCapacity()));
        case "RequestedCapacity":
            return Optional.ofNullable(clazz.cast(requestedCapacity()));
        case "AllocatedCapacity":
            return Optional.ofNullable(clazz.cast(allocatedCapacity()));
        case "IdleCapacity":
            return Optional.ofNullable(clazz.cast(idleCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocationName", LOCATION_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AlwaysOnCapacity", ALWAYS_ON_CAPACITY_FIELD);
        map.put("OnDemandCapacity", ON_DEMAND_CAPACITY_FIELD);
        map.put("RequestedCapacity", REQUESTED_CAPACITY_FIELD);
        map.put("AllocatedCapacity", ALLOCATED_CAPACITY_FIELD);
        map.put("IdleCapacity", IDLE_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LocationState, T> g) {
        return obj -> g.apply((LocationState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocationState> {
        /**
         * <p>
         * A location's name. For example, <code>us-east-1</code>. For a complete list of locations that Amazon GameLift
         * Streams supports, refer to <a
         * href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions, quotas,
         * and limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
         * </p>
         * 
         * @param locationName
         *        A location's name. For example, <code>us-east-1</code>. For a complete list of locations that Amazon
         *        GameLift Streams supports, refer to <a
         *        href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions,
         *        quotas, and limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationName(String locationName);

        /**
         * <p>
         * This value is set of locations, including their name, current status, and capacities.
         * </p>
         * <p>
         * A location can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale the
         * capacity of, or remove this location yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale the
         * capacity of, or remove this location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code>
         * field describes the error. You can remove this location and try to add it again.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
         * provisioned capacity for this location in this stream group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        This value is set of locations, including their name, current status, and capacities. </p>
         *        <p>
         *        A location can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from,
         *        scale the capacity of, or remove this location yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale
         *        the capacity of, or remove this location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The
         *        <code>StatusReason</code> field describes the error. You can remove this location and try to add it
         *        again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release
         *        all provisioned capacity for this location in this stream group.
         *        </p>
         *        </li>
         * @see StreamGroupLocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamGroupLocationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * This value is set of locations, including their name, current status, and capacities.
         * </p>
         * <p>
         * A location can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale the
         * capacity of, or remove this location yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale the
         * capacity of, or remove this location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code>
         * field describes the error. You can remove this location and try to add it again.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
         * provisioned capacity for this location in this stream group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        This value is set of locations, including their name, current status, and capacities. </p>
         *        <p>
         *        A location can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from,
         *        scale the capacity of, or remove this location yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale
         *        the capacity of, or remove this location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The
         *        <code>StatusReason</code> field describes the error. You can remove this location and try to add it
         *        again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release
         *        all provisioned capacity for this location in this stream group.
         *        </p>
         *        </li>
         * @see StreamGroupLocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamGroupLocationStatus
         */
        Builder status(StreamGroupLocationStatus status);

        /**
         * <p>
         * The streaming capacity that is allocated and ready to handle stream requests without delay. You pay for this
         * capacity whether it's in use or not. Best for quickest time from streaming request to streaming session.
         * Default is 1 when creating a stream group or adding a location.
         * </p>
         * 
         * @param alwaysOnCapacity
         *        The streaming capacity that is allocated and ready to handle stream requests without delay. You pay
         *        for this capacity whether it's in use or not. Best for quickest time from streaming request to
         *        streaming session. Default is 1 when creating a stream group or adding a location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alwaysOnCapacity(Integer alwaysOnCapacity);

        /**
         * <p>
         * The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and then
         * de-allocate when the session has terminated. This offers a cost control measure at the expense of a greater
         * startup time (typically under 5 minutes). Default is 0 when creating a stream group or adding a location.
         * </p>
         * 
         * @param onDemandCapacity
         *        The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and
         *        then de-allocate when the session has terminated. This offers a cost control measure at the expense of
         *        a greater startup time (typically under 5 minutes). Default is 0 when creating a stream group or
         *        adding a location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandCapacity(Integer onDemandCapacity);

        /**
         * <p>
         * This value is the total number of compute resources that you request for a stream group. This includes
         * resources that Amazon GameLift Streams has either already provisioned or is working to provision. You request
         * capacity for each location in a stream group.
         * </p>
         * 
         * @param requestedCapacity
         *        This value is the total number of compute resources that you request for a stream group. This includes
         *        resources that Amazon GameLift Streams has either already provisioned or is working to provision. You
         *        request capacity for each location in a stream group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedCapacity(Integer requestedCapacity);

        /**
         * <p>
         * This value is the number of compute resources that a stream group has provisioned and is ready to stream. It
         * includes resources that are currently streaming and resources that are idle and ready to respond to stream
         * requests.
         * </p>
         * 
         * @param allocatedCapacity
         *        This value is the number of compute resources that a stream group has provisioned and is ready to
         *        stream. It includes resources that are currently streaming and resources that are idle and ready to
         *        respond to stream requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedCapacity(Integer allocatedCapacity);

        /**
         * <p>
         * This value is the amount of allocated capacity that is not currently streaming. It represents the stream
         * group's availability to respond to new stream requests, but not including on-demand capacity.
         * </p>
         * 
         * @param idleCapacity
         *        This value is the amount of allocated capacity that is not currently streaming. It represents the
         *        stream group's availability to respond to new stream requests, but not including on-demand capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleCapacity(Integer idleCapacity);
    }

    static final class BuilderImpl implements Builder {
        private String locationName;

        private String status;

        private Integer alwaysOnCapacity;

        private Integer onDemandCapacity;

        private Integer requestedCapacity;

        private Integer allocatedCapacity;

        private Integer idleCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(LocationState model) {
            locationName(model.locationName);
            status(model.status);
            alwaysOnCapacity(model.alwaysOnCapacity);
            onDemandCapacity(model.onDemandCapacity);
            requestedCapacity(model.requestedCapacity);
            allocatedCapacity(model.allocatedCapacity);
            idleCapacity(model.idleCapacity);
        }

        public final String getLocationName() {
            return locationName;
        }

        public final void setLocationName(String locationName) {
            this.locationName = locationName;
        }

        @Override
        public final Builder locationName(String locationName) {
            this.locationName = locationName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamGroupLocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getAlwaysOnCapacity() {
            return alwaysOnCapacity;
        }

        public final void setAlwaysOnCapacity(Integer alwaysOnCapacity) {
            this.alwaysOnCapacity = alwaysOnCapacity;
        }

        @Override
        public final Builder alwaysOnCapacity(Integer alwaysOnCapacity) {
            this.alwaysOnCapacity = alwaysOnCapacity;
            return this;
        }

        public final Integer getOnDemandCapacity() {
            return onDemandCapacity;
        }

        public final void setOnDemandCapacity(Integer onDemandCapacity) {
            this.onDemandCapacity = onDemandCapacity;
        }

        @Override
        public final Builder onDemandCapacity(Integer onDemandCapacity) {
            this.onDemandCapacity = onDemandCapacity;
            return this;
        }

        public final Integer getRequestedCapacity() {
            return requestedCapacity;
        }

        public final void setRequestedCapacity(Integer requestedCapacity) {
            this.requestedCapacity = requestedCapacity;
        }

        @Override
        public final Builder requestedCapacity(Integer requestedCapacity) {
            this.requestedCapacity = requestedCapacity;
            return this;
        }

        public final Integer getAllocatedCapacity() {
            return allocatedCapacity;
        }

        public final void setAllocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
        }

        @Override
        public final Builder allocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
            return this;
        }

        public final Integer getIdleCapacity() {
            return idleCapacity;
        }

        public final void setIdleCapacity(Integer idleCapacity) {
            this.idleCapacity = idleCapacity;
        }

        @Override
        public final Builder idleCapacity(Integer idleCapacity) {
            this.idleCapacity = idleCapacity;
            return this;
        }

        @Override
        public LocationState build() {
            return new LocationState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
