/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationRequest extends GameLiftStreamsRequest implements
        ToCopyableBuilder<UpdateApplicationRequest.Builder, UpdateApplicationRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(UpdateApplicationRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateApplicationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> APPLICATION_LOG_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ApplicationLogPaths")
            .getter(getter(UpdateApplicationRequest::applicationLogPaths))
            .setter(setter(Builder::applicationLogPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationLogPaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APPLICATION_LOG_OUTPUT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationLogOutputUri").getter(getter(UpdateApplicationRequest::applicationLogOutputUri))
            .setter(setter(Builder::applicationLogOutputUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationLogOutputUri").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            DESCRIPTION_FIELD, APPLICATION_LOG_PATHS_FIELD, APPLICATION_LOG_OUTPUT_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final String description;

    private final List<String> applicationLogPaths;

    private final String applicationLogOutputUri;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.description = builder.description;
        this.applicationLogPaths = builder.applicationLogPaths;
        this.applicationLogOutputUri = builder.applicationLogOutputUri;
    }

    /**
     * <p>
     * An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a>
     * or ID that uniquely identifies the application resource. Example ARN:
     * <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
     * <code>a-9ZY8X7Wv6</code>.
     * </p>
     * 
     * @return An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
     *         (ARN)</a> or ID that uniquely identifies the application resource. Example ARN:
     *         <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
     *         <code>a-9ZY8X7Wv6</code>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * A human-readable label for the application.
     * </p>
     * 
     * @return A human-readable label for the application.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationLogPaths property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicationLogPaths() {
        return applicationLogPaths != null && !(applicationLogPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Locations of log files that your content generates during a stream session. Enter path values that are relative
     * to the <code>ApplicationSourceUri</code> location. You can specify up to 10 log paths. Amazon GameLift Streams
     * uploads designated log files to the Amazon S3 bucket that you specify in <code>ApplicationLogOutputUri</code> at
     * the end of a stream session. To retrieve stored log files, call <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html"
     * >GetStreamSession</a> and get the <code>LogFileLocationUri</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationLogPaths} method.
     * </p>
     * 
     * @return Locations of log files that your content generates during a stream session. Enter path values that are
     *         relative to the <code>ApplicationSourceUri</code> location. You can specify up to 10 log paths. Amazon
     *         GameLift Streams uploads designated log files to the Amazon S3 bucket that you specify in
     *         <code>ApplicationLogOutputUri</code> at the end of a stream session. To retrieve stored log files, call
     *         <a href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html">
     *         GetStreamSession</a> and get the <code>LogFileLocationUri</code>.
     */
    public final List<String> applicationLogPaths() {
        return applicationLogPaths;
    }

    /**
     * <p>
     * An Amazon S3 URI to a bucket where you would like Amazon GameLift Streams to save application logs. Required if
     * you specify one or more <code>ApplicationLogPaths</code>.
     * </p>
     * <note>
     * <p>
     * The log bucket must have permissions that give Amazon GameLift Streams access to write the log files. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/applications.html#application-bucket-permission-template"
     * >Application log bucket permission policy</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
     * </p>
     * </note>
     * 
     * @return An Amazon S3 URI to a bucket where you would like Amazon GameLift Streams to save application logs.
     *         Required if you specify one or more <code>ApplicationLogPaths</code>.</p> <note>
     *         <p>
     *         The log bucket must have permissions that give Amazon GameLift Streams access to write the log files. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/applications.html#application-bucket-permission-template"
     *         >Application log bucket permission policy</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
     *         </p>
     */
    public final String applicationLogOutputUri() {
        return applicationLogOutputUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationLogPaths() ? applicationLogPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationLogOutputUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(description(), other.description())
                && hasApplicationLogPaths() == other.hasApplicationLogPaths()
                && Objects.equals(applicationLogPaths(), other.applicationLogPaths())
                && Objects.equals(applicationLogOutputUri(), other.applicationLogOutputUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationRequest").add("Identifier", identifier()).add("Description", description())
                .add("ApplicationLogPaths", hasApplicationLogPaths() ? applicationLogPaths() : null)
                .add("ApplicationLogOutputUri", applicationLogOutputUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ApplicationLogPaths":
            return Optional.ofNullable(clazz.cast(applicationLogPaths()));
        case "ApplicationLogOutputUri":
            return Optional.ofNullable(clazz.cast(applicationLogOutputUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ApplicationLogPaths", APPLICATION_LOG_PATHS_FIELD);
        map.put("ApplicationLogOutputUri", APPLICATION_LOG_OUTPUT_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftStreamsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApplicationRequest> {
        /**
         * <p>
         * An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
         * (ARN)</a> or ID that uniquely identifies the application resource. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
         * <code>a-9ZY8X7Wv6</code>.
         * </p>
         * 
         * @param identifier
         *        An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
         *        (ARN)</a> or ID that uniquely identifies the application resource. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
         *        <code>a-9ZY8X7Wv6</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * A human-readable label for the application.
         * </p>
         * 
         * @param description
         *        A human-readable label for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Locations of log files that your content generates during a stream session. Enter path values that are
         * relative to the <code>ApplicationSourceUri</code> location. You can specify up to 10 log paths. Amazon
         * GameLift Streams uploads designated log files to the Amazon S3 bucket that you specify in
         * <code>ApplicationLogOutputUri</code> at the end of a stream session. To retrieve stored log files, call <a
         * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html">
         * GetStreamSession</a> and get the <code>LogFileLocationUri</code>.
         * </p>
         * 
         * @param applicationLogPaths
         *        Locations of log files that your content generates during a stream session. Enter path values that are
         *        relative to the <code>ApplicationSourceUri</code> location. You can specify up to 10 log paths. Amazon
         *        GameLift Streams uploads designated log files to the Amazon S3 bucket that you specify in
         *        <code>ApplicationLogOutputUri</code> at the end of a stream session. To retrieve stored log files,
         *        call <a
         *        href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html"
         *        >GetStreamSession</a> and get the <code>LogFileLocationUri</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationLogPaths(Collection<String> applicationLogPaths);

        /**
         * <p>
         * Locations of log files that your content generates during a stream session. Enter path values that are
         * relative to the <code>ApplicationSourceUri</code> location. You can specify up to 10 log paths. Amazon
         * GameLift Streams uploads designated log files to the Amazon S3 bucket that you specify in
         * <code>ApplicationLogOutputUri</code> at the end of a stream session. To retrieve stored log files, call <a
         * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html">
         * GetStreamSession</a> and get the <code>LogFileLocationUri</code>.
         * </p>
         * 
         * @param applicationLogPaths
         *        Locations of log files that your content generates during a stream session. Enter path values that are
         *        relative to the <code>ApplicationSourceUri</code> location. You can specify up to 10 log paths. Amazon
         *        GameLift Streams uploads designated log files to the Amazon S3 bucket that you specify in
         *        <code>ApplicationLogOutputUri</code> at the end of a stream session. To retrieve stored log files,
         *        call <a
         *        href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html"
         *        >GetStreamSession</a> and get the <code>LogFileLocationUri</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationLogPaths(String... applicationLogPaths);

        /**
         * <p>
         * An Amazon S3 URI to a bucket where you would like Amazon GameLift Streams to save application logs. Required
         * if you specify one or more <code>ApplicationLogPaths</code>.
         * </p>
         * <note>
         * <p>
         * The log bucket must have permissions that give Amazon GameLift Streams access to write the log files. For
         * more information, see <a href=
         * "https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/applications.html#application-bucket-permission-template"
         * >Application log bucket permission policy</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param applicationLogOutputUri
         *        An Amazon S3 URI to a bucket where you would like Amazon GameLift Streams to save application logs.
         *        Required if you specify one or more <code>ApplicationLogPaths</code>.</p> <note>
         *        <p>
         *        The log bucket must have permissions that give Amazon GameLift Streams access to write the log files.
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/applications.html#application-bucket-permission-template"
         *        >Application log bucket permission policy</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationLogOutputUri(String applicationLogOutputUri);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftStreamsRequest.BuilderImpl implements Builder {
        private String identifier;

        private String description;

        private List<String> applicationLogPaths = DefaultSdkAutoConstructList.getInstance();

        private String applicationLogOutputUri;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            identifier(model.identifier);
            description(model.description);
            applicationLogPaths(model.applicationLogPaths);
            applicationLogOutputUri(model.applicationLogOutputUri);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getApplicationLogPaths() {
            if (applicationLogPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return applicationLogPaths;
        }

        public final void setApplicationLogPaths(Collection<String> applicationLogPaths) {
            this.applicationLogPaths = FilePathsCopier.copy(applicationLogPaths);
        }

        @Override
        public final Builder applicationLogPaths(Collection<String> applicationLogPaths) {
            this.applicationLogPaths = FilePathsCopier.copy(applicationLogPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationLogPaths(String... applicationLogPaths) {
            applicationLogPaths(Arrays.asList(applicationLogPaths));
            return this;
        }

        public final String getApplicationLogOutputUri() {
            return applicationLogOutputUri;
        }

        public final void setApplicationLogOutputUri(String applicationLogOutputUri) {
            this.applicationLogOutputUri = applicationLogOutputUri;
        }

        @Override
        public final Builder applicationLogOutputUri(String applicationLogOutputUri) {
            this.applicationLogOutputUri = applicationLogOutputUri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
