/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.gameliftstreams.model.AddStreamGroupLocationsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.AddStreamGroupLocationsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.AssociateApplicationsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.AssociateApplicationsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.CreateApplicationRequest;
import software.amazon.awssdk.services.gameliftstreams.model.CreateApplicationResponse;
import software.amazon.awssdk.services.gameliftstreams.model.CreateStreamGroupRequest;
import software.amazon.awssdk.services.gameliftstreams.model.CreateStreamGroupResponse;
import software.amazon.awssdk.services.gameliftstreams.model.CreateStreamSessionConnectionRequest;
import software.amazon.awssdk.services.gameliftstreams.model.CreateStreamSessionConnectionResponse;
import software.amazon.awssdk.services.gameliftstreams.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.gameliftstreams.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.gameliftstreams.model.DeleteStreamGroupRequest;
import software.amazon.awssdk.services.gameliftstreams.model.DeleteStreamGroupResponse;
import software.amazon.awssdk.services.gameliftstreams.model.DisassociateApplicationsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.DisassociateApplicationsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.ExportStreamSessionFilesRequest;
import software.amazon.awssdk.services.gameliftstreams.model.ExportStreamSessionFilesResponse;
import software.amazon.awssdk.services.gameliftstreams.model.GetApplicationRequest;
import software.amazon.awssdk.services.gameliftstreams.model.GetApplicationResponse;
import software.amazon.awssdk.services.gameliftstreams.model.GetStreamGroupRequest;
import software.amazon.awssdk.services.gameliftstreams.model.GetStreamGroupResponse;
import software.amazon.awssdk.services.gameliftstreams.model.GetStreamSessionRequest;
import software.amazon.awssdk.services.gameliftstreams.model.GetStreamSessionResponse;
import software.amazon.awssdk.services.gameliftstreams.model.ListApplicationsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.ListApplicationsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsByAccountRequest;
import software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsByAccountResponse;
import software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.gameliftstreams.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.gameliftstreams.model.RemoveStreamGroupLocationsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.RemoveStreamGroupLocationsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.StartStreamSessionRequest;
import software.amazon.awssdk.services.gameliftstreams.model.StartStreamSessionResponse;
import software.amazon.awssdk.services.gameliftstreams.model.TagResourceRequest;
import software.amazon.awssdk.services.gameliftstreams.model.TagResourceResponse;
import software.amazon.awssdk.services.gameliftstreams.model.TerminateStreamSessionRequest;
import software.amazon.awssdk.services.gameliftstreams.model.TerminateStreamSessionResponse;
import software.amazon.awssdk.services.gameliftstreams.model.UntagResourceRequest;
import software.amazon.awssdk.services.gameliftstreams.model.UntagResourceResponse;
import software.amazon.awssdk.services.gameliftstreams.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.gameliftstreams.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.gameliftstreams.model.UpdateStreamGroupRequest;
import software.amazon.awssdk.services.gameliftstreams.model.UpdateStreamGroupResponse;
import software.amazon.awssdk.services.gameliftstreams.paginators.ListApplicationsPublisher;
import software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamGroupsPublisher;
import software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamSessionsByAccountPublisher;
import software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamSessionsPublisher;
import software.amazon.awssdk.services.gameliftstreams.waiters.GameLiftStreamsAsyncWaiter;

/**
 * Service client for accessing Amazon GameLift Streams asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * <fullname>Amazon GameLift Streams</fullname>
 * <p>
 * Amazon GameLift Streams provides a global cloud solution for content streaming experiences. Use Amazon GameLift
 * Streams tools to upload and configure content for streaming, deploy and scale computing resources to host streams,
 * and manage stream session placement to meet customer demand.
 * </p>
 * <p>
 * This Reference Guide describes the Amazon GameLift Streams service API. You can use the API through the Amazon Web
 * Services SDK, the Command Line Interface (CLI), or by making direct REST calls through HTTPS.
 * </p>
 * <p>
 * See the <i>Amazon GameLift Streams Developer Guide</i> for more information on how Amazon GameLift Streams works and
 * how to work with it.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GameLiftStreamsAsyncClient extends AwsClient {
    String SERVICE_NAME = "gameliftstreams";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "gameliftstreams";

    /**
     * <p>
     * Add locations that can host stream sessions. To add a location, the stream group must be in <code>ACTIVE</code>
     * status. You configure locations and their corresponding capacity for each stream group. Creating a stream group
     * in a location that's nearest to your end users can help minimize latency and improve quality.
     * </p>
     * <p>
     * This operation provisions stream capacity at the specified locations. By default, all locations have 1 or 2
     * capacity, depending on the stream class option: 2 for 'High' and 1 for 'Ultra' and 'Win2022'. This operation also
     * copies the content files of all associated applications to an internal S3 bucket at each location. This allows
     * Amazon GameLift Streams to host performant stream sessions.
     * </p>
     *
     * @param addStreamGroupLocationsRequest
     * @return A Java Future containing the result of the AddStreamGroupLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>ServiceQuotaExceededException The request would cause the resource to exceed an allowed service
     *         quota. Resolve the issue before you try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.AddStreamGroupLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/AddStreamGroupLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddStreamGroupLocationsResponse> addStreamGroupLocations(
            AddStreamGroupLocationsRequest addStreamGroupLocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add locations that can host stream sessions. To add a location, the stream group must be in <code>ACTIVE</code>
     * status. You configure locations and their corresponding capacity for each stream group. Creating a stream group
     * in a location that's nearest to your end users can help minimize latency and improve quality.
     * </p>
     * <p>
     * This operation provisions stream capacity at the specified locations. By default, all locations have 1 or 2
     * capacity, depending on the stream class option: 2 for 'High' and 1 for 'Ultra' and 'Win2022'. This operation also
     * copies the content files of all associated applications to an internal S3 bucket at each location. This allows
     * Amazon GameLift Streams to host performant stream sessions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddStreamGroupLocationsRequest.Builder} avoiding
     * the need to create one manually via {@link AddStreamGroupLocationsRequest#builder()}
     * </p>
     *
     * @param addStreamGroupLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.AddStreamGroupLocationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AddStreamGroupLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>ServiceQuotaExceededException The request would cause the resource to exceed an allowed service
     *         quota. Resolve the issue before you try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.AddStreamGroupLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/AddStreamGroupLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddStreamGroupLocationsResponse> addStreamGroupLocations(
            Consumer<AddStreamGroupLocationsRequest.Builder> addStreamGroupLocationsRequest) {
        return addStreamGroupLocations(AddStreamGroupLocationsRequest.builder().applyMutation(addStreamGroupLocationsRequest)
                .build());
    }

    /**
     * <p>
     * When you associate, or link, an application with a stream group, then Amazon GameLift Streams can launch the
     * application using the stream group's allocated compute resources. The stream group must be in <code>ACTIVE</code>
     * status. You can reverse this action by using <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_DisassociateApplications.html"
     * >DisassociateApplications</a>.
     * </p>
     * <p>
     * If a stream group does not already have a linked application, Amazon GameLift Streams will automatically assign
     * the first application provided in <code>ApplicationIdentifiers</code> as the default.
     * </p>
     *
     * @param associateApplicationsRequest
     * @return A Java Future containing the result of the AssociateApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>ServiceQuotaExceededException The request would cause the resource to exceed an allowed service
     *         quota. Resolve the issue before you try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.AssociateApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/AssociateApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateApplicationsResponse> associateApplications(
            AssociateApplicationsRequest associateApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When you associate, or link, an application with a stream group, then Amazon GameLift Streams can launch the
     * application using the stream group's allocated compute resources. The stream group must be in <code>ACTIVE</code>
     * status. You can reverse this action by using <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_DisassociateApplications.html"
     * >DisassociateApplications</a>.
     * </p>
     * <p>
     * If a stream group does not already have a linked application, Amazon GameLift Streams will automatically assign
     * the first application provided in <code>ApplicationIdentifiers</code> as the default.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateApplicationsRequest#builder()}
     * </p>
     *
     * @param associateApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.AssociateApplicationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>ServiceQuotaExceededException The request would cause the resource to exceed an allowed service
     *         quota. Resolve the issue before you try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.AssociateApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/AssociateApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateApplicationsResponse> associateApplications(
            Consumer<AssociateApplicationsRequest.Builder> associateApplicationsRequest) {
        return associateApplications(AssociateApplicationsRequest.builder().applyMutation(associateApplicationsRequest).build());
    }

    /**
     * <p>
     * Creates an application resource in Amazon GameLift Streams, which specifies the application content you want to
     * stream, such as a game build or other software, and configures the settings to run it.
     * </p>
     * <p>
     * Before you create an application, upload your application content files to an Amazon Simple Storage Service
     * (Amazon S3) bucket. For more information, see <b>Getting Started</b> in the Amazon GameLift Streams Developer
     * Guide.
     * </p>
     * <important>
     * <p>
     * Make sure that your files in the Amazon S3 bucket are the correct version you want to use. If you change the
     * files at a later time, you will need to create a new Amazon GameLift Streams application.
     * </p>
     * </important>
     * <p>
     * If the request is successful, Amazon GameLift Streams begins to create an application and sets the status to
     * <code>INITIALIZED</code>. When an application reaches <code>READY</code> status, you can use the application to
     * set up stream groups and start streams. To track application status, call <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetApplication.html"
     * >GetApplication</a>.
     * </p>
     *
     * @param createApplicationRequest
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>ServiceQuotaExceededException The request would cause the resource to exceed an allowed service
     *         quota. Resolve the issue before you try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application resource in Amazon GameLift Streams, which specifies the application content you want to
     * stream, such as a game build or other software, and configures the settings to run it.
     * </p>
     * <p>
     * Before you create an application, upload your application content files to an Amazon Simple Storage Service
     * (Amazon S3) bucket. For more information, see <b>Getting Started</b> in the Amazon GameLift Streams Developer
     * Guide.
     * </p>
     * <important>
     * <p>
     * Make sure that your files in the Amazon S3 bucket are the correct version you want to use. If you change the
     * files at a later time, you will need to create a new Amazon GameLift Streams application.
     * </p>
     * </important>
     * <p>
     * If the request is successful, Amazon GameLift Streams begins to create an application and sets the status to
     * <code>INITIALIZED</code>. When an application reaches <code>READY</code> status, you can use the application to
     * set up stream groups and start streams. To track application status, call <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetApplication.html"
     * >GetApplication</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.CreateApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>ServiceQuotaExceededException The request would cause the resource to exceed an allowed service
     *         quota. Resolve the issue before you try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(
            Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Stream groups manage how Amazon GameLift Streams allocates resources and handles concurrent streams, allowing you
     * to effectively manage capacity and costs. Within a stream group, you specify an application to stream, streaming
     * locations and their capacity, and the stream class you want to use when streaming applications to your end-users.
     * A stream class defines the hardware configuration of the compute resources that Amazon GameLift Streams will use
     * when streaming, such as the CPU, GPU, and memory.
     * </p>
     * <p>
     * Stream capacity represents the number of concurrent streams that can be active at a time. You set stream capacity
     * per location, per stream group. There are two types of capacity, always-on and on-demand:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Always-on</b>: The streaming capacity that is allocated and ready to handle stream requests without delay. You
     * pay for this capacity whether it's in use or not. Best for quickest time from streaming request to streaming
     * session. Default is 1 (2 for high stream classes) when creating a stream group or adding a location.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>On-demand</b>: The streaming capacity that Amazon GameLift Streams can allocate in response to stream
     * requests, and then de-allocate when the session has terminated. This offers a cost control measure at the expense
     * of a greater startup time (typically under 5 minutes). Default is 0 when creating a stream group or adding a
     * location.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Values for capacity must be whole number multiples of the tenancy value of the stream group's stream class.
     * </p>
     * <p>
     * To adjust the capacity of any <code>ACTIVE</code> stream group, call <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_UpdateStreamGroup.html"
     * >UpdateStreamGroup</a>.
     * </p>
     * <p>
     * If the <code>CreateStreamGroup</code> request is successful, Amazon GameLift Streams assigns a unique ID to the
     * stream group resource and sets the status to <code>ACTIVATING</code>. It can take a few minutes for Amazon
     * GameLift Streams to finish creating the stream group while it searches for unallocated compute resources and
     * provisions them. When complete, the stream group status will be <code>ACTIVE</code> and you can start stream
     * sessions by using <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_StartStreamSession.html"
     * >StartStreamSession</a>. To check the stream group's status, call <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamGroup.html"
     * >GetStreamGroup</a>.
     * </p>
     * <p>
     * Stream groups should be recreated every 3-4 weeks to pick up important service updates and fixes. Stream groups
     * that are older than 180 days can no longer be updated with new application associations. Stream groups expire
     * when they are 365 days old, at which point they can no longer stream sessions. The exact expiration date is
     * indicated by the date value in the <code>ExpiresAt</code> field.
     * </p>
     *
     * @param createStreamGroupRequest
     * @return A Java Future containing the result of the CreateStreamGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>ServiceQuotaExceededException The request would cause the resource to exceed an allowed service
     *         quota. Resolve the issue before you try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.CreateStreamGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/CreateStreamGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStreamGroupResponse> createStreamGroup(CreateStreamGroupRequest createStreamGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stream groups manage how Amazon GameLift Streams allocates resources and handles concurrent streams, allowing you
     * to effectively manage capacity and costs. Within a stream group, you specify an application to stream, streaming
     * locations and their capacity, and the stream class you want to use when streaming applications to your end-users.
     * A stream class defines the hardware configuration of the compute resources that Amazon GameLift Streams will use
     * when streaming, such as the CPU, GPU, and memory.
     * </p>
     * <p>
     * Stream capacity represents the number of concurrent streams that can be active at a time. You set stream capacity
     * per location, per stream group. There are two types of capacity, always-on and on-demand:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Always-on</b>: The streaming capacity that is allocated and ready to handle stream requests without delay. You
     * pay for this capacity whether it's in use or not. Best for quickest time from streaming request to streaming
     * session. Default is 1 (2 for high stream classes) when creating a stream group or adding a location.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>On-demand</b>: The streaming capacity that Amazon GameLift Streams can allocate in response to stream
     * requests, and then de-allocate when the session has terminated. This offers a cost control measure at the expense
     * of a greater startup time (typically under 5 minutes). Default is 0 when creating a stream group or adding a
     * location.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Values for capacity must be whole number multiples of the tenancy value of the stream group's stream class.
     * </p>
     * <p>
     * To adjust the capacity of any <code>ACTIVE</code> stream group, call <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_UpdateStreamGroup.html"
     * >UpdateStreamGroup</a>.
     * </p>
     * <p>
     * If the <code>CreateStreamGroup</code> request is successful, Amazon GameLift Streams assigns a unique ID to the
     * stream group resource and sets the status to <code>ACTIVATING</code>. It can take a few minutes for Amazon
     * GameLift Streams to finish creating the stream group while it searches for unallocated compute resources and
     * provisions them. When complete, the stream group status will be <code>ACTIVE</code> and you can start stream
     * sessions by using <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_StartStreamSession.html"
     * >StartStreamSession</a>. To check the stream group's status, call <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamGroup.html"
     * >GetStreamGroup</a>.
     * </p>
     * <p>
     * Stream groups should be recreated every 3-4 weeks to pick up important service updates and fixes. Stream groups
     * that are older than 180 days can no longer be updated with new application associations. Stream groups expire
     * when they are 365 days old, at which point they can no longer stream sessions. The exact expiration date is
     * indicated by the date value in the <code>ExpiresAt</code> field.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateStreamGroupRequest#builder()}
     * </p>
     *
     * @param createStreamGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.CreateStreamGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateStreamGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>ServiceQuotaExceededException The request would cause the resource to exceed an allowed service
     *         quota. Resolve the issue before you try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.CreateStreamGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/CreateStreamGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStreamGroupResponse> createStreamGroup(
            Consumer<CreateStreamGroupRequest.Builder> createStreamGroupRequest) {
        return createStreamGroup(CreateStreamGroupRequest.builder().applyMutation(createStreamGroupRequest).build());
    }

    /**
     * <p>
     * Enables clients to reconnect to a stream session while preserving all session state and data in the disconnected
     * session. This reconnection process can be initiated when a stream session is in either
     * <code>PENDING_CLIENT_RECONNECTION</code> or <code>ACTIVE</code> status. The process works as follows:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Initial disconnect:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When a client disconnects or loses connection, the stream session transitions from <code>CONNECTED</code> to
     * <code>PENDING_CLIENT_RECONNECTION</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Reconnection time window:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Clients have <code>ConnectionTimeoutSeconds</code> (defined in <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_StartStreamSession.html"
     * >StartStreamSession</a>) to reconnect before session termination
     * </p>
     * </li>
     * <li>
     * <p>
     * Your backend server must call <b>CreateStreamSessionConnection</b> to initiate reconnection
     * </p>
     * </li>
     * <li>
     * <p>
     * Session transitions to <code>RECONNECTING</code> status
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Reconnection completion:
     * </p>
     * <ul>
     * <li>
     * <p>
     * On successful <b>CreateStreamSessionConnection</b>, session status changes to <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the new connection information to the requesting client
     * </p>
     * </li>
     * <li>
     * <p>
     * Client must establish connection within <code>ConnectionTimeoutSeconds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Session terminates automatically if client fails to connect in time
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * For more information about the stream session lifecycle, see <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/stream-sessions.html">Stream sessions</a>
     * in the <i>Amazon GameLift Streams Developer Guide</i>.
     * </p>
     * <p>
     * To begin re-connecting to an existing stream session, specify the stream group ID and stream session ID that you
     * want to reconnect to, and the signal request to use with the stream.
     * </p>
     *
     * @param createStreamSessionConnectionRequest
     * @return A Java Future containing the result of the CreateStreamSessionConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.CreateStreamSessionConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/CreateStreamSessionConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStreamSessionConnectionResponse> createStreamSessionConnection(
            CreateStreamSessionConnectionRequest createStreamSessionConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables clients to reconnect to a stream session while preserving all session state and data in the disconnected
     * session. This reconnection process can be initiated when a stream session is in either
     * <code>PENDING_CLIENT_RECONNECTION</code> or <code>ACTIVE</code> status. The process works as follows:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Initial disconnect:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When a client disconnects or loses connection, the stream session transitions from <code>CONNECTED</code> to
     * <code>PENDING_CLIENT_RECONNECTION</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Reconnection time window:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Clients have <code>ConnectionTimeoutSeconds</code> (defined in <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_StartStreamSession.html"
     * >StartStreamSession</a>) to reconnect before session termination
     * </p>
     * </li>
     * <li>
     * <p>
     * Your backend server must call <b>CreateStreamSessionConnection</b> to initiate reconnection
     * </p>
     * </li>
     * <li>
     * <p>
     * Session transitions to <code>RECONNECTING</code> status
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Reconnection completion:
     * </p>
     * <ul>
     * <li>
     * <p>
     * On successful <b>CreateStreamSessionConnection</b>, session status changes to <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Provide the new connection information to the requesting client
     * </p>
     * </li>
     * <li>
     * <p>
     * Client must establish connection within <code>ConnectionTimeoutSeconds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Session terminates automatically if client fails to connect in time
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * For more information about the stream session lifecycle, see <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/stream-sessions.html">Stream sessions</a>
     * in the <i>Amazon GameLift Streams Developer Guide</i>.
     * </p>
     * <p>
     * To begin re-connecting to an existing stream session, specify the stream group ID and stream session ID that you
     * want to reconnect to, and the signal request to use with the stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamSessionConnectionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateStreamSessionConnectionRequest#builder()}
     * </p>
     *
     * @param createStreamSessionConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.CreateStreamSessionConnectionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateStreamSessionConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.CreateStreamSessionConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/CreateStreamSessionConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStreamSessionConnectionResponse> createStreamSessionConnection(
            Consumer<CreateStreamSessionConnectionRequest.Builder> createStreamSessionConnectionRequest) {
        return createStreamSessionConnection(CreateStreamSessionConnectionRequest.builder()
                .applyMutation(createStreamSessionConnectionRequest).build());
    }

    /**
     * <p>
     * Permanently deletes an Amazon GameLift Streams application resource. This also deletes the application content
     * files stored with Amazon GameLift Streams. However, this does not delete the original files that you uploaded to
     * your Amazon S3 bucket; you can delete these any time after Amazon GameLift Streams creates an application, which
     * is the only time Amazon GameLift Streams accesses your Amazon S3 bucket.
     * </p>
     * <p>
     * You can only delete an application that meets the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The application is in <code>READY</code> or <code>ERROR</code> status. You cannot delete an application that's in
     * <code>PROCESSING</code> or <code>INITIALIZED</code> status.
     * </p>
     * </li>
     * <li>
     * <p>
     * The application is not the default application of any stream groups. You must first delete the stream group by
     * using <a href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_DeleteStreamGroup.html">
     * DeleteStreamGroup</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The application is not linked to any stream groups. You must first unlink the stream group by using <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_DisassociateApplications.html"
     * >DisassociateApplications</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * An application is not streaming in any ongoing stream session. You must wait until the client ends the stream
     * session or call <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_TerminateStreamSession.html"
     * >TerminateStreamSession</a> to end the stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If any active stream groups exist for this application, this request returns a <code>ValidationException</code>.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes an Amazon GameLift Streams application resource. This also deletes the application content
     * files stored with Amazon GameLift Streams. However, this does not delete the original files that you uploaded to
     * your Amazon S3 bucket; you can delete these any time after Amazon GameLift Streams creates an application, which
     * is the only time Amazon GameLift Streams accesses your Amazon S3 bucket.
     * </p>
     * <p>
     * You can only delete an application that meets the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The application is in <code>READY</code> or <code>ERROR</code> status. You cannot delete an application that's in
     * <code>PROCESSING</code> or <code>INITIALIZED</code> status.
     * </p>
     * </li>
     * <li>
     * <p>
     * The application is not the default application of any stream groups. You must first delete the stream group by
     * using <a href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_DeleteStreamGroup.html">
     * DeleteStreamGroup</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The application is not linked to any stream groups. You must first unlink the stream group by using <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_DisassociateApplications.html"
     * >DisassociateApplications</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * An application is not streaming in any ongoing stream session. You must wait until the client ends the stream
     * session or call <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_TerminateStreamSession.html"
     * >TerminateStreamSession</a> to end the stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If any active stream groups exist for this application, this request returns a <code>ValidationException</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.DeleteApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(
            Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest) {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Permanently deletes all compute resources and information related to a stream group. To delete a stream group,
     * specify the unique stream group identifier. During the deletion process, the stream group's status is
     * <code>DELETING</code>. This operation stops streams in progress and prevents new streams from starting. As a best
     * practice, before deleting the stream group, call <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ListStreamSessions.html"
     * >ListStreamSessions</a> to check for streams in progress and take action to stop them. When you delete a stream
     * group, any application associations referring to that stream group are automatically removed.
     * </p>
     *
     * @param deleteStreamGroupRequest
     * @return A Java Future containing the result of the DeleteStreamGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.DeleteStreamGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/DeleteStreamGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStreamGroupResponse> deleteStreamGroup(DeleteStreamGroupRequest deleteStreamGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes all compute resources and information related to a stream group. To delete a stream group,
     * specify the unique stream group identifier. During the deletion process, the stream group's status is
     * <code>DELETING</code>. This operation stops streams in progress and prevents new streams from starting. As a best
     * practice, before deleting the stream group, call <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ListStreamSessions.html"
     * >ListStreamSessions</a> to check for streams in progress and take action to stop them. When you delete a stream
     * group, any application associations referring to that stream group are automatically removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStreamGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteStreamGroupRequest#builder()}
     * </p>
     *
     * @param deleteStreamGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.DeleteStreamGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteStreamGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.DeleteStreamGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/DeleteStreamGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStreamGroupResponse> deleteStreamGroup(
            Consumer<DeleteStreamGroupRequest.Builder> deleteStreamGroupRequest) {
        return deleteStreamGroup(DeleteStreamGroupRequest.builder().applyMutation(deleteStreamGroupRequest).build());
    }

    /**
     * <p>
     * When you disassociate, or unlink, an application from a stream group, you can no longer stream this application
     * by using that stream group's allocated compute resources. Any streams in process will continue until they
     * terminate, which helps avoid interrupting an end-user's stream. Amazon GameLift Streams will not initiate new
     * streams in the stream group using the disassociated application. The disassociate action does not affect the
     * stream capacity of a stream group. To disassociate an application, the stream group must be in
     * <code>ACTIVE</code> status.
     * </p>
     * <p>
     * If you disassociate the default application, Amazon GameLift Streams will automatically choose a new default
     * application from the remaining associated applications. To change which application is the default application,
     * call <a href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_UpdateStreamGroup.html">
     * UpdateStreamGroup</a> and specify a new <code>DefaultApplicationIdentifier</code>.
     * </p>
     *
     * @param disassociateApplicationsRequest
     * @return A Java Future containing the result of the DisassociateApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.DisassociateApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/DisassociateApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateApplicationsResponse> disassociateApplications(
            DisassociateApplicationsRequest disassociateApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When you disassociate, or unlink, an application from a stream group, you can no longer stream this application
     * by using that stream group's allocated compute resources. Any streams in process will continue until they
     * terminate, which helps avoid interrupting an end-user's stream. Amazon GameLift Streams will not initiate new
     * streams in the stream group using the disassociated application. The disassociate action does not affect the
     * stream capacity of a stream group. To disassociate an application, the stream group must be in
     * <code>ACTIVE</code> status.
     * </p>
     * <p>
     * If you disassociate the default application, Amazon GameLift Streams will automatically choose a new default
     * application from the remaining associated applications. To change which application is the default application,
     * call <a href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_UpdateStreamGroup.html">
     * UpdateStreamGroup</a> and specify a new <code>DefaultApplicationIdentifier</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateApplicationsRequest#builder()}
     * </p>
     *
     * @param disassociateApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.DisassociateApplicationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.DisassociateApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/DisassociateApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateApplicationsResponse> disassociateApplications(
            Consumer<DisassociateApplicationsRequest.Builder> disassociateApplicationsRequest) {
        return disassociateApplications(DisassociateApplicationsRequest.builder().applyMutation(disassociateApplicationsRequest)
                .build());
    }

    /**
     * <p>
     * Export the files that your application modifies or generates in a stream session, which can help you debug or
     * verify your application. When your application runs, it generates output files such as logs, diagnostic
     * information, crash dumps, save files, user data, screenshots, and so on. The files can be defined by the engine
     * or frameworks that your application uses, or information that you've programmed your application to output.
     * </p>
     * <p>
     * You can only call this action on a stream session that is in progress, specifically in one of the following
     * statuses <code>ACTIVE</code>, <code>CONNECTED</code>, <code>PENDING_CLIENT_RECONNECTION</code>, and
     * <code>RECONNECTING</code>. You must provide an Amazon Simple Storage Service (Amazon S3) bucket to store the
     * files in. When the session ends, Amazon GameLift Streams produces a compressed folder that contains all of the
     * files and directories that were modified or created by the application during the stream session. AWS uses your
     * security credentials to authenticate and authorize access to your Amazon S3 bucket.
     * </p>
     * <p>
     * Amazon GameLift Streams collects the following generated and modified files. Find them in the corresponding
     * folders in the <code>.zip</code> archive.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>application/</code>: The folder where your application or game is stored.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>profile/</code>: The user profile folder.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>temp/</code>: The system temp folder.
     * </p>
     * </li>
     * </ul>
     * <p/>
     * <p>
     * To verify the status of the exported files, use GetStreamSession.
     * </p>
     * <p>
     * To delete the files, delete the object in the S3 bucket.
     * </p>
     *
     * @param exportStreamSessionFilesRequest
     * @return A Java Future containing the result of the ExportStreamSessionFiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ExportStreamSessionFiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ExportStreamSessionFiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportStreamSessionFilesResponse> exportStreamSessionFiles(
            ExportStreamSessionFilesRequest exportStreamSessionFilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Export the files that your application modifies or generates in a stream session, which can help you debug or
     * verify your application. When your application runs, it generates output files such as logs, diagnostic
     * information, crash dumps, save files, user data, screenshots, and so on. The files can be defined by the engine
     * or frameworks that your application uses, or information that you've programmed your application to output.
     * </p>
     * <p>
     * You can only call this action on a stream session that is in progress, specifically in one of the following
     * statuses <code>ACTIVE</code>, <code>CONNECTED</code>, <code>PENDING_CLIENT_RECONNECTION</code>, and
     * <code>RECONNECTING</code>. You must provide an Amazon Simple Storage Service (Amazon S3) bucket to store the
     * files in. When the session ends, Amazon GameLift Streams produces a compressed folder that contains all of the
     * files and directories that were modified or created by the application during the stream session. AWS uses your
     * security credentials to authenticate and authorize access to your Amazon S3 bucket.
     * </p>
     * <p>
     * Amazon GameLift Streams collects the following generated and modified files. Find them in the corresponding
     * folders in the <code>.zip</code> archive.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>application/</code>: The folder where your application or game is stored.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>profile/</code>: The user profile folder.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>temp/</code>: The system temp folder.
     * </p>
     * </li>
     * </ul>
     * <p/>
     * <p>
     * To verify the status of the exported files, use GetStreamSession.
     * </p>
     * <p>
     * To delete the files, delete the object in the S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportStreamSessionFilesRequest.Builder} avoiding
     * the need to create one manually via {@link ExportStreamSessionFilesRequest#builder()}
     * </p>
     *
     * @param exportStreamSessionFilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.ExportStreamSessionFilesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ExportStreamSessionFiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ExportStreamSessionFiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ExportStreamSessionFiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportStreamSessionFilesResponse> exportStreamSessionFiles(
            Consumer<ExportStreamSessionFilesRequest.Builder> exportStreamSessionFilesRequest) {
        return exportStreamSessionFiles(ExportStreamSessionFilesRequest.builder().applyMutation(exportStreamSessionFilesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves properties for an Amazon GameLift Streams application resource. Specify the ID of the application that
     * you want to retrieve. If the operation is successful, it returns properties for the requested application.
     * </p>
     *
     * @param getApplicationRequest
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/GetApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(GetApplicationRequest getApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves properties for an Amazon GameLift Streams application resource. Specify the ID of the application that
     * you want to retrieve. If the operation is successful, it returns properties for the requested application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     * </p>
     *
     * @param getApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.GetApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/GetApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest) {
        return getApplication(GetApplicationRequest.builder().applyMutation(getApplicationRequest).build());
    }

    /**
     * <p>
     * Retrieves properties for a Amazon GameLift Streams stream group resource. Specify the ID of the stream group that
     * you want to retrieve. If the operation is successful, it returns properties for the requested stream group.
     * </p>
     *
     * @param getStreamGroupRequest
     * @return A Java Future containing the result of the GetStreamGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.GetStreamGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/GetStreamGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStreamGroupResponse> getStreamGroup(GetStreamGroupRequest getStreamGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves properties for a Amazon GameLift Streams stream group resource. Specify the ID of the stream group that
     * you want to retrieve. If the operation is successful, it returns properties for the requested stream group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStreamGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetStreamGroupRequest#builder()}
     * </p>
     *
     * @param getStreamGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.GetStreamGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetStreamGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.GetStreamGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/GetStreamGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStreamGroupResponse> getStreamGroup(Consumer<GetStreamGroupRequest.Builder> getStreamGroupRequest) {
        return getStreamGroup(GetStreamGroupRequest.builder().applyMutation(getStreamGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves properties for a Amazon GameLift Streams stream session resource. Specify the Amazon Resource Name
     * (ARN) of the stream session that you want to retrieve and its stream group ARN. If the operation is successful,
     * it returns properties for the requested resource.
     * </p>
     *
     * @param getStreamSessionRequest
     * @return A Java Future containing the result of the GetStreamSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.GetStreamSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/GetStreamSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStreamSessionResponse> getStreamSession(GetStreamSessionRequest getStreamSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves properties for a Amazon GameLift Streams stream session resource. Specify the Amazon Resource Name
     * (ARN) of the stream session that you want to retrieve and its stream group ARN. If the operation is successful,
     * it returns properties for the requested resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStreamSessionRequest.Builder} avoiding the need
     * to create one manually via {@link GetStreamSessionRequest#builder()}
     * </p>
     *
     * @param getStreamSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.GetStreamSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetStreamSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.GetStreamSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/GetStreamSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStreamSessionResponse> getStreamSession(
            Consumer<GetStreamSessionRequest.Builder> getStreamSessionRequest) {
        return getStreamSession(GetStreamSessionRequest.builder().applyMutation(getStreamSessionRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all Amazon GameLift Streams applications that are associated with the Amazon Web Services
     * account in use. This operation returns applications in all statuses, in no particular order. You can paginate the
     * results as needed.
     * </p>
     *
     * @param listApplicationsRequest
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all Amazon GameLift Streams applications that are associated with the Amazon Web Services
     * account in use. This operation returns applications in all statuses, in no particular order. You can paginate the
     * results as needed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.ListApplicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(
            Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.gameliftstreams.model.ListApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gameliftstreams.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gameliftstreams.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.gameliftstreams.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest) {
        return new ListApplicationsPublisher(this, listApplicationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.gameliftstreams.model.ListApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gameliftstreams.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gameliftstreams.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.gameliftstreams.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.ListApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all Amazon GameLift Streams stream groups that are associated with the Amazon Web Services
     * account in use. This operation returns stream groups in all statuses, in no particular order. You can paginate
     * the results as needed.
     * </p>
     *
     * @param listStreamGroupsRequest
     * @return A Java Future containing the result of the ListStreamGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListStreamGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListStreamGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStreamGroupsResponse> listStreamGroups(ListStreamGroupsRequest listStreamGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all Amazon GameLift Streams stream groups that are associated with the Amazon Web Services
     * account in use. This operation returns stream groups in all statuses, in no particular order. You can paginate
     * the results as needed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListStreamGroupsRequest#builder()}
     * </p>
     *
     * @param listStreamGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStreamGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListStreamGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListStreamGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStreamGroupsResponse> listStreamGroups(
            Consumer<ListStreamGroupsRequest.Builder> listStreamGroupsRequest) {
        return listStreamGroups(ListStreamGroupsRequest.builder().applyMutation(listStreamGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStreamGroups(software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamGroupsPublisher publisher = client.listStreamGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamGroupsPublisher publisher = client.listStreamGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamGroups(software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStreamGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListStreamGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListStreamGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStreamGroupsPublisher listStreamGroupsPaginator(ListStreamGroupsRequest listStreamGroupsRequest) {
        return new ListStreamGroupsPublisher(this, listStreamGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStreamGroups(software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamGroupsPublisher publisher = client.listStreamGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamGroupsPublisher publisher = client.listStreamGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamGroups(software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListStreamGroupsRequest#builder()}
     * </p>
     *
     * @param listStreamGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListStreamGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListStreamGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStreamGroupsPublisher listStreamGroupsPaginator(Consumer<ListStreamGroupsRequest.Builder> listStreamGroupsRequest) {
        return listStreamGroupsPaginator(ListStreamGroupsRequest.builder().applyMutation(listStreamGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of Amazon GameLift Streams stream sessions that a stream group is hosting.
     * </p>
     * <p>
     * To retrieve stream sessions, specify the stream group, and optionally filter by stream session status. You can
     * paginate the results as needed.
     * </p>
     * <p>
     * This operation returns the requested stream sessions in no particular order.
     * </p>
     *
     * @param listStreamSessionsRequest
     * @return A Java Future containing the result of the ListStreamSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListStreamSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListStreamSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStreamSessionsResponse> listStreamSessions(ListStreamSessionsRequest listStreamSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of Amazon GameLift Streams stream sessions that a stream group is hosting.
     * </p>
     * <p>
     * To retrieve stream sessions, specify the stream group, and optionally filter by stream session status. You can
     * paginate the results as needed.
     * </p>
     * <p>
     * This operation returns the requested stream sessions in no particular order.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStreamSessionsRequest#builder()}
     * </p>
     *
     * @param listStreamSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListStreamSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListStreamSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListStreamSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStreamSessionsResponse> listStreamSessions(
            Consumer<ListStreamSessionsRequest.Builder> listStreamSessionsRequest) {
        return listStreamSessions(ListStreamSessionsRequest.builder().applyMutation(listStreamSessionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of Amazon GameLift Streams stream sessions that this user account has access to.
     * </p>
     * <p>
     * In the returned list of stream sessions, the <code>ExportFilesMetadata</code> property only shows the
     * <code>Status</code> value. To get the <code>OutpurUri</code> and <code>StatusReason</code> values, use <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html"
     * >GetStreamSession</a>.
     * </p>
     * <p>
     * We don't recommend using this operation to regularly check stream session statuses because it's costly. Instead,
     * to check status updates for a specific stream session, use <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html"
     * >GetStreamSession</a>.
     * </p>
     *
     * @param listStreamSessionsByAccountRequest
     * @return A Java Future containing the result of the ListStreamSessionsByAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListStreamSessionsByAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListStreamSessionsByAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStreamSessionsByAccountResponse> listStreamSessionsByAccount(
            ListStreamSessionsByAccountRequest listStreamSessionsByAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of Amazon GameLift Streams stream sessions that this user account has access to.
     * </p>
     * <p>
     * In the returned list of stream sessions, the <code>ExportFilesMetadata</code> property only shows the
     * <code>Status</code> value. To get the <code>OutpurUri</code> and <code>StatusReason</code> values, use <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html"
     * >GetStreamSession</a>.
     * </p>
     * <p>
     * We don't recommend using this operation to regularly check stream session statuses because it's costly. Instead,
     * to check status updates for a specific stream session, use <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html"
     * >GetStreamSession</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamSessionsByAccountRequest.Builder}
     * avoiding the need to create one manually via {@link ListStreamSessionsByAccountRequest#builder()}
     * </p>
     *
     * @param listStreamSessionsByAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsByAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListStreamSessionsByAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListStreamSessionsByAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListStreamSessionsByAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStreamSessionsByAccountResponse> listStreamSessionsByAccount(
            Consumer<ListStreamSessionsByAccountRequest.Builder> listStreamSessionsByAccountRequest) {
        return listStreamSessionsByAccount(ListStreamSessionsByAccountRequest.builder()
                .applyMutation(listStreamSessionsByAccountRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStreamSessionsByAccount(software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsByAccountRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamSessionsByAccountPublisher publisher = client.listStreamSessionsByAccountPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamSessionsByAccountPublisher publisher = client.listStreamSessionsByAccountPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsByAccountResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsByAccountResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamSessionsByAccount(software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsByAccountRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStreamSessionsByAccountRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListStreamSessionsByAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListStreamSessionsByAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStreamSessionsByAccountPublisher listStreamSessionsByAccountPaginator(
            ListStreamSessionsByAccountRequest listStreamSessionsByAccountRequest) {
        return new ListStreamSessionsByAccountPublisher(this, listStreamSessionsByAccountRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStreamSessionsByAccount(software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsByAccountRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamSessionsByAccountPublisher publisher = client.listStreamSessionsByAccountPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamSessionsByAccountPublisher publisher = client.listStreamSessionsByAccountPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsByAccountResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsByAccountResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamSessionsByAccount(software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsByAccountRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamSessionsByAccountRequest.Builder}
     * avoiding the need to create one manually via {@link ListStreamSessionsByAccountRequest#builder()}
     * </p>
     *
     * @param listStreamSessionsByAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsByAccountRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListStreamSessionsByAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListStreamSessionsByAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStreamSessionsByAccountPublisher listStreamSessionsByAccountPaginator(
            Consumer<ListStreamSessionsByAccountRequest.Builder> listStreamSessionsByAccountRequest) {
        return listStreamSessionsByAccountPaginator(ListStreamSessionsByAccountRequest.builder()
                .applyMutation(listStreamSessionsByAccountRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStreamSessions(software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamSessionsPublisher publisher = client.listStreamSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamSessionsPublisher publisher = client.listStreamSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamSessions(software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStreamSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListStreamSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListStreamSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStreamSessionsPublisher listStreamSessionsPaginator(ListStreamSessionsRequest listStreamSessionsRequest) {
        return new ListStreamSessionsPublisher(this, listStreamSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStreamSessions(software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamSessionsPublisher publisher = client.listStreamSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gameliftstreams.paginators.ListStreamSessionsPublisher publisher = client.listStreamSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamSessions(software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStreamSessionsRequest#builder()}
     * </p>
     *
     * @param listStreamSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListStreamSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListStreamSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStreamSessionsPublisher listStreamSessionsPaginator(
            Consumer<ListStreamSessionsRequest.Builder> listStreamSessionsRequest) {
        return listStreamSessionsPaginator(ListStreamSessionsRequest.builder().applyMutation(listStreamSessionsRequest).build());
    }

    /**
     * <p>
     * Retrieves all tags assigned to a Amazon GameLift Streams resource. To list tags for a resource, specify the ARN
     * value for the resource.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     * Resources</a> in the <i>Amazon Web Services General Reference</i>
     * </p>
     * <p>
     * <a href="http://aws.amazon.com/answers/account-management/aws-tagging-strategies/"> Amazon Web Services Tagging
     * Strategies</a>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all tags assigned to a Amazon GameLift Streams resource. To list tags for a resource, specify the ARN
     * value for the resource.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     * Resources</a> in the <i>Amazon Web Services General Reference</i>
     * </p>
     * <p>
     * <a href="http://aws.amazon.com/answers/account-management/aws-tagging-strategies/"> Amazon Web Services Tagging
     * Strategies</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Removes a set of remote locations from this stream group. To remove a location, the stream group must be in
     * <code>ACTIVE</code> status. When you remove a location, Amazon GameLift Streams releases allocated compute
     * resources in that location. Stream sessions can no longer start from removed locations in a stream group. Amazon
     * GameLift Streams also deletes the content files of all associated applications that were in Amazon GameLift
     * Streams's internal Amazon S3 bucket at this location.
     * </p>
     * <p>
     * You cannot remove the Amazon Web Services Region location where you initially created this stream group, known as
     * the primary location. However, you can set the stream capacity to zero to avoid incurring costs for allocated
     * compute resources in that location.
     * </p>
     *
     * @param removeStreamGroupLocationsRequest
     * @return A Java Future containing the result of the RemoveStreamGroupLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.RemoveStreamGroupLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/RemoveStreamGroupLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveStreamGroupLocationsResponse> removeStreamGroupLocations(
            RemoveStreamGroupLocationsRequest removeStreamGroupLocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a set of remote locations from this stream group. To remove a location, the stream group must be in
     * <code>ACTIVE</code> status. When you remove a location, Amazon GameLift Streams releases allocated compute
     * resources in that location. Stream sessions can no longer start from removed locations in a stream group. Amazon
     * GameLift Streams also deletes the content files of all associated applications that were in Amazon GameLift
     * Streams's internal Amazon S3 bucket at this location.
     * </p>
     * <p>
     * You cannot remove the Amazon Web Services Region location where you initially created this stream group, known as
     * the primary location. However, you can set the stream capacity to zero to avoid incurring costs for allocated
     * compute resources in that location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveStreamGroupLocationsRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveStreamGroupLocationsRequest#builder()}
     * </p>
     *
     * @param removeStreamGroupLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.RemoveStreamGroupLocationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RemoveStreamGroupLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.RemoveStreamGroupLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/RemoveStreamGroupLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveStreamGroupLocationsResponse> removeStreamGroupLocations(
            Consumer<RemoveStreamGroupLocationsRequest.Builder> removeStreamGroupLocationsRequest) {
        return removeStreamGroupLocations(RemoveStreamGroupLocationsRequest.builder()
                .applyMutation(removeStreamGroupLocationsRequest).build());
    }

    /**
     * <p>
     * This action initiates a new stream session and outputs connection information that clients can use to access the
     * stream. A stream session refers to an instance of a stream that Amazon GameLift Streams transmits from the server
     * to the end-user. A stream session runs on a compute resource that a stream group has allocated. The start stream
     * session process works as follows:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must have a stream group in <code>ACTIVE</code> status
     * </p>
     * </li>
     * <li>
     * <p>
     * You must have idle or on-demand capacity in a stream group in the location you want to stream from
     * </p>
     * </li>
     * <li>
     * <p>
     * You must have at least one application associated to the stream group (use <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_AssociateApplications.html"
     * >AssociateApplications</a> if needed)
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Start stream request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Your backend server calls <b>StartStreamSession</b> to initiate connection
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon GameLift Streams creates the stream session resource, assigns an Amazon Resource Name (ARN) value, and
     * begins searching for available stream capacity to run the stream
     * </p>
     * </li>
     * <li>
     * <p>
     * Session transitions to <code>ACTIVATING</code> status
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Placement completion:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If Amazon GameLift Streams is successful in finding capacity for the stream, the stream session status changes to
     * <code>ACTIVE</code> status and <b>StartStreamSession</b> returns stream connection information
     * </p>
     * </li>
     * <li>
     * <p>
     * If Amazon GameLift Streams was not successful in finding capacity within the placement timeout period (defined
     * according to the capacity type and platform type), the stream session status changes to <code>ERROR</code> status
     * and <b>StartStreamSession</b> returns a <code>StatusReason</code> of <code>placementTimeout</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Connection completion:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Provide the new connection information to the requesting client
     * </p>
     * </li>
     * <li>
     * <p>
     * Client must establish connection within <code>ConnectionTimeoutSeconds</code> (specified in
     * <b>StartStreamSession</b> parameters)
     * </p>
     * </li>
     * <li>
     * <p>
     * Session terminates automatically if client fails to connect in time
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * For more information about the stream session lifecycle, see <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/stream-sessions.html">Stream sessions</a>
     * in the <i>Amazon GameLift Streams Developer Guide</i>.
     * </p>
     * <p>
     * Timeouts to be aware of that affect a stream session:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Placement timeout</b>: The amount of time that Amazon GameLift Streams has to find capacity for a stream
     * request. Placement timeout varies based on the capacity type used to fulfill your stream request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Always-on capacity</b>: 75 seconds
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>On-demand capacity</b>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Linux/Proton runtimes: 90 seconds
     * </p>
     * </li>
     * <li>
     * <p>
     * Windows runtime: 10 minutes
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Connection timeout</b>: The amount of time that Amazon GameLift Streams waits for a client to connect to a
     * stream session in <code>ACTIVE</code> status, or reconnect to a stream session in
     * <code>PENDING_CLIENT_RECONNECTION</code> status, the latter of which occurs when a client disconnects or loses
     * connection from a stream session. If no client connects before the timeout, Amazon GameLift Streams terminates
     * the stream session. This value is specified by <code>ConnectionTimeoutSeconds</code> in the
     * <code>StartStreamSession</code> parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Idle timeout</b>: A stream session will be terminated if no user input has been received for 60 minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Maximum session length</b>: A stream session will be terminated after this amount of time has elapsed since it
     * started, regardless of any existing client connections. This value is specified by
     * <code>SessionLengthSeconds</code> in the <code>StartStreamSession</code> parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To start a new stream session, specify a stream group ID and application ID, along with the transport protocol
     * and signal request to use with the stream session.
     * </p>
     * <p>
     * For stream groups that have multiple locations, provide a set of locations ordered by priority using a
     * <code>Locations</code> parameter. Amazon GameLift Streams will start a single stream session in the next
     * available location. An application must be finished replicating to a remote location before the remote location
     * can host a stream.
     * </p>
     * <p>
     * To reconnect to a stream session after a client disconnects or loses connection, use <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_CreateStreamSessionConnection.html"
     * >CreateStreamSessionConnection</a>.
     * </p>
     *
     * @param startStreamSessionRequest
     * @return A Java Future containing the result of the StartStreamSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.StartStreamSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/StartStreamSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartStreamSessionResponse> startStreamSession(StartStreamSessionRequest startStreamSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action initiates a new stream session and outputs connection information that clients can use to access the
     * stream. A stream session refers to an instance of a stream that Amazon GameLift Streams transmits from the server
     * to the end-user. A stream session runs on a compute resource that a stream group has allocated. The start stream
     * session process works as follows:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must have a stream group in <code>ACTIVE</code> status
     * </p>
     * </li>
     * <li>
     * <p>
     * You must have idle or on-demand capacity in a stream group in the location you want to stream from
     * </p>
     * </li>
     * <li>
     * <p>
     * You must have at least one application associated to the stream group (use <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_AssociateApplications.html"
     * >AssociateApplications</a> if needed)
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Start stream request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Your backend server calls <b>StartStreamSession</b> to initiate connection
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon GameLift Streams creates the stream session resource, assigns an Amazon Resource Name (ARN) value, and
     * begins searching for available stream capacity to run the stream
     * </p>
     * </li>
     * <li>
     * <p>
     * Session transitions to <code>ACTIVATING</code> status
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Placement completion:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If Amazon GameLift Streams is successful in finding capacity for the stream, the stream session status changes to
     * <code>ACTIVE</code> status and <b>StartStreamSession</b> returns stream connection information
     * </p>
     * </li>
     * <li>
     * <p>
     * If Amazon GameLift Streams was not successful in finding capacity within the placement timeout period (defined
     * according to the capacity type and platform type), the stream session status changes to <code>ERROR</code> status
     * and <b>StartStreamSession</b> returns a <code>StatusReason</code> of <code>placementTimeout</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Connection completion:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Provide the new connection information to the requesting client
     * </p>
     * </li>
     * <li>
     * <p>
     * Client must establish connection within <code>ConnectionTimeoutSeconds</code> (specified in
     * <b>StartStreamSession</b> parameters)
     * </p>
     * </li>
     * <li>
     * <p>
     * Session terminates automatically if client fails to connect in time
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * For more information about the stream session lifecycle, see <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/stream-sessions.html">Stream sessions</a>
     * in the <i>Amazon GameLift Streams Developer Guide</i>.
     * </p>
     * <p>
     * Timeouts to be aware of that affect a stream session:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Placement timeout</b>: The amount of time that Amazon GameLift Streams has to find capacity for a stream
     * request. Placement timeout varies based on the capacity type used to fulfill your stream request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Always-on capacity</b>: 75 seconds
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>On-demand capacity</b>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Linux/Proton runtimes: 90 seconds
     * </p>
     * </li>
     * <li>
     * <p>
     * Windows runtime: 10 minutes
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Connection timeout</b>: The amount of time that Amazon GameLift Streams waits for a client to connect to a
     * stream session in <code>ACTIVE</code> status, or reconnect to a stream session in
     * <code>PENDING_CLIENT_RECONNECTION</code> status, the latter of which occurs when a client disconnects or loses
     * connection from a stream session. If no client connects before the timeout, Amazon GameLift Streams terminates
     * the stream session. This value is specified by <code>ConnectionTimeoutSeconds</code> in the
     * <code>StartStreamSession</code> parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Idle timeout</b>: A stream session will be terminated if no user input has been received for 60 minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Maximum session length</b>: A stream session will be terminated after this amount of time has elapsed since it
     * started, regardless of any existing client connections. This value is specified by
     * <code>SessionLengthSeconds</code> in the <code>StartStreamSession</code> parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To start a new stream session, specify a stream group ID and application ID, along with the transport protocol
     * and signal request to use with the stream session.
     * </p>
     * <p>
     * For stream groups that have multiple locations, provide a set of locations ordered by priority using a
     * <code>Locations</code> parameter. Amazon GameLift Streams will start a single stream session in the next
     * available location. An application must be finished replicating to a remote location before the remote location
     * can host a stream.
     * </p>
     * <p>
     * To reconnect to a stream session after a client disconnects or loses connection, use <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_CreateStreamSessionConnection.html"
     * >CreateStreamSessionConnection</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartStreamSessionRequest.Builder} avoiding the
     * need to create one manually via {@link StartStreamSessionRequest#builder()}
     * </p>
     *
     * @param startStreamSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.StartStreamSessionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartStreamSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.StartStreamSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/StartStreamSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartStreamSessionResponse> startStreamSession(
            Consumer<StartStreamSessionRequest.Builder> startStreamSessionRequest) {
        return startStreamSession(StartStreamSessionRequest.builder().applyMutation(startStreamSessionRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags to a Amazon GameLift Streams resource. Use tags to organize Amazon Web Services
     * resources for a range of purposes. You can assign tags to the following Amazon GameLift Streams resource types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Application
     * </p>
     * </li>
     * <li>
     * <p>
     * StreamGroup
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     * Resources</a> in the <i>Amazon Web Services General Reference</i>
     * </p>
     * <p>
     * <a href="http://aws.amazon.com/answers/account-management/aws-tagging-strategies/"> Amazon Web Services Tagging
     * Strategies</a>
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags to a Amazon GameLift Streams resource. Use tags to organize Amazon Web Services
     * resources for a range of purposes. You can assign tags to the following Amazon GameLift Streams resource types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Application
     * </p>
     * </li>
     * <li>
     * <p>
     * StreamGroup
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     * Resources</a> in the <i>Amazon Web Services General Reference</i>
     * </p>
     * <p>
     * <a href="http://aws.amazon.com/answers/account-management/aws-tagging-strategies/"> Amazon Web Services Tagging
     * Strategies</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Permanently terminates an active stream session. When called, the stream session status changes to
     * <code>TERMINATING</code>. You can terminate a stream session in any status except <code>ACTIVATING</code>. If the
     * stream session is in <code>ACTIVATING</code> status, an exception is thrown.
     * </p>
     *
     * @param terminateStreamSessionRequest
     * @return A Java Future containing the result of the TerminateStreamSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.TerminateStreamSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/TerminateStreamSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TerminateStreamSessionResponse> terminateStreamSession(
            TerminateStreamSessionRequest terminateStreamSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently terminates an active stream session. When called, the stream session status changes to
     * <code>TERMINATING</code>. You can terminate a stream session in any status except <code>ACTIVATING</code>. If the
     * stream session is in <code>ACTIVATING</code> status, an exception is thrown.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateStreamSessionRequest.Builder} avoiding the
     * need to create one manually via {@link TerminateStreamSessionRequest#builder()}
     * </p>
     *
     * @param terminateStreamSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.TerminateStreamSessionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the TerminateStreamSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.TerminateStreamSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/TerminateStreamSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TerminateStreamSessionResponse> terminateStreamSession(
            Consumer<TerminateStreamSessionRequest.Builder> terminateStreamSessionRequest) {
        return terminateStreamSession(TerminateStreamSessionRequest.builder().applyMutation(terminateStreamSessionRequest)
                .build());
    }

    /**
     * <p>
     * Removes one or more tags from a Amazon GameLift Streams resource. To remove tags, specify the Amazon GameLift
     * Streams resource and a list of one or more tags to remove.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a Amazon GameLift Streams resource. To remove tags, specify the Amazon GameLift
     * Streams resource and a list of one or more tags to remove.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the mutable configuration settings for a Amazon GameLift Streams application resource. You can change the
     * <code>Description</code>, <code>ApplicationLogOutputUri</code>, and <code>ApplicationLogPaths</code>.
     * </p>
     * <p>
     * To update application settings, specify the application ID and provide the new values. If the operation is
     * successful, it returns the complete updated set of settings for the application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the mutable configuration settings for a Amazon GameLift Streams application resource. You can change the
     * <code>Description</code>, <code>ApplicationLogOutputUri</code>, and <code>ApplicationLogPaths</code>.
     * </p>
     * <p>
     * To update application settings, specify the application ID and provide the new values. If the operation is
     * successful, it returns the complete updated set of settings for the application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.UpdateApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(
            Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest) {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates the configuration settings for an Amazon GameLift Streams stream group resource. To update a stream
     * group, it must be in <code>ACTIVE</code> status. You can change the description, the set of locations, and the
     * requested capacity of a stream group per location. If you want to change the stream class, create a new stream
     * group.
     * </p>
     * <p>
     * Stream capacity represents the number of concurrent streams that can be active at a time. You set stream capacity
     * per location, per stream group. There are two types of capacity, always-on and on-demand:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Always-on</b>: The streaming capacity that is allocated and ready to handle stream requests without delay. You
     * pay for this capacity whether it's in use or not. Best for quickest time from streaming request to streaming
     * session. Default is 1 (2 for high stream classes) when creating a stream group or adding a location.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>On-demand</b>: The streaming capacity that Amazon GameLift Streams can allocate in response to stream
     * requests, and then de-allocate when the session has terminated. This offers a cost control measure at the expense
     * of a greater startup time (typically under 5 minutes). Default is 0 when creating a stream group or adding a
     * location.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Values for capacity must be whole number multiples of the tenancy value of the stream group's stream class.
     * </p>
     * <p>
     * To update a stream group, specify the stream group's Amazon Resource Name (ARN) and provide the new values. If
     * the request is successful, Amazon GameLift Streams returns the complete updated metadata for the stream group.
     * Expired stream groups cannot be updated.
     * </p>
     *
     * @param updateStreamGroupRequest
     * @return A Java Future containing the result of the UpdateStreamGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>ServiceQuotaExceededException The request would cause the resource to exceed an allowed service
     *         quota. Resolve the issue before you try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.UpdateStreamGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/UpdateStreamGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStreamGroupResponse> updateStreamGroup(UpdateStreamGroupRequest updateStreamGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration settings for an Amazon GameLift Streams stream group resource. To update a stream
     * group, it must be in <code>ACTIVE</code> status. You can change the description, the set of locations, and the
     * requested capacity of a stream group per location. If you want to change the stream class, create a new stream
     * group.
     * </p>
     * <p>
     * Stream capacity represents the number of concurrent streams that can be active at a time. You set stream capacity
     * per location, per stream group. There are two types of capacity, always-on and on-demand:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Always-on</b>: The streaming capacity that is allocated and ready to handle stream requests without delay. You
     * pay for this capacity whether it's in use or not. Best for quickest time from streaming request to streaming
     * session. Default is 1 (2 for high stream classes) when creating a stream group or adding a location.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>On-demand</b>: The streaming capacity that Amazon GameLift Streams can allocate in response to stream
     * requests, and then de-allocate when the session has terminated. This offers a cost control measure at the expense
     * of a greater startup time (typically under 5 minutes). Default is 0 when creating a stream group or adding a
     * location.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Values for capacity must be whole number multiples of the tenancy value of the stream group's stream class.
     * </p>
     * <p>
     * To update a stream group, specify the stream group's Amazon Resource Name (ARN) and provide the new values. If
     * the request is successful, Amazon GameLift Streams returns the complete updated metadata for the stream group.
     * Expired stream groups cannot be updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStreamGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateStreamGroupRequest#builder()}
     * </p>
     *
     * @param updateStreamGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gameliftstreams.model.UpdateStreamGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateStreamGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have the required permissions to access this Amazon GameLift Streams
     *         resource. Correct the permissions before you try again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request was not found. Correct the request
     *         before you try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Retry the request after the
     *         suggested wait time.</li>
     *         <li>InternalServerException The service encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException One or more parameter values in the request fail to satisfy the specified
     *         constraints. Correct the invalid parameter values before retrying the request.</li>
     *         <li>ServiceQuotaExceededException The request would cause the resource to exceed an allowed service
     *         quota. Resolve the issue before you try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftStreamsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample GameLiftStreamsAsyncClient.UpdateStreamGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gameliftstreams-2018-05-10/UpdateStreamGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStreamGroupResponse> updateStreamGroup(
            Consumer<UpdateStreamGroupRequest.Builder> updateStreamGroupRequest) {
        return updateStreamGroup(UpdateStreamGroupRequest.builder().applyMutation(updateStreamGroupRequest).build());
    }

    /**
     * Create an instance of {@link GameLiftStreamsAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link GameLiftStreamsAsyncWaiter}
     */
    default GameLiftStreamsAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default GameLiftStreamsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link GameLiftStreamsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GameLiftStreamsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GameLiftStreamsAsyncClient}.
     */
    static GameLiftStreamsAsyncClientBuilder builder() {
        return new DefaultGameLiftStreamsAsyncClientBuilder();
    }
}
