/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an application resource that represents a collection of content for streaming with Amazon GameLift Streams.
 * To retrieve additional application details, call <a
 * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetApplication.html">GetApplication</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationSummary.Builder, ApplicationSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ApplicationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ApplicationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ApplicationSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ApplicationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ApplicationSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(ApplicationSummary::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<RuntimeEnvironment> RUNTIME_ENVIRONMENT_FIELD = SdkField
            .<RuntimeEnvironment> builder(MarshallingType.SDK_POJO).memberName("RuntimeEnvironment")
            .getter(getter(ApplicationSummary::runtimeEnvironment)).setter(setter(Builder::runtimeEnvironment))
            .constructor(RuntimeEnvironment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            DESCRIPTION_FIELD, STATUS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, RUNTIME_ENVIRONMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String description;

    private final String status;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final RuntimeEnvironment runtimeEnvironment;

    private ApplicationSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.description = builder.description;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.runtimeEnvironment = builder.runtimeEnvironment;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that's assigned to an application resource and uniquely identifies the application
     * across all Amazon Web Services Regions. Format is
     * <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:application/[resource ID]</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that's assigned to an application resource and uniquely identifies the
     *         application across all Amazon Web Services Regions. Format is
     *         <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:application/[resource ID]</code>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * An ID that uniquely identifies the application resource. Example ID: <code>a-9ZY8X7Wv6</code>.
     * </p>
     * 
     * @return An ID that uniquely identifies the application resource. Example ID: <code>a-9ZY8X7Wv6</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A human-readable label for the application. You can edit this value.
     * </p>
     * 
     * @return A human-readable label for the application. You can edit this value.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current status of the application resource. Possible statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work flow to
     * create an application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is copying the
     * content and caching for future deployment in a stream group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code>: The application is ready to deploy in a stream group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: An error occurred when setting up the application. For more information about the error, call
     * <code>GetApplication</code> and refer to <code>StatusReason</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the application resource. Possible statuses include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work
     *         flow to create an application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is
     *         copying the content and caching for future deployment in a stream group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code>: The application is ready to deploy in a stream group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: An error occurred when setting up the application. For more information about the
     *         error, call <code>GetApplication</code> and refer to <code>StatusReason</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
     *         </p>
     *         </li>
     * @see ApplicationStatus
     */
    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the application resource. Possible statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work flow to
     * create an application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is copying the
     * content and caching for future deployment in a stream group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code>: The application is ready to deploy in a stream group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: An error occurred when setting up the application. For more information about the error, call
     * <code>GetApplication</code> and refer to <code>StatusReason</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the application resource. Possible statuses include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work
     *         flow to create an application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is
     *         copying the content and caching for future deployment in a stream group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code>: The application is ready to deploy in a stream group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: An error occurred when setting up the application. For more information about the
     *         error, call <code>GetApplication</code> and refer to <code>StatusReason</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
     *         </p>
     *         </li>
     * @see ApplicationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601 format, such
     * as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     * </p>
     * 
     * @return A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601
     *         format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601 format,
     * such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     * </p>
     * 
     * @return A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601
     *         format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * Configuration settings that identify the operating system for an application resource. This can also include a
     * compatibility layer and other drivers.
     * </p>
     * <p>
     * A runtime environment can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Linux applications
     * </p>
     * <ul>
     * <li>
     * <p>
     * Ubuntu 22.04 LTS (<code>Type=UBUNTU, Version=22_04_LTS</code>)
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For Windows applications
     * </p>
     * <ul>
     * <li>
     * <p>
     * Microsoft Windows Server 2022 Base (<code>Type=WINDOWS, Version=2022</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Proton 9.0-2 (<code>Type=PROTON, Version=20250516</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Proton 8.0-5 (<code>Type=PROTON, Version=20241007</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Proton 8.0-2c (<code>Type=PROTON, Version=20230704</code>)
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return Configuration settings that identify the operating system for an application resource. This can also
     *         include a compatibility layer and other drivers. </p>
     *         <p>
     *         A runtime environment can be one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For Linux applications
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Ubuntu 22.04 LTS (<code>Type=UBUNTU, Version=22_04_LTS</code>)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For Windows applications
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Microsoft Windows Server 2022 Base (<code>Type=WINDOWS, Version=2022</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Proton 9.0-2 (<code>Type=PROTON, Version=20250516</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Proton 8.0-5 (<code>Type=PROTON, Version=20241007</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Proton 8.0-2c (<code>Type=PROTON, Version=20230704</code>)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final RuntimeEnvironment runtimeEnvironment() {
        return runtimeEnvironment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeEnvironment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(runtimeEnvironment(), other.runtimeEnvironment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationSummary").add("Arn", arn()).add("Id", id()).add("Description", description())
                .add("Status", statusAsString()).add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("RuntimeEnvironment", runtimeEnvironment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "RuntimeEnvironment":
            return Optional.ofNullable(clazz.cast(runtimeEnvironment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("RuntimeEnvironment", RUNTIME_ENVIRONMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSummary, T> g) {
        return obj -> g.apply((ApplicationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationSummary> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that's assigned to an application resource and uniquely identifies the
         * application across all Amazon Web Services Regions. Format is
         * <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:application/[resource ID]</code>.
         * </p>
         * 
         * @param arn
         *        An Amazon Resource Name (ARN) that's assigned to an application resource and uniquely identifies the
         *        application across all Amazon Web Services Regions. Format is
         *        <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:application/[resource ID]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * An ID that uniquely identifies the application resource. Example ID: <code>a-9ZY8X7Wv6</code>.
         * </p>
         * 
         * @param id
         *        An ID that uniquely identifies the application resource. Example ID: <code>a-9ZY8X7Wv6</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A human-readable label for the application. You can edit this value.
         * </p>
         * 
         * @param description
         *        A human-readable label for the application. You can edit this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current status of the application resource. Possible statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work flow to
         * create an application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is copying
         * the content and caching for future deployment in a stream group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code>: The application is ready to deploy in a stream group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: An error occurred when setting up the application. For more information about the error,
         * call <code>GetApplication</code> and refer to <code>StatusReason</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the application resource. Possible statuses include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work
         *        flow to create an application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is
         *        copying the content and caching for future deployment in a stream group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code>: The application is ready to deploy in a stream group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: An error occurred when setting up the application. For more information about the
         *        error, call <code>GetApplication</code> and refer to <code>StatusReason</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
         *        </p>
         *        </li>
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the application resource. Possible statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work flow to
         * create an application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is copying
         * the content and caching for future deployment in a stream group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code>: The application is ready to deploy in a stream group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: An error occurred when setting up the application. For more information about the error,
         * call <code>GetApplication</code> and refer to <code>StatusReason</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the application resource. Possible statuses include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work
         *        flow to create an application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is
         *        copying the content and caching for future deployment in a stream group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code>: The application is ready to deploy in a stream group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: An error occurred when setting up the application. For more information about the
         *        error, call <code>GetApplication</code> and refer to <code>StatusReason</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
         *        </p>
         *        </li>
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(ApplicationStatus status);

        /**
         * <p>
         * A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601 format,
         * such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * </p>
         * 
         * @param createdAt
         *        A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601
         *        format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601
         * format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * </p>
         * 
         * @param lastUpdatedAt
         *        A timestamp that indicates when this resource was last updated. Timestamps are expressed using in
         *        ISO8601 format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * Configuration settings that identify the operating system for an application resource. This can also include
         * a compatibility layer and other drivers.
         * </p>
         * <p>
         * A runtime environment can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For Linux applications
         * </p>
         * <ul>
         * <li>
         * <p>
         * Ubuntu 22.04 LTS (<code>Type=UBUNTU, Version=22_04_LTS</code>)
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For Windows applications
         * </p>
         * <ul>
         * <li>
         * <p>
         * Microsoft Windows Server 2022 Base (<code>Type=WINDOWS, Version=2022</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Proton 9.0-2 (<code>Type=PROTON, Version=20250516</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Proton 8.0-5 (<code>Type=PROTON, Version=20241007</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Proton 8.0-2c (<code>Type=PROTON, Version=20230704</code>)
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param runtimeEnvironment
         *        Configuration settings that identify the operating system for an application resource. This can also
         *        include a compatibility layer and other drivers. </p>
         *        <p>
         *        A runtime environment can be one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For Linux applications
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Ubuntu 22.04 LTS (<code>Type=UBUNTU, Version=22_04_LTS</code>)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For Windows applications
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Microsoft Windows Server 2022 Base (<code>Type=WINDOWS, Version=2022</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Proton 9.0-2 (<code>Type=PROTON, Version=20250516</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Proton 8.0-5 (<code>Type=PROTON, Version=20241007</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Proton 8.0-2c (<code>Type=PROTON, Version=20230704</code>)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment);

        /**
         * <p>
         * Configuration settings that identify the operating system for an application resource. This can also include
         * a compatibility layer and other drivers.
         * </p>
         * <p>
         * A runtime environment can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For Linux applications
         * </p>
         * <ul>
         * <li>
         * <p>
         * Ubuntu 22.04 LTS (<code>Type=UBUNTU, Version=22_04_LTS</code>)
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For Windows applications
         * </p>
         * <ul>
         * <li>
         * <p>
         * Microsoft Windows Server 2022 Base (<code>Type=WINDOWS, Version=2022</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Proton 9.0-2 (<code>Type=PROTON, Version=20250516</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Proton 8.0-5 (<code>Type=PROTON, Version=20241007</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Proton 8.0-2c (<code>Type=PROTON, Version=20230704</code>)
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link RuntimeEnvironment.Builder} avoiding the
         * need to create one manually via {@link RuntimeEnvironment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuntimeEnvironment.Builder#build()} is called immediately and its
         * result is passed to {@link #runtimeEnvironment(RuntimeEnvironment)}.
         * 
         * @param runtimeEnvironment
         *        a consumer that will call methods on {@link RuntimeEnvironment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeEnvironment(RuntimeEnvironment)
         */
        default Builder runtimeEnvironment(Consumer<RuntimeEnvironment.Builder> runtimeEnvironment) {
            return runtimeEnvironment(RuntimeEnvironment.builder().applyMutation(runtimeEnvironment).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String description;

        private String status;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private RuntimeEnvironment runtimeEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            arn(model.arn);
            id(model.id);
            description(model.description);
            status(model.status);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            runtimeEnvironment(model.runtimeEnvironment);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final RuntimeEnvironment.Builder getRuntimeEnvironment() {
            return runtimeEnvironment != null ? runtimeEnvironment.toBuilder() : null;
        }

        public final void setRuntimeEnvironment(RuntimeEnvironment.BuilderImpl runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment != null ? runtimeEnvironment.build() : null;
        }

        @Override
        public final Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        @Override
        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
