/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamSessionsRequest extends GameLiftStreamsRequest implements
        ToCopyableBuilder<ListStreamSessionsRequest.Builder, ListStreamSessionsRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListStreamSessionsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Status").build()).build();

    private static final SdkField<String> EXPORT_FILES_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportFilesStatus").getter(getter(ListStreamSessionsRequest::exportFilesStatusAsString))
            .setter(setter(Builder::exportFilesStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ExportFilesStatus").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStreamSessionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListStreamSessionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(ListStreamSessionsRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            EXPORT_FILES_STATUS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final String exportFilesStatus;

    private final String nextToken;

    private final Integer maxResults;

    private final String identifier;

    private ListStreamSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.exportFilesStatus = builder.exportFilesStatus;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.identifier = builder.identifier;
    }

    /**
     * <p>
     * Filter by the stream session status. You can specify one status in each request to retrieve only sessions that
     * are currently in that status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Filter by the stream session status. You can specify one status in each request to retrieve only sessions
     *         that are currently in that status.
     * @see StreamSessionStatus
     */
    public final StreamSessionStatus status() {
        return StreamSessionStatus.fromValue(status);
    }

    /**
     * <p>
     * Filter by the stream session status. You can specify one status in each request to retrieve only sessions that
     * are currently in that status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Filter by the stream session status. You can specify one status in each request to retrieve only sessions
     *         that are currently in that status.
     * @see StreamSessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Filter by the exported files status. You can specify one status in each request to retrieve only sessions that
     * currently have that exported files status.
     * </p>
     * <p>
     * Exported files can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The exported files are successfully stored in an S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The session ended but Amazon GameLift Streams couldn't collect and upload the files to S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>: Either the stream session is still in progress, or uploading the exported files to the S3
     * bucket is in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportFilesStatus}
     * will return {@link ExportFilesStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportFilesStatusAsString}.
     * </p>
     * 
     * @return Filter by the exported files status. You can specify one status in each request to retrieve only sessions
     *         that currently have that exported files status.</p>
     *         <p>
     *         Exported files can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The exported files are successfully stored in an S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The session ended but Amazon GameLift Streams couldn't collect and upload the files
     *         to S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: Either the stream session is still in progress, or uploading the exported files to
     *         the S3 bucket is in progress.
     *         </p>
     *         </li>
     * @see ExportFilesStatus
     */
    public final ExportFilesStatus exportFilesStatus() {
        return ExportFilesStatus.fromValue(exportFilesStatus);
    }

    /**
     * <p>
     * Filter by the exported files status. You can specify one status in each request to retrieve only sessions that
     * currently have that exported files status.
     * </p>
     * <p>
     * Exported files can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The exported files are successfully stored in an S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The session ended but Amazon GameLift Streams couldn't collect and upload the files to S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>: Either the stream session is still in progress, or uploading the exported files to the S3
     * bucket is in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportFilesStatus}
     * will return {@link ExportFilesStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportFilesStatusAsString}.
     * </p>
     * 
     * @return Filter by the exported files status. You can specify one status in each request to retrieve only sessions
     *         that currently have that exported files status.</p>
     *         <p>
     *         Exported files can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The exported files are successfully stored in an S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The session ended but Amazon GameLift Streams couldn't collect and upload the files
     *         to S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: Either the stream session is still in progress, or uploading the exported files to
     *         the S3 bucket is in progress.
     *         </p>
     *         </li>
     * @see ExportFilesStatus
     */
    public final String exportFilesStatusAsString() {
        return exportFilesStatus;
    }

    /**
     * <p>
     * The token that marks the start of the next set of results. Use this token when you retrieve results as sequential
     * pages. To get the first page of results, omit a token value. To get the remaining pages, provide the token
     * returned with the previous result set.
     * </p>
     * 
     * @return The token that marks the start of the next set of results. Use this token when you retrieve results as
     *         sequential pages. To get the first page of results, omit a token value. To get the remaining pages,
     *         provide the token returned with the previous result set.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of results to return. Use this parameter with <code>NextToken</code> to return results in sequential
     * pages. Default value is <code>25</code>.
     * </p>
     * 
     * @return The number of results to return. Use this parameter with <code>NextToken</code> to return results in
     *         sequential pages. Default value is <code>25</code>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The unique identifier of a Amazon GameLift Streams stream group to retrieve the stream session for. You can use
     * either the stream group ID or the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a>.
     * </p>
     * 
     * @return The unique identifier of a Amazon GameLift Streams stream group to retrieve the stream session for. You
     *         can use either the stream group ID or the <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
     *         (ARN)</a>.
     */
    public final String identifier() {
        return identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportFilesStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamSessionsRequest)) {
            return false;
        }
        ListStreamSessionsRequest other = (ListStreamSessionsRequest) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(exportFilesStatusAsString(), other.exportFilesStatusAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(identifier(), other.identifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStreamSessionsRequest").add("Status", statusAsString())
                .add("ExportFilesStatus", exportFilesStatusAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Identifier", identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ExportFilesStatus":
            return Optional.ofNullable(clazz.cast(exportFilesStatusAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("ExportFilesStatus", EXPORT_FILES_STATUS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStreamSessionsRequest, T> g) {
        return obj -> g.apply((ListStreamSessionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftStreamsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListStreamSessionsRequest> {
        /**
         * <p>
         * Filter by the stream session status. You can specify one status in each request to retrieve only sessions
         * that are currently in that status.
         * </p>
         * 
         * @param status
         *        Filter by the stream session status. You can specify one status in each request to retrieve only
         *        sessions that are currently in that status.
         * @see StreamSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamSessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Filter by the stream session status. You can specify one status in each request to retrieve only sessions
         * that are currently in that status.
         * </p>
         * 
         * @param status
         *        Filter by the stream session status. You can specify one status in each request to retrieve only
         *        sessions that are currently in that status.
         * @see StreamSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamSessionStatus
         */
        Builder status(StreamSessionStatus status);

        /**
         * <p>
         * Filter by the exported files status. You can specify one status in each request to retrieve only sessions
         * that currently have that exported files status.
         * </p>
         * <p>
         * Exported files can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The exported files are successfully stored in an S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The session ended but Amazon GameLift Streams couldn't collect and upload the files to
         * S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>: Either the stream session is still in progress, or uploading the exported files to the
         * S3 bucket is in progress.
         * </p>
         * </li>
         * </ul>
         * 
         * @param exportFilesStatus
         *        Filter by the exported files status. You can specify one status in each request to retrieve only
         *        sessions that currently have that exported files status.</p>
         *        <p>
         *        Exported files can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The exported files are successfully stored in an S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The session ended but Amazon GameLift Streams couldn't collect and upload the
         *        files to S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: Either the stream session is still in progress, or uploading the exported files
         *        to the S3 bucket is in progress.
         *        </p>
         *        </li>
         * @see ExportFilesStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportFilesStatus
         */
        Builder exportFilesStatus(String exportFilesStatus);

        /**
         * <p>
         * Filter by the exported files status. You can specify one status in each request to retrieve only sessions
         * that currently have that exported files status.
         * </p>
         * <p>
         * Exported files can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The exported files are successfully stored in an S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The session ended but Amazon GameLift Streams couldn't collect and upload the files to
         * S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>: Either the stream session is still in progress, or uploading the exported files to the
         * S3 bucket is in progress.
         * </p>
         * </li>
         * </ul>
         * 
         * @param exportFilesStatus
         *        Filter by the exported files status. You can specify one status in each request to retrieve only
         *        sessions that currently have that exported files status.</p>
         *        <p>
         *        Exported files can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The exported files are successfully stored in an S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The session ended but Amazon GameLift Streams couldn't collect and upload the
         *        files to S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: Either the stream session is still in progress, or uploading the exported files
         *        to the S3 bucket is in progress.
         *        </p>
         *        </li>
         * @see ExportFilesStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportFilesStatus
         */
        Builder exportFilesStatus(ExportFilesStatus exportFilesStatus);

        /**
         * <p>
         * The token that marks the start of the next set of results. Use this token when you retrieve results as
         * sequential pages. To get the first page of results, omit a token value. To get the remaining pages, provide
         * the token returned with the previous result set.
         * </p>
         * 
         * @param nextToken
         *        The token that marks the start of the next set of results. Use this token when you retrieve results as
         *        sequential pages. To get the first page of results, omit a token value. To get the remaining pages,
         *        provide the token returned with the previous result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of results to return. Use this parameter with <code>NextToken</code> to return results in
         * sequential pages. Default value is <code>25</code>.
         * </p>
         * 
         * @param maxResults
         *        The number of results to return. Use this parameter with <code>NextToken</code> to return results in
         *        sequential pages. Default value is <code>25</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The unique identifier of a Amazon GameLift Streams stream group to retrieve the stream session for. You can
         * use either the stream group ID or the <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a>.
         * </p>
         * 
         * @param identifier
         *        The unique identifier of a Amazon GameLift Streams stream group to retrieve the stream session for.
         *        You can use either the stream group ID or the <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
         *        (ARN)</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftStreamsRequest.BuilderImpl implements Builder {
        private String status;

        private String exportFilesStatus;

        private String nextToken;

        private Integer maxResults;

        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamSessionsRequest model) {
            super(model);
            status(model.status);
            exportFilesStatus(model.exportFilesStatus);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            identifier(model.identifier);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getExportFilesStatus() {
            return exportFilesStatus;
        }

        public final void setExportFilesStatus(String exportFilesStatus) {
            this.exportFilesStatus = exportFilesStatus;
        }

        @Override
        public final Builder exportFilesStatus(String exportFilesStatus) {
            this.exportFilesStatus = exportFilesStatus;
            return this;
        }

        @Override
        public final Builder exportFilesStatus(ExportFilesStatus exportFilesStatus) {
            this.exportFilesStatus(exportFilesStatus == null ? null : exportFilesStatus.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStreamSessionsRequest build() {
            return new ListStreamSessionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
