/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartStreamSessionRequest extends GameLiftStreamsRequest implements
        ToCopyableBuilder<StartStreamSessionRequest.Builder, StartStreamSessionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartStreamSessionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartStreamSessionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(StartStreamSessionRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(StartStreamSessionRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> SIGNAL_REQUEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SignalRequest").getter(getter(StartStreamSessionRequest::signalRequest))
            .setter(setter(Builder::signalRequest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalRequest").build()).build();

    private static final SdkField<String> APPLICATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationIdentifier").getter(getter(StartStreamSessionRequest::applicationIdentifier))
            .setter(setter(Builder::applicationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIdentifier").build())
            .build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(StartStreamSessionRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<List<String>> LOCATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Locations")
            .getter(getter(StartStreamSessionRequest::locations))
            .setter(setter(Builder::locations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> CONNECTION_TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConnectionTimeoutSeconds").getter(getter(StartStreamSessionRequest::connectionTimeoutSeconds))
            .setter(setter(Builder::connectionTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTimeoutSeconds").build())
            .build();

    private static final SdkField<Integer> SESSION_LENGTH_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionLengthSeconds").getter(getter(StartStreamSessionRequest::sessionLengthSeconds))
            .setter(setter(Builder::sessionLengthSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionLengthSeconds").build())
            .build();

    private static final SdkField<List<String>> ADDITIONAL_LAUNCH_ARGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalLaunchArgs")
            .getter(getter(StartStreamSessionRequest::additionalLaunchArgs))
            .setter(setter(Builder::additionalLaunchArgs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalLaunchArgs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ADDITIONAL_ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdditionalEnvironmentVariables")
            .getter(getter(StartStreamSessionRequest::additionalEnvironmentVariables))
            .setter(setter(Builder::additionalEnvironmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalEnvironmentVariables")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, IDENTIFIER_FIELD, PROTOCOL_FIELD, SIGNAL_REQUEST_FIELD, APPLICATION_IDENTIFIER_FIELD,
            USER_ID_FIELD, LOCATIONS_FIELD, CONNECTION_TIMEOUT_SECONDS_FIELD, SESSION_LENGTH_SECONDS_FIELD,
            ADDITIONAL_LAUNCH_ARGS_FIELD, ADDITIONAL_ENVIRONMENT_VARIABLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String description;

    private final String identifier;

    private final String protocol;

    private final String signalRequest;

    private final String applicationIdentifier;

    private final String userId;

    private final List<String> locations;

    private final Integer connectionTimeoutSeconds;

    private final Integer sessionLengthSeconds;

    private final List<String> additionalLaunchArgs;

    private final Map<String, String> additionalEnvironmentVariables;

    private StartStreamSessionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.identifier = builder.identifier;
        this.protocol = builder.protocol;
        this.signalRequest = builder.signalRequest;
        this.applicationIdentifier = builder.applicationIdentifier;
        this.userId = builder.userId;
        this.locations = builder.locations;
        this.connectionTimeoutSeconds = builder.connectionTimeoutSeconds;
        this.sessionLengthSeconds = builder.sessionLengthSeconds;
        this.additionalLaunchArgs = builder.additionalLaunchArgs;
        this.additionalEnvironmentVariables = builder.additionalEnvironmentVariables;
    }

    /**
     * <p>
     * A unique identifier that represents a client request. The request is idempotent, which ensures that an API
     * request completes only once. When users send a request, Amazon GameLift Streams automatically populates this
     * field.
     * </p>
     * 
     * @return A unique identifier that represents a client request. The request is idempotent, which ensures that an
     *         API request completes only once. When users send a request, Amazon GameLift Streams automatically
     *         populates this field.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A human-readable label for the stream session. You can update this value later.
     * </p>
     * 
     * @return A human-readable label for the stream session. You can update this value later.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The stream group to run this stream session with.
     * </p>
     * <p>
     * This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource
     * Name (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
     * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
     * <code>sg-1AB2C3De4</code>.
     * </p>
     * 
     * @return The stream group to run this stream session with.</p>
     *         <p>
     *         This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
     *         Resource Name (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
     *         <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
     *         <code>sg-1AB2C3De4</code>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The data transport protocol to use for the stream session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The data transport protocol to use for the stream session.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * <p>
     * The data transport protocol to use for the stream session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The data transport protocol to use for the stream session.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * A WebRTC ICE offer string to use when initializing a WebRTC connection. Typically, the offer is a very long JSON
     * string. Provide the string as a text value in quotes.
     * </p>
     * <p>
     * Amazon GameLift Streams also supports setting the field to "NO_CLIENT_CONNECTION". This will create a session
     * without needing any browser request or Web SDK integration. The session starts up as usual and waits for a
     * reconnection from a browser, which is accomplished using <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_CreateStreamSessionConnection.html"
     * >CreateStreamSessionConnection</a>.
     * </p>
     * 
     * @return A WebRTC ICE offer string to use when initializing a WebRTC connection. Typically, the offer is a very
     *         long JSON string. Provide the string as a text value in quotes.</p>
     *         <p>
     *         Amazon GameLift Streams also supports setting the field to "NO_CLIENT_CONNECTION". This will create a
     *         session without needing any browser request or Web SDK integration. The session starts up as usual and
     *         waits for a reconnection from a browser, which is accomplished using <a href=
     *         "https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_CreateStreamSessionConnection.html"
     *         >CreateStreamSessionConnection</a>.
     */
    public final String signalRequest() {
        return signalRequest;
    }

    /**
     * <p>
     * An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a>
     * or ID that uniquely identifies the application resource. Example ARN:
     * <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
     * <code>a-9ZY8X7Wv6</code>.
     * </p>
     * 
     * @return An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
     *         (ARN)</a> or ID that uniquely identifies the application resource. Example ARN:
     *         <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
     *         <code>a-9ZY8X7Wv6</code>.
     */
    public final String applicationIdentifier() {
        return applicationIdentifier;
    }

    /**
     * <p>
     * An opaque, unique identifier for an end-user, defined by the developer.
     * </p>
     * 
     * @return An opaque, unique identifier for an end-user, defined by the developer.
     */
    public final String userId() {
        return userId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Locations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLocations() {
        return locations != null && !(locations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of locations, in order of priority, where you want Amazon GameLift Streams to start a stream from. For
     * example, <code>us-east-1</code>. Amazon GameLift Streams selects the location with the next available capacity to
     * start a single stream session in. If this value is empty, Amazon GameLift Streams attempts to start a stream
     * session in the primary location.
     * </p>
     * <p>
     * For a complete list of locations that Amazon GameLift Streams supports, refer to <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions, quotas, and
     * limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocations} method.
     * </p>
     * 
     * @return A list of locations, in order of priority, where you want Amazon GameLift Streams to start a stream from.
     *         For example, <code>us-east-1</code>. Amazon GameLift Streams selects the location with the next available
     *         capacity to start a single stream session in. If this value is empty, Amazon GameLift Streams attempts to
     *         start a stream session in the primary location. </p>
     *         <p>
     *         For a complete list of locations that Amazon GameLift Streams supports, refer to <a
     *         href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions,
     *         quotas, and limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
     */
    public final List<String> locations() {
        return locations;
    }

    /**
     * <p>
     * Length of time (in seconds) that Amazon GameLift Streams should wait for a client to connect or reconnect to the
     * stream session. Applies to both connection and reconnection scenarios. This time span starts when the stream
     * session reaches <code>ACTIVE</code> state. If no client connects before the timeout, Amazon GameLift Streams
     * terminates the stream session. Default value is 120.
     * </p>
     * 
     * @return Length of time (in seconds) that Amazon GameLift Streams should wait for a client to connect or reconnect
     *         to the stream session. Applies to both connection and reconnection scenarios. This time span starts when
     *         the stream session reaches <code>ACTIVE</code> state. If no client connects before the timeout, Amazon
     *         GameLift Streams terminates the stream session. Default value is 120.
     */
    public final Integer connectionTimeoutSeconds() {
        return connectionTimeoutSeconds;
    }

    /**
     * <p>
     * The maximum duration of a session. Amazon GameLift Streams will automatically terminate a session after this
     * amount of time has elapsed, regardless of any existing client connections. Default value is 43200 (12 hours).
     * </p>
     * 
     * @return The maximum duration of a session. Amazon GameLift Streams will automatically terminate a session after
     *         this amount of time has elapsed, regardless of any existing client connections. Default value is 43200
     *         (12 hours).
     */
    public final Integer sessionLengthSeconds() {
        return sessionLengthSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalLaunchArgs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalLaunchArgs() {
        return additionalLaunchArgs != null && !(additionalLaunchArgs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of CLI arguments that are sent to the streaming server when a stream session launches. You can use this to
     * configure the application or stream session details. You can also provide custom arguments that Amazon GameLift
     * Streams passes to your game client.
     * </p>
     * <p>
     * <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar purposes.
     * <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
     * <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalLaunchArgs} method.
     * </p>
     * 
     * @return A list of CLI arguments that are sent to the streaming server when a stream session launches. You can use
     *         this to configure the application or stream session details. You can also provide custom arguments that
     *         Amazon GameLift Streams passes to your game client.</p>
     *         <p>
     *         <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar purposes.
     *         <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
     *         <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
     */
    public final List<String> additionalLaunchArgs() {
        return additionalLaunchArgs;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalEnvironmentVariables property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalEnvironmentVariables() {
        return additionalEnvironmentVariables != null && !(additionalEnvironmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of options that you can use to control the stream session runtime environment, expressed as a set of
     * key-value pairs. You can use this to configure the application or stream session details. You can also provide
     * custom environment variables that Amazon GameLift Streams passes to your game client.
     * </p>
     * <note>
     * <p>
     * If you want to debug your application with environment variables, we recommend that you do so in a local
     * environment outside of Amazon GameLift Streams. For more information, refer to the Compatibility Guidance in the
     * troubleshooting section of the Developer Guide.
     * </p>
     * </note>
     * <p>
     * <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar purposes.
     * <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
     * <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalEnvironmentVariables} method.
     * </p>
     * 
     * @return A set of options that you can use to control the stream session runtime environment, expressed as a set
     *         of key-value pairs. You can use this to configure the application or stream session details. You can also
     *         provide custom environment variables that Amazon GameLift Streams passes to your game client.</p> <note>
     *         <p>
     *         If you want to debug your application with environment variables, we recommend that you do so in a local
     *         environment outside of Amazon GameLift Streams. For more information, refer to the Compatibility Guidance
     *         in the troubleshooting section of the Developer Guide.
     *         </p>
     *         </note>
     *         <p>
     *         <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar purposes.
     *         <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
     *         <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
     */
    public final Map<String, String> additionalEnvironmentVariables() {
        return additionalEnvironmentVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(signalRequest());
        hashCode = 31 * hashCode + Objects.hashCode(applicationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocations() ? locations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(sessionLengthSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalLaunchArgs() ? additionalLaunchArgs() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAdditionalEnvironmentVariables() ? additionalEnvironmentVariables() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartStreamSessionRequest)) {
            return false;
        }
        StartStreamSessionRequest other = (StartStreamSessionRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(identifier(), other.identifier())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(signalRequest(), other.signalRequest())
                && Objects.equals(applicationIdentifier(), other.applicationIdentifier())
                && Objects.equals(userId(), other.userId()) && hasLocations() == other.hasLocations()
                && Objects.equals(locations(), other.locations())
                && Objects.equals(connectionTimeoutSeconds(), other.connectionTimeoutSeconds())
                && Objects.equals(sessionLengthSeconds(), other.sessionLengthSeconds())
                && hasAdditionalLaunchArgs() == other.hasAdditionalLaunchArgs()
                && Objects.equals(additionalLaunchArgs(), other.additionalLaunchArgs())
                && hasAdditionalEnvironmentVariables() == other.hasAdditionalEnvironmentVariables()
                && Objects.equals(additionalEnvironmentVariables(), other.additionalEnvironmentVariables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("StartStreamSessionRequest")
                .add("ClientToken", clientToken())
                .add("Description", description())
                .add("Identifier", identifier())
                .add("Protocol", protocolAsString())
                .add("SignalRequest", signalRequest() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ApplicationIdentifier", applicationIdentifier())
                .add("UserId", userId())
                .add("Locations", hasLocations() ? locations() : null)
                .add("ConnectionTimeoutSeconds", connectionTimeoutSeconds())
                .add("SessionLengthSeconds", sessionLengthSeconds())
                .add("AdditionalLaunchArgs", hasAdditionalLaunchArgs() ? additionalLaunchArgs() : null)
                .add("AdditionalEnvironmentVariables",
                        hasAdditionalEnvironmentVariables() ? additionalEnvironmentVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "SignalRequest":
            return Optional.ofNullable(clazz.cast(signalRequest()));
        case "ApplicationIdentifier":
            return Optional.ofNullable(clazz.cast(applicationIdentifier()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "Locations":
            return Optional.ofNullable(clazz.cast(locations()));
        case "ConnectionTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(connectionTimeoutSeconds()));
        case "SessionLengthSeconds":
            return Optional.ofNullable(clazz.cast(sessionLengthSeconds()));
        case "AdditionalLaunchArgs":
            return Optional.ofNullable(clazz.cast(additionalLaunchArgs()));
        case "AdditionalEnvironmentVariables":
            return Optional.ofNullable(clazz.cast(additionalEnvironmentVariables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("SignalRequest", SIGNAL_REQUEST_FIELD);
        map.put("ApplicationIdentifier", APPLICATION_IDENTIFIER_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("Locations", LOCATIONS_FIELD);
        map.put("ConnectionTimeoutSeconds", CONNECTION_TIMEOUT_SECONDS_FIELD);
        map.put("SessionLengthSeconds", SESSION_LENGTH_SECONDS_FIELD);
        map.put("AdditionalLaunchArgs", ADDITIONAL_LAUNCH_ARGS_FIELD);
        map.put("AdditionalEnvironmentVariables", ADDITIONAL_ENVIRONMENT_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartStreamSessionRequest, T> g) {
        return obj -> g.apply((StartStreamSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftStreamsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartStreamSessionRequest> {
        /**
         * <p>
         * A unique identifier that represents a client request. The request is idempotent, which ensures that an API
         * request completes only once. When users send a request, Amazon GameLift Streams automatically populates this
         * field.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier that represents a client request. The request is idempotent, which ensures that an
         *        API request completes only once. When users send a request, Amazon GameLift Streams automatically
         *        populates this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A human-readable label for the stream session. You can update this value later.
         * </p>
         * 
         * @param description
         *        A human-readable label for the stream session. You can update this value later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The stream group to run this stream session with.
         * </p>
         * <p>
         * This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
         * Resource Name (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
         * <code>sg-1AB2C3De4</code>.
         * </p>
         * 
         * @param identifier
         *        The stream group to run this stream session with.</p>
         *        <p>
         *        This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
         *        Resource Name (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
         *        <code>sg-1AB2C3De4</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The data transport protocol to use for the stream session.
         * </p>
         * 
         * @param protocol
         *        The data transport protocol to use for the stream session.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The data transport protocol to use for the stream session.
         * </p>
         * 
         * @param protocol
         *        The data transport protocol to use for the stream session.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * <p>
         * A WebRTC ICE offer string to use when initializing a WebRTC connection. Typically, the offer is a very long
         * JSON string. Provide the string as a text value in quotes.
         * </p>
         * <p>
         * Amazon GameLift Streams also supports setting the field to "NO_CLIENT_CONNECTION". This will create a session
         * without needing any browser request or Web SDK integration. The session starts up as usual and waits for a
         * reconnection from a browser, which is accomplished using <a href=
         * "https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_CreateStreamSessionConnection.html"
         * >CreateStreamSessionConnection</a>.
         * </p>
         * 
         * @param signalRequest
         *        A WebRTC ICE offer string to use when initializing a WebRTC connection. Typically, the offer is a very
         *        long JSON string. Provide the string as a text value in quotes.</p>
         *        <p>
         *        Amazon GameLift Streams also supports setting the field to "NO_CLIENT_CONNECTION". This will create a
         *        session without needing any browser request or Web SDK integration. The session starts up as usual and
         *        waits for a reconnection from a browser, which is accomplished using <a href=
         *        "https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_CreateStreamSessionConnection.html"
         *        >CreateStreamSessionConnection</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalRequest(String signalRequest);

        /**
         * <p>
         * An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
         * (ARN)</a> or ID that uniquely identifies the application resource. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
         * <code>a-9ZY8X7Wv6</code>.
         * </p>
         * 
         * @param applicationIdentifier
         *        An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
         *        (ARN)</a> or ID that uniquely identifies the application resource. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
         *        <code>a-9ZY8X7Wv6</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIdentifier(String applicationIdentifier);

        /**
         * <p>
         * An opaque, unique identifier for an end-user, defined by the developer.
         * </p>
         * 
         * @param userId
         *        An opaque, unique identifier for an end-user, defined by the developer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * A list of locations, in order of priority, where you want Amazon GameLift Streams to start a stream from. For
         * example, <code>us-east-1</code>. Amazon GameLift Streams selects the location with the next available
         * capacity to start a single stream session in. If this value is empty, Amazon GameLift Streams attempts to
         * start a stream session in the primary location.
         * </p>
         * <p>
         * For a complete list of locations that Amazon GameLift Streams supports, refer to <a
         * href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions, quotas,
         * and limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
         * </p>
         * 
         * @param locations
         *        A list of locations, in order of priority, where you want Amazon GameLift Streams to start a stream
         *        from. For example, <code>us-east-1</code>. Amazon GameLift Streams selects the location with the next
         *        available capacity to start a single stream session in. If this value is empty, Amazon GameLift
         *        Streams attempts to start a stream session in the primary location. </p>
         *        <p>
         *        For a complete list of locations that Amazon GameLift Streams supports, refer to <a
         *        href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions,
         *        quotas, and limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(Collection<String> locations);

        /**
         * <p>
         * A list of locations, in order of priority, where you want Amazon GameLift Streams to start a stream from. For
         * example, <code>us-east-1</code>. Amazon GameLift Streams selects the location with the next available
         * capacity to start a single stream session in. If this value is empty, Amazon GameLift Streams attempts to
         * start a stream session in the primary location.
         * </p>
         * <p>
         * For a complete list of locations that Amazon GameLift Streams supports, refer to <a
         * href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions, quotas,
         * and limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
         * </p>
         * 
         * @param locations
         *        A list of locations, in order of priority, where you want Amazon GameLift Streams to start a stream
         *        from. For example, <code>us-east-1</code>. Amazon GameLift Streams selects the location with the next
         *        available capacity to start a single stream session in. If this value is empty, Amazon GameLift
         *        Streams attempts to start a stream session in the primary location. </p>
         *        <p>
         *        For a complete list of locations that Amazon GameLift Streams supports, refer to <a
         *        href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions,
         *        quotas, and limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(String... locations);

        /**
         * <p>
         * Length of time (in seconds) that Amazon GameLift Streams should wait for a client to connect or reconnect to
         * the stream session. Applies to both connection and reconnection scenarios. This time span starts when the
         * stream session reaches <code>ACTIVE</code> state. If no client connects before the timeout, Amazon GameLift
         * Streams terminates the stream session. Default value is 120.
         * </p>
         * 
         * @param connectionTimeoutSeconds
         *        Length of time (in seconds) that Amazon GameLift Streams should wait for a client to connect or
         *        reconnect to the stream session. Applies to both connection and reconnection scenarios. This time span
         *        starts when the stream session reaches <code>ACTIVE</code> state. If no client connects before the
         *        timeout, Amazon GameLift Streams terminates the stream session. Default value is 120.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionTimeoutSeconds(Integer connectionTimeoutSeconds);

        /**
         * <p>
         * The maximum duration of a session. Amazon GameLift Streams will automatically terminate a session after this
         * amount of time has elapsed, regardless of any existing client connections. Default value is 43200 (12 hours).
         * </p>
         * 
         * @param sessionLengthSeconds
         *        The maximum duration of a session. Amazon GameLift Streams will automatically terminate a session
         *        after this amount of time has elapsed, regardless of any existing client connections. Default value is
         *        43200 (12 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLengthSeconds(Integer sessionLengthSeconds);

        /**
         * <p>
         * A list of CLI arguments that are sent to the streaming server when a stream session launches. You can use
         * this to configure the application or stream session details. You can also provide custom arguments that
         * Amazon GameLift Streams passes to your game client.
         * </p>
         * <p>
         * <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar purposes.
         * <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
         * <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
         * </p>
         * 
         * @param additionalLaunchArgs
         *        A list of CLI arguments that are sent to the streaming server when a stream session launches. You can
         *        use this to configure the application or stream session details. You can also provide custom arguments
         *        that Amazon GameLift Streams passes to your game client.</p>
         *        <p>
         *        <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar
         *        purposes. <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
         *        <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalLaunchArgs(Collection<String> additionalLaunchArgs);

        /**
         * <p>
         * A list of CLI arguments that are sent to the streaming server when a stream session launches. You can use
         * this to configure the application or stream session details. You can also provide custom arguments that
         * Amazon GameLift Streams passes to your game client.
         * </p>
         * <p>
         * <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar purposes.
         * <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
         * <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
         * </p>
         * 
         * @param additionalLaunchArgs
         *        A list of CLI arguments that are sent to the streaming server when a stream session launches. You can
         *        use this to configure the application or stream session details. You can also provide custom arguments
         *        that Amazon GameLift Streams passes to your game client.</p>
         *        <p>
         *        <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar
         *        purposes. <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
         *        <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalLaunchArgs(String... additionalLaunchArgs);

        /**
         * <p>
         * A set of options that you can use to control the stream session runtime environment, expressed as a set of
         * key-value pairs. You can use this to configure the application or stream session details. You can also
         * provide custom environment variables that Amazon GameLift Streams passes to your game client.
         * </p>
         * <note>
         * <p>
         * If you want to debug your application with environment variables, we recommend that you do so in a local
         * environment outside of Amazon GameLift Streams. For more information, refer to the Compatibility Guidance in
         * the troubleshooting section of the Developer Guide.
         * </p>
         * </note>
         * <p>
         * <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar purposes.
         * <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
         * <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
         * </p>
         * 
         * @param additionalEnvironmentVariables
         *        A set of options that you can use to control the stream session runtime environment, expressed as a
         *        set of key-value pairs. You can use this to configure the application or stream session details. You
         *        can also provide custom environment variables that Amazon GameLift Streams passes to your game
         *        client.</p> <note>
         *        <p>
         *        If you want to debug your application with environment variables, we recommend that you do so in a
         *        local environment outside of Amazon GameLift Streams. For more information, refer to the Compatibility
         *        Guidance in the troubleshooting section of the Developer Guide.
         *        </p>
         *        </note>
         *        <p>
         *        <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar
         *        purposes. <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
         *        <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalEnvironmentVariables(Map<String, String> additionalEnvironmentVariables);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftStreamsRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private String identifier;

        private String protocol;

        private String signalRequest;

        private String applicationIdentifier;

        private String userId;

        private List<String> locations = DefaultSdkAutoConstructList.getInstance();

        private Integer connectionTimeoutSeconds;

        private Integer sessionLengthSeconds;

        private List<String> additionalLaunchArgs = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> additionalEnvironmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartStreamSessionRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            identifier(model.identifier);
            protocol(model.protocol);
            signalRequest(model.signalRequest);
            applicationIdentifier(model.applicationIdentifier);
            userId(model.userId);
            locations(model.locations);
            connectionTimeoutSeconds(model.connectionTimeoutSeconds);
            sessionLengthSeconds(model.sessionLengthSeconds);
            additionalLaunchArgs(model.additionalLaunchArgs);
            additionalEnvironmentVariables(model.additionalEnvironmentVariables);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getSignalRequest() {
            return signalRequest;
        }

        public final void setSignalRequest(String signalRequest) {
            this.signalRequest = signalRequest;
        }

        @Override
        public final Builder signalRequest(String signalRequest) {
            this.signalRequest = signalRequest;
            return this;
        }

        public final String getApplicationIdentifier() {
            return applicationIdentifier;
        }

        public final void setApplicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
        }

        @Override
        public final Builder applicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Collection<String> getLocations() {
            if (locations instanceof SdkAutoConstructList) {
                return null;
            }
            return locations;
        }

        public final void setLocations(Collection<String> locations) {
            this.locations = LocationListCopier.copy(locations);
        }

        @Override
        public final Builder locations(Collection<String> locations) {
            this.locations = LocationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(String... locations) {
            locations(Arrays.asList(locations));
            return this;
        }

        public final Integer getConnectionTimeoutSeconds() {
            return connectionTimeoutSeconds;
        }

        public final void setConnectionTimeoutSeconds(Integer connectionTimeoutSeconds) {
            this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        }

        @Override
        public final Builder connectionTimeoutSeconds(Integer connectionTimeoutSeconds) {
            this.connectionTimeoutSeconds = connectionTimeoutSeconds;
            return this;
        }

        public final Integer getSessionLengthSeconds() {
            return sessionLengthSeconds;
        }

        public final void setSessionLengthSeconds(Integer sessionLengthSeconds) {
            this.sessionLengthSeconds = sessionLengthSeconds;
        }

        @Override
        public final Builder sessionLengthSeconds(Integer sessionLengthSeconds) {
            this.sessionLengthSeconds = sessionLengthSeconds;
            return this;
        }

        public final Collection<String> getAdditionalLaunchArgs() {
            if (additionalLaunchArgs instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalLaunchArgs;
        }

        public final void setAdditionalLaunchArgs(Collection<String> additionalLaunchArgs) {
            this.additionalLaunchArgs = GameLaunchArgListCopier.copy(additionalLaunchArgs);
        }

        @Override
        public final Builder additionalLaunchArgs(Collection<String> additionalLaunchArgs) {
            this.additionalLaunchArgs = GameLaunchArgListCopier.copy(additionalLaunchArgs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLaunchArgs(String... additionalLaunchArgs) {
            additionalLaunchArgs(Arrays.asList(additionalLaunchArgs));
            return this;
        }

        public final Map<String, String> getAdditionalEnvironmentVariables() {
            if (additionalEnvironmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalEnvironmentVariables;
        }

        public final void setAdditionalEnvironmentVariables(Map<String, String> additionalEnvironmentVariables) {
            this.additionalEnvironmentVariables = EnvironmentVariablesCopier.copy(additionalEnvironmentVariables);
        }

        @Override
        public final Builder additionalEnvironmentVariables(Map<String, String> additionalEnvironmentVariables) {
            this.additionalEnvironmentVariables = EnvironmentVariablesCopier.copy(additionalEnvironmentVariables);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartStreamSessionRequest build() {
            return new StartStreamSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
