/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Amazon GameLift Streams stream group resource for hosting content streams. To retrieve additional stream
 * group details, call <a
 * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamGroup.html">GetStreamGroup</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamGroupSummary.Builder, StreamGroupSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(StreamGroupSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(StreamGroupSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StreamGroupSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<DefaultApplication> DEFAULT_APPLICATION_FIELD = SdkField
            .<DefaultApplication> builder(MarshallingType.SDK_POJO).memberName("DefaultApplication")
            .getter(getter(StreamGroupSummary::defaultApplication)).setter(setter(Builder::defaultApplication))
            .constructor(DefaultApplication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultApplication").build())
            .build();

    private static final SdkField<String> STREAM_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamClass").getter(getter(StreamGroupSummary::streamClassAsString))
            .setter(setter(Builder::streamClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamClass").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StreamGroupSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(StreamGroupSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(StreamGroupSummary::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiresAt").getter(getter(StreamGroupSummary::expiresAt)).setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            DESCRIPTION_FIELD, DEFAULT_APPLICATION_FIELD, STREAM_CLASS_FIELD, STATUS_FIELD, CREATED_AT_FIELD,
            LAST_UPDATED_AT_FIELD, EXPIRES_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String description;

    private final DefaultApplication defaultApplication;

    private final String streamClass;

    private final String status;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final Instant expiresAt;

    private StreamGroupSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.description = builder.description;
        this.defaultApplication = builder.defaultApplication;
        this.streamClass = builder.streamClass;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.expiresAt = builder.expiresAt;
    }

    /**
     * <p>
     * An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a>
     * that uniquely identifies the stream group resource. Example ARN:
     * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>.
     * </p>
     * 
     * @return An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
     *         (ARN)</a> that uniquely identifies the stream group resource. Example ARN:
     *         <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * An ID that uniquely identifies the stream group resource. Example ID: <code>sg-1AB2C3De4</code>.
     * </p>
     * 
     * @return An ID that uniquely identifies the stream group resource. Example ID: <code>sg-1AB2C3De4</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A descriptive label for the stream group.
     * </p>
     * 
     * @return A descriptive label for the stream group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Object that identifies the Amazon GameLift Streams application to stream with this stream group.
     * </p>
     * 
     * @return Object that identifies the Amazon GameLift Streams application to stream with this stream group.
     */
    public final DefaultApplication defaultApplication() {
        return defaultApplication;
    }

    /**
     * <p>
     * The target stream quality for the stream group.
     * </p>
     * <p>
     * A stream class can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene complexity.
     * Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine
     * versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene complexity.
     * Uses NVIDIA A10G Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports up to 2 concurrent stream sessions
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene complexity.
     * Uses dedicated NVIDIA A10G Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene complexity.
     * Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine
     * versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene complexity.
     * Uses NVIDIA T4 Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports up to 2 concurrent stream sessions
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity. Uses
     * dedicated NVIDIA T4 Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamClass} will
     * return {@link StreamClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamClassAsString}.
     * </p>
     * 
     * @return The target stream quality for the stream group. </p>
     *         <p>
     *         A stream class can be one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
     *         complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible
     *         with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses
     *         NVIDIA A10G Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
     *         complexity. Uses NVIDIA A10G Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports up to 2 concurrent stream sessions
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
     *         complexity. Uses dedicated NVIDIA A10G Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
     *         complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible
     *         with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses
     *         NVIDIA T4 Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
     *         complexity. Uses NVIDIA T4 Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports up to 2 concurrent stream sessions
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity.
     *         Uses dedicated NVIDIA T4 Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see StreamClass
     */
    public final StreamClass streamClass() {
        return StreamClass.fromValue(streamClass);
    }

    /**
     * <p>
     * The target stream quality for the stream group.
     * </p>
     * <p>
     * A stream class can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene complexity.
     * Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine
     * versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene complexity.
     * Uses NVIDIA A10G Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports up to 2 concurrent stream sessions
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene complexity.
     * Uses dedicated NVIDIA A10G Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene complexity.
     * Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine
     * versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene complexity.
     * Uses NVIDIA T4 Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports up to 2 concurrent stream sessions
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity. Uses
     * dedicated NVIDIA T4 Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamClass} will
     * return {@link StreamClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamClassAsString}.
     * </p>
     * 
     * @return The target stream quality for the stream group. </p>
     *         <p>
     *         A stream class can be one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
     *         complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible
     *         with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses
     *         NVIDIA A10G Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
     *         complexity. Uses NVIDIA A10G Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports up to 2 concurrent stream sessions
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
     *         complexity. Uses dedicated NVIDIA A10G Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
     *         complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible
     *         with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses
     *         NVIDIA T4 Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
     *         complexity. Uses NVIDIA T4 Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports up to 2 concurrent stream sessions
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity.
     *         Uses dedicated NVIDIA T4 Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see StreamClass
     */
    public final String streamClassAsString() {
        return streamClass;
    }

    /**
     * <p>
     * The current status of the stream group resource. Possible statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The stream group is ready to host streams.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state. Verify the
     * details of individual locations and remove any locations which are in error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code> (returned by
     * <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and <code>UpdateStreamGroup</code>) for more
     * information.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically occurs when a
     * stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>. Create a new stream group to
     * resume streaming capabilities.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of updating (either
     * activating or deleting).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the stream group resource. Possible statuses include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The stream group is ready to host streams.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state. Verify
     *         the details of individual locations and remove any locations which are in error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code>
     *         (returned by <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and
     *         <code>UpdateStreamGroup</code>) for more information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically occurs
     *         when a stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>. Create a new
     *         stream group to resume streaming capabilities.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of updating
     *         (either activating or deleting).
     *         </p>
     *         </li>
     * @see StreamGroupStatus
     */
    public final StreamGroupStatus status() {
        return StreamGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the stream group resource. Possible statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The stream group is ready to host streams.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state. Verify the
     * details of individual locations and remove any locations which are in error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code> (returned by
     * <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and <code>UpdateStreamGroup</code>) for more
     * information.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically occurs when a
     * stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>. Create a new stream group to
     * resume streaming capabilities.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of updating (either
     * activating or deleting).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the stream group resource. Possible statuses include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The stream group is ready to host streams.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state. Verify
     *         the details of individual locations and remove any locations which are in error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code>
     *         (returned by <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and
     *         <code>UpdateStreamGroup</code>) for more information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically occurs
     *         when a stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>. Create a new
     *         stream group to resume streaming capabilities.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of updating
     *         (either activating or deleting).
     *         </p>
     *         </li>
     * @see StreamGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601 format, such
     * as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     * </p>
     * 
     * @return A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601
     *         format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601 format,
     * such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     * </p>
     * 
     * @return A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601
     *         format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The time at which this stream group expires. Timestamps are expressed using in ISO8601 format, such as:
     * <code>2022-12-27T22:29:40+00:00</code> (UTC). After this time, you will no longer be able to update this stream
     * group or use it to start stream sessions. Only Get and Delete operations will work on an expired stream group.
     * </p>
     * 
     * @return The time at which this stream group expires. Timestamps are expressed using in ISO8601 format, such as:
     *         <code>2022-12-27T22:29:40+00:00</code> (UTC). After this time, you will no longer be able to update this
     *         stream group or use it to start stream sessions. Only Get and Delete operations will work on an expired
     *         stream group.
     */
    public final Instant expiresAt() {
        return expiresAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultApplication());
        hashCode = 31 * hashCode + Objects.hashCode(streamClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamGroupSummary)) {
            return false;
        }
        StreamGroupSummary other = (StreamGroupSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(description(), other.description())
                && Objects.equals(defaultApplication(), other.defaultApplication())
                && Objects.equals(streamClassAsString(), other.streamClassAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(expiresAt(), other.expiresAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamGroupSummary").add("Arn", arn()).add("Id", id()).add("Description", description())
                .add("DefaultApplication", defaultApplication()).add("StreamClass", streamClassAsString())
                .add("Status", statusAsString()).add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("ExpiresAt", expiresAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DefaultApplication":
            return Optional.ofNullable(clazz.cast(defaultApplication()));
        case "StreamClass":
            return Optional.ofNullable(clazz.cast(streamClassAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "ExpiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DefaultApplication", DEFAULT_APPLICATION_FIELD);
        map.put("StreamClass", STREAM_CLASS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("ExpiresAt", EXPIRES_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamGroupSummary, T> g) {
        return obj -> g.apply((StreamGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamGroupSummary> {
        /**
         * <p>
         * An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
         * (ARN)</a> that uniquely identifies the stream group resource. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>.
         * </p>
         * 
         * @param arn
         *        An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
         *        (ARN)</a> that uniquely identifies the stream group resource. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * An ID that uniquely identifies the stream group resource. Example ID: <code>sg-1AB2C3De4</code>.
         * </p>
         * 
         * @param id
         *        An ID that uniquely identifies the stream group resource. Example ID: <code>sg-1AB2C3De4</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A descriptive label for the stream group.
         * </p>
         * 
         * @param description
         *        A descriptive label for the stream group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Object that identifies the Amazon GameLift Streams application to stream with this stream group.
         * </p>
         * 
         * @param defaultApplication
         *        Object that identifies the Amazon GameLift Streams application to stream with this stream group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultApplication(DefaultApplication defaultApplication);

        /**
         * <p>
         * Object that identifies the Amazon GameLift Streams application to stream with this stream group.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultApplication.Builder} avoiding the
         * need to create one manually via {@link DefaultApplication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultApplication.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultApplication(DefaultApplication)}.
         * 
         * @param defaultApplication
         *        a consumer that will call methods on {@link DefaultApplication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultApplication(DefaultApplication)
         */
        default Builder defaultApplication(Consumer<DefaultApplication.Builder> defaultApplication) {
            return defaultApplication(DefaultApplication.builder().applyMutation(defaultApplication).build());
        }

        /**
         * <p>
         * The target stream quality for the stream group.
         * </p>
         * <p>
         * A stream class can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         * complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with
         * Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA
         * A10G Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         * complexity. Uses NVIDIA A10G Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports up to 2 concurrent stream sessions
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         * complexity. Uses dedicated NVIDIA A10G Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         * complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with
         * Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4
         * Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         * complexity. Uses NVIDIA T4 Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports up to 2 concurrent stream sessions
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity. Uses
         * dedicated NVIDIA T4 Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param streamClass
         *        The target stream quality for the stream group. </p>
         *        <p>
         *        A stream class can be one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         *        complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12.
         *        Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat
         *        technology. Uses NVIDIA A10G Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         *        complexity. Uses NVIDIA A10G Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports up to 2 concurrent stream sessions
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         *        complexity. Uses dedicated NVIDIA A10G Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         *        complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12.
         *        Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat
         *        technology. Uses NVIDIA T4 Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         *        complexity. Uses NVIDIA T4 Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports up to 2 concurrent stream sessions
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity.
         *        Uses dedicated NVIDIA T4 Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see StreamClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamClass
         */
        Builder streamClass(String streamClass);

        /**
         * <p>
         * The target stream quality for the stream group.
         * </p>
         * <p>
         * A stream class can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         * complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with
         * Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA
         * A10G Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         * complexity. Uses NVIDIA A10G Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports up to 2 concurrent stream sessions
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         * complexity. Uses dedicated NVIDIA A10G Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         * complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with
         * Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4
         * Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         * complexity. Uses NVIDIA T4 Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports up to 2 concurrent stream sessions
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity. Uses
         * dedicated NVIDIA T4 Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param streamClass
         *        The target stream quality for the stream group. </p>
         *        <p>
         *        A stream class can be one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         *        complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12.
         *        Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat
         *        technology. Uses NVIDIA A10G Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         *        complexity. Uses NVIDIA A10G Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports up to 2 concurrent stream sessions
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         *        complexity. Uses dedicated NVIDIA A10G Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         *        complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12.
         *        Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat
         *        technology. Uses NVIDIA T4 Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         *        complexity. Uses NVIDIA T4 Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports up to 2 concurrent stream sessions
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity.
         *        Uses dedicated NVIDIA T4 Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see StreamClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamClass
         */
        Builder streamClass(StreamClass streamClass);

        /**
         * <p>
         * The current status of the stream group resource. Possible statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The stream group is ready to host streams.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state. Verify the
         * details of individual locations and remove any locations which are in error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code> (returned
         * by <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and <code>UpdateStreamGroup</code>) for more
         * information.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically occurs when
         * a stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>. Create a new stream
         * group to resume streaming capabilities.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of updating
         * (either activating or deleting).
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the stream group resource. Possible statuses include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The stream group is ready to host streams.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state.
         *        Verify the details of individual locations and remove any locations which are in error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code>
         *        (returned by <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and
         *        <code>UpdateStreamGroup</code>) for more information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically
         *        occurs when a stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>.
         *        Create a new stream group to resume streaming capabilities.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of
         *        updating (either activating or deleting).
         *        </p>
         *        </li>
         * @see StreamGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the stream group resource. Possible statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The stream group is ready to host streams.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state. Verify the
         * details of individual locations and remove any locations which are in error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code> (returned
         * by <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and <code>UpdateStreamGroup</code>) for more
         * information.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically occurs when
         * a stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>. Create a new stream
         * group to resume streaming capabilities.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of updating
         * (either activating or deleting).
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the stream group resource. Possible statuses include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The stream group is ready to host streams.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state.
         *        Verify the details of individual locations and remove any locations which are in error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code>
         *        (returned by <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and
         *        <code>UpdateStreamGroup</code>) for more information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically
         *        occurs when a stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>.
         *        Create a new stream group to resume streaming capabilities.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of
         *        updating (either activating or deleting).
         *        </p>
         *        </li>
         * @see StreamGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamGroupStatus
         */
        Builder status(StreamGroupStatus status);

        /**
         * <p>
         * A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601 format,
         * such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * </p>
         * 
         * @param createdAt
         *        A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601
         *        format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601
         * format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * </p>
         * 
         * @param lastUpdatedAt
         *        A timestamp that indicates when this resource was last updated. Timestamps are expressed using in
         *        ISO8601 format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The time at which this stream group expires. Timestamps are expressed using in ISO8601 format, such as:
         * <code>2022-12-27T22:29:40+00:00</code> (UTC). After this time, you will no longer be able to update this
         * stream group or use it to start stream sessions. Only Get and Delete operations will work on an expired
         * stream group.
         * </p>
         * 
         * @param expiresAt
         *        The time at which this stream group expires. Timestamps are expressed using in ISO8601 format, such
         *        as: <code>2022-12-27T22:29:40+00:00</code> (UTC). After this time, you will no longer be able to
         *        update this stream group or use it to start stream sessions. Only Get and Delete operations will work
         *        on an expired stream group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String description;

        private DefaultApplication defaultApplication;

        private String streamClass;

        private String status;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private Instant expiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamGroupSummary model) {
            arn(model.arn);
            id(model.id);
            description(model.description);
            defaultApplication(model.defaultApplication);
            streamClass(model.streamClass);
            status(model.status);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            expiresAt(model.expiresAt);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DefaultApplication.Builder getDefaultApplication() {
            return defaultApplication != null ? defaultApplication.toBuilder() : null;
        }

        public final void setDefaultApplication(DefaultApplication.BuilderImpl defaultApplication) {
            this.defaultApplication = defaultApplication != null ? defaultApplication.build() : null;
        }

        @Override
        public final Builder defaultApplication(DefaultApplication defaultApplication) {
            this.defaultApplication = defaultApplication;
            return this;
        }

        public final String getStreamClass() {
            return streamClass;
        }

        public final void setStreamClass(String streamClass) {
            this.streamClass = streamClass;
        }

        @Override
        public final Builder streamClass(String streamClass) {
            this.streamClass = streamClass;
            return this;
        }

        @Override
        public final Builder streamClass(StreamClass streamClass) {
            this.streamClass(streamClass == null ? null : streamClass.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public StreamGroupSummary build() {
            return new StreamGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
