/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStreamGroupRequest extends GameLiftStreamsRequest implements
        ToCopyableBuilder<UpdateStreamGroupRequest.Builder, UpdateStreamGroupRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(UpdateStreamGroupRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<List<LocationConfiguration>> LOCATION_CONFIGURATIONS_FIELD = SdkField
            .<List<LocationConfiguration>> builder(MarshallingType.LIST)
            .memberName("LocationConfigurations")
            .getter(getter(UpdateStreamGroupRequest::locationConfigurations))
            .setter(setter(Builder::locationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateStreamGroupRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DEFAULT_APPLICATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultApplicationIdentifier")
            .getter(getter(UpdateStreamGroupRequest::defaultApplicationIdentifier))
            .setter(setter(Builder::defaultApplicationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultApplicationIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            LOCATION_CONFIGURATIONS_FIELD, DESCRIPTION_FIELD, DEFAULT_APPLICATION_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final List<LocationConfiguration> locationConfigurations;

    private final String description;

    private final String defaultApplicationIdentifier;

    private UpdateStreamGroupRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.locationConfigurations = builder.locationConfigurations;
        this.description = builder.description;
        this.defaultApplicationIdentifier = builder.defaultApplicationIdentifier;
    }

    /**
     * <p>
     * An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a>
     * or ID that uniquely identifies the stream group resource. Example ARN:
     * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
     * <code>sg-1AB2C3De4</code>.
     * </p>
     * 
     * @return An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
     *         (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
     *         <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
     *         <code>sg-1AB2C3De4</code>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocationConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLocationConfigurations() {
        return locationConfigurations != null && !(locationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of one or more locations and the streaming capacity for each location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocationConfigurations} method.
     * </p>
     * 
     * @return A set of one or more locations and the streaming capacity for each location.
     */
    public final List<LocationConfiguration> locationConfigurations() {
        return locationConfigurations;
    }

    /**
     * <p>
     * A descriptive label for the stream group.
     * </p>
     * 
     * @return A descriptive label for the stream group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the Amazon GameLift Streams application that you want to set as the default application
     * in a stream group. The application that you specify must be in <code>READY</code> status. The default application
     * is pre-cached on always-on compute resources, reducing stream startup times. Other applications are automatically
     * cached as needed.
     * </p>
     * <p>
     * Note that this parameter only sets the default application in a stream group. To associate a new application to
     * an existing stream group, you must use <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_AssociateApplications.html"
     * >AssociateApplications</a>.
     * </p>
     * <p>
     * When you switch default applications in a stream group, it can take up to a few hours for the new default
     * application to be pre-cached.
     * </p>
     * <p>
     * This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource
     * Name (ARN)</a> or ID that uniquely identifies the application resource. Example ARN:
     * <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
     * <code>a-9ZY8X7Wv6</code>.
     * </p>
     * 
     * @return The unique identifier of the Amazon GameLift Streams application that you want to set as the default
     *         application in a stream group. The application that you specify must be in <code>READY</code> status. The
     *         default application is pre-cached on always-on compute resources, reducing stream startup times. Other
     *         applications are automatically cached as needed.</p>
     *         <p>
     *         Note that this parameter only sets the default application in a stream group. To associate a new
     *         application to an existing stream group, you must use <a
     *         href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_AssociateApplications.html"
     *         >AssociateApplications</a>.
     *         </p>
     *         <p>
     *         When you switch default applications in a stream group, it can take up to a few hours for the new default
     *         application to be pre-cached.
     *         </p>
     *         <p>
     *         This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
     *         Resource Name (ARN)</a> or ID that uniquely identifies the application resource. Example ARN:
     *         <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
     *         <code>a-9ZY8X7Wv6</code>.
     */
    public final String defaultApplicationIdentifier() {
        return defaultApplicationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocationConfigurations() ? locationConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultApplicationIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamGroupRequest)) {
            return false;
        }
        UpdateStreamGroupRequest other = (UpdateStreamGroupRequest) obj;
        return Objects.equals(identifier(), other.identifier())
                && hasLocationConfigurations() == other.hasLocationConfigurations()
                && Objects.equals(locationConfigurations(), other.locationConfigurations())
                && Objects.equals(description(), other.description())
                && Objects.equals(defaultApplicationIdentifier(), other.defaultApplicationIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStreamGroupRequest").add("Identifier", identifier())
                .add("LocationConfigurations", hasLocationConfigurations() ? locationConfigurations() : null)
                .add("Description", description()).add("DefaultApplicationIdentifier", defaultApplicationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "LocationConfigurations":
            return Optional.ofNullable(clazz.cast(locationConfigurations()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DefaultApplicationIdentifier":
            return Optional.ofNullable(clazz.cast(defaultApplicationIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("LocationConfigurations", LOCATION_CONFIGURATIONS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DefaultApplicationIdentifier", DEFAULT_APPLICATION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStreamGroupRequest, T> g) {
        return obj -> g.apply((UpdateStreamGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftStreamsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStreamGroupRequest> {
        /**
         * <p>
         * An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
         * (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
         * <code>sg-1AB2C3De4</code>.
         * </p>
         * 
         * @param identifier
         *        An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
         *        (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
         *        <code>sg-1AB2C3De4</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * A set of one or more locations and the streaming capacity for each location.
         * </p>
         * 
         * @param locationConfigurations
         *        A set of one or more locations and the streaming capacity for each location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationConfigurations(Collection<LocationConfiguration> locationConfigurations);

        /**
         * <p>
         * A set of one or more locations and the streaming capacity for each location.
         * </p>
         * 
         * @param locationConfigurations
         *        A set of one or more locations and the streaming capacity for each location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationConfigurations(LocationConfiguration... locationConfigurations);

        /**
         * <p>
         * A set of one or more locations and the streaming capacity for each location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gameliftstreams.model.LocationConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.gameliftstreams.model.LocationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gameliftstreams.model.LocationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #locationConfigurations(List<LocationConfiguration>)}.
         * 
         * @param locationConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gameliftstreams.model.LocationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locationConfigurations(java.util.Collection<LocationConfiguration>)
         */
        Builder locationConfigurations(Consumer<LocationConfiguration.Builder>... locationConfigurations);

        /**
         * <p>
         * A descriptive label for the stream group.
         * </p>
         * 
         * @param description
         *        A descriptive label for the stream group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the Amazon GameLift Streams application that you want to set as the default
         * application in a stream group. The application that you specify must be in <code>READY</code> status. The
         * default application is pre-cached on always-on compute resources, reducing stream startup times. Other
         * applications are automatically cached as needed.
         * </p>
         * <p>
         * Note that this parameter only sets the default application in a stream group. To associate a new application
         * to an existing stream group, you must use <a
         * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_AssociateApplications.html"
         * >AssociateApplications</a>.
         * </p>
         * <p>
         * When you switch default applications in a stream group, it can take up to a few hours for the new default
         * application to be pre-cached.
         * </p>
         * <p>
         * This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
         * Resource Name (ARN)</a> or ID that uniquely identifies the application resource. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
         * <code>a-9ZY8X7Wv6</code>.
         * </p>
         * 
         * @param defaultApplicationIdentifier
         *        The unique identifier of the Amazon GameLift Streams application that you want to set as the default
         *        application in a stream group. The application that you specify must be in <code>READY</code> status.
         *        The default application is pre-cached on always-on compute resources, reducing stream startup times.
         *        Other applications are automatically cached as needed.</p>
         *        <p>
         *        Note that this parameter only sets the default application in a stream group. To associate a new
         *        application to an existing stream group, you must use <a href=
         *        "https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_AssociateApplications.html"
         *        >AssociateApplications</a>.
         *        </p>
         *        <p>
         *        When you switch default applications in a stream group, it can take up to a few hours for the new
         *        default application to be pre-cached.
         *        </p>
         *        <p>
         *        This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
         *        Resource Name (ARN)</a> or ID that uniquely identifies the application resource. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
         *        <code>a-9ZY8X7Wv6</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultApplicationIdentifier(String defaultApplicationIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftStreamsRequest.BuilderImpl implements Builder {
        private String identifier;

        private List<LocationConfiguration> locationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String defaultApplicationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamGroupRequest model) {
            super(model);
            identifier(model.identifier);
            locationConfigurations(model.locationConfigurations);
            description(model.description);
            defaultApplicationIdentifier(model.defaultApplicationIdentifier);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final List<LocationConfiguration.Builder> getLocationConfigurations() {
            List<LocationConfiguration.Builder> result = LocationConfigurationsCopier.copyToBuilder(this.locationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocationConfigurations(Collection<LocationConfiguration.BuilderImpl> locationConfigurations) {
            this.locationConfigurations = LocationConfigurationsCopier.copyFromBuilder(locationConfigurations);
        }

        @Override
        public final Builder locationConfigurations(Collection<LocationConfiguration> locationConfigurations) {
            this.locationConfigurations = LocationConfigurationsCopier.copy(locationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationConfigurations(LocationConfiguration... locationConfigurations) {
            locationConfigurations(Arrays.asList(locationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationConfigurations(Consumer<LocationConfiguration.Builder>... locationConfigurations) {
            locationConfigurations(Stream.of(locationConfigurations)
                    .map(c -> LocationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultApplicationIdentifier() {
            return defaultApplicationIdentifier;
        }

        public final void setDefaultApplicationIdentifier(String defaultApplicationIdentifier) {
            this.defaultApplicationIdentifier = defaultApplicationIdentifier;
        }

        @Override
        public final Builder defaultApplicationIdentifier(String defaultApplicationIdentifier) {
            this.defaultApplicationIdentifier = defaultApplicationIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStreamGroupRequest build() {
            return new UpdateStreamGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
