/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * <fullname>Amazon GameLift Streams</fullname>
 * <p>
 * Amazon GameLift Streams provides a global cloud solution for content streaming experiences. Use Amazon GameLift
 * Streams tools to upload and configure content for streaming, deploy and scale computing resources to host streams,
 * and manage stream session placement to meet customer demand.
 * </p>
 * <p>
 * This Reference Guide describes the Amazon GameLift Streams service API. You can use the API through the Amazon Web
 * Services SDK, the Command Line Interface (CLI), or by making direct REST calls through HTTPS.
 * </p>
 * <p>
 * See the <i>Amazon GameLift Streams Developer Guide</i> for more information on how Amazon GameLift Streams works and
 * how to work with it.
 * </p>
 * </p>
 */
package software.amazon.awssdk.services.gameliftstreams;