/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gameliftstreams.model.ExportFilesMetadata;
import software.amazon.awssdk.services.gameliftstreams.model.Protocol;
import software.amazon.awssdk.services.gameliftstreams.model.StreamSessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamSessionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamSessionSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(StreamSessionSummary.getter(StreamSessionSummary::arn)).setter(StreamSessionSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(StreamSessionSummary.getter(StreamSessionSummary::userId)).setter(StreamSessionSummary.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StreamSessionSummary.getter(StreamSessionSummary::statusAsString)).setter(StreamSessionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(StreamSessionSummary.getter(StreamSessionSummary::protocolAsString)).setter(StreamSessionSummary.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(StreamSessionSummary.getter(StreamSessionSummary::lastUpdatedAt)).setter(StreamSessionSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(StreamSessionSummary.getter(StreamSessionSummary::createdAt)).setter(StreamSessionSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(StreamSessionSummary.getter(StreamSessionSummary::applicationArn)).setter(StreamSessionSummary.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()}).build();
    private static final SdkField<ExportFilesMetadata> EXPORT_FILES_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportFilesMetadata").getter(StreamSessionSummary.getter(StreamSessionSummary::exportFilesMetadata)).setter(StreamSessionSummary.setter(Builder::exportFilesMetadata)).constructor(ExportFilesMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFilesMetadata").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(StreamSessionSummary.getter(StreamSessionSummary::location)).setter(StreamSessionSummary.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, USER_ID_FIELD, STATUS_FIELD, PROTOCOL_FIELD, LAST_UPDATED_AT_FIELD, CREATED_AT_FIELD, APPLICATION_ARN_FIELD, EXPORT_FILES_METADATA_FIELD, LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StreamSessionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String userId;
    private final String status;
    private final String protocol;
    private final Instant lastUpdatedAt;
    private final Instant createdAt;
    private final String applicationArn;
    private final ExportFilesMetadata exportFilesMetadata;
    private final String location;

    private StreamSessionSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.userId = builder.userId;
        this.status = builder.status;
        this.protocol = builder.protocol;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdAt = builder.createdAt;
        this.applicationArn = builder.applicationArn;
        this.exportFilesMetadata = builder.exportFilesMetadata;
        this.location = builder.location;
    }

    public final String arn() {
        return this.arn;
    }

    public final String userId() {
        return this.userId;
    }

    public final StreamSessionStatus status() {
        return StreamSessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final ExportFilesMetadata exportFilesMetadata() {
        return this.exportFilesMetadata;
    }

    public final String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportFilesMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSessionSummary)) {
            return false;
        }
        StreamSessionSummary other = (StreamSessionSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.exportFilesMetadata(), other.exportFilesMetadata()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"StreamSessionSummary").add("Arn", (Object)this.arn()).add("UserId", (Object)this.userId()).add("Status", (Object)this.statusAsString()).add("Protocol", (Object)this.protocolAsString()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("CreatedAt", (Object)this.createdAt()).add("ApplicationArn", (Object)this.applicationArn()).add("ExportFilesMetadata", (Object)this.exportFilesMetadata()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "ExportFilesMetadata": {
                return Optional.ofNullable(clazz.cast(this.exportFilesMetadata()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("ExportFilesMetadata", EXPORT_FILES_METADATA_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamSessionSummary, T> g) {
        return obj -> g.apply((StreamSessionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String userId;
        private String status;
        private String protocol;
        private Instant lastUpdatedAt;
        private Instant createdAt;
        private String applicationArn;
        private ExportFilesMetadata exportFilesMetadata;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSessionSummary model) {
            this.arn(model.arn);
            this.userId(model.userId);
            this.status(model.status);
            this.protocol(model.protocol);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.createdAt(model.createdAt);
            this.applicationArn(model.applicationArn);
            this.exportFilesMetadata(model.exportFilesMetadata);
            this.location(model.location);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final ExportFilesMetadata.Builder getExportFilesMetadata() {
            return this.exportFilesMetadata != null ? this.exportFilesMetadata.toBuilder() : null;
        }

        public final void setExportFilesMetadata(ExportFilesMetadata.BuilderImpl exportFilesMetadata) {
            this.exportFilesMetadata = exportFilesMetadata != null ? exportFilesMetadata.build() : null;
        }

        @Override
        public final Builder exportFilesMetadata(ExportFilesMetadata exportFilesMetadata) {
            this.exportFilesMetadata = exportFilesMetadata;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public StreamSessionSummary build() {
            return new StreamSessionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamSessionSummary> {
        public Builder arn(String var1);

        public Builder userId(String var1);

        public Builder status(String var1);

        public Builder status(StreamSessionStatus var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder applicationArn(String var1);

        public Builder exportFilesMetadata(ExportFilesMetadata var1);

        default public Builder exportFilesMetadata(Consumer<ExportFilesMetadata.Builder> exportFilesMetadata) {
            return this.exportFilesMetadata((ExportFilesMetadata)((ExportFilesMetadata.Builder)ExportFilesMetadata.builder().applyMutation(exportFilesMetadata)).build());
        }

        public Builder location(String var1);
    }
}

