/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateApplicationsRequest extends GameLiftStreamsRequest implements
        ToCopyableBuilder<AssociateApplicationsRequest.Builder, AssociateApplicationsRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(AssociateApplicationsRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<List<String>> APPLICATION_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ApplicationIdentifiers")
            .getter(getter(AssociateApplicationsRequest::applicationIdentifiers))
            .setter(setter(Builder::applicationIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            APPLICATION_IDENTIFIERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final List<String> applicationIdentifiers;

    private AssociateApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.applicationIdentifiers = builder.applicationIdentifiers;
    }

    /**
     * <p>
     * A stream group to associate to the applications.
     * </p>
     * <p>
     * This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource
     * Name (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
     * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
     * <code>sg-1AB2C3De4</code>.
     * </p>
     * 
     * @return A stream group to associate to the applications.</p>
     *         <p>
     *         This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
     *         Resource Name (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
     *         <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
     *         <code>sg-1AB2C3De4</code>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationIdentifiers property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasApplicationIdentifiers() {
        return applicationIdentifiers != null && !(applicationIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of applications to associate with the stream group.
     * </p>
     * <p>
     * This value is a set of either <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names (ARN)</a> or
     * IDs that uniquely identify application resources. Example ARN:
     * <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
     * <code>a-9ZY8X7Wv6</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationIdentifiers} method.
     * </p>
     * 
     * @return A set of applications to associate with the stream group.</p>
     *         <p>
     *         This value is a set of either <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names
     *         (ARN)</a> or IDs that uniquely identify application resources. Example ARN:
     *         <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
     *         <code>a-9ZY8X7Wv6</code>.
     */
    public final List<String> applicationIdentifiers() {
        return applicationIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationIdentifiers() ? applicationIdentifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateApplicationsRequest)) {
            return false;
        }
        AssociateApplicationsRequest other = (AssociateApplicationsRequest) obj;
        return Objects.equals(identifier(), other.identifier())
                && hasApplicationIdentifiers() == other.hasApplicationIdentifiers()
                && Objects.equals(applicationIdentifiers(), other.applicationIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateApplicationsRequest").add("Identifier", identifier())
                .add("ApplicationIdentifiers", hasApplicationIdentifiers() ? applicationIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "ApplicationIdentifiers":
            return Optional.ofNullable(clazz.cast(applicationIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("ApplicationIdentifiers", APPLICATION_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateApplicationsRequest, T> g) {
        return obj -> g.apply((AssociateApplicationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftStreamsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateApplicationsRequest> {
        /**
         * <p>
         * A stream group to associate to the applications.
         * </p>
         * <p>
         * This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
         * Resource Name (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
         * <code>sg-1AB2C3De4</code>.
         * </p>
         * 
         * @param identifier
         *        A stream group to associate to the applications.</p>
         *        <p>
         *        This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
         *        Resource Name (ARN)</a> or ID that uniquely identifies the stream group resource. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>. Example ID:
         *        <code>sg-1AB2C3De4</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * A set of applications to associate with the stream group.
         * </p>
         * <p>
         * This value is a set of either <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names (ARN)</a>
         * or IDs that uniquely identify application resources. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
         * <code>a-9ZY8X7Wv6</code>.
         * </p>
         * 
         * @param applicationIdentifiers
         *        A set of applications to associate with the stream group.</p>
         *        <p>
         *        This value is a set of either <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names
         *        (ARN)</a> or IDs that uniquely identify application resources. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
         *        <code>a-9ZY8X7Wv6</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIdentifiers(Collection<String> applicationIdentifiers);

        /**
         * <p>
         * A set of applications to associate with the stream group.
         * </p>
         * <p>
         * This value is a set of either <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names (ARN)</a>
         * or IDs that uniquely identify application resources. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
         * <code>a-9ZY8X7Wv6</code>.
         * </p>
         * 
         * @param applicationIdentifiers
         *        A set of applications to associate with the stream group.</p>
         *        <p>
         *        This value is a set of either <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names
         *        (ARN)</a> or IDs that uniquely identify application resources. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>. Example ID:
         *        <code>a-9ZY8X7Wv6</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIdentifiers(String... applicationIdentifiers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftStreamsRequest.BuilderImpl implements Builder {
        private String identifier;

        private List<String> applicationIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateApplicationsRequest model) {
            super(model);
            identifier(model.identifier);
            applicationIdentifiers(model.applicationIdentifiers);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Collection<String> getApplicationIdentifiers() {
            if (applicationIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return applicationIdentifiers;
        }

        public final void setApplicationIdentifiers(Collection<String> applicationIdentifiers) {
            this.applicationIdentifiers = IdentifiersCopier.copy(applicationIdentifiers);
        }

        @Override
        public final Builder applicationIdentifiers(Collection<String> applicationIdentifiers) {
            this.applicationIdentifiers = IdentifiersCopier.copy(applicationIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationIdentifiers(String... applicationIdentifiers) {
            applicationIdentifiers(Arrays.asList(applicationIdentifiers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateApplicationsRequest build() {
            return new AssociateApplicationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
