/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStreamGroupResponse extends GameLiftStreamsResponse implements
        ToCopyableBuilder<GetStreamGroupResponse.Builder, GetStreamGroupResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetStreamGroupResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetStreamGroupResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<DefaultApplication> DEFAULT_APPLICATION_FIELD = SdkField
            .<DefaultApplication> builder(MarshallingType.SDK_POJO).memberName("DefaultApplication")
            .getter(getter(GetStreamGroupResponse::defaultApplication)).setter(setter(Builder::defaultApplication))
            .constructor(DefaultApplication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultApplication").build())
            .build();

    private static final SdkField<List<LocationState>> LOCATION_STATES_FIELD = SdkField
            .<List<LocationState>> builder(MarshallingType.LIST)
            .memberName("LocationStates")
            .getter(getter(GetStreamGroupResponse::locationStates))
            .setter(setter(Builder::locationStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocationState> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocationState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STREAM_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamClass").getter(getter(GetStreamGroupResponse::streamClassAsString))
            .setter(setter(Builder::streamClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamClass").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetStreamGroupResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetStreamGroupResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(GetStreamGroupResponse::statusReasonAsString))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(GetStreamGroupResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(GetStreamGroupResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiresAt").getter(getter(GetStreamGroupResponse::expiresAt)).setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresAt").build()).build();

    private static final SdkField<List<String>> ASSOCIATED_APPLICATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssociatedApplications")
            .getter(getter(GetStreamGroupResponse::associatedApplications))
            .setter(setter(Builder::associatedApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedApplications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD,
            DEFAULT_APPLICATION_FIELD, LOCATION_STATES_FIELD, STREAM_CLASS_FIELD, ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD,
            LAST_UPDATED_AT_FIELD, CREATED_AT_FIELD, EXPIRES_AT_FIELD, ASSOCIATED_APPLICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String description;

    private final DefaultApplication defaultApplication;

    private final List<LocationState> locationStates;

    private final String streamClass;

    private final String id;

    private final String status;

    private final String statusReason;

    private final Instant lastUpdatedAt;

    private final Instant createdAt;

    private final Instant expiresAt;

    private final List<String> associatedApplications;

    private GetStreamGroupResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.description = builder.description;
        this.defaultApplication = builder.defaultApplication;
        this.locationStates = builder.locationStates;
        this.streamClass = builder.streamClass;
        this.id = builder.id;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdAt = builder.createdAt;
        this.expiresAt = builder.expiresAt;
        this.associatedApplications = builder.associatedApplications;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a>
     * that is assigned to the stream group resource and that uniquely identifies the group across all Amazon Web
     * Services Regions. Format is
     * <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:streamgroup/[resource ID]</code>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
     *         (ARN)</a> that is assigned to the stream group resource and that uniquely identifies the group across all
     *         Amazon Web Services Regions. Format is
     *         <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:streamgroup/[resource ID]</code>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A descriptive label for the stream group.
     * </p>
     * 
     * @return A descriptive label for the stream group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The default Amazon GameLift Streams application that is associated with this stream group.
     * </p>
     * 
     * @return The default Amazon GameLift Streams application that is associated with this stream group.
     */
    public final DefaultApplication defaultApplication() {
        return defaultApplication;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocationStates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLocationStates() {
        return locationStates != null && !(locationStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This value is the set of locations, including their name, current status, and capacities.
     * </p>
     * <p>
     * A location can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale the
     * capacity of, or remove this location yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale the
     * capacity of, or remove this location.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code> field
     * describes the error. You can remove this location and try to add it again.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
     * provisioned capacity for this location in this stream group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocationStates} method.
     * </p>
     * 
     * @return This value is the set of locations, including their name, current status, and capacities. </p>
     *         <p>
     *         A location can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale
     *         the capacity of, or remove this location yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale
     *         the capacity of, or remove this location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code>
     *         field describes the error. You can remove this location and try to add it again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
     *         provisioned capacity for this location in this stream group.
     *         </p>
     *         </li>
     */
    public final List<LocationState> locationStates() {
        return locationStates;
    }

    /**
     * <p>
     * The target stream quality for the stream group.
     * </p>
     * <p>
     * A stream class can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene complexity.
     * Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine
     * versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene complexity.
     * Uses NVIDIA A10G Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports up to 2 concurrent stream sessions
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene complexity.
     * Uses dedicated NVIDIA A10G Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene complexity.
     * Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine
     * versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene complexity.
     * Uses NVIDIA T4 Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports up to 2 concurrent stream sessions
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity. Uses
     * dedicated NVIDIA T4 Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamClass} will
     * return {@link StreamClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamClassAsString}.
     * </p>
     * 
     * @return The target stream quality for the stream group.</p>
     *         <p>
     *         A stream class can be one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
     *         complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible
     *         with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses
     *         NVIDIA A10G Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
     *         complexity. Uses NVIDIA A10G Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports up to 2 concurrent stream sessions
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
     *         complexity. Uses dedicated NVIDIA A10G Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
     *         complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible
     *         with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses
     *         NVIDIA T4 Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
     *         complexity. Uses NVIDIA T4 Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports up to 2 concurrent stream sessions
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity.
     *         Uses dedicated NVIDIA T4 Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see StreamClass
     */
    public final StreamClass streamClass() {
        return StreamClass.fromValue(streamClass);
    }

    /**
     * <p>
     * The target stream quality for the stream group.
     * </p>
     * <p>
     * A stream class can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene complexity.
     * Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine
     * versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene complexity.
     * Uses NVIDIA A10G Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports up to 2 concurrent stream sessions
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene complexity.
     * Uses dedicated NVIDIA A10G Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene complexity.
     * Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine
     * versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene complexity.
     * Uses NVIDIA T4 Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports up to 2 concurrent stream sessions
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity. Uses
     * dedicated NVIDIA T4 Tensor GPU.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Reference resolution: 1080p
     * </p>
     * </li>
     * <li>
     * <p>
     * Reference frame rate: 60 fps
     * </p>
     * </li>
     * <li>
     * <p>
     * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     * </p>
     * </li>
     * <li>
     * <p>
     * Tenancy: Supports 1 concurrent stream session
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamClass} will
     * return {@link StreamClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamClassAsString}.
     * </p>
     * 
     * @return The target stream quality for the stream group.</p>
     *         <p>
     *         A stream class can be one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
     *         complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible
     *         with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses
     *         NVIDIA A10G Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
     *         complexity. Uses NVIDIA A10G Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports up to 2 concurrent stream sessions
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
     *         complexity. Uses dedicated NVIDIA A10G Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
     *         complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible
     *         with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses
     *         NVIDIA T4 Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
     *         complexity. Uses NVIDIA T4 Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports up to 2 concurrent stream sessions
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity.
     *         Uses dedicated NVIDIA T4 Tensor GPU.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Reference resolution: 1080p
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reference frame rate: 60 fps
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tenancy: Supports 1 concurrent stream session
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see StreamClass
     */
    public final String streamClassAsString() {
        return streamClass;
    }

    /**
     * <p>
     * A unique ID value that is assigned to the resource when it's created. Format example: <code>sg-1AB2C3De4</code>.
     * </p>
     * 
     * @return A unique ID value that is assigned to the resource when it's created. Format example:
     *         <code>sg-1AB2C3De4</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The current status of the stream group resource. Possible statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The stream group is ready to host streams.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state. Verify the
     * details of individual locations and remove any locations which are in error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code> (returned by
     * <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and <code>UpdateStreamGroup</code>) for more
     * information.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically occurs when a
     * stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>. Create a new stream group to
     * resume streaming capabilities.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of updating (either
     * activating or deleting).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the stream group resource. Possible statuses include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The stream group is ready to host streams.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state. Verify
     *         the details of individual locations and remove any locations which are in error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code>
     *         (returned by <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and
     *         <code>UpdateStreamGroup</code>) for more information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically occurs
     *         when a stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>. Create a new
     *         stream group to resume streaming capabilities.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of updating
     *         (either activating or deleting).
     *         </p>
     *         </li>
     * @see StreamGroupStatus
     */
    public final StreamGroupStatus status() {
        return StreamGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the stream group resource. Possible statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The stream group is ready to host streams.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state. Verify the
     * details of individual locations and remove any locations which are in error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code> (returned by
     * <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and <code>UpdateStreamGroup</code>) for more
     * information.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically occurs when a
     * stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>. Create a new stream group to
     * resume streaming capabilities.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of updating (either
     * activating or deleting).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the stream group resource. Possible statuses include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The stream group is ready to host streams.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state. Verify
     *         the details of individual locations and remove any locations which are in error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code>
     *         (returned by <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and
     *         <code>UpdateStreamGroup</code>) for more information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically occurs
     *         when a stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>. Create a new
     *         stream group to resume streaming capabilities.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of updating
     *         (either activating or deleting).
     *         </p>
     *         </li>
     * @see StreamGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A short description of the reason that the stream group is in <code>ERROR</code> status. The possible reasons can
     * be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>internalError</code>: The request can't process right now because of an issue with the server. Try again
     * later.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>noAvailableInstances</code>: Amazon GameLift Streams does not currently have enough available on-demand
     * capacity to fulfill your request. Wait a few minutes and retry the request as capacity can shift frequently. You
     * can also try to make the request using a different stream class or in another region.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link StreamGroupStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return A short description of the reason that the stream group is in <code>ERROR</code> status. The possible
     *         reasons can be one of the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>internalError</code>: The request can't process right now because of an issue with the server. Try
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>noAvailableInstances</code>: Amazon GameLift Streams does not currently have enough available
     *         on-demand capacity to fulfill your request. Wait a few minutes and retry the request as capacity can
     *         shift frequently. You can also try to make the request using a different stream class or in another
     *         region.
     *         </p>
     *         </li>
     * @see StreamGroupStatusReason
     */
    public final StreamGroupStatusReason statusReason() {
        return StreamGroupStatusReason.fromValue(statusReason);
    }

    /**
     * <p>
     * A short description of the reason that the stream group is in <code>ERROR</code> status. The possible reasons can
     * be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>internalError</code>: The request can't process right now because of an issue with the server. Try again
     * later.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>noAvailableInstances</code>: Amazon GameLift Streams does not currently have enough available on-demand
     * capacity to fulfill your request. Wait a few minutes and retry the request as capacity can shift frequently. You
     * can also try to make the request using a different stream class or in another region.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link StreamGroupStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return A short description of the reason that the stream group is in <code>ERROR</code> status. The possible
     *         reasons can be one of the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>internalError</code>: The request can't process right now because of an issue with the server. Try
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>noAvailableInstances</code>: Amazon GameLift Streams does not currently have enough available
     *         on-demand capacity to fulfill your request. Wait a few minutes and retry the request as capacity can
     *         shift frequently. You can also try to make the request using a different stream class or in another
     *         region.
     *         </p>
     *         </li>
     * @see StreamGroupStatusReason
     */
    public final String statusReasonAsString() {
        return statusReason;
    }

    /**
     * <p>
     * A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601 format,
     * such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     * </p>
     * 
     * @return A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601
     *         format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601 format, such
     * as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     * </p>
     * 
     * @return A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601
     *         format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time at which this stream group expires. Timestamps are expressed using in ISO8601 format, such as:
     * <code>2022-12-27T22:29:40+00:00</code> (UTC). After this time, you will no longer be able to update this stream
     * group or use it to start stream sessions. Only Get and Delete operations will work on an expired stream group.
     * </p>
     * 
     * @return The time at which this stream group expires. Timestamps are expressed using in ISO8601 format, such as:
     *         <code>2022-12-27T22:29:40+00:00</code> (UTC). After this time, you will no longer be able to update this
     *         stream group or use it to start stream sessions. Only Get and Delete operations will work on an expired
     *         stream group.
     */
    public final Instant expiresAt() {
        return expiresAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedApplications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssociatedApplications() {
        return associatedApplications != null && !(associatedApplications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of applications that this stream group is associated to. You can stream any of these applications by using
     * this stream group.
     * </p>
     * <p>
     * This value is a set of <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
     * Resource Names (ARNs)</a> that uniquely identify application resources. Example ARN:
     * <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedApplications} method.
     * </p>
     * 
     * @return A set of applications that this stream group is associated to. You can stream any of these applications
     *         by using this stream group. </p>
     *         <p>
     *         This value is a set of <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names
     *         (ARNs)</a> that uniquely identify application resources. Example ARN:
     *         <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>.
     */
    public final List<String> associatedApplications() {
        return associatedApplications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultApplication());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocationStates() ? locationStates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(streamClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedApplications() ? associatedApplications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamGroupResponse)) {
            return false;
        }
        GetStreamGroupResponse other = (GetStreamGroupResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description())
                && Objects.equals(defaultApplication(), other.defaultApplication())
                && hasLocationStates() == other.hasLocationStates() && Objects.equals(locationStates(), other.locationStates())
                && Objects.equals(streamClassAsString(), other.streamClassAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReasonAsString(), other.statusReasonAsString())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(expiresAt(), other.expiresAt())
                && hasAssociatedApplications() == other.hasAssociatedApplications()
                && Objects.equals(associatedApplications(), other.associatedApplications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStreamGroupResponse").add("Arn", arn()).add("Description", description())
                .add("DefaultApplication", defaultApplication())
                .add("LocationStates", hasLocationStates() ? locationStates() : null).add("StreamClass", streamClassAsString())
                .add("Id", id()).add("Status", statusAsString()).add("StatusReason", statusReasonAsString())
                .add("LastUpdatedAt", lastUpdatedAt()).add("CreatedAt", createdAt()).add("ExpiresAt", expiresAt())
                .add("AssociatedApplications", hasAssociatedApplications() ? associatedApplications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DefaultApplication":
            return Optional.ofNullable(clazz.cast(defaultApplication()));
        case "LocationStates":
            return Optional.ofNullable(clazz.cast(locationStates()));
        case "StreamClass":
            return Optional.ofNullable(clazz.cast(streamClassAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReasonAsString()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ExpiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        case "AssociatedApplications":
            return Optional.ofNullable(clazz.cast(associatedApplications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DefaultApplication", DEFAULT_APPLICATION_FIELD);
        map.put("LocationStates", LOCATION_STATES_FIELD);
        map.put("StreamClass", STREAM_CLASS_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ExpiresAt", EXPIRES_AT_FIELD);
        map.put("AssociatedApplications", ASSOCIATED_APPLICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStreamGroupResponse, T> g) {
        return obj -> g.apply((GetStreamGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftStreamsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStreamGroupResponse> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
         * (ARN)</a> that is assigned to the stream group resource and that uniquely identifies the group across all
         * Amazon Web Services Regions. Format is
         * <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:streamgroup/[resource ID]</code>.
         * </p>
         * 
         * @param arn
         *        The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource
         *        Name (ARN)</a> that is assigned to the stream group resource and that uniquely identifies the group
         *        across all Amazon Web Services Regions. Format is
         *        <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:streamgroup/[resource ID]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A descriptive label for the stream group.
         * </p>
         * 
         * @param description
         *        A descriptive label for the stream group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The default Amazon GameLift Streams application that is associated with this stream group.
         * </p>
         * 
         * @param defaultApplication
         *        The default Amazon GameLift Streams application that is associated with this stream group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultApplication(DefaultApplication defaultApplication);

        /**
         * <p>
         * The default Amazon GameLift Streams application that is associated with this stream group.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultApplication.Builder} avoiding the
         * need to create one manually via {@link DefaultApplication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultApplication.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultApplication(DefaultApplication)}.
         * 
         * @param defaultApplication
         *        a consumer that will call methods on {@link DefaultApplication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultApplication(DefaultApplication)
         */
        default Builder defaultApplication(Consumer<DefaultApplication.Builder> defaultApplication) {
            return defaultApplication(DefaultApplication.builder().applyMutation(defaultApplication).build());
        }

        /**
         * <p>
         * This value is the set of locations, including their name, current status, and capacities.
         * </p>
         * <p>
         * A location can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale the
         * capacity of, or remove this location yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale the
         * capacity of, or remove this location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code>
         * field describes the error. You can remove this location and try to add it again.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
         * provisioned capacity for this location in this stream group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param locationStates
         *        This value is the set of locations, including their name, current status, and capacities. </p>
         *        <p>
         *        A location can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from,
         *        scale the capacity of, or remove this location yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale
         *        the capacity of, or remove this location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The
         *        <code>StatusReason</code> field describes the error. You can remove this location and try to add it
         *        again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release
         *        all provisioned capacity for this location in this stream group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationStates(Collection<LocationState> locationStates);

        /**
         * <p>
         * This value is the set of locations, including their name, current status, and capacities.
         * </p>
         * <p>
         * A location can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale the
         * capacity of, or remove this location yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale the
         * capacity of, or remove this location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code>
         * field describes the error. You can remove this location and try to add it again.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
         * provisioned capacity for this location in this stream group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param locationStates
         *        This value is the set of locations, including their name, current status, and capacities. </p>
         *        <p>
         *        A location can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from,
         *        scale the capacity of, or remove this location yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale
         *        the capacity of, or remove this location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The
         *        <code>StatusReason</code> field describes the error. You can remove this location and try to add it
         *        again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release
         *        all provisioned capacity for this location in this stream group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationStates(LocationState... locationStates);

        /**
         * <p>
         * This value is the set of locations, including their name, current status, and capacities.
         * </p>
         * <p>
         * A location can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVATING</code>: Amazon GameLift Streams is preparing the location. You cannot stream from, scale the
         * capacity of, or remove this location yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The location is provisioned with initial capacity. You can now stream from, scale the
         * capacity of, or remove this location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: Amazon GameLift Streams failed to set up this location. The <code>StatusReason</code>
         * field describes the error. You can remove this location and try to add it again.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVING</code>: Amazon GameLift Streams is working to remove this location. This will release all
         * provisioned capacity for this location in this stream group.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gameliftstreams.model.LocationState.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.gameliftstreams.model.LocationState#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gameliftstreams.model.LocationState.Builder#build()} is called
         * immediately and its result is passed to {@link #locationStates(List<LocationState>)}.
         * 
         * @param locationStates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gameliftstreams.model.LocationState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locationStates(java.util.Collection<LocationState>)
         */
        Builder locationStates(Consumer<LocationState.Builder>... locationStates);

        /**
         * <p>
         * The target stream quality for the stream group.
         * </p>
         * <p>
         * A stream class can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         * complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with
         * Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA
         * A10G Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         * complexity. Uses NVIDIA A10G Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports up to 2 concurrent stream sessions
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         * complexity. Uses dedicated NVIDIA A10G Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         * complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with
         * Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4
         * Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         * complexity. Uses NVIDIA T4 Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports up to 2 concurrent stream sessions
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity. Uses
         * dedicated NVIDIA T4 Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param streamClass
         *        The target stream quality for the stream group.</p>
         *        <p>
         *        A stream class can be one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         *        complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12.
         *        Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat
         *        technology. Uses NVIDIA A10G Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         *        complexity. Uses NVIDIA A10G Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports up to 2 concurrent stream sessions
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         *        complexity. Uses dedicated NVIDIA A10G Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         *        complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12.
         *        Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat
         *        technology. Uses NVIDIA T4 Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         *        complexity. Uses NVIDIA T4 Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports up to 2 concurrent stream sessions
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity.
         *        Uses dedicated NVIDIA T4 Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see StreamClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamClass
         */
        Builder streamClass(String streamClass);

        /**
         * <p>
         * The target stream quality for the stream group.
         * </p>
         * <p>
         * A stream class can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         * complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with
         * Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA
         * A10G Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         * complexity. Uses NVIDIA A10G Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports up to 2 concurrent stream sessions
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         * complexity. Uses dedicated NVIDIA A10G Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         * complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with
         * Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4
         * Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         * complexity. Uses NVIDIA T4 Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports up to 2 concurrent stream sessions
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity. Uses
         * dedicated NVIDIA T4 Tensor GPU.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Reference resolution: 1080p
         * </p>
         * </li>
         * <li>
         * <p>
         * Reference frame rate: 60 fps
         * </p>
         * </li>
         * <li>
         * <p>
         * Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         * </p>
         * </li>
         * <li>
         * <p>
         * Tenancy: Supports 1 concurrent stream session
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param streamClass
         *        The target stream quality for the stream group.</p>
         *        <p>
         *        A stream class can be one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>gen5n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         *        complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12.
         *        Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat
         *        technology. Uses NVIDIA A10G Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen5n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         *        complexity. Uses NVIDIA A10G Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports up to 2 concurrent stream sessions
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen5n_ultra</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         *        complexity. Uses dedicated NVIDIA A10G Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen4n_win2022</code> (NVIDIA, ultra)</b> Supports applications with extremely high 3D scene
         *        complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12.
         *        Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat
         *        technology. Uses NVIDIA T4 Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen4n_high</code> (NVIDIA, high)</b> Supports applications with moderate to high 3D scene
         *        complexity. Uses NVIDIA T4 Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports up to 2 concurrent stream sessions
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>gen4n_ultra</code> (NVIDIA, ultra)</b> Supports applications with high 3D scene complexity.
         *        Uses dedicated NVIDIA T4 Tensor GPU.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Reference resolution: 1080p
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reference frame rate: 60 fps
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tenancy: Supports 1 concurrent stream session
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see StreamClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamClass
         */
        Builder streamClass(StreamClass streamClass);

        /**
         * <p>
         * A unique ID value that is assigned to the resource when it's created. Format example:
         * <code>sg-1AB2C3De4</code>.
         * </p>
         * 
         * @param id
         *        A unique ID value that is assigned to the resource when it's created. Format example:
         *        <code>sg-1AB2C3De4</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The current status of the stream group resource. Possible statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The stream group is ready to host streams.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state. Verify the
         * details of individual locations and remove any locations which are in error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code> (returned
         * by <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and <code>UpdateStreamGroup</code>) for more
         * information.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically occurs when
         * a stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>. Create a new stream
         * group to resume streaming capabilities.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of updating
         * (either activating or deleting).
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the stream group resource. Possible statuses include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The stream group is ready to host streams.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state.
         *        Verify the details of individual locations and remove any locations which are in error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code>
         *        (returned by <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and
         *        <code>UpdateStreamGroup</code>) for more information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically
         *        occurs when a stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>.
         *        Create a new stream group to resume streaming capabilities.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of
         *        updating (either activating or deleting).
         *        </p>
         *        </li>
         * @see StreamGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the stream group resource. Possible statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The stream group is ready to host streams.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state. Verify the
         * details of individual locations and remove any locations which are in error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code> (returned
         * by <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and <code>UpdateStreamGroup</code>) for more
         * information.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically occurs when
         * a stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>. Create a new stream
         * group to resume streaming capabilities.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of updating
         * (either activating or deleting).
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the stream group resource. Possible statuses include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code>: The stream group is deploying and isn't ready to host streams.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The stream group is ready to host streams.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE_WITH_ERRORS</code>: One or more locations in the stream group are in an error state.
         *        Verify the details of individual locations and remove any locations which are in error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the stream group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: An error occurred when the stream group deployed. See <code>StatusReason</code>
         *        (returned by <code>CreateStreamGroup</code>, <code>GetStreamGroup</code>, and
         *        <code>UpdateStreamGroup</code>) for more information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPIRED</code>: The stream group is expired and can no longer host streams. This typically
         *        occurs when a stream group is 365 days old, as indicated by the value of <code>ExpiresAt</code>.
         *        Create a new stream group to resume streaming capabilities.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING_LOCATIONS</code>: One or more locations in the stream group are in the process of
         *        updating (either activating or deleting).
         *        </p>
         *        </li>
         * @see StreamGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamGroupStatus
         */
        Builder status(StreamGroupStatus status);

        /**
         * <p>
         * A short description of the reason that the stream group is in <code>ERROR</code> status. The possible reasons
         * can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>internalError</code>: The request can't process right now because of an issue with the server. Try
         * again later.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>noAvailableInstances</code>: Amazon GameLift Streams does not currently have enough available on-demand
         * capacity to fulfill your request. Wait a few minutes and retry the request as capacity can shift frequently.
         * You can also try to make the request using a different stream class or in another region.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusReason
         *        A short description of the reason that the stream group is in <code>ERROR</code> status. The possible
         *        reasons can be one of the following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>internalError</code>: The request can't process right now because of an issue with the server.
         *        Try again later.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>noAvailableInstances</code>: Amazon GameLift Streams does not currently have enough available
         *        on-demand capacity to fulfill your request. Wait a few minutes and retry the request as capacity can
         *        shift frequently. You can also try to make the request using a different stream class or in another
         *        region.
         *        </p>
         *        </li>
         * @see StreamGroupStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamGroupStatusReason
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * A short description of the reason that the stream group is in <code>ERROR</code> status. The possible reasons
         * can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>internalError</code>: The request can't process right now because of an issue with the server. Try
         * again later.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>noAvailableInstances</code>: Amazon GameLift Streams does not currently have enough available on-demand
         * capacity to fulfill your request. Wait a few minutes and retry the request as capacity can shift frequently.
         * You can also try to make the request using a different stream class or in another region.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusReason
         *        A short description of the reason that the stream group is in <code>ERROR</code> status. The possible
         *        reasons can be one of the following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>internalError</code>: The request can't process right now because of an issue with the server.
         *        Try again later.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>noAvailableInstances</code>: Amazon GameLift Streams does not currently have enough available
         *        on-demand capacity to fulfill your request. Wait a few minutes and retry the request as capacity can
         *        shift frequently. You can also try to make the request using a different stream class or in another
         *        region.
         *        </p>
         *        </li>
         * @see StreamGroupStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamGroupStatusReason
         */
        Builder statusReason(StreamGroupStatusReason statusReason);

        /**
         * <p>
         * A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601
         * format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * </p>
         * 
         * @param lastUpdatedAt
         *        A timestamp that indicates when this resource was last updated. Timestamps are expressed using in
         *        ISO8601 format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601 format,
         * such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * </p>
         * 
         * @param createdAt
         *        A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601
         *        format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time at which this stream group expires. Timestamps are expressed using in ISO8601 format, such as:
         * <code>2022-12-27T22:29:40+00:00</code> (UTC). After this time, you will no longer be able to update this
         * stream group or use it to start stream sessions. Only Get and Delete operations will work on an expired
         * stream group.
         * </p>
         * 
         * @param expiresAt
         *        The time at which this stream group expires. Timestamps are expressed using in ISO8601 format, such
         *        as: <code>2022-12-27T22:29:40+00:00</code> (UTC). After this time, you will no longer be able to
         *        update this stream group or use it to start stream sessions. Only Get and Delete operations will work
         *        on an expired stream group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);

        /**
         * <p>
         * A set of applications that this stream group is associated to. You can stream any of these applications by
         * using this stream group.
         * </p>
         * <p>
         * This value is a set of <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
         * Resource Names (ARNs)</a> that uniquely identify application resources. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>.
         * </p>
         * 
         * @param associatedApplications
         *        A set of applications that this stream group is associated to. You can stream any of these
         *        applications by using this stream group. </p>
         *        <p>
         *        This value is a set of <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names
         *        (ARNs)</a> that uniquely identify application resources. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedApplications(Collection<String> associatedApplications);

        /**
         * <p>
         * A set of applications that this stream group is associated to. You can stream any of these applications by
         * using this stream group.
         * </p>
         * <p>
         * This value is a set of <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
         * Resource Names (ARNs)</a> that uniquely identify application resources. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>.
         * </p>
         * 
         * @param associatedApplications
         *        A set of applications that this stream group is associated to. You can stream any of these
         *        applications by using this stream group. </p>
         *        <p>
         *        This value is a set of <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names
         *        (ARNs)</a> that uniquely identify application resources. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedApplications(String... associatedApplications);
    }

    static final class BuilderImpl extends GameLiftStreamsResponse.BuilderImpl implements Builder {
        private String arn;

        private String description;

        private DefaultApplication defaultApplication;

        private List<LocationState> locationStates = DefaultSdkAutoConstructList.getInstance();

        private String streamClass;

        private String id;

        private String status;

        private String statusReason;

        private Instant lastUpdatedAt;

        private Instant createdAt;

        private Instant expiresAt;

        private List<String> associatedApplications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamGroupResponse model) {
            super(model);
            arn(model.arn);
            description(model.description);
            defaultApplication(model.defaultApplication);
            locationStates(model.locationStates);
            streamClass(model.streamClass);
            id(model.id);
            status(model.status);
            statusReason(model.statusReason);
            lastUpdatedAt(model.lastUpdatedAt);
            createdAt(model.createdAt);
            expiresAt(model.expiresAt);
            associatedApplications(model.associatedApplications);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DefaultApplication.Builder getDefaultApplication() {
            return defaultApplication != null ? defaultApplication.toBuilder() : null;
        }

        public final void setDefaultApplication(DefaultApplication.BuilderImpl defaultApplication) {
            this.defaultApplication = defaultApplication != null ? defaultApplication.build() : null;
        }

        @Override
        public final Builder defaultApplication(DefaultApplication defaultApplication) {
            this.defaultApplication = defaultApplication;
            return this;
        }

        public final List<LocationState.Builder> getLocationStates() {
            List<LocationState.Builder> result = LocationStatesCopier.copyToBuilder(this.locationStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocationStates(Collection<LocationState.BuilderImpl> locationStates) {
            this.locationStates = LocationStatesCopier.copyFromBuilder(locationStates);
        }

        @Override
        public final Builder locationStates(Collection<LocationState> locationStates) {
            this.locationStates = LocationStatesCopier.copy(locationStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationStates(LocationState... locationStates) {
            locationStates(Arrays.asList(locationStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationStates(Consumer<LocationState.Builder>... locationStates) {
            locationStates(Stream.of(locationStates).map(c -> LocationState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStreamClass() {
            return streamClass;
        }

        public final void setStreamClass(String streamClass) {
            this.streamClass = streamClass;
        }

        @Override
        public final Builder streamClass(String streamClass) {
            this.streamClass = streamClass;
            return this;
        }

        @Override
        public final Builder streamClass(StreamClass streamClass) {
            this.streamClass(streamClass == null ? null : streamClass.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(StreamGroupStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final Collection<String> getAssociatedApplications() {
            if (associatedApplications instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedApplications;
        }

        public final void setAssociatedApplications(Collection<String> associatedApplications) {
            this.associatedApplications = ArnListCopier.copy(associatedApplications);
        }

        @Override
        public final Builder associatedApplications(Collection<String> associatedApplications) {
            this.associatedApplications = ArnListCopier.copy(associatedApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedApplications(String... associatedApplications) {
            associatedApplications(Arrays.asList(associatedApplications));
            return this;
        }

        @Override
        public GetStreamGroupResponse build() {
            return new GetStreamGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
