/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings that identify the operating system for an application resource. This can also include a
 * compatibility layer and other drivers.
 * </p>
 * <p>
 * A runtime environment can be one of the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * For Linux applications
 * </p>
 * <ul>
 * <li>
 * <p>
 * Ubuntu 22.04 LTS (<code>Type=UBUNTU, Version=22_04_LTS</code>)
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * For Windows applications
 * </p>
 * <ul>
 * <li>
 * <p>
 * Microsoft Windows Server 2022 Base (<code>Type=WINDOWS, Version=2022</code>)
 * </p>
 * </li>
 * <li>
 * <p>
 * Proton 9.0-2 (<code>Type=PROTON, Version=20250516</code>)
 * </p>
 * </li>
 * <li>
 * <p>
 * Proton 8.0-5 (<code>Type=PROTON, Version=20241007</code>)
 * </p>
 * </li>
 * <li>
 * <p>
 * Proton 8.0-2c (<code>Type=PROTON, Version=20230704</code>)
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuntimeEnvironment implements SdkPojo, Serializable,
        ToCopyableBuilder<RuntimeEnvironment.Builder, RuntimeEnvironment> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RuntimeEnvironment::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(RuntimeEnvironment::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String version;

    private RuntimeEnvironment(BuilderImpl builder) {
        this.type = builder.type;
        this.version = builder.version;
    }

    /**
     * <p>
     * The operating system and other drivers. For Proton, this also includes the Proton compatibility layer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RuntimeEnvironmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The operating system and other drivers. For Proton, this also includes the Proton compatibility layer.
     * @see RuntimeEnvironmentType
     */
    public final RuntimeEnvironmentType type() {
        return RuntimeEnvironmentType.fromValue(type);
    }

    /**
     * <p>
     * The operating system and other drivers. For Proton, this also includes the Proton compatibility layer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RuntimeEnvironmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The operating system and other drivers. For Proton, this also includes the Proton compatibility layer.
     * @see RuntimeEnvironmentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Versioned container environment for the application operating system.
     * </p>
     * 
     * @return Versioned container environment for the application operating system.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeEnvironment)) {
            return false;
        }
        RuntimeEnvironment other = (RuntimeEnvironment) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuntimeEnvironment").add("Type", typeAsString()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuntimeEnvironment, T> g) {
        return obj -> g.apply((RuntimeEnvironment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuntimeEnvironment> {
        /**
         * <p>
         * The operating system and other drivers. For Proton, this also includes the Proton compatibility layer.
         * </p>
         * 
         * @param type
         *        The operating system and other drivers. For Proton, this also includes the Proton compatibility layer.
         * @see RuntimeEnvironmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuntimeEnvironmentType
         */
        Builder type(String type);

        /**
         * <p>
         * The operating system and other drivers. For Proton, this also includes the Proton compatibility layer.
         * </p>
         * 
         * @param type
         *        The operating system and other drivers. For Proton, this also includes the Proton compatibility layer.
         * @see RuntimeEnvironmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuntimeEnvironmentType
         */
        Builder type(RuntimeEnvironmentType type);

        /**
         * <p>
         * Versioned container environment for the application operating system.
         * </p>
         * 
         * @param version
         *        Versioned container environment for the application operating system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeEnvironment model) {
            type(model.type);
            version(model.version);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RuntimeEnvironmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public RuntimeEnvironment build() {
            return new RuntimeEnvironment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
