/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartStreamSessionResponse extends GameLiftStreamsResponse implements
        ToCopyableBuilder<StartStreamSessionResponse.Builder, StartStreamSessionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(StartStreamSessionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartStreamSessionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STREAM_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamGroupId").getter(getter(StartStreamSessionResponse::streamGroupId))
            .setter(setter(Builder::streamGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamGroupId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(StartStreamSessionResponse::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StartStreamSessionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(StartStreamSessionResponse::statusReasonAsString))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(StartStreamSessionResponse::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(StartStreamSessionResponse::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> SIGNAL_REQUEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SignalRequest").getter(getter(StartStreamSessionResponse::signalRequest))
            .setter(setter(Builder::signalRequest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalRequest").build()).build();

    private static final SdkField<String> SIGNAL_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SignalResponse").getter(getter(StartStreamSessionResponse::signalResponse))
            .setter(setter(Builder::signalResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalResponse").build()).build();

    private static final SdkField<Integer> CONNECTION_TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConnectionTimeoutSeconds").getter(getter(StartStreamSessionResponse::connectionTimeoutSeconds))
            .setter(setter(Builder::connectionTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTimeoutSeconds").build())
            .build();

    private static final SdkField<Integer> SESSION_LENGTH_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionLengthSeconds").getter(getter(StartStreamSessionResponse::sessionLengthSeconds))
            .setter(setter(Builder::sessionLengthSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionLengthSeconds").build())
            .build();

    private static final SdkField<List<String>> ADDITIONAL_LAUNCH_ARGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalLaunchArgs")
            .getter(getter(StartStreamSessionResponse::additionalLaunchArgs))
            .setter(setter(Builder::additionalLaunchArgs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalLaunchArgs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ADDITIONAL_ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdditionalEnvironmentVariables")
            .getter(getter(StartStreamSessionResponse::additionalEnvironmentVariables))
            .setter(setter(Builder::additionalEnvironmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalEnvironmentVariables")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> LOG_FILE_LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogFileLocationUri").getter(getter(StartStreamSessionResponse::logFileLocationUri))
            .setter(setter(Builder::logFileLocationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFileLocationUri").build())
            .build();

    private static final SdkField<String> WEB_SDK_PROTOCOL_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebSdkProtocolUrl").getter(getter(StartStreamSessionResponse::webSdkProtocolUrl))
            .setter(setter(Builder::webSdkProtocolUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebSdkProtocolUrl").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(StartStreamSessionResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(StartStreamSessionResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn").getter(getter(StartStreamSessionResponse::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final SdkField<ExportFilesMetadata> EXPORT_FILES_METADATA_FIELD = SdkField
            .<ExportFilesMetadata> builder(MarshallingType.SDK_POJO).memberName("ExportFilesMetadata")
            .getter(getter(StartStreamSessionResponse::exportFilesMetadata)).setter(setter(Builder::exportFilesMetadata))
            .constructor(ExportFilesMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFilesMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD,
            STREAM_GROUP_ID_FIELD, USER_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, PROTOCOL_FIELD, LOCATION_FIELD,
            SIGNAL_REQUEST_FIELD, SIGNAL_RESPONSE_FIELD, CONNECTION_TIMEOUT_SECONDS_FIELD, SESSION_LENGTH_SECONDS_FIELD,
            ADDITIONAL_LAUNCH_ARGS_FIELD, ADDITIONAL_ENVIRONMENT_VARIABLES_FIELD, LOG_FILE_LOCATION_URI_FIELD,
            WEB_SDK_PROTOCOL_URL_FIELD, LAST_UPDATED_AT_FIELD, CREATED_AT_FIELD, APPLICATION_ARN_FIELD,
            EXPORT_FILES_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String description;

    private final String streamGroupId;

    private final String userId;

    private final String status;

    private final String statusReason;

    private final String protocol;

    private final String location;

    private final String signalRequest;

    private final String signalResponse;

    private final Integer connectionTimeoutSeconds;

    private final Integer sessionLengthSeconds;

    private final List<String> additionalLaunchArgs;

    private final Map<String, String> additionalEnvironmentVariables;

    private final String logFileLocationUri;

    private final String webSdkProtocolUrl;

    private final Instant lastUpdatedAt;

    private final Instant createdAt;

    private final String applicationArn;

    private final ExportFilesMetadata exportFilesMetadata;

    private StartStreamSessionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.description = builder.description;
        this.streamGroupId = builder.streamGroupId;
        this.userId = builder.userId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.protocol = builder.protocol;
        this.location = builder.location;
        this.signalRequest = builder.signalRequest;
        this.signalResponse = builder.signalResponse;
        this.connectionTimeoutSeconds = builder.connectionTimeoutSeconds;
        this.sessionLengthSeconds = builder.sessionLengthSeconds;
        this.additionalLaunchArgs = builder.additionalLaunchArgs;
        this.additionalEnvironmentVariables = builder.additionalEnvironmentVariables;
        this.logFileLocationUri = builder.logFileLocationUri;
        this.webSdkProtocolUrl = builder.webSdkProtocolUrl;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdAt = builder.createdAt;
        this.applicationArn = builder.applicationArn;
        this.exportFilesMetadata = builder.exportFilesMetadata;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a>
     * that's assigned to a stream session resource. When combined with the stream group resource ID, this value
     * uniquely identifies the stream session across all Amazon Web Services Regions. Format is
     * <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:streamsession/[stream group resource ID]/[stream session resource ID]</code>
     * .
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
     *         (ARN)</a> that's assigned to a stream session resource. When combined with the stream group resource ID,
     *         this value uniquely identifies the stream session across all Amazon Web Services Regions. Format is
     *         <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:streamsession/[stream group resource ID]/[stream session resource ID]</code>
     *         .
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A human-readable label for the stream session. You can update this value at any time.
     * </p>
     * 
     * @return A human-readable label for the stream session. You can update this value at any time.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier for the Amazon GameLift Streams stream group that is hosting the stream session. Format
     * example: <code>sg-1AB2C3De4</code>.
     * </p>
     * 
     * @return The unique identifier for the Amazon GameLift Streams stream group that is hosting the stream session.
     *         Format example: <code>sg-1AB2C3De4</code>.
     */
    public final String streamGroupId() {
        return streamGroupId;
    }

    /**
     * <p>
     * An opaque, unique identifier for an end-user, defined by the developer.
     * </p>
     * 
     * @return An opaque, unique identifier for an end-user, defined by the developer.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The current status of the stream session. A stream session is ready for a client to connect when in
     * <code>ACTIVE</code> status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVATING</code>: The stream session is starting and preparing to stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The stream session is ready and waiting for a client connection. A client has
     * <code>ConnectionTimeoutSeconds</code> (specified in <code>StartStreamSession</code>) from when the session
     * reaches <code>ACTIVE</code> state to establish a connection. If no client connects within this timeframe, the
     * session automatically terminates.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONNECTED</code>: The stream session has a connected client. A session will automatically terminate if
     * there is no user input for 60 minutes, or if the maximum length of a session specified by
     * <code>SessionLengthSeconds</code> in <code>StartStreamSession</code> is exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: The stream session failed to activate. See <code>StatusReason</code> (returned by
     * <code>GetStreamSession</code> and <code>StartStreamSession</code>) for more information.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_CLIENT_RECONNECTION</code>: A client has recently disconnected and the stream session is waiting
     * for the client to reconnect. A client has <code>ConnectionTimeoutSeconds</code> (specified in
     * <code>StartStreamSession</code>) from when the session reaches <code>PENDING_CLIENT_RECONNECTION</code> state to
     * re-establish a connection. If no client connects within this timeframe, the session automatically terminates.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RECONNECTING</code>: A client has initiated a reconnect to a session that was in
     * <code>PENDING_CLIENT_RECONNECTION</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TERMINATING</code>: The stream session is ending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TERMINATED</code>: The stream session has ended.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the stream session. A stream session is ready for a client to connect when in
     *         <code>ACTIVE</code> status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code>: The stream session is starting and preparing to stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The stream session is ready and waiting for a client connection. A client has
     *         <code>ConnectionTimeoutSeconds</code> (specified in <code>StartStreamSession</code>) from when the
     *         session reaches <code>ACTIVE</code> state to establish a connection. If no client connects within this
     *         timeframe, the session automatically terminates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONNECTED</code>: The stream session has a connected client. A session will automatically terminate
     *         if there is no user input for 60 minutes, or if the maximum length of a session specified by
     *         <code>SessionLengthSeconds</code> in <code>StartStreamSession</code> is exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: The stream session failed to activate. See <code>StatusReason</code> (returned by
     *         <code>GetStreamSession</code> and <code>StartStreamSession</code>) for more information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_CLIENT_RECONNECTION</code>: A client has recently disconnected and the stream session is
     *         waiting for the client to reconnect. A client has <code>ConnectionTimeoutSeconds</code> (specified in
     *         <code>StartStreamSession</code>) from when the session reaches <code>PENDING_CLIENT_RECONNECTION</code>
     *         state to re-establish a connection. If no client connects within this timeframe, the session
     *         automatically terminates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RECONNECTING</code>: A client has initiated a reconnect to a session that was in
     *         <code>PENDING_CLIENT_RECONNECTION</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TERMINATING</code>: The stream session is ending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TERMINATED</code>: The stream session has ended.
     *         </p>
     *         </li>
     * @see StreamSessionStatus
     */
    public final StreamSessionStatus status() {
        return StreamSessionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the stream session. A stream session is ready for a client to connect when in
     * <code>ACTIVE</code> status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVATING</code>: The stream session is starting and preparing to stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The stream session is ready and waiting for a client connection. A client has
     * <code>ConnectionTimeoutSeconds</code> (specified in <code>StartStreamSession</code>) from when the session
     * reaches <code>ACTIVE</code> state to establish a connection. If no client connects within this timeframe, the
     * session automatically terminates.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONNECTED</code>: The stream session has a connected client. A session will automatically terminate if
     * there is no user input for 60 minutes, or if the maximum length of a session specified by
     * <code>SessionLengthSeconds</code> in <code>StartStreamSession</code> is exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: The stream session failed to activate. See <code>StatusReason</code> (returned by
     * <code>GetStreamSession</code> and <code>StartStreamSession</code>) for more information.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_CLIENT_RECONNECTION</code>: A client has recently disconnected and the stream session is waiting
     * for the client to reconnect. A client has <code>ConnectionTimeoutSeconds</code> (specified in
     * <code>StartStreamSession</code>) from when the session reaches <code>PENDING_CLIENT_RECONNECTION</code> state to
     * re-establish a connection. If no client connects within this timeframe, the session automatically terminates.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RECONNECTING</code>: A client has initiated a reconnect to a session that was in
     * <code>PENDING_CLIENT_RECONNECTION</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TERMINATING</code>: The stream session is ending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TERMINATED</code>: The stream session has ended.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the stream session. A stream session is ready for a client to connect when in
     *         <code>ACTIVE</code> status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code>: The stream session is starting and preparing to stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The stream session is ready and waiting for a client connection. A client has
     *         <code>ConnectionTimeoutSeconds</code> (specified in <code>StartStreamSession</code>) from when the
     *         session reaches <code>ACTIVE</code> state to establish a connection. If no client connects within this
     *         timeframe, the session automatically terminates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONNECTED</code>: The stream session has a connected client. A session will automatically terminate
     *         if there is no user input for 60 minutes, or if the maximum length of a session specified by
     *         <code>SessionLengthSeconds</code> in <code>StartStreamSession</code> is exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: The stream session failed to activate. See <code>StatusReason</code> (returned by
     *         <code>GetStreamSession</code> and <code>StartStreamSession</code>) for more information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_CLIENT_RECONNECTION</code>: A client has recently disconnected and the stream session is
     *         waiting for the client to reconnect. A client has <code>ConnectionTimeoutSeconds</code> (specified in
     *         <code>StartStreamSession</code>) from when the session reaches <code>PENDING_CLIENT_RECONNECTION</code>
     *         state to re-establish a connection. If no client connects within this timeframe, the session
     *         automatically terminates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RECONNECTING</code>: A client has initiated a reconnect to a session that was in
     *         <code>PENDING_CLIENT_RECONNECTION</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TERMINATING</code>: The stream session is ending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TERMINATED</code>: The stream session has ended.
     *         </p>
     *         </li>
     * @see StreamSessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A short description of the reason the stream session is in <code>ERROR</code> status or <code>TERMINATED</code>
     * status.
     * </p>
     * <p>
     * <code>ERROR</code> status reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>applicationLogS3DestinationError</code>: Could not write the application log to the Amazon S3 bucket that
     * is configured for the streaming application. Make sure the bucket still exists.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>internalError</code>: An internal service error occurred. Start a new stream session to continue streaming.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>invalidSignalRequest</code>: The WebRTC signal request that was sent is not valid. When starting or
     * reconnecting to a stream session, use <code>generateSignalRequest</code> in the Amazon GameLift Streams Web SDK
     * to generate a new signal request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>placementTimeout</code>: Amazon GameLift Streams could not find available stream capacity to start a stream
     * session. Increase the stream capacity in the stream group or wait until capacity becomes available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>TERMINATED</code> status reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>apiTerminated</code>: The stream session was terminated by an API call to <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_TerminateStreamSession.html"
     * >TerminateStreamSession</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>applicationExit</code>: The streaming application exited or crashed. The stream session was terminated
     * because the application is no longer running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>connectionTimeout</code>: The stream session was terminated because the client failed to connect within the
     * connection timeout period specified by <code>ConnectionTimeoutSeconds</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>idleTimeout</code>: The stream session was terminated because it exceeded the idle timeout period of 60
     * minutes with no user input activity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maxSessionLengthTimeout</code>: The stream session was terminated because it exceeded the maximum session
     * length timeout period specified by <code>SessionLengthSeconds</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reconnectionTimeout</code>: The stream session was terminated because the client failed to reconnect within
     * the reconnection timeout period specified by <code>ConnectionTimeoutSeconds</code> after losing connection.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link StreamSessionStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return A short description of the reason the stream session is in <code>ERROR</code> status or
     *         <code>TERMINATED</code> status.</p>
     *         <p>
     *         <code>ERROR</code> status reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>applicationLogS3DestinationError</code>: Could not write the application log to the Amazon S3
     *         bucket that is configured for the streaming application. Make sure the bucket still exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>internalError</code>: An internal service error occurred. Start a new stream session to continue
     *         streaming.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>invalidSignalRequest</code>: The WebRTC signal request that was sent is not valid. When starting or
     *         reconnecting to a stream session, use <code>generateSignalRequest</code> in the Amazon GameLift Streams
     *         Web SDK to generate a new signal request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>placementTimeout</code>: Amazon GameLift Streams could not find available stream capacity to start
     *         a stream session. Increase the stream capacity in the stream group or wait until capacity becomes
     *         available.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>TERMINATED</code> status reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>apiTerminated</code>: The stream session was terminated by an API call to <a
     *         href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_TerminateStreamSession.html"
     *         >TerminateStreamSession</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>applicationExit</code>: The streaming application exited or crashed. The stream session was
     *         terminated because the application is no longer running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>connectionTimeout</code>: The stream session was terminated because the client failed to connect
     *         within the connection timeout period specified by <code>ConnectionTimeoutSeconds</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>idleTimeout</code>: The stream session was terminated because it exceeded the idle timeout period
     *         of 60 minutes with no user input activity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maxSessionLengthTimeout</code>: The stream session was terminated because it exceeded the maximum
     *         session length timeout period specified by <code>SessionLengthSeconds</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reconnectionTimeout</code>: The stream session was terminated because the client failed to
     *         reconnect within the reconnection timeout period specified by <code>ConnectionTimeoutSeconds</code> after
     *         losing connection.
     *         </p>
     *         </li>
     * @see StreamSessionStatusReason
     */
    public final StreamSessionStatusReason statusReason() {
        return StreamSessionStatusReason.fromValue(statusReason);
    }

    /**
     * <p>
     * A short description of the reason the stream session is in <code>ERROR</code> status or <code>TERMINATED</code>
     * status.
     * </p>
     * <p>
     * <code>ERROR</code> status reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>applicationLogS3DestinationError</code>: Could not write the application log to the Amazon S3 bucket that
     * is configured for the streaming application. Make sure the bucket still exists.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>internalError</code>: An internal service error occurred. Start a new stream session to continue streaming.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>invalidSignalRequest</code>: The WebRTC signal request that was sent is not valid. When starting or
     * reconnecting to a stream session, use <code>generateSignalRequest</code> in the Amazon GameLift Streams Web SDK
     * to generate a new signal request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>placementTimeout</code>: Amazon GameLift Streams could not find available stream capacity to start a stream
     * session. Increase the stream capacity in the stream group or wait until capacity becomes available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>TERMINATED</code> status reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>apiTerminated</code>: The stream session was terminated by an API call to <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_TerminateStreamSession.html"
     * >TerminateStreamSession</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>applicationExit</code>: The streaming application exited or crashed. The stream session was terminated
     * because the application is no longer running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>connectionTimeout</code>: The stream session was terminated because the client failed to connect within the
     * connection timeout period specified by <code>ConnectionTimeoutSeconds</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>idleTimeout</code>: The stream session was terminated because it exceeded the idle timeout period of 60
     * minutes with no user input activity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maxSessionLengthTimeout</code>: The stream session was terminated because it exceeded the maximum session
     * length timeout period specified by <code>SessionLengthSeconds</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reconnectionTimeout</code>: The stream session was terminated because the client failed to reconnect within
     * the reconnection timeout period specified by <code>ConnectionTimeoutSeconds</code> after losing connection.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link StreamSessionStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return A short description of the reason the stream session is in <code>ERROR</code> status or
     *         <code>TERMINATED</code> status.</p>
     *         <p>
     *         <code>ERROR</code> status reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>applicationLogS3DestinationError</code>: Could not write the application log to the Amazon S3
     *         bucket that is configured for the streaming application. Make sure the bucket still exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>internalError</code>: An internal service error occurred. Start a new stream session to continue
     *         streaming.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>invalidSignalRequest</code>: The WebRTC signal request that was sent is not valid. When starting or
     *         reconnecting to a stream session, use <code>generateSignalRequest</code> in the Amazon GameLift Streams
     *         Web SDK to generate a new signal request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>placementTimeout</code>: Amazon GameLift Streams could not find available stream capacity to start
     *         a stream session. Increase the stream capacity in the stream group or wait until capacity becomes
     *         available.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>TERMINATED</code> status reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>apiTerminated</code>: The stream session was terminated by an API call to <a
     *         href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_TerminateStreamSession.html"
     *         >TerminateStreamSession</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>applicationExit</code>: The streaming application exited or crashed. The stream session was
     *         terminated because the application is no longer running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>connectionTimeout</code>: The stream session was terminated because the client failed to connect
     *         within the connection timeout period specified by <code>ConnectionTimeoutSeconds</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>idleTimeout</code>: The stream session was terminated because it exceeded the idle timeout period
     *         of 60 minutes with no user input activity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maxSessionLengthTimeout</code>: The stream session was terminated because it exceeded the maximum
     *         session length timeout period specified by <code>SessionLengthSeconds</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reconnectionTimeout</code>: The stream session was terminated because the client failed to
     *         reconnect within the reconnection timeout period specified by <code>ConnectionTimeoutSeconds</code> after
     *         losing connection.
     *         </p>
     *         </li>
     * @see StreamSessionStatusReason
     */
    public final String statusReasonAsString() {
        return statusReason;
    }

    /**
     * <p>
     * The data transfer protocol in use with the stream session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The data transfer protocol in use with the stream session.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * <p>
     * The data transfer protocol in use with the stream session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The data transfer protocol in use with the stream session.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The location where Amazon GameLift Streams hosts and streams your application. For example,
     * <code>us-east-1</code>. For a complete list of locations that Amazon GameLift Streams supports, refer to <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions, quotas, and
     * limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
     * </p>
     * 
     * @return The location where Amazon GameLift Streams hosts and streams your application. For example,
     *         <code>us-east-1</code>. For a complete list of locations that Amazon GameLift Streams supports, refer to
     *         <a href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions,
     *         quotas, and limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The WebRTC ICE offer string that a client generates to initiate a connection to the stream session.
     * </p>
     * 
     * @return The WebRTC ICE offer string that a client generates to initiate a connection to the stream session.
     */
    public final String signalRequest() {
        return signalRequest;
    }

    /**
     * <p>
     * The WebRTC answer string that the stream server generates in response to the <code>SignalRequest</code>.
     * </p>
     * 
     * @return The WebRTC answer string that the stream server generates in response to the <code>SignalRequest</code>.
     */
    public final String signalResponse() {
        return signalResponse;
    }

    /**
     * <p>
     * The length of time that Amazon GameLift Streams should wait for a client to connect or reconnect to the stream
     * session. This time span starts when the stream session reaches <code>ACTIVE</code> or
     * <code>PENDING_CLIENT_RECONNECTION</code> state. If no client connects (or reconnects) before the timeout, Amazon
     * GameLift Streams terminates the stream session.
     * </p>
     * 
     * @return The length of time that Amazon GameLift Streams should wait for a client to connect or reconnect to the
     *         stream session. This time span starts when the stream session reaches <code>ACTIVE</code> or
     *         <code>PENDING_CLIENT_RECONNECTION</code> state. If no client connects (or reconnects) before the timeout,
     *         Amazon GameLift Streams terminates the stream session.
     */
    public final Integer connectionTimeoutSeconds() {
        return connectionTimeoutSeconds;
    }

    /**
     * <p>
     * The maximum duration of a session. Amazon GameLift Streams will automatically terminate a session after this
     * amount of time has elapsed, regardless of any existing client connections.
     * </p>
     * 
     * @return The maximum duration of a session. Amazon GameLift Streams will automatically terminate a session after
     *         this amount of time has elapsed, regardless of any existing client connections.
     */
    public final Integer sessionLengthSeconds() {
        return sessionLengthSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalLaunchArgs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalLaunchArgs() {
        return additionalLaunchArgs != null && !(additionalLaunchArgs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of CLI arguments that are sent to the streaming server when a stream session launches. You can use this to
     * configure the application or stream session details. You can also provide custom arguments that Amazon GameLift
     * Streams passes to your game client.
     * </p>
     * <p>
     * <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar purposes.
     * <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
     * <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalLaunchArgs} method.
     * </p>
     * 
     * @return A list of CLI arguments that are sent to the streaming server when a stream session launches. You can use
     *         this to configure the application or stream session details. You can also provide custom arguments that
     *         Amazon GameLift Streams passes to your game client.</p>
     *         <p>
     *         <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar purposes.
     *         <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
     *         <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
     */
    public final List<String> additionalLaunchArgs() {
        return additionalLaunchArgs;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalEnvironmentVariables property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalEnvironmentVariables() {
        return additionalEnvironmentVariables != null && !(additionalEnvironmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of options that you can use to control the stream session runtime environment, expressed as a set of
     * key-value pairs. You can use this to configure the application or stream session details. You can also provide
     * custom environment variables that Amazon GameLift Streams passes to your game client.
     * </p>
     * <note>
     * <p>
     * If you want to debug your application with environment variables, we recommend that you do so in a local
     * environment outside of Amazon GameLift Streams. For more information, refer to the Compatibility Guidance in the
     * troubleshooting section of the Developer Guide.
     * </p>
     * </note>
     * <p>
     * <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar purposes.
     * <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
     * <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalEnvironmentVariables} method.
     * </p>
     * 
     * @return A set of options that you can use to control the stream session runtime environment, expressed as a set
     *         of key-value pairs. You can use this to configure the application or stream session details. You can also
     *         provide custom environment variables that Amazon GameLift Streams passes to your game client.</p> <note>
     *         <p>
     *         If you want to debug your application with environment variables, we recommend that you do so in a local
     *         environment outside of Amazon GameLift Streams. For more information, refer to the Compatibility Guidance
     *         in the troubleshooting section of the Developer Guide.
     *         </p>
     *         </note>
     *         <p>
     *         <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar purposes.
     *         <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
     *         <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
     */
    public final Map<String, String> additionalEnvironmentVariables() {
        return additionalEnvironmentVariables;
    }

    /**
     * <p>
     * Access location for log files that your content generates during a stream session. These log files are uploaded
     * to cloud storage location at the end of a stream session. The Amazon GameLift Streams application resource
     * defines which log files to upload.
     * </p>
     * 
     * @return Access location for log files that your content generates during a stream session. These log files are
     *         uploaded to cloud storage location at the end of a stream session. The Amazon GameLift Streams
     *         application resource defines which log files to upload.
     */
    public final String logFileLocationUri() {
        return logFileLocationUri;
    }

    /**
     * <p>
     * The URL of an S3 bucket that stores Amazon GameLift Streams WebSDK files. The URL is used to establish connection
     * with the client.
     * </p>
     * 
     * @return The URL of an S3 bucket that stores Amazon GameLift Streams WebSDK files. The URL is used to establish
     *         connection with the client.
     */
    public final String webSdkProtocolUrl() {
        return webSdkProtocolUrl;
    }

    /**
     * <p>
     * A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601 format,
     * such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     * </p>
     * 
     * @return A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601
     *         format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601 format, such
     * as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     * </p>
     * 
     * @return A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601
     *         format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The application streaming in this session.
     * </p>
     * <p>
     * This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource
     * Name (ARN)</a> that uniquely identifies the application resource. Example ARN:
     * <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>.
     * </p>
     * 
     * @return The application streaming in this session.</p>
     *         <p>
     *         This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
     *         Resource Name (ARN)</a> that uniquely identifies the application resource. Example ARN:
     *         <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * Provides details about the stream session's exported files.
     * </p>
     * 
     * @return Provides details about the stream session's exported files.
     */
    public final ExportFilesMetadata exportFilesMetadata() {
        return exportFilesMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(streamGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(signalRequest());
        hashCode = 31 * hashCode + Objects.hashCode(signalResponse());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(sessionLengthSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalLaunchArgs() ? additionalLaunchArgs() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAdditionalEnvironmentVariables() ? additionalEnvironmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logFileLocationUri());
        hashCode = 31 * hashCode + Objects.hashCode(webSdkProtocolUrl());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(exportFilesMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartStreamSessionResponse)) {
            return false;
        }
        StartStreamSessionResponse other = (StartStreamSessionResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description())
                && Objects.equals(streamGroupId(), other.streamGroupId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReasonAsString(), other.statusReasonAsString())
                && Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(location(), other.location())
                && Objects.equals(signalRequest(), other.signalRequest())
                && Objects.equals(signalResponse(), other.signalResponse())
                && Objects.equals(connectionTimeoutSeconds(), other.connectionTimeoutSeconds())
                && Objects.equals(sessionLengthSeconds(), other.sessionLengthSeconds())
                && hasAdditionalLaunchArgs() == other.hasAdditionalLaunchArgs()
                && Objects.equals(additionalLaunchArgs(), other.additionalLaunchArgs())
                && hasAdditionalEnvironmentVariables() == other.hasAdditionalEnvironmentVariables()
                && Objects.equals(additionalEnvironmentVariables(), other.additionalEnvironmentVariables())
                && Objects.equals(logFileLocationUri(), other.logFileLocationUri())
                && Objects.equals(webSdkProtocolUrl(), other.webSdkProtocolUrl())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(exportFilesMetadata(), other.exportFilesMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("StartStreamSessionResponse")
                .add("Arn", arn())
                .add("Description", description())
                .add("StreamGroupId", streamGroupId())
                .add("UserId", userId())
                .add("Status", statusAsString())
                .add("StatusReason", statusReasonAsString())
                .add("Protocol", protocolAsString())
                .add("Location", location())
                .add("SignalRequest", signalRequest() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SignalResponse", signalResponse() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConnectionTimeoutSeconds", connectionTimeoutSeconds())
                .add("SessionLengthSeconds", sessionLengthSeconds())
                .add("AdditionalLaunchArgs", hasAdditionalLaunchArgs() ? additionalLaunchArgs() : null)
                .add("AdditionalEnvironmentVariables",
                        hasAdditionalEnvironmentVariables() ? additionalEnvironmentVariables() : null)
                .add("LogFileLocationUri", logFileLocationUri()).add("WebSdkProtocolUrl", webSdkProtocolUrl())
                .add("LastUpdatedAt", lastUpdatedAt()).add("CreatedAt", createdAt()).add("ApplicationArn", applicationArn())
                .add("ExportFilesMetadata", exportFilesMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "StreamGroupId":
            return Optional.ofNullable(clazz.cast(streamGroupId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReasonAsString()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "SignalRequest":
            return Optional.ofNullable(clazz.cast(signalRequest()));
        case "SignalResponse":
            return Optional.ofNullable(clazz.cast(signalResponse()));
        case "ConnectionTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(connectionTimeoutSeconds()));
        case "SessionLengthSeconds":
            return Optional.ofNullable(clazz.cast(sessionLengthSeconds()));
        case "AdditionalLaunchArgs":
            return Optional.ofNullable(clazz.cast(additionalLaunchArgs()));
        case "AdditionalEnvironmentVariables":
            return Optional.ofNullable(clazz.cast(additionalEnvironmentVariables()));
        case "LogFileLocationUri":
            return Optional.ofNullable(clazz.cast(logFileLocationUri()));
        case "WebSdkProtocolUrl":
            return Optional.ofNullable(clazz.cast(webSdkProtocolUrl()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "ExportFilesMetadata":
            return Optional.ofNullable(clazz.cast(exportFilesMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("StreamGroupId", STREAM_GROUP_ID_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("SignalRequest", SIGNAL_REQUEST_FIELD);
        map.put("SignalResponse", SIGNAL_RESPONSE_FIELD);
        map.put("ConnectionTimeoutSeconds", CONNECTION_TIMEOUT_SECONDS_FIELD);
        map.put("SessionLengthSeconds", SESSION_LENGTH_SECONDS_FIELD);
        map.put("AdditionalLaunchArgs", ADDITIONAL_LAUNCH_ARGS_FIELD);
        map.put("AdditionalEnvironmentVariables", ADDITIONAL_ENVIRONMENT_VARIABLES_FIELD);
        map.put("LogFileLocationUri", LOG_FILE_LOCATION_URI_FIELD);
        map.put("WebSdkProtocolUrl", WEB_SDK_PROTOCOL_URL_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("ExportFilesMetadata", EXPORT_FILES_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartStreamSessionResponse, T> g) {
        return obj -> g.apply((StartStreamSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftStreamsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartStreamSessionResponse> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
         * (ARN)</a> that's assigned to a stream session resource. When combined with the stream group resource ID, this
         * value uniquely identifies the stream session across all Amazon Web Services Regions. Format is
         * <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:streamsession/[stream group resource ID]/[stream session resource ID]</code>
         * .
         * </p>
         * 
         * @param arn
         *        The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource
         *        Name (ARN)</a> that's assigned to a stream session resource. When combined with the stream group
         *        resource ID, this value uniquely identifies the stream session across all Amazon Web Services Regions.
         *        Format is
         *        <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:streamsession/[stream group resource ID]/[stream session resource ID]</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A human-readable label for the stream session. You can update this value at any time.
         * </p>
         * 
         * @param description
         *        A human-readable label for the stream session. You can update this value at any time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier for the Amazon GameLift Streams stream group that is hosting the stream session. Format
         * example: <code>sg-1AB2C3De4</code>.
         * </p>
         * 
         * @param streamGroupId
         *        The unique identifier for the Amazon GameLift Streams stream group that is hosting the stream session.
         *        Format example: <code>sg-1AB2C3De4</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamGroupId(String streamGroupId);

        /**
         * <p>
         * An opaque, unique identifier for an end-user, defined by the developer.
         * </p>
         * 
         * @param userId
         *        An opaque, unique identifier for an end-user, defined by the developer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The current status of the stream session. A stream session is ready for a client to connect when in
         * <code>ACTIVE</code> status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVATING</code>: The stream session is starting and preparing to stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The stream session is ready and waiting for a client connection. A client has
         * <code>ConnectionTimeoutSeconds</code> (specified in <code>StartStreamSession</code>) from when the session
         * reaches <code>ACTIVE</code> state to establish a connection. If no client connects within this timeframe, the
         * session automatically terminates.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONNECTED</code>: The stream session has a connected client. A session will automatically terminate if
         * there is no user input for 60 minutes, or if the maximum length of a session specified by
         * <code>SessionLengthSeconds</code> in <code>StartStreamSession</code> is exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: The stream session failed to activate. See <code>StatusReason</code> (returned by
         * <code>GetStreamSession</code> and <code>StartStreamSession</code>) for more information.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_CLIENT_RECONNECTION</code>: A client has recently disconnected and the stream session is
         * waiting for the client to reconnect. A client has <code>ConnectionTimeoutSeconds</code> (specified in
         * <code>StartStreamSession</code>) from when the session reaches <code>PENDING_CLIENT_RECONNECTION</code> state
         * to re-establish a connection. If no client connects within this timeframe, the session automatically
         * terminates.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RECONNECTING</code>: A client has initiated a reconnect to a session that was in
         * <code>PENDING_CLIENT_RECONNECTION</code> state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TERMINATING</code>: The stream session is ending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TERMINATED</code>: The stream session has ended.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the stream session. A stream session is ready for a client to connect when in
         *        <code>ACTIVE</code> status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code>: The stream session is starting and preparing to stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The stream session is ready and waiting for a client connection. A client has
         *        <code>ConnectionTimeoutSeconds</code> (specified in <code>StartStreamSession</code>) from when the
         *        session reaches <code>ACTIVE</code> state to establish a connection. If no client connects within this
         *        timeframe, the session automatically terminates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONNECTED</code>: The stream session has a connected client. A session will automatically
         *        terminate if there is no user input for 60 minutes, or if the maximum length of a session specified by
         *        <code>SessionLengthSeconds</code> in <code>StartStreamSession</code> is exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: The stream session failed to activate. See <code>StatusReason</code> (returned by
         *        <code>GetStreamSession</code> and <code>StartStreamSession</code>) for more information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_CLIENT_RECONNECTION</code>: A client has recently disconnected and the stream session is
         *        waiting for the client to reconnect. A client has <code>ConnectionTimeoutSeconds</code> (specified in
         *        <code>StartStreamSession</code>) from when the session reaches
         *        <code>PENDING_CLIENT_RECONNECTION</code> state to re-establish a connection. If no client connects
         *        within this timeframe, the session automatically terminates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RECONNECTING</code>: A client has initiated a reconnect to a session that was in
         *        <code>PENDING_CLIENT_RECONNECTION</code> state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TERMINATING</code>: The stream session is ending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TERMINATED</code>: The stream session has ended.
         *        </p>
         *        </li>
         * @see StreamSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamSessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the stream session. A stream session is ready for a client to connect when in
         * <code>ACTIVE</code> status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVATING</code>: The stream session is starting and preparing to stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The stream session is ready and waiting for a client connection. A client has
         * <code>ConnectionTimeoutSeconds</code> (specified in <code>StartStreamSession</code>) from when the session
         * reaches <code>ACTIVE</code> state to establish a connection. If no client connects within this timeframe, the
         * session automatically terminates.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONNECTED</code>: The stream session has a connected client. A session will automatically terminate if
         * there is no user input for 60 minutes, or if the maximum length of a session specified by
         * <code>SessionLengthSeconds</code> in <code>StartStreamSession</code> is exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: The stream session failed to activate. See <code>StatusReason</code> (returned by
         * <code>GetStreamSession</code> and <code>StartStreamSession</code>) for more information.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_CLIENT_RECONNECTION</code>: A client has recently disconnected and the stream session is
         * waiting for the client to reconnect. A client has <code>ConnectionTimeoutSeconds</code> (specified in
         * <code>StartStreamSession</code>) from when the session reaches <code>PENDING_CLIENT_RECONNECTION</code> state
         * to re-establish a connection. If no client connects within this timeframe, the session automatically
         * terminates.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RECONNECTING</code>: A client has initiated a reconnect to a session that was in
         * <code>PENDING_CLIENT_RECONNECTION</code> state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TERMINATING</code>: The stream session is ending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TERMINATED</code>: The stream session has ended.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the stream session. A stream session is ready for a client to connect when in
         *        <code>ACTIVE</code> status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code>: The stream session is starting and preparing to stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The stream session is ready and waiting for a client connection. A client has
         *        <code>ConnectionTimeoutSeconds</code> (specified in <code>StartStreamSession</code>) from when the
         *        session reaches <code>ACTIVE</code> state to establish a connection. If no client connects within this
         *        timeframe, the session automatically terminates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONNECTED</code>: The stream session has a connected client. A session will automatically
         *        terminate if there is no user input for 60 minutes, or if the maximum length of a session specified by
         *        <code>SessionLengthSeconds</code> in <code>StartStreamSession</code> is exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: The stream session failed to activate. See <code>StatusReason</code> (returned by
         *        <code>GetStreamSession</code> and <code>StartStreamSession</code>) for more information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_CLIENT_RECONNECTION</code>: A client has recently disconnected and the stream session is
         *        waiting for the client to reconnect. A client has <code>ConnectionTimeoutSeconds</code> (specified in
         *        <code>StartStreamSession</code>) from when the session reaches
         *        <code>PENDING_CLIENT_RECONNECTION</code> state to re-establish a connection. If no client connects
         *        within this timeframe, the session automatically terminates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RECONNECTING</code>: A client has initiated a reconnect to a session that was in
         *        <code>PENDING_CLIENT_RECONNECTION</code> state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TERMINATING</code>: The stream session is ending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TERMINATED</code>: The stream session has ended.
         *        </p>
         *        </li>
         * @see StreamSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamSessionStatus
         */
        Builder status(StreamSessionStatus status);

        /**
         * <p>
         * A short description of the reason the stream session is in <code>ERROR</code> status or
         * <code>TERMINATED</code> status.
         * </p>
         * <p>
         * <code>ERROR</code> status reasons:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>applicationLogS3DestinationError</code>: Could not write the application log to the Amazon S3 bucket
         * that is configured for the streaming application. Make sure the bucket still exists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>internalError</code>: An internal service error occurred. Start a new stream session to continue
         * streaming.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>invalidSignalRequest</code>: The WebRTC signal request that was sent is not valid. When starting or
         * reconnecting to a stream session, use <code>generateSignalRequest</code> in the Amazon GameLift Streams Web
         * SDK to generate a new signal request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placementTimeout</code>: Amazon GameLift Streams could not find available stream capacity to start a
         * stream session. Increase the stream capacity in the stream group or wait until capacity becomes available.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>TERMINATED</code> status reasons:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>apiTerminated</code>: The stream session was terminated by an API call to <a
         * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_TerminateStreamSession.html"
         * >TerminateStreamSession</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>applicationExit</code>: The streaming application exited or crashed. The stream session was terminated
         * because the application is no longer running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>connectionTimeout</code>: The stream session was terminated because the client failed to connect within
         * the connection timeout period specified by <code>ConnectionTimeoutSeconds</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>idleTimeout</code>: The stream session was terminated because it exceeded the idle timeout period of 60
         * minutes with no user input activity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maxSessionLengthTimeout</code>: The stream session was terminated because it exceeded the maximum
         * session length timeout period specified by <code>SessionLengthSeconds</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reconnectionTimeout</code>: The stream session was terminated because the client failed to reconnect
         * within the reconnection timeout period specified by <code>ConnectionTimeoutSeconds</code> after losing
         * connection.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusReason
         *        A short description of the reason the stream session is in <code>ERROR</code> status or
         *        <code>TERMINATED</code> status.</p>
         *        <p>
         *        <code>ERROR</code> status reasons:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>applicationLogS3DestinationError</code>: Could not write the application log to the Amazon S3
         *        bucket that is configured for the streaming application. Make sure the bucket still exists.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>internalError</code>: An internal service error occurred. Start a new stream session to continue
         *        streaming.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>invalidSignalRequest</code>: The WebRTC signal request that was sent is not valid. When starting
         *        or reconnecting to a stream session, use <code>generateSignalRequest</code> in the Amazon GameLift
         *        Streams Web SDK to generate a new signal request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>placementTimeout</code>: Amazon GameLift Streams could not find available stream capacity to
         *        start a stream session. Increase the stream capacity in the stream group or wait until capacity
         *        becomes available.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>TERMINATED</code> status reasons:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>apiTerminated</code>: The stream session was terminated by an API call to <a
         *        href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_TerminateStreamSession.html"
         *        >TerminateStreamSession</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>applicationExit</code>: The streaming application exited or crashed. The stream session was
         *        terminated because the application is no longer running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>connectionTimeout</code>: The stream session was terminated because the client failed to connect
         *        within the connection timeout period specified by <code>ConnectionTimeoutSeconds</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>idleTimeout</code>: The stream session was terminated because it exceeded the idle timeout
         *        period of 60 minutes with no user input activity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maxSessionLengthTimeout</code>: The stream session was terminated because it exceeded the
         *        maximum session length timeout period specified by <code>SessionLengthSeconds</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reconnectionTimeout</code>: The stream session was terminated because the client failed to
         *        reconnect within the reconnection timeout period specified by <code>ConnectionTimeoutSeconds</code>
         *        after losing connection.
         *        </p>
         *        </li>
         * @see StreamSessionStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamSessionStatusReason
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * A short description of the reason the stream session is in <code>ERROR</code> status or
         * <code>TERMINATED</code> status.
         * </p>
         * <p>
         * <code>ERROR</code> status reasons:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>applicationLogS3DestinationError</code>: Could not write the application log to the Amazon S3 bucket
         * that is configured for the streaming application. Make sure the bucket still exists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>internalError</code>: An internal service error occurred. Start a new stream session to continue
         * streaming.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>invalidSignalRequest</code>: The WebRTC signal request that was sent is not valid. When starting or
         * reconnecting to a stream session, use <code>generateSignalRequest</code> in the Amazon GameLift Streams Web
         * SDK to generate a new signal request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placementTimeout</code>: Amazon GameLift Streams could not find available stream capacity to start a
         * stream session. Increase the stream capacity in the stream group or wait until capacity becomes available.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>TERMINATED</code> status reasons:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>apiTerminated</code>: The stream session was terminated by an API call to <a
         * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_TerminateStreamSession.html"
         * >TerminateStreamSession</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>applicationExit</code>: The streaming application exited or crashed. The stream session was terminated
         * because the application is no longer running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>connectionTimeout</code>: The stream session was terminated because the client failed to connect within
         * the connection timeout period specified by <code>ConnectionTimeoutSeconds</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>idleTimeout</code>: The stream session was terminated because it exceeded the idle timeout period of 60
         * minutes with no user input activity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maxSessionLengthTimeout</code>: The stream session was terminated because it exceeded the maximum
         * session length timeout period specified by <code>SessionLengthSeconds</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reconnectionTimeout</code>: The stream session was terminated because the client failed to reconnect
         * within the reconnection timeout period specified by <code>ConnectionTimeoutSeconds</code> after losing
         * connection.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusReason
         *        A short description of the reason the stream session is in <code>ERROR</code> status or
         *        <code>TERMINATED</code> status.</p>
         *        <p>
         *        <code>ERROR</code> status reasons:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>applicationLogS3DestinationError</code>: Could not write the application log to the Amazon S3
         *        bucket that is configured for the streaming application. Make sure the bucket still exists.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>internalError</code>: An internal service error occurred. Start a new stream session to continue
         *        streaming.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>invalidSignalRequest</code>: The WebRTC signal request that was sent is not valid. When starting
         *        or reconnecting to a stream session, use <code>generateSignalRequest</code> in the Amazon GameLift
         *        Streams Web SDK to generate a new signal request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>placementTimeout</code>: Amazon GameLift Streams could not find available stream capacity to
         *        start a stream session. Increase the stream capacity in the stream group or wait until capacity
         *        becomes available.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>TERMINATED</code> status reasons:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>apiTerminated</code>: The stream session was terminated by an API call to <a
         *        href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_TerminateStreamSession.html"
         *        >TerminateStreamSession</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>applicationExit</code>: The streaming application exited or crashed. The stream session was
         *        terminated because the application is no longer running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>connectionTimeout</code>: The stream session was terminated because the client failed to connect
         *        within the connection timeout period specified by <code>ConnectionTimeoutSeconds</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>idleTimeout</code>: The stream session was terminated because it exceeded the idle timeout
         *        period of 60 minutes with no user input activity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maxSessionLengthTimeout</code>: The stream session was terminated because it exceeded the
         *        maximum session length timeout period specified by <code>SessionLengthSeconds</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reconnectionTimeout</code>: The stream session was terminated because the client failed to
         *        reconnect within the reconnection timeout period specified by <code>ConnectionTimeoutSeconds</code>
         *        after losing connection.
         *        </p>
         *        </li>
         * @see StreamSessionStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamSessionStatusReason
         */
        Builder statusReason(StreamSessionStatusReason statusReason);

        /**
         * <p>
         * The data transfer protocol in use with the stream session.
         * </p>
         * 
         * @param protocol
         *        The data transfer protocol in use with the stream session.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The data transfer protocol in use with the stream session.
         * </p>
         * 
         * @param protocol
         *        The data transfer protocol in use with the stream session.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * <p>
         * The location where Amazon GameLift Streams hosts and streams your application. For example,
         * <code>us-east-1</code>. For a complete list of locations that Amazon GameLift Streams supports, refer to <a
         * href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions, quotas,
         * and limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
         * </p>
         * 
         * @param location
         *        The location where Amazon GameLift Streams hosts and streams your application. For example,
         *        <code>us-east-1</code>. For a complete list of locations that Amazon GameLift Streams supports, refer
         *        to <a
         *        href="https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html">Regions,
         *        quotas, and limitations</a> in the <i>Amazon GameLift Streams Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The WebRTC ICE offer string that a client generates to initiate a connection to the stream session.
         * </p>
         * 
         * @param signalRequest
         *        The WebRTC ICE offer string that a client generates to initiate a connection to the stream session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalRequest(String signalRequest);

        /**
         * <p>
         * The WebRTC answer string that the stream server generates in response to the <code>SignalRequest</code>.
         * </p>
         * 
         * @param signalResponse
         *        The WebRTC answer string that the stream server generates in response to the
         *        <code>SignalRequest</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalResponse(String signalResponse);

        /**
         * <p>
         * The length of time that Amazon GameLift Streams should wait for a client to connect or reconnect to the
         * stream session. This time span starts when the stream session reaches <code>ACTIVE</code> or
         * <code>PENDING_CLIENT_RECONNECTION</code> state. If no client connects (or reconnects) before the timeout,
         * Amazon GameLift Streams terminates the stream session.
         * </p>
         * 
         * @param connectionTimeoutSeconds
         *        The length of time that Amazon GameLift Streams should wait for a client to connect or reconnect to
         *        the stream session. This time span starts when the stream session reaches <code>ACTIVE</code> or
         *        <code>PENDING_CLIENT_RECONNECTION</code> state. If no client connects (or reconnects) before the
         *        timeout, Amazon GameLift Streams terminates the stream session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionTimeoutSeconds(Integer connectionTimeoutSeconds);

        /**
         * <p>
         * The maximum duration of a session. Amazon GameLift Streams will automatically terminate a session after this
         * amount of time has elapsed, regardless of any existing client connections.
         * </p>
         * 
         * @param sessionLengthSeconds
         *        The maximum duration of a session. Amazon GameLift Streams will automatically terminate a session
         *        after this amount of time has elapsed, regardless of any existing client connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLengthSeconds(Integer sessionLengthSeconds);

        /**
         * <p>
         * A list of CLI arguments that are sent to the streaming server when a stream session launches. You can use
         * this to configure the application or stream session details. You can also provide custom arguments that
         * Amazon GameLift Streams passes to your game client.
         * </p>
         * <p>
         * <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar purposes.
         * <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
         * <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
         * </p>
         * 
         * @param additionalLaunchArgs
         *        A list of CLI arguments that are sent to the streaming server when a stream session launches. You can
         *        use this to configure the application or stream session details. You can also provide custom arguments
         *        that Amazon GameLift Streams passes to your game client.</p>
         *        <p>
         *        <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar
         *        purposes. <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
         *        <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalLaunchArgs(Collection<String> additionalLaunchArgs);

        /**
         * <p>
         * A list of CLI arguments that are sent to the streaming server when a stream session launches. You can use
         * this to configure the application or stream session details. You can also provide custom arguments that
         * Amazon GameLift Streams passes to your game client.
         * </p>
         * <p>
         * <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar purposes.
         * <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
         * <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
         * </p>
         * 
         * @param additionalLaunchArgs
         *        A list of CLI arguments that are sent to the streaming server when a stream session launches. You can
         *        use this to configure the application or stream session details. You can also provide custom arguments
         *        that Amazon GameLift Streams passes to your game client.</p>
         *        <p>
         *        <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar
         *        purposes. <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
         *        <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalLaunchArgs(String... additionalLaunchArgs);

        /**
         * <p>
         * A set of options that you can use to control the stream session runtime environment, expressed as a set of
         * key-value pairs. You can use this to configure the application or stream session details. You can also
         * provide custom environment variables that Amazon GameLift Streams passes to your game client.
         * </p>
         * <note>
         * <p>
         * If you want to debug your application with environment variables, we recommend that you do so in a local
         * environment outside of Amazon GameLift Streams. For more information, refer to the Compatibility Guidance in
         * the troubleshooting section of the Developer Guide.
         * </p>
         * </note>
         * <p>
         * <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar purposes.
         * <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
         * <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
         * </p>
         * 
         * @param additionalEnvironmentVariables
         *        A set of options that you can use to control the stream session runtime environment, expressed as a
         *        set of key-value pairs. You can use this to configure the application or stream session details. You
         *        can also provide custom environment variables that Amazon GameLift Streams passes to your game
         *        client.</p> <note>
         *        <p>
         *        If you want to debug your application with environment variables, we recommend that you do so in a
         *        local environment outside of Amazon GameLift Streams. For more information, refer to the Compatibility
         *        Guidance in the troubleshooting section of the Developer Guide.
         *        </p>
         *        </note>
         *        <p>
         *        <code>AdditionalEnvironmentVariables</code> and <code>AdditionalLaunchArgs</code> have similar
         *        purposes. <code>AdditionalEnvironmentVariables</code> passes data using environment variables; while
         *        <code>AdditionalLaunchArgs</code> passes data using command-line arguments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalEnvironmentVariables(Map<String, String> additionalEnvironmentVariables);

        /**
         * <p>
         * Access location for log files that your content generates during a stream session. These log files are
         * uploaded to cloud storage location at the end of a stream session. The Amazon GameLift Streams application
         * resource defines which log files to upload.
         * </p>
         * 
         * @param logFileLocationUri
         *        Access location for log files that your content generates during a stream session. These log files are
         *        uploaded to cloud storage location at the end of a stream session. The Amazon GameLift Streams
         *        application resource defines which log files to upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFileLocationUri(String logFileLocationUri);

        /**
         * <p>
         * The URL of an S3 bucket that stores Amazon GameLift Streams WebSDK files. The URL is used to establish
         * connection with the client.
         * </p>
         * 
         * @param webSdkProtocolUrl
         *        The URL of an S3 bucket that stores Amazon GameLift Streams WebSDK files. The URL is used to establish
         *        connection with the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webSdkProtocolUrl(String webSdkProtocolUrl);

        /**
         * <p>
         * A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601
         * format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * </p>
         * 
         * @param lastUpdatedAt
         *        A timestamp that indicates when this resource was last updated. Timestamps are expressed using in
         *        ISO8601 format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601 format,
         * such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * </p>
         * 
         * @param createdAt
         *        A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601
         *        format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The application streaming in this session.
         * </p>
         * <p>
         * This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
         * Resource Name (ARN)</a> that uniquely identifies the application resource. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>.
         * </p>
         * 
         * @param applicationArn
         *        The application streaming in this session.</p>
         *        <p>
         *        This value is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
         *        Resource Name (ARN)</a> that uniquely identifies the application resource. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * Provides details about the stream session's exported files.
         * </p>
         * 
         * @param exportFilesMetadata
         *        Provides details about the stream session's exported files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportFilesMetadata(ExportFilesMetadata exportFilesMetadata);

        /**
         * <p>
         * Provides details about the stream session's exported files.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportFilesMetadata.Builder} avoiding the
         * need to create one manually via {@link ExportFilesMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportFilesMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #exportFilesMetadata(ExportFilesMetadata)}.
         * 
         * @param exportFilesMetadata
         *        a consumer that will call methods on {@link ExportFilesMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportFilesMetadata(ExportFilesMetadata)
         */
        default Builder exportFilesMetadata(Consumer<ExportFilesMetadata.Builder> exportFilesMetadata) {
            return exportFilesMetadata(ExportFilesMetadata.builder().applyMutation(exportFilesMetadata).build());
        }
    }

    static final class BuilderImpl extends GameLiftStreamsResponse.BuilderImpl implements Builder {
        private String arn;

        private String description;

        private String streamGroupId;

        private String userId;

        private String status;

        private String statusReason;

        private String protocol;

        private String location;

        private String signalRequest;

        private String signalResponse;

        private Integer connectionTimeoutSeconds;

        private Integer sessionLengthSeconds;

        private List<String> additionalLaunchArgs = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> additionalEnvironmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private String logFileLocationUri;

        private String webSdkProtocolUrl;

        private Instant lastUpdatedAt;

        private Instant createdAt;

        private String applicationArn;

        private ExportFilesMetadata exportFilesMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(StartStreamSessionResponse model) {
            super(model);
            arn(model.arn);
            description(model.description);
            streamGroupId(model.streamGroupId);
            userId(model.userId);
            status(model.status);
            statusReason(model.statusReason);
            protocol(model.protocol);
            location(model.location);
            signalRequest(model.signalRequest);
            signalResponse(model.signalResponse);
            connectionTimeoutSeconds(model.connectionTimeoutSeconds);
            sessionLengthSeconds(model.sessionLengthSeconds);
            additionalLaunchArgs(model.additionalLaunchArgs);
            additionalEnvironmentVariables(model.additionalEnvironmentVariables);
            logFileLocationUri(model.logFileLocationUri);
            webSdkProtocolUrl(model.webSdkProtocolUrl);
            lastUpdatedAt(model.lastUpdatedAt);
            createdAt(model.createdAt);
            applicationArn(model.applicationArn);
            exportFilesMetadata(model.exportFilesMetadata);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStreamGroupId() {
            return streamGroupId;
        }

        public final void setStreamGroupId(String streamGroupId) {
            this.streamGroupId = streamGroupId;
        }

        @Override
        public final Builder streamGroupId(String streamGroupId) {
            this.streamGroupId = streamGroupId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(StreamSessionStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getSignalRequest() {
            return signalRequest;
        }

        public final void setSignalRequest(String signalRequest) {
            this.signalRequest = signalRequest;
        }

        @Override
        public final Builder signalRequest(String signalRequest) {
            this.signalRequest = signalRequest;
            return this;
        }

        public final String getSignalResponse() {
            return signalResponse;
        }

        public final void setSignalResponse(String signalResponse) {
            this.signalResponse = signalResponse;
        }

        @Override
        public final Builder signalResponse(String signalResponse) {
            this.signalResponse = signalResponse;
            return this;
        }

        public final Integer getConnectionTimeoutSeconds() {
            return connectionTimeoutSeconds;
        }

        public final void setConnectionTimeoutSeconds(Integer connectionTimeoutSeconds) {
            this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        }

        @Override
        public final Builder connectionTimeoutSeconds(Integer connectionTimeoutSeconds) {
            this.connectionTimeoutSeconds = connectionTimeoutSeconds;
            return this;
        }

        public final Integer getSessionLengthSeconds() {
            return sessionLengthSeconds;
        }

        public final void setSessionLengthSeconds(Integer sessionLengthSeconds) {
            this.sessionLengthSeconds = sessionLengthSeconds;
        }

        @Override
        public final Builder sessionLengthSeconds(Integer sessionLengthSeconds) {
            this.sessionLengthSeconds = sessionLengthSeconds;
            return this;
        }

        public final Collection<String> getAdditionalLaunchArgs() {
            if (additionalLaunchArgs instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalLaunchArgs;
        }

        public final void setAdditionalLaunchArgs(Collection<String> additionalLaunchArgs) {
            this.additionalLaunchArgs = GameLaunchArgListCopier.copy(additionalLaunchArgs);
        }

        @Override
        public final Builder additionalLaunchArgs(Collection<String> additionalLaunchArgs) {
            this.additionalLaunchArgs = GameLaunchArgListCopier.copy(additionalLaunchArgs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLaunchArgs(String... additionalLaunchArgs) {
            additionalLaunchArgs(Arrays.asList(additionalLaunchArgs));
            return this;
        }

        public final Map<String, String> getAdditionalEnvironmentVariables() {
            if (additionalEnvironmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalEnvironmentVariables;
        }

        public final void setAdditionalEnvironmentVariables(Map<String, String> additionalEnvironmentVariables) {
            this.additionalEnvironmentVariables = EnvironmentVariablesCopier.copy(additionalEnvironmentVariables);
        }

        @Override
        public final Builder additionalEnvironmentVariables(Map<String, String> additionalEnvironmentVariables) {
            this.additionalEnvironmentVariables = EnvironmentVariablesCopier.copy(additionalEnvironmentVariables);
            return this;
        }

        public final String getLogFileLocationUri() {
            return logFileLocationUri;
        }

        public final void setLogFileLocationUri(String logFileLocationUri) {
            this.logFileLocationUri = logFileLocationUri;
        }

        @Override
        public final Builder logFileLocationUri(String logFileLocationUri) {
            this.logFileLocationUri = logFileLocationUri;
            return this;
        }

        public final String getWebSdkProtocolUrl() {
            return webSdkProtocolUrl;
        }

        public final void setWebSdkProtocolUrl(String webSdkProtocolUrl) {
            this.webSdkProtocolUrl = webSdkProtocolUrl;
        }

        @Override
        public final Builder webSdkProtocolUrl(String webSdkProtocolUrl) {
            this.webSdkProtocolUrl = webSdkProtocolUrl;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final ExportFilesMetadata.Builder getExportFilesMetadata() {
            return exportFilesMetadata != null ? exportFilesMetadata.toBuilder() : null;
        }

        public final void setExportFilesMetadata(ExportFilesMetadata.BuilderImpl exportFilesMetadata) {
            this.exportFilesMetadata = exportFilesMetadata != null ? exportFilesMetadata.build() : null;
        }

        @Override
        public final Builder exportFilesMetadata(ExportFilesMetadata exportFilesMetadata) {
            this.exportFilesMetadata = exportFilesMetadata;
            return this;
        }

        @Override
        public StartStreamSessionResponse build() {
            return new StartStreamSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
