/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum StreamSessionStatusReason {
    INTERNAL_ERROR("internalError"),

    INVALID_SIGNAL_REQUEST("invalidSignalRequest"),

    PLACEMENT_TIMEOUT("placementTimeout"),

    APPLICATION_LOG_S3_DESTINATION_ERROR("applicationLogS3DestinationError"),

    APPLICATION_EXIT("applicationExit"),

    CONNECTION_TIMEOUT("connectionTimeout"),

    RECONNECTION_TIMEOUT("reconnectionTimeout"),

    MAX_SESSION_LENGTH_TIMEOUT("maxSessionLengthTimeout"),

    IDLE_TIMEOUT("idleTimeout"),

    API_TERMINATED("apiTerminated"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StreamSessionStatusReason> VALUE_MAP = EnumUtils.uniqueIndex(
            StreamSessionStatusReason.class, StreamSessionStatusReason::toString);

    private final String value;

    private StreamSessionStatusReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return StreamSessionStatusReason corresponding to the value
     */
    public static StreamSessionStatusReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link StreamSessionStatusReason}s
     */
    public static Set<StreamSessionStatusReason> knownValues() {
        Set<StreamSessionStatusReason> knownValues = EnumSet.allOf(StreamSessionStatusReason.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
