/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gameliftstreams.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationResponse extends GameLiftStreamsResponse implements
        ToCopyableBuilder<UpdateApplicationResponse.Builder, UpdateApplicationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateApplicationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateApplicationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<RuntimeEnvironment> RUNTIME_ENVIRONMENT_FIELD = SdkField
            .<RuntimeEnvironment> builder(MarshallingType.SDK_POJO).memberName("RuntimeEnvironment")
            .getter(getter(UpdateApplicationResponse::runtimeEnvironment)).setter(setter(Builder::runtimeEnvironment))
            .constructor(RuntimeEnvironment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironment").build())
            .build();

    private static final SdkField<String> EXECUTABLE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutablePath").getter(getter(UpdateApplicationResponse::executablePath))
            .setter(setter(Builder::executablePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutablePath").build()).build();

    private static final SdkField<List<String>> APPLICATION_LOG_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ApplicationLogPaths")
            .getter(getter(UpdateApplicationResponse::applicationLogPaths))
            .setter(setter(Builder::applicationLogPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationLogPaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APPLICATION_LOG_OUTPUT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationLogOutputUri").getter(getter(UpdateApplicationResponse::applicationLogOutputUri))
            .setter(setter(Builder::applicationLogOutputUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationLogOutputUri").build())
            .build();

    private static final SdkField<String> APPLICATION_SOURCE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationSourceUri").getter(getter(UpdateApplicationResponse::applicationSourceUri))
            .setter(setter(Builder::applicationSourceUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSourceUri").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateApplicationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateApplicationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(UpdateApplicationResponse::statusReasonAsString))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<List<ReplicationStatus>> REPLICATION_STATUSES_FIELD = SdkField
            .<List<ReplicationStatus>> builder(MarshallingType.LIST)
            .memberName("ReplicationStatuses")
            .getter(getter(UpdateApplicationResponse::replicationStatuses))
            .setter(setter(Builder::replicationStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(UpdateApplicationResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(UpdateApplicationResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<List<String>> ASSOCIATED_STREAM_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssociatedStreamGroups")
            .getter(getter(UpdateApplicationResponse::associatedStreamGroups))
            .setter(setter(Builder::associatedStreamGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedStreamGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD,
            RUNTIME_ENVIRONMENT_FIELD, EXECUTABLE_PATH_FIELD, APPLICATION_LOG_PATHS_FIELD, APPLICATION_LOG_OUTPUT_URI_FIELD,
            APPLICATION_SOURCE_URI_FIELD, ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, REPLICATION_STATUSES_FIELD,
            CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, ASSOCIATED_STREAM_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String description;

    private final RuntimeEnvironment runtimeEnvironment;

    private final String executablePath;

    private final List<String> applicationLogPaths;

    private final String applicationLogOutputUri;

    private final String applicationSourceUri;

    private final String id;

    private final String status;

    private final String statusReason;

    private final List<ReplicationStatus> replicationStatuses;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final List<String> associatedStreamGroups;

    private UpdateApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.description = builder.description;
        this.runtimeEnvironment = builder.runtimeEnvironment;
        this.executablePath = builder.executablePath;
        this.applicationLogPaths = builder.applicationLogPaths;
        this.applicationLogOutputUri = builder.applicationLogOutputUri;
        this.applicationSourceUri = builder.applicationSourceUri;
        this.id = builder.id;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.replicationStatuses = builder.replicationStatuses;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.associatedStreamGroups = builder.associatedStreamGroups;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name (ARN)</a>
     * that's assigned to an application resource and uniquely identifies it across all Amazon Web Services Regions.
     * Format is <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:application/[resource ID]</code>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
     *         (ARN)</a> that's assigned to an application resource and uniquely identifies it across all Amazon Web
     *         Services Regions. Format is
     *         <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:application/[resource ID]</code>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A human-readable label for the application. You can edit this value.
     * </p>
     * 
     * @return A human-readable label for the application. You can edit this value.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Configuration settings that identify the operating system for an application resource. This can also include a
     * compatibility layer and other drivers.
     * </p>
     * <p>
     * A runtime environment can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Linux applications
     * </p>
     * <ul>
     * <li>
     * <p>
     * Ubuntu 22.04 LTS (<code>Type=UBUNTU, Version=22_04_LTS</code>)
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For Windows applications
     * </p>
     * <ul>
     * <li>
     * <p>
     * Microsoft Windows Server 2022 Base (<code>Type=WINDOWS, Version=2022</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Proton 9.0-2 (<code>Type=PROTON, Version=20250516</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Proton 8.0-5 (<code>Type=PROTON, Version=20241007</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Proton 8.0-2c (<code>Type=PROTON, Version=20230704</code>)
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return Configuration settings that identify the operating system for an application resource. This can also
     *         include a compatibility layer and other drivers. </p>
     *         <p>
     *         A runtime environment can be one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For Linux applications
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Ubuntu 22.04 LTS (<code>Type=UBUNTU, Version=22_04_LTS</code>)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For Windows applications
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Microsoft Windows Server 2022 Base (<code>Type=WINDOWS, Version=2022</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Proton 9.0-2 (<code>Type=PROTON, Version=20250516</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Proton 8.0-5 (<code>Type=PROTON, Version=20241007</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Proton 8.0-2c (<code>Type=PROTON, Version=20230704</code>)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final RuntimeEnvironment runtimeEnvironment() {
        return runtimeEnvironment;
    }

    /**
     * <p>
     * The relative path and file name of the executable file that launches the content for streaming.
     * </p>
     * 
     * @return The relative path and file name of the executable file that launches the content for streaming.
     */
    public final String executablePath() {
        return executablePath;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationLogPaths property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicationLogPaths() {
        return applicationLogPaths != null && !(applicationLogPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Locations of log files that your content generates during a stream session. Amazon GameLift Streams uploads log
     * files to the Amazon S3 bucket that you specify in <code>ApplicationLogOutputUri</code> at the end of a stream
     * session. To retrieve stored log files, call <a
     * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html"
     * >GetStreamSession</a> and get the <code>LogFileLocationUri</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationLogPaths} method.
     * </p>
     * 
     * @return Locations of log files that your content generates during a stream session. Amazon GameLift Streams
     *         uploads log files to the Amazon S3 bucket that you specify in <code>ApplicationLogOutputUri</code> at the
     *         end of a stream session. To retrieve stored log files, call <a
     *         href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html"
     *         >GetStreamSession</a> and get the <code>LogFileLocationUri</code>.
     */
    public final List<String> applicationLogPaths() {
        return applicationLogPaths;
    }

    /**
     * <p>
     * An Amazon S3 URI to a bucket where you would like Amazon GameLift Streams to save application logs. Required if
     * you specify one or more <code>ApplicationLogPaths</code>.
     * </p>
     * 
     * @return An Amazon S3 URI to a bucket where you would like Amazon GameLift Streams to save application logs.
     *         Required if you specify one or more <code>ApplicationLogPaths</code>.
     */
    public final String applicationLogOutputUri() {
        return applicationLogOutputUri;
    }

    /**
     * <p>
     * The original Amazon S3 location of uploaded stream content for the application.
     * </p>
     * 
     * @return The original Amazon S3 location of uploaded stream content for the application.
     */
    public final String applicationSourceUri() {
        return applicationSourceUri;
    }

    /**
     * <p>
     * A unique ID value that is assigned to the resource when it's created. Format example: <code>a-9ZY8X7Wv6</code>.
     * </p>
     * 
     * @return A unique ID value that is assigned to the resource when it's created. Format example:
     *         <code>a-9ZY8X7Wv6</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The current status of the application resource. Possible statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work flow to
     * create an application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is copying the
     * content and caching for future deployment in a stream group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code>: The application is ready to deploy in a stream group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: An error occurred when setting up the application. See <code>StatusReason</code> for more
     * information.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the application resource. Possible statuses include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work
     *         flow to create an application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is
     *         copying the content and caching for future deployment in a stream group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code>: The application is ready to deploy in a stream group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: An error occurred when setting up the application. See <code>StatusReason</code> for
     *         more information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
     *         </p>
     *         </li>
     * @see ApplicationStatus
     */
    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the application resource. Possible statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work flow to
     * create an application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is copying the
     * content and caching for future deployment in a stream group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code>: The application is ready to deploy in a stream group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>: An error occurred when setting up the application. See <code>StatusReason</code> for more
     * information.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the application resource. Possible statuses include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work
     *         flow to create an application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is
     *         copying the content and caching for future deployment in a stream group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code>: The application is ready to deploy in a stream group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>: An error occurred when setting up the application. See <code>StatusReason</code> for
     *         more information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
     *         </p>
     *         </li>
     * @see ApplicationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A short description of the status reason when the application is in <code>ERROR</code> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link ApplicationStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return A short description of the status reason when the application is in <code>ERROR</code> status.
     * @see ApplicationStatusReason
     */
    public final ApplicationStatusReason statusReason() {
        return ApplicationStatusReason.fromValue(statusReason);
    }

    /**
     * <p>
     * A short description of the status reason when the application is in <code>ERROR</code> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link ApplicationStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return A short description of the status reason when the application is in <code>ERROR</code> status.
     * @see ApplicationStatusReason
     */
    public final String statusReasonAsString() {
        return statusReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationStatuses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationStatuses() {
        return replicationStatuses != null && !(replicationStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of replication statuses for each location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationStatuses} method.
     * </p>
     * 
     * @return A set of replication statuses for each location.
     */
    public final List<ReplicationStatus> replicationStatuses() {
        return replicationStatuses;
    }

    /**
     * <p>
     * A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601 format, such
     * as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     * </p>
     * 
     * @return A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601
     *         format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601 format,
     * such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     * </p>
     * 
     * @return A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601
     *         format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedStreamGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssociatedStreamGroups() {
        return associatedStreamGroups != null && !(associatedStreamGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of stream groups that this application is associated with. You can use any of these stream groups to stream
     * your application.
     * </p>
     * <p>
     * This value is a set of <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
     * Resource Names (ARNs)</a> that uniquely identify stream group resources. Example ARN:
     * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedStreamGroups} method.
     * </p>
     * 
     * @return A set of stream groups that this application is associated with. You can use any of these stream groups
     *         to stream your application. </p>
     *         <p>
     *         This value is a set of <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names
     *         (ARNs)</a> that uniquely identify stream group resources. Example ARN:
     *         <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>.
     */
    public final List<String> associatedStreamGroups() {
        return associatedStreamGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeEnvironment());
        hashCode = 31 * hashCode + Objects.hashCode(executablePath());
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationLogPaths() ? applicationLogPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationLogOutputUri());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationStatuses() ? replicationStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedStreamGroups() ? associatedStreamGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationResponse)) {
            return false;
        }
        UpdateApplicationResponse other = (UpdateApplicationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description())
                && Objects.equals(runtimeEnvironment(), other.runtimeEnvironment())
                && Objects.equals(executablePath(), other.executablePath())
                && hasApplicationLogPaths() == other.hasApplicationLogPaths()
                && Objects.equals(applicationLogPaths(), other.applicationLogPaths())
                && Objects.equals(applicationLogOutputUri(), other.applicationLogOutputUri())
                && Objects.equals(applicationSourceUri(), other.applicationSourceUri()) && Objects.equals(id(), other.id())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReasonAsString(), other.statusReasonAsString())
                && hasReplicationStatuses() == other.hasReplicationStatuses()
                && Objects.equals(replicationStatuses(), other.replicationStatuses())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && hasAssociatedStreamGroups() == other.hasAssociatedStreamGroups()
                && Objects.equals(associatedStreamGroups(), other.associatedStreamGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationResponse").add("Arn", arn()).add("Description", description())
                .add("RuntimeEnvironment", runtimeEnvironment()).add("ExecutablePath", executablePath())
                .add("ApplicationLogPaths", hasApplicationLogPaths() ? applicationLogPaths() : null)
                .add("ApplicationLogOutputUri", applicationLogOutputUri()).add("ApplicationSourceUri", applicationSourceUri())
                .add("Id", id()).add("Status", statusAsString()).add("StatusReason", statusReasonAsString())
                .add("ReplicationStatuses", hasReplicationStatuses() ? replicationStatuses() : null)
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("AssociatedStreamGroups", hasAssociatedStreamGroups() ? associatedStreamGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RuntimeEnvironment":
            return Optional.ofNullable(clazz.cast(runtimeEnvironment()));
        case "ExecutablePath":
            return Optional.ofNullable(clazz.cast(executablePath()));
        case "ApplicationLogPaths":
            return Optional.ofNullable(clazz.cast(applicationLogPaths()));
        case "ApplicationLogOutputUri":
            return Optional.ofNullable(clazz.cast(applicationLogOutputUri()));
        case "ApplicationSourceUri":
            return Optional.ofNullable(clazz.cast(applicationSourceUri()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReasonAsString()));
        case "ReplicationStatuses":
            return Optional.ofNullable(clazz.cast(replicationStatuses()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "AssociatedStreamGroups":
            return Optional.ofNullable(clazz.cast(associatedStreamGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RuntimeEnvironment", RUNTIME_ENVIRONMENT_FIELD);
        map.put("ExecutablePath", EXECUTABLE_PATH_FIELD);
        map.put("ApplicationLogPaths", APPLICATION_LOG_PATHS_FIELD);
        map.put("ApplicationLogOutputUri", APPLICATION_LOG_OUTPUT_URI_FIELD);
        map.put("ApplicationSourceUri", APPLICATION_SOURCE_URI_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("ReplicationStatuses", REPLICATION_STATUSES_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("AssociatedStreamGroups", ASSOCIATED_STREAM_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationResponse, T> g) {
        return obj -> g.apply((UpdateApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftStreamsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateApplicationResponse> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Name
         * (ARN)</a> that's assigned to an application resource and uniquely identifies it across all Amazon Web
         * Services Regions. Format is
         * <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:application/[resource ID]</code>.
         * </p>
         * 
         * @param arn
         *        The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource
         *        Name (ARN)</a> that's assigned to an application resource and uniquely identifies it across all Amazon
         *        Web Services Regions. Format is
         *        <code>arn:aws:gameliftstreams:[AWS Region]:[AWS account]:application/[resource ID]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A human-readable label for the application. You can edit this value.
         * </p>
         * 
         * @param description
         *        A human-readable label for the application. You can edit this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Configuration settings that identify the operating system for an application resource. This can also include
         * a compatibility layer and other drivers.
         * </p>
         * <p>
         * A runtime environment can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For Linux applications
         * </p>
         * <ul>
         * <li>
         * <p>
         * Ubuntu 22.04 LTS (<code>Type=UBUNTU, Version=22_04_LTS</code>)
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For Windows applications
         * </p>
         * <ul>
         * <li>
         * <p>
         * Microsoft Windows Server 2022 Base (<code>Type=WINDOWS, Version=2022</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Proton 9.0-2 (<code>Type=PROTON, Version=20250516</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Proton 8.0-5 (<code>Type=PROTON, Version=20241007</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Proton 8.0-2c (<code>Type=PROTON, Version=20230704</code>)
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param runtimeEnvironment
         *        Configuration settings that identify the operating system for an application resource. This can also
         *        include a compatibility layer and other drivers. </p>
         *        <p>
         *        A runtime environment can be one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For Linux applications
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Ubuntu 22.04 LTS (<code>Type=UBUNTU, Version=22_04_LTS</code>)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For Windows applications
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Microsoft Windows Server 2022 Base (<code>Type=WINDOWS, Version=2022</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Proton 9.0-2 (<code>Type=PROTON, Version=20250516</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Proton 8.0-5 (<code>Type=PROTON, Version=20241007</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Proton 8.0-2c (<code>Type=PROTON, Version=20230704</code>)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment);

        /**
         * <p>
         * Configuration settings that identify the operating system for an application resource. This can also include
         * a compatibility layer and other drivers.
         * </p>
         * <p>
         * A runtime environment can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For Linux applications
         * </p>
         * <ul>
         * <li>
         * <p>
         * Ubuntu 22.04 LTS (<code>Type=UBUNTU, Version=22_04_LTS</code>)
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For Windows applications
         * </p>
         * <ul>
         * <li>
         * <p>
         * Microsoft Windows Server 2022 Base (<code>Type=WINDOWS, Version=2022</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Proton 9.0-2 (<code>Type=PROTON, Version=20250516</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Proton 8.0-5 (<code>Type=PROTON, Version=20241007</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * Proton 8.0-2c (<code>Type=PROTON, Version=20230704</code>)
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link RuntimeEnvironment.Builder} avoiding the
         * need to create one manually via {@link RuntimeEnvironment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuntimeEnvironment.Builder#build()} is called immediately and its
         * result is passed to {@link #runtimeEnvironment(RuntimeEnvironment)}.
         * 
         * @param runtimeEnvironment
         *        a consumer that will call methods on {@link RuntimeEnvironment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeEnvironment(RuntimeEnvironment)
         */
        default Builder runtimeEnvironment(Consumer<RuntimeEnvironment.Builder> runtimeEnvironment) {
            return runtimeEnvironment(RuntimeEnvironment.builder().applyMutation(runtimeEnvironment).build());
        }

        /**
         * <p>
         * The relative path and file name of the executable file that launches the content for streaming.
         * </p>
         * 
         * @param executablePath
         *        The relative path and file name of the executable file that launches the content for streaming.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executablePath(String executablePath);

        /**
         * <p>
         * Locations of log files that your content generates during a stream session. Amazon GameLift Streams uploads
         * log files to the Amazon S3 bucket that you specify in <code>ApplicationLogOutputUri</code> at the end of a
         * stream session. To retrieve stored log files, call <a
         * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html"
         * >GetStreamSession</a> and get the <code>LogFileLocationUri</code>.
         * </p>
         * 
         * @param applicationLogPaths
         *        Locations of log files that your content generates during a stream session. Amazon GameLift Streams
         *        uploads log files to the Amazon S3 bucket that you specify in <code>ApplicationLogOutputUri</code> at
         *        the end of a stream session. To retrieve stored log files, call <a
         *        href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html"
         *        >GetStreamSession</a> and get the <code>LogFileLocationUri</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationLogPaths(Collection<String> applicationLogPaths);

        /**
         * <p>
         * Locations of log files that your content generates during a stream session. Amazon GameLift Streams uploads
         * log files to the Amazon S3 bucket that you specify in <code>ApplicationLogOutputUri</code> at the end of a
         * stream session. To retrieve stored log files, call <a
         * href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html"
         * >GetStreamSession</a> and get the <code>LogFileLocationUri</code>.
         * </p>
         * 
         * @param applicationLogPaths
         *        Locations of log files that your content generates during a stream session. Amazon GameLift Streams
         *        uploads log files to the Amazon S3 bucket that you specify in <code>ApplicationLogOutputUri</code> at
         *        the end of a stream session. To retrieve stored log files, call <a
         *        href="https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html"
         *        >GetStreamSession</a> and get the <code>LogFileLocationUri</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationLogPaths(String... applicationLogPaths);

        /**
         * <p>
         * An Amazon S3 URI to a bucket where you would like Amazon GameLift Streams to save application logs. Required
         * if you specify one or more <code>ApplicationLogPaths</code>.
         * </p>
         * 
         * @param applicationLogOutputUri
         *        An Amazon S3 URI to a bucket where you would like Amazon GameLift Streams to save application logs.
         *        Required if you specify one or more <code>ApplicationLogPaths</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationLogOutputUri(String applicationLogOutputUri);

        /**
         * <p>
         * The original Amazon S3 location of uploaded stream content for the application.
         * </p>
         * 
         * @param applicationSourceUri
         *        The original Amazon S3 location of uploaded stream content for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSourceUri(String applicationSourceUri);

        /**
         * <p>
         * A unique ID value that is assigned to the resource when it's created. Format example:
         * <code>a-9ZY8X7Wv6</code>.
         * </p>
         * 
         * @param id
         *        A unique ID value that is assigned to the resource when it's created. Format example:
         *        <code>a-9ZY8X7Wv6</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The current status of the application resource. Possible statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work flow to
         * create an application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is copying
         * the content and caching for future deployment in a stream group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code>: The application is ready to deploy in a stream group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: An error occurred when setting up the application. See <code>StatusReason</code> for more
         * information.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the application resource. Possible statuses include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work
         *        flow to create an application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is
         *        copying the content and caching for future deployment in a stream group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code>: The application is ready to deploy in a stream group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: An error occurred when setting up the application. See <code>StatusReason</code>
         *        for more information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
         *        </p>
         *        </li>
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the application resource. Possible statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work flow to
         * create an application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is copying
         * the content and caching for future deployment in a stream group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code>: The application is ready to deploy in a stream group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>: An error occurred when setting up the application. See <code>StatusReason</code> for more
         * information.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the application resource. Possible statuses include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INITIALIZED</code>: Amazon GameLift Streams has received the request and is initiating the work
         *        flow to create an application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROCESSING</code>: The create application work flow is in process. Amazon GameLift Streams is
         *        copying the content and caching for future deployment in a stream group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code>: The application is ready to deploy in a stream group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>: An error occurred when setting up the application. See <code>StatusReason</code>
         *        for more information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: Amazon GameLift Streams is in the process of deleting the application.
         *        </p>
         *        </li>
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(ApplicationStatus status);

        /**
         * <p>
         * A short description of the status reason when the application is in <code>ERROR</code> status.
         * </p>
         * 
         * @param statusReason
         *        A short description of the status reason when the application is in <code>ERROR</code> status.
         * @see ApplicationStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatusReason
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * A short description of the status reason when the application is in <code>ERROR</code> status.
         * </p>
         * 
         * @param statusReason
         *        A short description of the status reason when the application is in <code>ERROR</code> status.
         * @see ApplicationStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatusReason
         */
        Builder statusReason(ApplicationStatusReason statusReason);

        /**
         * <p>
         * A set of replication statuses for each location.
         * </p>
         * 
         * @param replicationStatuses
         *        A set of replication statuses for each location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStatuses(Collection<ReplicationStatus> replicationStatuses);

        /**
         * <p>
         * A set of replication statuses for each location.
         * </p>
         * 
         * @param replicationStatuses
         *        A set of replication statuses for each location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStatuses(ReplicationStatus... replicationStatuses);

        /**
         * <p>
         * A set of replication statuses for each location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gameliftstreams.model.ReplicationStatus.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.gameliftstreams.model.ReplicationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gameliftstreams.model.ReplicationStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #replicationStatuses(List<ReplicationStatus>)}.
         * 
         * @param replicationStatuses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gameliftstreams.model.ReplicationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationStatuses(java.util.Collection<ReplicationStatus>)
         */
        Builder replicationStatuses(Consumer<ReplicationStatus.Builder>... replicationStatuses);

        /**
         * <p>
         * A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601 format,
         * such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * </p>
         * 
         * @param createdAt
         *        A timestamp that indicates when this resource was created. Timestamps are expressed using in ISO8601
         *        format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A timestamp that indicates when this resource was last updated. Timestamps are expressed using in ISO8601
         * format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * </p>
         * 
         * @param lastUpdatedAt
         *        A timestamp that indicates when this resource was last updated. Timestamps are expressed using in
         *        ISO8601 format, such as: <code>2022-12-27T22:29:40+00:00</code> (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * A set of stream groups that this application is associated with. You can use any of these stream groups to
         * stream your application.
         * </p>
         * <p>
         * This value is a set of <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
         * Resource Names (ARNs)</a> that uniquely identify stream group resources. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>.
         * </p>
         * 
         * @param associatedStreamGroups
         *        A set of stream groups that this application is associated with. You can use any of these stream
         *        groups to stream your application. </p>
         *        <p>
         *        This value is a set of <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names
         *        (ARNs)</a> that uniquely identify stream group resources. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedStreamGroups(Collection<String> associatedStreamGroups);

        /**
         * <p>
         * A set of stream groups that this application is associated with. You can use any of these stream groups to
         * stream your application.
         * </p>
         * <p>
         * This value is a set of <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon
         * Resource Names (ARNs)</a> that uniquely identify stream group resources. Example ARN:
         * <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>.
         * </p>
         * 
         * @param associatedStreamGroups
         *        A set of stream groups that this application is associated with. You can use any of these stream
         *        groups to stream your application. </p>
         *        <p>
         *        This value is a set of <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names
         *        (ARNs)</a> that uniquely identify stream group resources. Example ARN:
         *        <code>arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedStreamGroups(String... associatedStreamGroups);
    }

    static final class BuilderImpl extends GameLiftStreamsResponse.BuilderImpl implements Builder {
        private String arn;

        private String description;

        private RuntimeEnvironment runtimeEnvironment;

        private String executablePath;

        private List<String> applicationLogPaths = DefaultSdkAutoConstructList.getInstance();

        private String applicationLogOutputUri;

        private String applicationSourceUri;

        private String id;

        private String status;

        private String statusReason;

        private List<ReplicationStatus> replicationStatuses = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private List<String> associatedStreamGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationResponse model) {
            super(model);
            arn(model.arn);
            description(model.description);
            runtimeEnvironment(model.runtimeEnvironment);
            executablePath(model.executablePath);
            applicationLogPaths(model.applicationLogPaths);
            applicationLogOutputUri(model.applicationLogOutputUri);
            applicationSourceUri(model.applicationSourceUri);
            id(model.id);
            status(model.status);
            statusReason(model.statusReason);
            replicationStatuses(model.replicationStatuses);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            associatedStreamGroups(model.associatedStreamGroups);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RuntimeEnvironment.Builder getRuntimeEnvironment() {
            return runtimeEnvironment != null ? runtimeEnvironment.toBuilder() : null;
        }

        public final void setRuntimeEnvironment(RuntimeEnvironment.BuilderImpl runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment != null ? runtimeEnvironment.build() : null;
        }

        @Override
        public final Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        public final String getExecutablePath() {
            return executablePath;
        }

        public final void setExecutablePath(String executablePath) {
            this.executablePath = executablePath;
        }

        @Override
        public final Builder executablePath(String executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        public final Collection<String> getApplicationLogPaths() {
            if (applicationLogPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return applicationLogPaths;
        }

        public final void setApplicationLogPaths(Collection<String> applicationLogPaths) {
            this.applicationLogPaths = FilePathsCopier.copy(applicationLogPaths);
        }

        @Override
        public final Builder applicationLogPaths(Collection<String> applicationLogPaths) {
            this.applicationLogPaths = FilePathsCopier.copy(applicationLogPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationLogPaths(String... applicationLogPaths) {
            applicationLogPaths(Arrays.asList(applicationLogPaths));
            return this;
        }

        public final String getApplicationLogOutputUri() {
            return applicationLogOutputUri;
        }

        public final void setApplicationLogOutputUri(String applicationLogOutputUri) {
            this.applicationLogOutputUri = applicationLogOutputUri;
        }

        @Override
        public final Builder applicationLogOutputUri(String applicationLogOutputUri) {
            this.applicationLogOutputUri = applicationLogOutputUri;
            return this;
        }

        public final String getApplicationSourceUri() {
            return applicationSourceUri;
        }

        public final void setApplicationSourceUri(String applicationSourceUri) {
            this.applicationSourceUri = applicationSourceUri;
        }

        @Override
        public final Builder applicationSourceUri(String applicationSourceUri) {
            this.applicationSourceUri = applicationSourceUri;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(ApplicationStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final List<ReplicationStatus.Builder> getReplicationStatuses() {
            List<ReplicationStatus.Builder> result = ReplicationStatusesCopier.copyToBuilder(this.replicationStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationStatuses(Collection<ReplicationStatus.BuilderImpl> replicationStatuses) {
            this.replicationStatuses = ReplicationStatusesCopier.copyFromBuilder(replicationStatuses);
        }

        @Override
        public final Builder replicationStatuses(Collection<ReplicationStatus> replicationStatuses) {
            this.replicationStatuses = ReplicationStatusesCopier.copy(replicationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatuses(ReplicationStatus... replicationStatuses) {
            replicationStatuses(Arrays.asList(replicationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatuses(Consumer<ReplicationStatus.Builder>... replicationStatuses) {
            replicationStatuses(Stream.of(replicationStatuses).map(c -> ReplicationStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Collection<String> getAssociatedStreamGroups() {
            if (associatedStreamGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedStreamGroups;
        }

        public final void setAssociatedStreamGroups(Collection<String> associatedStreamGroups) {
            this.associatedStreamGroups = ArnListCopier.copy(associatedStreamGroups);
        }

        @Override
        public final Builder associatedStreamGroups(Collection<String> associatedStreamGroups) {
            this.associatedStreamGroups = ArnListCopier.copy(associatedStreamGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedStreamGroups(String... associatedStreamGroups) {
            associatedStreamGroups(Arrays.asList(associatedStreamGroups));
            return this;
        }

        @Override
        public UpdateApplicationResponse build() {
            return new UpdateApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
