/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExtensionVersionResponse extends GameSparksResponse implements
        ToCopyableBuilder<GetExtensionVersionResponse.Builder, GetExtensionVersionResponse> {
    private static final SdkField<ExtensionVersionDetails> EXTENSION_VERSION_FIELD = SdkField
            .<ExtensionVersionDetails> builder(MarshallingType.SDK_POJO).memberName("ExtensionVersion")
            .getter(getter(GetExtensionVersionResponse::extensionVersion)).setter(setter(Builder::extensionVersion))
            .constructor(ExtensionVersionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENSION_VERSION_FIELD));

    private final ExtensionVersionDetails extensionVersion;

    private GetExtensionVersionResponse(BuilderImpl builder) {
        super(builder);
        this.extensionVersion = builder.extensionVersion;
    }

    /**
     * <p>
     * The version of the extension.
     * </p>
     * 
     * @return The version of the extension.
     */
    public final ExtensionVersionDetails extensionVersion() {
        return extensionVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(extensionVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExtensionVersionResponse)) {
            return false;
        }
        GetExtensionVersionResponse other = (GetExtensionVersionResponse) obj;
        return Objects.equals(extensionVersion(), other.extensionVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExtensionVersionResponse").add("ExtensionVersion", extensionVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExtensionVersion":
            return Optional.ofNullable(clazz.cast(extensionVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExtensionVersionResponse, T> g) {
        return obj -> g.apply((GetExtensionVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetExtensionVersionResponse> {
        /**
         * <p>
         * The version of the extension.
         * </p>
         * 
         * @param extensionVersion
         *        The version of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionVersion(ExtensionVersionDetails extensionVersion);

        /**
         * <p>
         * The version of the extension.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExtensionVersionDetails.Builder} avoiding
         * the need to create one manually via {@link ExtensionVersionDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExtensionVersionDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #extensionVersion(ExtensionVersionDetails)}.
         * 
         * @param extensionVersion
         *        a consumer that will call methods on {@link ExtensionVersionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extensionVersion(ExtensionVersionDetails)
         */
        default Builder extensionVersion(Consumer<ExtensionVersionDetails.Builder> extensionVersion) {
            return extensionVersion(ExtensionVersionDetails.builder().applyMutation(extensionVersion).build());
        }
    }

    static final class BuilderImpl extends GameSparksResponse.BuilderImpl implements Builder {
        private ExtensionVersionDetails extensionVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExtensionVersionResponse model) {
            super(model);
            extensionVersion(model.extensionVersion);
        }

        public final ExtensionVersionDetails.Builder getExtensionVersion() {
            return extensionVersion != null ? extensionVersion.toBuilder() : null;
        }

        public final void setExtensionVersion(ExtensionVersionDetails.BuilderImpl extensionVersion) {
            this.extensionVersion = extensionVersion != null ? extensionVersion.build() : null;
        }

        @Override
        public final Builder extensionVersion(ExtensionVersionDetails extensionVersion) {
            this.extensionVersion = extensionVersion;
            return this;
        }

        @Override
        public GetExtensionVersionResponse build() {
            return new GetExtensionVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
