/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGameResponse extends GameSparksResponse implements
        ToCopyableBuilder<GetGameResponse.Builder, GetGameResponse> {
    private static final SdkField<GameDetails> GAME_FIELD = SdkField.<GameDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Game").getter(getter(GetGameResponse::game)).setter(setter(Builder::game))
            .constructor(GameDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Game").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_FIELD));

    private final GameDetails game;

    private GetGameResponse(BuilderImpl builder) {
        super(builder);
        this.game = builder.game;
    }

    /**
     * <p>
     * The details of the game.
     * </p>
     * 
     * @return The details of the game.
     */
    public final GameDetails game() {
        return game;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(game());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGameResponse)) {
            return false;
        }
        GetGameResponse other = (GetGameResponse) obj;
        return Objects.equals(game(), other.game());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGameResponse").add("Game", game()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Game":
            return Optional.ofNullable(clazz.cast(game()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGameResponse, T> g) {
        return obj -> g.apply((GetGameResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGameResponse> {
        /**
         * <p>
         * The details of the game.
         * </p>
         * 
         * @param game
         *        The details of the game.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder game(GameDetails game);

        /**
         * <p>
         * The details of the game.
         * </p>
         * This is a convenience method that creates an instance of the {@link GameDetails.Builder} avoiding the need to
         * create one manually via {@link GameDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link GameDetails.Builder#build()} is called immediately and its result
         * is passed to {@link #game(GameDetails)}.
         * 
         * @param game
         *        a consumer that will call methods on {@link GameDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #game(GameDetails)
         */
        default Builder game(Consumer<GameDetails.Builder> game) {
            return game(GameDetails.builder().applyMutation(game).build());
        }
    }

    static final class BuilderImpl extends GameSparksResponse.BuilderImpl implements Builder {
        private GameDetails game;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGameResponse model) {
            super(model);
            game(model.game);
        }

        public final GameDetails.Builder getGame() {
            return game != null ? game.toBuilder() : null;
        }

        public final void setGame(GameDetails.BuilderImpl game) {
            this.game = game != null ? game.build() : null;
        }

        @Override
        public final Builder game(GameDetails game) {
            this.game = game;
            return this;
        }

        @Override
        public GetGameResponse build() {
            return new GetGameResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
