/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGeneratedCodeJobResponse extends GameSparksResponse implements
        ToCopyableBuilder<GetGeneratedCodeJobResponse.Builder, GetGeneratedCodeJobResponse> {
    private static final SdkField<GeneratedCodeJobDetails> GENERATED_CODE_JOB_FIELD = SdkField
            .<GeneratedCodeJobDetails> builder(MarshallingType.SDK_POJO).memberName("GeneratedCodeJob")
            .getter(getter(GetGeneratedCodeJobResponse::generatedCodeJob)).setter(setter(Builder::generatedCodeJob))
            .constructor(GeneratedCodeJobDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedCodeJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_CODE_JOB_FIELD));

    private final GeneratedCodeJobDetails generatedCodeJob;

    private GetGeneratedCodeJobResponse(BuilderImpl builder) {
        super(builder);
        this.generatedCodeJob = builder.generatedCodeJob;
    }

    /**
     * <p>
     * Details about the generated code job.
     * </p>
     * 
     * @return Details about the generated code job.
     */
    public final GeneratedCodeJobDetails generatedCodeJob() {
        return generatedCodeJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(generatedCodeJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGeneratedCodeJobResponse)) {
            return false;
        }
        GetGeneratedCodeJobResponse other = (GetGeneratedCodeJobResponse) obj;
        return Objects.equals(generatedCodeJob(), other.generatedCodeJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGeneratedCodeJobResponse").add("GeneratedCodeJob", generatedCodeJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeneratedCodeJob":
            return Optional.ofNullable(clazz.cast(generatedCodeJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGeneratedCodeJobResponse, T> g) {
        return obj -> g.apply((GetGeneratedCodeJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGeneratedCodeJobResponse> {
        /**
         * <p>
         * Details about the generated code job.
         * </p>
         * 
         * @param generatedCodeJob
         *        Details about the generated code job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedCodeJob(GeneratedCodeJobDetails generatedCodeJob);

        /**
         * <p>
         * Details about the generated code job.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeneratedCodeJobDetails.Builder} avoiding
         * the need to create one manually via {@link GeneratedCodeJobDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link GeneratedCodeJobDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #generatedCodeJob(GeneratedCodeJobDetails)}.
         * 
         * @param generatedCodeJob
         *        a consumer that will call methods on {@link GeneratedCodeJobDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generatedCodeJob(GeneratedCodeJobDetails)
         */
        default Builder generatedCodeJob(Consumer<GeneratedCodeJobDetails.Builder> generatedCodeJob) {
            return generatedCodeJob(GeneratedCodeJobDetails.builder().applyMutation(generatedCodeJob).build());
        }
    }

    static final class BuilderImpl extends GameSparksResponse.BuilderImpl implements Builder {
        private GeneratedCodeJobDetails generatedCodeJob;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGeneratedCodeJobResponse model) {
            super(model);
            generatedCodeJob(model.generatedCodeJob);
        }

        public final GeneratedCodeJobDetails.Builder getGeneratedCodeJob() {
            return generatedCodeJob != null ? generatedCodeJob.toBuilder() : null;
        }

        public final void setGeneratedCodeJob(GeneratedCodeJobDetails.BuilderImpl generatedCodeJob) {
            this.generatedCodeJob = generatedCodeJob != null ? generatedCodeJob.build() : null;
        }

        @Override
        public final Builder generatedCodeJob(GeneratedCodeJobDetails generatedCodeJob) {
            this.generatedCodeJob = generatedCodeJob;
            return this;
        }

        @Override
        public GetGeneratedCodeJobResponse build() {
            return new GetGeneratedCodeJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
