/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSnapshotsResponse extends GameSparksResponse implements
        ToCopyableBuilder<ListSnapshotsResponse.Builder, ListSnapshotsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSnapshotsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<SnapshotSummary>> SNAPSHOTS_FIELD = SdkField
            .<List<SnapshotSummary>> builder(MarshallingType.LIST)
            .memberName("Snapshots")
            .getter(getter(ListSnapshotsResponse::snapshots))
            .setter(setter(Builder::snapshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snapshots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SnapshotSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SNAPSHOTS_FIELD));

    private final String nextToken;

    private final List<SnapshotSummary> snapshots;

    private ListSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.snapshots = builder.snapshots;
    }

    /**
     * <p>
     * The token that indicates the start of the next sequential page of results.
     * </p>
     * <p>
     * Use this value when making the next call to this operation to continue where the last one finished.
     * </p>
     * 
     * @return The token that indicates the start of the next sequential page of results.</p>
     *         <p>
     *         Use this value when making the next call to this operation to continue where the last one finished.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Snapshots property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSnapshots() {
        return snapshots != null && !(snapshots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of snapshot summaries. You can use the returned snapshot IDs in the <code>UpdateSnapshot</code> and
     * <code>GetSnapshot</code> operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshots} method.
     * </p>
     * 
     * @return A list of snapshot summaries. You can use the returned snapshot IDs in the <code>UpdateSnapshot</code>
     *         and <code>GetSnapshot</code> operations.
     */
    public final List<SnapshotSummary> snapshots() {
        return snapshots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshots() ? snapshots() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSnapshotsResponse)) {
            return false;
        }
        ListSnapshotsResponse other = (ListSnapshotsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSnapshots() == other.hasSnapshots()
                && Objects.equals(snapshots(), other.snapshots());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSnapshotsResponse").add("NextToken", nextToken())
                .add("Snapshots", hasSnapshots() ? snapshots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Snapshots":
            return Optional.ofNullable(clazz.cast(snapshots()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSnapshotsResponse, T> g) {
        return obj -> g.apply((ListSnapshotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSnapshotsResponse> {
        /**
         * <p>
         * The token that indicates the start of the next sequential page of results.
         * </p>
         * <p>
         * Use this value when making the next call to this operation to continue where the last one finished.
         * </p>
         * 
         * @param nextToken
         *        The token that indicates the start of the next sequential page of results.</p>
         *        <p>
         *        Use this value when making the next call to this operation to continue where the last one finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of snapshot summaries. You can use the returned snapshot IDs in the <code>UpdateSnapshot</code> and
         * <code>GetSnapshot</code> operations.
         * </p>
         * 
         * @param snapshots
         *        A list of snapshot summaries. You can use the returned snapshot IDs in the <code>UpdateSnapshot</code>
         *        and <code>GetSnapshot</code> operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshots(Collection<SnapshotSummary> snapshots);

        /**
         * <p>
         * A list of snapshot summaries. You can use the returned snapshot IDs in the <code>UpdateSnapshot</code> and
         * <code>GetSnapshot</code> operations.
         * </p>
         * 
         * @param snapshots
         *        A list of snapshot summaries. You can use the returned snapshot IDs in the <code>UpdateSnapshot</code>
         *        and <code>GetSnapshot</code> operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshots(SnapshotSummary... snapshots);

        /**
         * <p>
         * A list of snapshot summaries. You can use the returned snapshot IDs in the <code>UpdateSnapshot</code> and
         * <code>GetSnapshot</code> operations.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<SnapshotSummary>.Builder} avoiding
         * the need to create one manually via {@link List<SnapshotSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SnapshotSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #snapshots(List<SnapshotSummary>)}.
         * 
         * @param snapshots
         *        a consumer that will call methods on {@link List<SnapshotSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshots(List<SnapshotSummary>)
         */
        Builder snapshots(Consumer<SnapshotSummary.Builder>... snapshots);
    }

    static final class BuilderImpl extends GameSparksResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SnapshotSummary> snapshots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSnapshotsResponse model) {
            super(model);
            nextToken(model.nextToken);
            snapshots(model.snapshots);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SnapshotSummary.Builder> getSnapshots() {
            List<SnapshotSummary.Builder> result = SnapshotSummaryListCopier.copyToBuilder(this.snapshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshots(Collection<SnapshotSummary.BuilderImpl> snapshots) {
            this.snapshots = SnapshotSummaryListCopier.copyFromBuilder(snapshots);
        }

        @Override
        public final Builder snapshots(Collection<SnapshotSummary> snapshots) {
            this.snapshots = SnapshotSummaryListCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(SnapshotSummary... snapshots) {
            snapshots(Arrays.asList(snapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Consumer<SnapshotSummary.Builder>... snapshots) {
            snapshots(Stream.of(snapshots).map(c -> SnapshotSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSnapshotsResponse build() {
            return new ListSnapshotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
