/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStageDeploymentsResponse extends GameSparksResponse implements
        ToCopyableBuilder<ListStageDeploymentsResponse.Builder, ListStageDeploymentsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStageDeploymentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<StageDeploymentSummary>> STAGE_DEPLOYMENTS_FIELD = SdkField
            .<List<StageDeploymentSummary>> builder(MarshallingType.LIST)
            .memberName("StageDeployments")
            .getter(getter(ListStageDeploymentsResponse::stageDeployments))
            .setter(setter(Builder::stageDeployments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageDeployments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StageDeploymentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StageDeploymentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            STAGE_DEPLOYMENTS_FIELD));

    private final String nextToken;

    private final List<StageDeploymentSummary> stageDeployments;

    private ListStageDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.stageDeployments = builder.stageDeployments;
    }

    /**
     * <p>
     * The token that indicates the start of the next sequential page of results.
     * </p>
     * <p>
     * Use this value when making the next call to this operation to continue where the last one finished.
     * </p>
     * 
     * @return The token that indicates the start of the next sequential page of results.</p>
     *         <p>
     *         Use this value when making the next call to this operation to continue where the last one finished.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StageDeployments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStageDeployments() {
        return stageDeployments != null && !(stageDeployments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of stage deployment summaries. You can use the deployment IDs in the <code>UpdateStageDeployment</code>
     * and <code>GetStageDeployment</code> actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStageDeployments} method.
     * </p>
     * 
     * @return A list of stage deployment summaries. You can use the deployment IDs in the
     *         <code>UpdateStageDeployment</code> and <code>GetStageDeployment</code> actions.
     */
    public final List<StageDeploymentSummary> stageDeployments() {
        return stageDeployments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasStageDeployments() ? stageDeployments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStageDeploymentsResponse)) {
            return false;
        }
        ListStageDeploymentsResponse other = (ListStageDeploymentsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasStageDeployments() == other.hasStageDeployments()
                && Objects.equals(stageDeployments(), other.stageDeployments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStageDeploymentsResponse").add("NextToken", nextToken())
                .add("StageDeployments", hasStageDeployments() ? stageDeployments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "StageDeployments":
            return Optional.ofNullable(clazz.cast(stageDeployments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStageDeploymentsResponse, T> g) {
        return obj -> g.apply((ListStageDeploymentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStageDeploymentsResponse> {
        /**
         * <p>
         * The token that indicates the start of the next sequential page of results.
         * </p>
         * <p>
         * Use this value when making the next call to this operation to continue where the last one finished.
         * </p>
         * 
         * @param nextToken
         *        The token that indicates the start of the next sequential page of results.</p>
         *        <p>
         *        Use this value when making the next call to this operation to continue where the last one finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of stage deployment summaries. You can use the deployment IDs in the
         * <code>UpdateStageDeployment</code> and <code>GetStageDeployment</code> actions.
         * </p>
         * 
         * @param stageDeployments
         *        A list of stage deployment summaries. You can use the deployment IDs in the
         *        <code>UpdateStageDeployment</code> and <code>GetStageDeployment</code> actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageDeployments(Collection<StageDeploymentSummary> stageDeployments);

        /**
         * <p>
         * A list of stage deployment summaries. You can use the deployment IDs in the
         * <code>UpdateStageDeployment</code> and <code>GetStageDeployment</code> actions.
         * </p>
         * 
         * @param stageDeployments
         *        A list of stage deployment summaries. You can use the deployment IDs in the
         *        <code>UpdateStageDeployment</code> and <code>GetStageDeployment</code> actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageDeployments(StageDeploymentSummary... stageDeployments);

        /**
         * <p>
         * A list of stage deployment summaries. You can use the deployment IDs in the
         * <code>UpdateStageDeployment</code> and <code>GetStageDeployment</code> actions.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<StageDeploymentSummary>.Builder}
         * avoiding the need to create one manually via {@link List<StageDeploymentSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StageDeploymentSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #stageDeployments(List<StageDeploymentSummary>)}.
         * 
         * @param stageDeployments
         *        a consumer that will call methods on {@link List<StageDeploymentSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stageDeployments(List<StageDeploymentSummary>)
         */
        Builder stageDeployments(Consumer<StageDeploymentSummary.Builder>... stageDeployments);
    }

    static final class BuilderImpl extends GameSparksResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<StageDeploymentSummary> stageDeployments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStageDeploymentsResponse model) {
            super(model);
            nextToken(model.nextToken);
            stageDeployments(model.stageDeployments);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StageDeploymentSummary.Builder> getStageDeployments() {
            List<StageDeploymentSummary.Builder> result = StageDeploymentListCopier.copyToBuilder(this.stageDeployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStageDeployments(Collection<StageDeploymentSummary.BuilderImpl> stageDeployments) {
            this.stageDeployments = StageDeploymentListCopier.copyFromBuilder(stageDeployments);
        }

        @Override
        public final Builder stageDeployments(Collection<StageDeploymentSummary> stageDeployments) {
            this.stageDeployments = StageDeploymentListCopier.copy(stageDeployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageDeployments(StageDeploymentSummary... stageDeployments) {
            stageDeployments(Arrays.asList(stageDeployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageDeployments(Consumer<StageDeploymentSummary.Builder>... stageDeployments) {
            stageDeployments(Stream.of(stageDeployments).map(c -> StageDeploymentSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStageDeploymentsResponse build() {
            return new ListStageDeploymentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
