/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartGeneratedCodeJobRequest extends GameSparksRequest implements
        ToCopyableBuilder<StartGeneratedCodeJobRequest.Builder, StartGeneratedCodeJobRequest> {
    private static final SdkField<String> GAME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameName").getter(getter(StartGeneratedCodeJobRequest::gameName)).setter(setter(Builder::gameName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("GameName").build()).build();

    private static final SdkField<Generator> GENERATOR_FIELD = SdkField.<Generator> builder(MarshallingType.SDK_POJO)
            .memberName("Generator").getter(getter(StartGeneratedCodeJobRequest::generator)).setter(setter(Builder::generator))
            .constructor(Generator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Generator").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(StartGeneratedCodeJobRequest::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SnapshotId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_NAME_FIELD,
            GENERATOR_FIELD, SNAPSHOT_ID_FIELD));

    private final String gameName;

    private final Generator generator;

    private final String snapshotId;

    private StartGeneratedCodeJobRequest(BuilderImpl builder) {
        super(builder);
        this.gameName = builder.gameName;
        this.generator = builder.generator;
        this.snapshotId = builder.snapshotId;
    }

    /**
     * <p>
     * The name of the game.
     * </p>
     * 
     * @return The name of the game.
     */
    public final String gameName() {
        return gameName;
    }

    /**
     * <p>
     * Properties of the generator to use for the job.
     * </p>
     * 
     * @return Properties of the generator to use for the job.
     */
    public final Generator generator() {
        return generator;
    }

    /**
     * <p>
     * The identifier of the snapshot for which to generate code.
     * </p>
     * 
     * @return The identifier of the snapshot for which to generate code.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameName());
        hashCode = 31 * hashCode + Objects.hashCode(generator());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartGeneratedCodeJobRequest)) {
            return false;
        }
        StartGeneratedCodeJobRequest other = (StartGeneratedCodeJobRequest) obj;
        return Objects.equals(gameName(), other.gameName()) && Objects.equals(generator(), other.generator())
                && Objects.equals(snapshotId(), other.snapshotId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartGeneratedCodeJobRequest").add("GameName", gameName()).add("Generator", generator())
                .add("SnapshotId", snapshotId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameName":
            return Optional.ofNullable(clazz.cast(gameName()));
        case "Generator":
            return Optional.ofNullable(clazz.cast(generator()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartGeneratedCodeJobRequest, T> g) {
        return obj -> g.apply((StartGeneratedCodeJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartGeneratedCodeJobRequest> {
        /**
         * <p>
         * The name of the game.
         * </p>
         * 
         * @param gameName
         *        The name of the game.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameName(String gameName);

        /**
         * <p>
         * Properties of the generator to use for the job.
         * </p>
         * 
         * @param generator
         *        Properties of the generator to use for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generator(Generator generator);

        /**
         * <p>
         * Properties of the generator to use for the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link Generator.Builder} avoiding the need to
         * create one manually via {@link Generator#builder()}.
         *
         * When the {@link Consumer} completes, {@link Generator.Builder#build()} is called immediately and its result
         * is passed to {@link #generator(Generator)}.
         * 
         * @param generator
         *        a consumer that will call methods on {@link Generator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generator(Generator)
         */
        default Builder generator(Consumer<Generator.Builder> generator) {
            return generator(Generator.builder().applyMutation(generator).build());
        }

        /**
         * <p>
         * The identifier of the snapshot for which to generate code.
         * </p>
         * 
         * @param snapshotId
         *        The identifier of the snapshot for which to generate code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameSparksRequest.BuilderImpl implements Builder {
        private String gameName;

        private Generator generator;

        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartGeneratedCodeJobRequest model) {
            super(model);
            gameName(model.gameName);
            generator(model.generator);
            snapshotId(model.snapshotId);
        }

        public final String getGameName() {
            return gameName;
        }

        public final void setGameName(String gameName) {
            this.gameName = gameName;
        }

        @Override
        public final Builder gameName(String gameName) {
            this.gameName = gameName;
            return this;
        }

        public final Generator.Builder getGenerator() {
            return generator != null ? generator.toBuilder() : null;
        }

        public final void setGenerator(Generator.BuilderImpl generator) {
            this.generator = generator != null ? generator.build() : null;
        }

        @Override
        public final Builder generator(Generator generator) {
            this.generator = generator;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartGeneratedCodeJobRequest build() {
            return new StartGeneratedCodeJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
