/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStageResponse extends GameSparksResponse implements
        ToCopyableBuilder<UpdateStageResponse.Builder, UpdateStageResponse> {
    private static final SdkField<StageDetails> STAGE_FIELD = SdkField.<StageDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Stage").getter(getter(UpdateStageResponse::stage)).setter(setter(Builder::stage))
            .constructor(StageDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_FIELD));

    private final StageDetails stage;

    private UpdateStageResponse(BuilderImpl builder) {
        super(builder);
        this.stage = builder.stage;
    }

    /**
     * <p>
     * Properties that provide details of the updated stage.
     * </p>
     * 
     * @return Properties that provide details of the updated stage.
     */
    public final StageDetails stage() {
        return stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStageResponse)) {
            return false;
        }
        UpdateStageResponse other = (UpdateStageResponse) obj;
        return Objects.equals(stage(), other.stage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStageResponse").add("Stage", stage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Stage":
            return Optional.ofNullable(clazz.cast(stage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStageResponse, T> g) {
        return obj -> g.apply((UpdateStageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStageResponse> {
        /**
         * <p>
         * Properties that provide details of the updated stage.
         * </p>
         * 
         * @param stage
         *        Properties that provide details of the updated stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(StageDetails stage);

        /**
         * <p>
         * Properties that provide details of the updated stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link StageDetails.Builder} avoiding the need
         * to create one manually via {@link StageDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link StageDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #stage(StageDetails)}.
         * 
         * @param stage
         *        a consumer that will call methods on {@link StageDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stage(StageDetails)
         */
        default Builder stage(Consumer<StageDetails.Builder> stage) {
            return stage(StageDetails.builder().applyMutation(stage).build());
        }
    }

    static final class BuilderImpl extends GameSparksResponse.BuilderImpl implements Builder {
        private StageDetails stage;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStageResponse model) {
            super(model);
            stage(model.stage);
        }

        public final StageDetails.Builder getStage() {
            return stage != null ? stage.toBuilder() : null;
        }

        public final void setStage(StageDetails.BuilderImpl stage) {
            this.stage = stage != null ? stage.build() : null;
        }

        @Override
        public final Builder stage(StageDetails stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public UpdateStageResponse build() {
            return new UpdateStageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
