/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamesparks.model.GameSparksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGeneratedCodeJobRequest
extends GameSparksRequest
implements ToCopyableBuilder<Builder, GetGeneratedCodeJobRequest> {
    private static final SdkField<String> GAME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameName").getter(GetGeneratedCodeJobRequest.getter(GetGeneratedCodeJobRequest::gameName)).setter(GetGeneratedCodeJobRequest.setter(Builder::gameName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("GameName").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(GetGeneratedCodeJobRequest.getter(GetGeneratedCodeJobRequest::jobId)).setter(GetGeneratedCodeJobRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("JobId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(GetGeneratedCodeJobRequest.getter(GetGeneratedCodeJobRequest::snapshotId)).setter(GetGeneratedCodeJobRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("SnapshotId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_NAME_FIELD, JOB_ID_FIELD, SNAPSHOT_ID_FIELD));
    private final String gameName;
    private final String jobId;
    private final String snapshotId;

    private GetGeneratedCodeJobRequest(BuilderImpl builder) {
        super(builder);
        this.gameName = builder.gameName;
        this.jobId = builder.jobId;
        this.snapshotId = builder.snapshotId;
    }

    public final String gameName() {
        return this.gameName;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGeneratedCodeJobRequest)) {
            return false;
        }
        GetGeneratedCodeJobRequest other = (GetGeneratedCodeJobRequest)((Object)obj);
        return Objects.equals(this.gameName(), other.gameName()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.snapshotId(), other.snapshotId());
    }

    public final String toString() {
        return ToString.builder((String)"GetGeneratedCodeJobRequest").add("GameName", (Object)this.gameName()).add("JobId", (Object)this.jobId()).add("SnapshotId", (Object)this.snapshotId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameName": {
                return Optional.ofNullable(clazz.cast(this.gameName()));
            }
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGeneratedCodeJobRequest, T> g) {
        return obj -> g.apply((GetGeneratedCodeJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameSparksRequest.BuilderImpl
    implements Builder {
        private String gameName;
        private String jobId;
        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGeneratedCodeJobRequest model) {
            super(model);
            this.gameName(model.gameName);
            this.jobId(model.jobId);
            this.snapshotId(model.snapshotId);
        }

        public final String getGameName() {
            return this.gameName;
        }

        public final void setGameName(String gameName) {
            this.gameName = gameName;
        }

        @Override
        public final Builder gameName(String gameName) {
            this.gameName = gameName;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGeneratedCodeJobRequest build() {
            return new GetGeneratedCodeJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameSparksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGeneratedCodeJobRequest> {
        public Builder gameName(String var1);

        public Builder jobId(String var1);

        public Builder snapshotId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

