/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExtensionVersionsRequest extends GameSparksRequest implements
        ToCopyableBuilder<ListExtensionVersionsRequest.Builder, ListExtensionVersionsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListExtensionVersionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListExtensionVersionsRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(ListExtensionVersionsRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListExtensionVersionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NAME_FIELD,
            NAMESPACE_FIELD, NEXT_TOKEN_FIELD));

    private final Integer maxResults;

    private final String name;

    private final String namespace;

    private final String nextToken;

    private ListExtensionVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.namespace = builder.namespace;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * <p>
     * Use this parameter with NextToken to get results as a set of sequential pages.
     * </p>
     * 
     * @return The maximum number of results to return.</p>
     *         <p>
     *         Use this parameter with NextToken to get results as a set of sequential pages.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name of the extension.
     * </p>
     * 
     * @return The name of the extension.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The namespace (qualifier) of the extension.
     * </p>
     * 
     * @return The namespace (qualifier) of the extension.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The token that indicates the start of the next sequential page of results.
     * </p>
     * <p>
     * Use the token that is returned with a previous call to this operation. To start at the beginning of the result
     * set, do not specify a value.
     * </p>
     * 
     * @return The token that indicates the start of the next sequential page of results.</p>
     *         <p>
     *         Use the token that is returned with a previous call to this operation. To start at the beginning of the
     *         result set, do not specify a value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExtensionVersionsRequest)) {
            return false;
        }
        ListExtensionVersionsRequest other = (ListExtensionVersionsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(name(), other.name())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListExtensionVersionsRequest").add("MaxResults", maxResults()).add("Name", name())
                .add("Namespace", namespace()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExtensionVersionsRequest, T> g) {
        return obj -> g.apply((ListExtensionVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListExtensionVersionsRequest> {
        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * <p>
         * Use this parameter with NextToken to get results as a set of sequential pages.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.</p>
         *        <p>
         *        Use this parameter with NextToken to get results as a set of sequential pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name of the extension.
         * </p>
         * 
         * @param name
         *        The name of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The namespace (qualifier) of the extension.
         * </p>
         * 
         * @param namespace
         *        The namespace (qualifier) of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The token that indicates the start of the next sequential page of results.
         * </p>
         * <p>
         * Use the token that is returned with a previous call to this operation. To start at the beginning of the
         * result set, do not specify a value.
         * </p>
         * 
         * @param nextToken
         *        The token that indicates the start of the next sequential page of results.</p>
         *        <p>
         *        Use the token that is returned with a previous call to this operation. To start at the beginning of
         *        the result set, do not specify a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameSparksRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String name;

        private String namespace;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExtensionVersionsRequest model) {
            super(model);
            maxResults(model.maxResults);
            name(model.name);
            namespace(model.namespace);
            nextToken(model.nextToken);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListExtensionVersionsRequest build() {
            return new ListExtensionVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
