/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamesparks.model.Operation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SectionModification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SectionModification> {
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(SectionModification.getter(SectionModification::operationAsString)).setter(SectionModification.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(SectionModification.getter(SectionModification::path)).setter(SectionModification.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> SECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Section").getter(SectionModification.getter(SectionModification::section)).setter(SectionModification.setter(Builder::section)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Section").build()}).build();
    private static final SdkField<Document> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("Value").getter(SectionModification.getter(SectionModification::value)).setter(SectionModification.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_FIELD, PATH_FIELD, SECTION_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String operation;
    private final String path;
    private final String section;
    private final Document value;

    private SectionModification(BuilderImpl builder) {
        this.operation = builder.operation;
        this.path = builder.path;
        this.section = builder.section;
        this.value = builder.value;
    }

    public final Operation operation() {
        return Operation.fromValue(this.operation);
    }

    public final String operationAsString() {
        return this.operation;
    }

    public final String path() {
        return this.path;
    }

    public final String section() {
        return this.section;
    }

    public final Document value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.section());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SectionModification)) {
            return false;
        }
        SectionModification other = (SectionModification)obj;
        return Objects.equals(this.operationAsString(), other.operationAsString()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.section(), other.section()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"SectionModification").add("Operation", (Object)this.operationAsString()).add("Path", (Object)this.path()).add("Section", (Object)this.section()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Section": {
                return Optional.ofNullable(clazz.cast(this.section()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SectionModification, T> g) {
        return obj -> g.apply((SectionModification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operation;
        private String path;
        private String section;
        private Document value;

        private BuilderImpl() {
        }

        private BuilderImpl(SectionModification model) {
            this.operation(model.operation);
            this.path(model.path);
            this.section(model.section);
            this.value(model.value);
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getSection() {
            return this.section;
        }

        public final void setSection(String section) {
            this.section = section;
        }

        @Override
        public final Builder section(String section) {
            this.section = section;
            return this;
        }

        public final Document getValue() {
            return this.value;
        }

        public final void setValue(Document value) {
            this.value = value;
        }

        @Override
        public final Builder value(Document value) {
            this.value = value;
            return this;
        }

        public SectionModification build() {
            return new SectionModification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SectionModification> {
        public Builder operation(String var1);

        public Builder operation(Operation var1);

        public Builder path(String var1);

        public Builder section(String var1);

        public Builder value(Document var1);
    }
}

