/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamesparks.GameSparksAsyncClient;
import software.amazon.awssdk.services.gamesparks.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsResponse;
import software.amazon.awssdk.services.gamesparks.model.StageDeploymentSummary;

public class ListStageDeploymentsPublisher
implements SdkPublisher<ListStageDeploymentsResponse> {
    private final GameSparksAsyncClient client;
    private final ListStageDeploymentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStageDeploymentsPublisher(GameSparksAsyncClient client, ListStageDeploymentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStageDeploymentsPublisher(GameSparksAsyncClient client, ListStageDeploymentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStageDeploymentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStageDeploymentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StageDeploymentSummary> stageDeployments() {
        Function<ListStageDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.stageDeployments() != null) {
                return response.stageDeployments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStageDeploymentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStageDeploymentsResponseFetcher
    implements AsyncPageFetcher<ListStageDeploymentsResponse> {
        private ListStageDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListStageDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStageDeploymentsResponse> nextPage(ListStageDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return ListStageDeploymentsPublisher.this.client.listStageDeployments(ListStageDeploymentsPublisher.this.firstRequest);
            }
            return ListStageDeploymentsPublisher.this.client.listStageDeployments((ListStageDeploymentsRequest)((Object)ListStageDeploymentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

