/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamesparks.model.GameSparksRequest;
import software.amazon.awssdk.services.gamesparks.model.ImportGameConfigurationSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportGameConfigurationRequest
extends GameSparksRequest
implements ToCopyableBuilder<Builder, ImportGameConfigurationRequest> {
    private static final SdkField<String> GAME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameName").getter(ImportGameConfigurationRequest.getter(ImportGameConfigurationRequest::gameName)).setter(ImportGameConfigurationRequest.setter(Builder::gameName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("GameName").build()}).build();
    private static final SdkField<ImportGameConfigurationSource> IMPORT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportSource").getter(ImportGameConfigurationRequest.getter(ImportGameConfigurationRequest::importSource)).setter(ImportGameConfigurationRequest.setter(Builder::importSource)).constructor(ImportGameConfigurationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_NAME_FIELD, IMPORT_SOURCE_FIELD));
    private final String gameName;
    private final ImportGameConfigurationSource importSource;

    private ImportGameConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.gameName = builder.gameName;
        this.importSource = builder.importSource;
    }

    public final String gameName() {
        return this.gameName;
    }

    public final ImportGameConfigurationSource importSource() {
        return this.importSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameName());
        hashCode = 31 * hashCode + Objects.hashCode(this.importSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportGameConfigurationRequest)) {
            return false;
        }
        ImportGameConfigurationRequest other = (ImportGameConfigurationRequest)((Object)obj);
        return Objects.equals(this.gameName(), other.gameName()) && Objects.equals(this.importSource(), other.importSource());
    }

    public final String toString() {
        return ToString.builder((String)"ImportGameConfigurationRequest").add("GameName", (Object)this.gameName()).add("ImportSource", (Object)this.importSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameName": {
                return Optional.ofNullable(clazz.cast(this.gameName()));
            }
            case "ImportSource": {
                return Optional.ofNullable(clazz.cast(this.importSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportGameConfigurationRequest, T> g) {
        return obj -> g.apply((ImportGameConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameSparksRequest.BuilderImpl
    implements Builder {
        private String gameName;
        private ImportGameConfigurationSource importSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportGameConfigurationRequest model) {
            super(model);
            this.gameName(model.gameName);
            this.importSource(model.importSource);
        }

        public final String getGameName() {
            return this.gameName;
        }

        public final void setGameName(String gameName) {
            this.gameName = gameName;
        }

        @Override
        public final Builder gameName(String gameName) {
            this.gameName = gameName;
            return this;
        }

        public final ImportGameConfigurationSource.Builder getImportSource() {
            return this.importSource != null ? this.importSource.toBuilder() : null;
        }

        public final void setImportSource(ImportGameConfigurationSource.BuilderImpl importSource) {
            this.importSource = importSource != null ? importSource.build() : null;
        }

        @Override
        public final Builder importSource(ImportGameConfigurationSource importSource) {
            this.importSource = importSource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportGameConfigurationRequest build() {
            return new ImportGameConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameSparksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportGameConfigurationRequest> {
        public Builder gameName(String var1);

        public Builder importSource(ImportGameConfigurationSource var1);

        default public Builder importSource(Consumer<ImportGameConfigurationSource.Builder> importSource) {
            return this.importSource((ImportGameConfigurationSource)((ImportGameConfigurationSource.Builder)ImportGameConfigurationSource.builder().applyMutation(importSource)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

