/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGameConfigurationRequest extends GameSparksRequest implements
        ToCopyableBuilder<GetGameConfigurationRequest.Builder, GetGameConfigurationRequest> {
    private static final SdkField<String> GAME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameName").getter(getter(GetGameConfigurationRequest::gameName)).setter(setter(Builder::gameName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("GameName").build()).build();

    private static final SdkField<List<String>> SECTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Sections")
            .getter(getter(GetGameConfigurationRequest::sections))
            .setter(setter(Builder::sections))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Sections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_NAME_FIELD,
            SECTIONS_FIELD));

    private final String gameName;

    private final List<String> sections;

    private GetGameConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.gameName = builder.gameName;
        this.sections = builder.sections;
    }

    /**
     * <p>
     * The name of the game.
     * </p>
     * 
     * @return The name of the game.
     */
    public final String gameName() {
        return gameName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sections property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSections() {
        return sections != null && !(sections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of sections to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSections} method.
     * </p>
     * 
     * @return The list of sections to return.
     */
    public final List<String> sections() {
        return sections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSections() ? sections() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGameConfigurationRequest)) {
            return false;
        }
        GetGameConfigurationRequest other = (GetGameConfigurationRequest) obj;
        return Objects.equals(gameName(), other.gameName()) && hasSections() == other.hasSections()
                && Objects.equals(sections(), other.sections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGameConfigurationRequest").add("GameName", gameName())
                .add("Sections", hasSections() ? sections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameName":
            return Optional.ofNullable(clazz.cast(gameName()));
        case "Sections":
            return Optional.ofNullable(clazz.cast(sections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGameConfigurationRequest, T> g) {
        return obj -> g.apply((GetGameConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetGameConfigurationRequest> {
        /**
         * <p>
         * The name of the game.
         * </p>
         * 
         * @param gameName
         *        The name of the game.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameName(String gameName);

        /**
         * <p>
         * The list of sections to return.
         * </p>
         * 
         * @param sections
         *        The list of sections to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sections(Collection<String> sections);

        /**
         * <p>
         * The list of sections to return.
         * </p>
         * 
         * @param sections
         *        The list of sections to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sections(String... sections);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameSparksRequest.BuilderImpl implements Builder {
        private String gameName;

        private List<String> sections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetGameConfigurationRequest model) {
            super(model);
            gameName(model.gameName);
            sections(model.sections);
        }

        public final String getGameName() {
            return gameName;
        }

        public final void setGameName(String gameName) {
            this.gameName = gameName;
        }

        @Override
        public final Builder gameName(String gameName) {
            this.gameName = gameName;
            return this;
        }

        public final Collection<String> getSections() {
            if (sections instanceof SdkAutoConstructList) {
                return null;
            }
            return sections;
        }

        public final void setSections(Collection<String> sections) {
            this.sections = SectionListCopier.copy(sections);
        }

        @Override
        public final Builder sections(Collection<String> sections) {
            this.sections = SectionListCopier.copy(sections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sections(String... sections) {
            sections(Arrays.asList(sections));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGameConfigurationRequest build() {
            return new GetGameConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
