/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the properties of a stage deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StageDeploymentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<StageDeploymentSummary.Builder, StageDeploymentSummary> {
    private static final SdkField<String> DEPLOYMENT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentAction").getter(getter(StageDeploymentSummary::deploymentActionAsString))
            .setter(setter(Builder::deploymentAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentAction").build()).build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentId").getter(getter(StageDeploymentSummary::deploymentId))
            .setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()).build();

    private static final SdkField<DeploymentResult> DEPLOYMENT_RESULT_FIELD = SdkField
            .<DeploymentResult> builder(MarshallingType.SDK_POJO).memberName("DeploymentResult")
            .getter(getter(StageDeploymentSummary::deploymentResult)).setter(setter(Builder::deploymentResult))
            .constructor(DeploymentResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentResult").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentState").getter(getter(StageDeploymentSummary::deploymentStateAsString))
            .setter(setter(Builder::deploymentState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentState").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated")
            .getter(getter(StageDeploymentSummary::lastUpdated))
            .setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(StageDeploymentSummary::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ACTION_FIELD,
            DEPLOYMENT_ID_FIELD, DEPLOYMENT_RESULT_FIELD, DEPLOYMENT_STATE_FIELD, LAST_UPDATED_FIELD, SNAPSHOT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deploymentAction;

    private final String deploymentId;

    private final DeploymentResult deploymentResult;

    private final String deploymentState;

    private final Instant lastUpdated;

    private final String snapshotId;

    private StageDeploymentSummary(BuilderImpl builder) {
        this.deploymentAction = builder.deploymentAction;
        this.deploymentId = builder.deploymentId;
        this.deploymentResult = builder.deploymentResult;
        this.deploymentState = builder.deploymentState;
        this.lastUpdated = builder.lastUpdated;
        this.snapshotId = builder.snapshotId;
    }

    /**
     * <p>
     * The type of action of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentAction}
     * will return {@link DeploymentAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentActionAsString}.
     * </p>
     * 
     * @return The type of action of the deployment.
     * @see DeploymentAction
     */
    public final DeploymentAction deploymentAction() {
        return DeploymentAction.fromValue(deploymentAction);
    }

    /**
     * <p>
     * The type of action of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentAction}
     * will return {@link DeploymentAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentActionAsString}.
     * </p>
     * 
     * @return The type of action of the deployment.
     * @see DeploymentAction
     */
    public final String deploymentActionAsString() {
        return deploymentAction;
    }

    /**
     * <p>
     * The identifier of the deployment.
     * </p>
     * 
     * @return The identifier of the deployment.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The result of the deployment.
     * </p>
     * 
     * @return The result of the deployment.
     */
    public final DeploymentResult deploymentResult() {
        return deploymentResult;
    }

    /**
     * <p>
     * The state of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentState}
     * will return {@link DeploymentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStateAsString}.
     * </p>
     * 
     * @return The state of the deployment.
     * @see DeploymentState
     */
    public final DeploymentState deploymentState() {
        return DeploymentState.fromValue(deploymentState);
    }

    /**
     * <p>
     * The state of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentState}
     * will return {@link DeploymentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStateAsString}.
     * </p>
     * 
     * @return The state of the deployment.
     * @see DeploymentState
     */
    public final String deploymentStateAsString() {
        return deploymentState;
    }

    /**
     * <p>
     * The timestamp of when the deployment was last updated.
     * </p>
     * 
     * @return The timestamp of when the deployment was last updated.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The identifier of the snapshot associated with the stage deployment.
     * </p>
     * 
     * @return The identifier of the snapshot associated with the stage deployment.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentResult());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageDeploymentSummary)) {
            return false;
        }
        StageDeploymentSummary other = (StageDeploymentSummary) obj;
        return Objects.equals(deploymentActionAsString(), other.deploymentActionAsString())
                && Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(deploymentResult(), other.deploymentResult())
                && Objects.equals(deploymentStateAsString(), other.deploymentStateAsString())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(snapshotId(), other.snapshotId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StageDeploymentSummary").add("DeploymentAction", deploymentActionAsString())
                .add("DeploymentId", deploymentId()).add("DeploymentResult", deploymentResult())
                .add("DeploymentState", deploymentStateAsString()).add("LastUpdated", lastUpdated())
                .add("SnapshotId", snapshotId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentAction":
            return Optional.ofNullable(clazz.cast(deploymentActionAsString()));
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "DeploymentResult":
            return Optional.ofNullable(clazz.cast(deploymentResult()));
        case "DeploymentState":
            return Optional.ofNullable(clazz.cast(deploymentStateAsString()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StageDeploymentSummary, T> g) {
        return obj -> g.apply((StageDeploymentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StageDeploymentSummary> {
        /**
         * <p>
         * The type of action of the deployment.
         * </p>
         * 
         * @param deploymentAction
         *        The type of action of the deployment.
         * @see DeploymentAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentAction
         */
        Builder deploymentAction(String deploymentAction);

        /**
         * <p>
         * The type of action of the deployment.
         * </p>
         * 
         * @param deploymentAction
         *        The type of action of the deployment.
         * @see DeploymentAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentAction
         */
        Builder deploymentAction(DeploymentAction deploymentAction);

        /**
         * <p>
         * The identifier of the deployment.
         * </p>
         * 
         * @param deploymentId
         *        The identifier of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The result of the deployment.
         * </p>
         * 
         * @param deploymentResult
         *        The result of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentResult(DeploymentResult deploymentResult);

        /**
         * <p>
         * The result of the deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentResult.Builder} avoiding the
         * need to create one manually via {@link DeploymentResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentResult.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentResult(DeploymentResult)}.
         * 
         * @param deploymentResult
         *        a consumer that will call methods on {@link DeploymentResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentResult(DeploymentResult)
         */
        default Builder deploymentResult(Consumer<DeploymentResult.Builder> deploymentResult) {
            return deploymentResult(DeploymentResult.builder().applyMutation(deploymentResult).build());
        }

        /**
         * <p>
         * The state of the deployment.
         * </p>
         * 
         * @param deploymentState
         *        The state of the deployment.
         * @see DeploymentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentState
         */
        Builder deploymentState(String deploymentState);

        /**
         * <p>
         * The state of the deployment.
         * </p>
         * 
         * @param deploymentState
         *        The state of the deployment.
         * @see DeploymentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentState
         */
        Builder deploymentState(DeploymentState deploymentState);

        /**
         * <p>
         * The timestamp of when the deployment was last updated.
         * </p>
         * 
         * @param lastUpdated
         *        The timestamp of when the deployment was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The identifier of the snapshot associated with the stage deployment.
         * </p>
         * 
         * @param snapshotId
         *        The identifier of the snapshot associated with the stage deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentAction;

        private String deploymentId;

        private DeploymentResult deploymentResult;

        private String deploymentState;

        private Instant lastUpdated;

        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(StageDeploymentSummary model) {
            deploymentAction(model.deploymentAction);
            deploymentId(model.deploymentId);
            deploymentResult(model.deploymentResult);
            deploymentState(model.deploymentState);
            lastUpdated(model.lastUpdated);
            snapshotId(model.snapshotId);
        }

        public final String getDeploymentAction() {
            return deploymentAction;
        }

        public final void setDeploymentAction(String deploymentAction) {
            this.deploymentAction = deploymentAction;
        }

        @Override
        public final Builder deploymentAction(String deploymentAction) {
            this.deploymentAction = deploymentAction;
            return this;
        }

        @Override
        public final Builder deploymentAction(DeploymentAction deploymentAction) {
            this.deploymentAction(deploymentAction == null ? null : deploymentAction.toString());
            return this;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final DeploymentResult.Builder getDeploymentResult() {
            return deploymentResult != null ? deploymentResult.toBuilder() : null;
        }

        public final void setDeploymentResult(DeploymentResult.BuilderImpl deploymentResult) {
            this.deploymentResult = deploymentResult != null ? deploymentResult.build() : null;
        }

        @Override
        public final Builder deploymentResult(DeploymentResult deploymentResult) {
            this.deploymentResult = deploymentResult;
            return this;
        }

        public final String getDeploymentState() {
            return deploymentState;
        }

        public final void setDeploymentState(String deploymentState) {
            this.deploymentState = deploymentState;
        }

        @Override
        public final Builder deploymentState(String deploymentState) {
            this.deploymentState = deploymentState;
            return this;
        }

        @Override
        public final Builder deploymentState(DeploymentState deploymentState) {
            this.deploymentState(deploymentState == null ? null : deploymentState.toString());
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        @Override
        public StageDeploymentSummary build() {
            return new StageDeploymentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
