/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentState {
    PENDING("PENDING"),
    IN_PROGRESS("IN_PROGRESS"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentState> VALUE_MAP;
    private final String value;

    private DeploymentState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentState> knownValues() {
        EnumSet<DeploymentState> knownValues = EnumSet.allOf(DeploymentState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentState.class, DeploymentState::toString);
    }
}

