/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamesparks.model.GeneratedCodeJobState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeneratedCodeJobDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeneratedCodeJobDetails> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GeneratedCodeJobDetails.getter(GeneratedCodeJobDetails::description)).setter(GeneratedCodeJobDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationTime").getter(GeneratedCodeJobDetails.getter(GeneratedCodeJobDetails::expirationTime)).setter(GeneratedCodeJobDetails.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> GENERATED_CODE_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedCodeJobId").getter(GeneratedCodeJobDetails.getter(GeneratedCodeJobDetails::generatedCodeJobId)).setter(GeneratedCodeJobDetails.setter(Builder::generatedCodeJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedCodeJobId").build()}).build();
    private static final SdkField<String> S3_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Url").getter(GeneratedCodeJobDetails.getter(GeneratedCodeJobDetails::s3Url)).setter(GeneratedCodeJobDetails.setter(Builder::s3Url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Url").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GeneratedCodeJobDetails.getter(GeneratedCodeJobDetails::statusAsString)).setter(GeneratedCodeJobDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, EXPIRATION_TIME_FIELD, GENERATED_CODE_JOB_ID_FIELD, S3_URL_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final Instant expirationTime;
    private final String generatedCodeJobId;
    private final String s3Url;
    private final String status;

    private GeneratedCodeJobDetails(BuilderImpl builder) {
        this.description = builder.description;
        this.expirationTime = builder.expirationTime;
        this.generatedCodeJobId = builder.generatedCodeJobId;
        this.s3Url = builder.s3Url;
        this.status = builder.status;
    }

    public final String description() {
        return this.description;
    }

    public final Instant expirationTime() {
        return this.expirationTime;
    }

    public final String generatedCodeJobId() {
        return this.generatedCodeJobId;
    }

    public final String s3Url() {
        return this.s3Url;
    }

    public final GeneratedCodeJobState status() {
        return GeneratedCodeJobState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedCodeJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Url());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratedCodeJobDetails)) {
            return false;
        }
        GeneratedCodeJobDetails other = (GeneratedCodeJobDetails)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.expirationTime(), other.expirationTime()) && Objects.equals(this.generatedCodeJobId(), other.generatedCodeJobId()) && Objects.equals(this.s3Url(), other.s3Url()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GeneratedCodeJobDetails").add("Description", (Object)this.description()).add("ExpirationTime", (Object)this.expirationTime()).add("GeneratedCodeJobId", (Object)this.generatedCodeJobId()).add("S3Url", (Object)this.s3Url()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
            case "GeneratedCodeJobId": {
                return Optional.ofNullable(clazz.cast(this.generatedCodeJobId()));
            }
            case "S3Url": {
                return Optional.ofNullable(clazz.cast(this.s3Url()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeneratedCodeJobDetails, T> g) {
        return obj -> g.apply((GeneratedCodeJobDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private Instant expirationTime;
        private String generatedCodeJobId;
        private String s3Url;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratedCodeJobDetails model) {
            this.description(model.description);
            this.expirationTime(model.expirationTime);
            this.generatedCodeJobId(model.generatedCodeJobId);
            this.s3Url(model.s3Url);
            this.status(model.status);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final String getGeneratedCodeJobId() {
            return this.generatedCodeJobId;
        }

        public final void setGeneratedCodeJobId(String generatedCodeJobId) {
            this.generatedCodeJobId = generatedCodeJobId;
        }

        @Override
        public final Builder generatedCodeJobId(String generatedCodeJobId) {
            this.generatedCodeJobId = generatedCodeJobId;
            return this;
        }

        public final String getS3Url() {
            return this.s3Url;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GeneratedCodeJobState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public GeneratedCodeJobDetails build() {
            return new GeneratedCodeJobDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeneratedCodeJobDetails> {
        public Builder description(String var1);

        public Builder expirationTime(Instant var1);

        public Builder generatedCodeJobId(String var1);

        public Builder s3Url(String var1);

        public Builder status(String var1);

        public Builder status(GeneratedCodeJobState var1);
    }
}

