/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamesparks.GameSparksClient;
import software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsResponse;
import software.amazon.awssdk.services.gamesparks.model.StageDeploymentSummary;

public class ListStageDeploymentsIterable
implements SdkIterable<ListStageDeploymentsResponse> {
    private final GameSparksClient client;
    private final ListStageDeploymentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStageDeploymentsIterable(GameSparksClient client, ListStageDeploymentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStageDeploymentsResponseFetcher();
    }

    public Iterator<ListStageDeploymentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StageDeploymentSummary> stageDeployments() {
        Function<ListStageDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.stageDeployments() != null) {
                return response.stageDeployments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStageDeploymentsResponseFetcher
    implements SyncPageFetcher<ListStageDeploymentsResponse> {
        private ListStageDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListStageDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStageDeploymentsResponse nextPage(ListStageDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return ListStageDeploymentsIterable.this.client.listStageDeployments(ListStageDeploymentsIterable.this.firstRequest);
            }
            return ListStageDeploymentsIterable.this.client.listStageDeployments((ListStageDeploymentsRequest)((Object)ListStageDeploymentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

