/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExtensionResponse extends GameSparksResponse implements
        ToCopyableBuilder<GetExtensionResponse.Builder, GetExtensionResponse> {
    private static final SdkField<ExtensionDetails> EXTENSION_FIELD = SdkField
            .<ExtensionDetails> builder(MarshallingType.SDK_POJO).memberName("Extension")
            .getter(getter(GetExtensionResponse::extension)).setter(setter(Builder::extension))
            .constructor(ExtensionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Extension").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENSION_FIELD));

    private final ExtensionDetails extension;

    private GetExtensionResponse(BuilderImpl builder) {
        super(builder);
        this.extension = builder.extension;
    }

    /**
     * <p>
     * Details about the extension.
     * </p>
     * 
     * @return Details about the extension.
     */
    public final ExtensionDetails extension() {
        return extension;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(extension());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExtensionResponse)) {
            return false;
        }
        GetExtensionResponse other = (GetExtensionResponse) obj;
        return Objects.equals(extension(), other.extension());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExtensionResponse").add("Extension", extension()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Extension":
            return Optional.ofNullable(clazz.cast(extension()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExtensionResponse, T> g) {
        return obj -> g.apply((GetExtensionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetExtensionResponse> {
        /**
         * <p>
         * Details about the extension.
         * </p>
         * 
         * @param extension
         *        Details about the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extension(ExtensionDetails extension);

        /**
         * <p>
         * Details about the extension.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExtensionDetails.Builder} avoiding the
         * need to create one manually via {@link ExtensionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExtensionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #extension(ExtensionDetails)}.
         * 
         * @param extension
         *        a consumer that will call methods on {@link ExtensionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extension(ExtensionDetails)
         */
        default Builder extension(Consumer<ExtensionDetails.Builder> extension) {
            return extension(ExtensionDetails.builder().applyMutation(extension).build());
        }
    }

    static final class BuilderImpl extends GameSparksResponse.BuilderImpl implements Builder {
        private ExtensionDetails extension;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExtensionResponse model) {
            super(model);
            extension(model.extension);
        }

        public final ExtensionDetails.Builder getExtension() {
            return extension != null ? extension.toBuilder() : null;
        }

        public final void setExtension(ExtensionDetails.BuilderImpl extension) {
            this.extension = extension != null ? extension.build() : null;
        }

        @Override
        public final Builder extension(ExtensionDetails extension) {
            this.extension = extension;
            return this;
        }

        @Override
        public GetExtensionResponse build() {
            return new GetExtensionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
