/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties that provide details of a snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotDetails implements SdkPojo, Serializable, ToCopyableBuilder<SnapshotDetails.Builder, SnapshotDetails> {
    private static final SdkField<Instant> CREATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Created")
            .getter(getter(SnapshotDetails::created))
            .setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(SnapshotDetails::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(SnapshotDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated")
            .getter(getter(SnapshotDetails::lastUpdated))
            .setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, Section>> SECTIONS_FIELD = SdkField
            .<Map<String, Section>> builder(MarshallingType.MAP)
            .memberName("Sections")
            .getter(getter(SnapshotDetails::sections))
            .setter(setter(Builder::sections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sections").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Section> builder(MarshallingType.SDK_POJO)
                                            .constructor(Section::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_FIELD,
            DESCRIPTION_FIELD, ID_FIELD, LAST_UPDATED_FIELD, SECTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant created;

    private final String description;

    private final String id;

    private final Instant lastUpdated;

    private final Map<String, Section> sections;

    private SnapshotDetails(BuilderImpl builder) {
        this.created = builder.created;
        this.description = builder.description;
        this.id = builder.id;
        this.lastUpdated = builder.lastUpdated;
        this.sections = builder.sections;
    }

    /**
     * <p>
     * The timestamp of when the snapshot was created.
     * </p>
     * 
     * @return The timestamp of when the snapshot was created.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The description of the snapshot.
     * </p>
     * 
     * @return The description of the snapshot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the snapshot.
     * </p>
     * 
     * @return The identifier of the snapshot.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The timestamp of when the snapshot was last updated.
     * </p>
     * 
     * @return The timestamp of when the snapshot was last updated.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sections property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSections() {
        return sections != null && !(sections instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The sections in the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSections} method.
     * </p>
     * 
     * @return The sections in the snapshot.
     */
    public final Map<String, Section> sections() {
        return sections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(hasSections() ? sections() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotDetails)) {
            return false;
        }
        SnapshotDetails other = (SnapshotDetails) obj;
        return Objects.equals(created(), other.created()) && Objects.equals(description(), other.description())
                && Objects.equals(id(), other.id()) && Objects.equals(lastUpdated(), other.lastUpdated())
                && hasSections() == other.hasSections() && Objects.equals(sections(), other.sections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotDetails").add("Created", created()).add("Description", description()).add("Id", id())
                .add("LastUpdated", lastUpdated()).add("Sections", hasSections() ? sections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "Sections":
            return Optional.ofNullable(clazz.cast(sections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotDetails, T> g) {
        return obj -> g.apply((SnapshotDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotDetails> {
        /**
         * <p>
         * The timestamp of when the snapshot was created.
         * </p>
         * 
         * @param created
         *        The timestamp of when the snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The description of the snapshot.
         * </p>
         * 
         * @param description
         *        The description of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the snapshot.
         * </p>
         * 
         * @param id
         *        The identifier of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The timestamp of when the snapshot was last updated.
         * </p>
         * 
         * @param lastUpdated
         *        The timestamp of when the snapshot was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The sections in the snapshot.
         * </p>
         * 
         * @param sections
         *        The sections in the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sections(Map<String, Section> sections);
    }

    static final class BuilderImpl implements Builder {
        private Instant created;

        private String description;

        private String id;

        private Instant lastUpdated;

        private Map<String, Section> sections = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotDetails model) {
            created(model.created);
            description(model.description);
            id(model.id);
            lastUpdated(model.lastUpdated);
            sections(model.sections);
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final Map<String, Section.Builder> getSections() {
            Map<String, Section.Builder> result = SectionsCopier.copyToBuilder(this.sections);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSections(Map<String, Section.BuilderImpl> sections) {
            this.sections = SectionsCopier.copyFromBuilder(sections);
        }

        @Override
        public final Builder sections(Map<String, Section> sections) {
            this.sections = SectionsCopier.copy(sections);
            return this;
        }

        @Override
        public SnapshotDetails build() {
            return new SnapshotDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
