/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.gamesparks.DefaultGameSparksBaseClientBuilder;
import software.amazon.awssdk.services.gamesparks.DefaultGameSparksClient;
import software.amazon.awssdk.services.gamesparks.GameSparksClient;
import software.amazon.awssdk.services.gamesparks.GameSparksClientBuilder;
import software.amazon.awssdk.services.gamesparks.GameSparksServiceClientConfiguration;
import software.amazon.awssdk.services.gamesparks.endpoints.GameSparksEndpointProvider;

@SdkInternalApi
final class DefaultGameSparksClientBuilder
extends DefaultGameSparksBaseClientBuilder<GameSparksClientBuilder, GameSparksClient>
implements GameSparksClientBuilder {
    DefaultGameSparksClientBuilder() {
    }

    @Override
    public DefaultGameSparksClientBuilder endpointProvider(GameSparksEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GameSparksClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultGameSparksClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        GameSparksServiceClientConfiguration serviceClientConfiguration = GameSparksServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultGameSparksClient(serviceClientConfiguration, clientConfiguration);
    }
}

