/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.gamesparks.model.CreateGameRequest;
import software.amazon.awssdk.services.gamesparks.model.CreateGameResponse;
import software.amazon.awssdk.services.gamesparks.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.gamesparks.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.gamesparks.model.CreateStageRequest;
import software.amazon.awssdk.services.gamesparks.model.CreateStageResponse;
import software.amazon.awssdk.services.gamesparks.model.DeleteGameRequest;
import software.amazon.awssdk.services.gamesparks.model.DeleteGameResponse;
import software.amazon.awssdk.services.gamesparks.model.DeleteStageRequest;
import software.amazon.awssdk.services.gamesparks.model.DeleteStageResponse;
import software.amazon.awssdk.services.gamesparks.model.DisconnectPlayerRequest;
import software.amazon.awssdk.services.gamesparks.model.DisconnectPlayerResponse;
import software.amazon.awssdk.services.gamesparks.model.ExportSnapshotRequest;
import software.amazon.awssdk.services.gamesparks.model.ExportSnapshotResponse;
import software.amazon.awssdk.services.gamesparks.model.GetExtensionRequest;
import software.amazon.awssdk.services.gamesparks.model.GetExtensionResponse;
import software.amazon.awssdk.services.gamesparks.model.GetExtensionVersionRequest;
import software.amazon.awssdk.services.gamesparks.model.GetExtensionVersionResponse;
import software.amazon.awssdk.services.gamesparks.model.GetGameConfigurationRequest;
import software.amazon.awssdk.services.gamesparks.model.GetGameConfigurationResponse;
import software.amazon.awssdk.services.gamesparks.model.GetGameRequest;
import software.amazon.awssdk.services.gamesparks.model.GetGameResponse;
import software.amazon.awssdk.services.gamesparks.model.GetGeneratedCodeJobRequest;
import software.amazon.awssdk.services.gamesparks.model.GetGeneratedCodeJobResponse;
import software.amazon.awssdk.services.gamesparks.model.GetPlayerConnectionStatusRequest;
import software.amazon.awssdk.services.gamesparks.model.GetPlayerConnectionStatusResponse;
import software.amazon.awssdk.services.gamesparks.model.GetSnapshotRequest;
import software.amazon.awssdk.services.gamesparks.model.GetSnapshotResponse;
import software.amazon.awssdk.services.gamesparks.model.GetStageDeploymentRequest;
import software.amazon.awssdk.services.gamesparks.model.GetStageDeploymentResponse;
import software.amazon.awssdk.services.gamesparks.model.GetStageRequest;
import software.amazon.awssdk.services.gamesparks.model.GetStageResponse;
import software.amazon.awssdk.services.gamesparks.model.ImportGameConfigurationRequest;
import software.amazon.awssdk.services.gamesparks.model.ImportGameConfigurationResponse;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListGamesRequest;
import software.amazon.awssdk.services.gamesparks.model.ListGamesResponse;
import software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListSnapshotsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListStagesRequest;
import software.amazon.awssdk.services.gamesparks.model.ListStagesResponse;
import software.amazon.awssdk.services.gamesparks.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.gamesparks.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.gamesparks.model.StartGeneratedCodeJobRequest;
import software.amazon.awssdk.services.gamesparks.model.StartGeneratedCodeJobResponse;
import software.amazon.awssdk.services.gamesparks.model.StartStageDeploymentRequest;
import software.amazon.awssdk.services.gamesparks.model.StartStageDeploymentResponse;
import software.amazon.awssdk.services.gamesparks.model.TagResourceRequest;
import software.amazon.awssdk.services.gamesparks.model.TagResourceResponse;
import software.amazon.awssdk.services.gamesparks.model.UntagResourceRequest;
import software.amazon.awssdk.services.gamesparks.model.UntagResourceResponse;
import software.amazon.awssdk.services.gamesparks.model.UpdateGameConfigurationRequest;
import software.amazon.awssdk.services.gamesparks.model.UpdateGameConfigurationResponse;
import software.amazon.awssdk.services.gamesparks.model.UpdateGameRequest;
import software.amazon.awssdk.services.gamesparks.model.UpdateGameResponse;
import software.amazon.awssdk.services.gamesparks.model.UpdateSnapshotRequest;
import software.amazon.awssdk.services.gamesparks.model.UpdateSnapshotResponse;
import software.amazon.awssdk.services.gamesparks.model.UpdateStageRequest;
import software.amazon.awssdk.services.gamesparks.model.UpdateStageResponse;
import software.amazon.awssdk.services.gamesparks.paginators.ListExtensionVersionsPublisher;
import software.amazon.awssdk.services.gamesparks.paginators.ListExtensionsPublisher;
import software.amazon.awssdk.services.gamesparks.paginators.ListGamesPublisher;
import software.amazon.awssdk.services.gamesparks.paginators.ListGeneratedCodeJobsPublisher;
import software.amazon.awssdk.services.gamesparks.paginators.ListSnapshotsPublisher;
import software.amazon.awssdk.services.gamesparks.paginators.ListStageDeploymentsPublisher;
import software.amazon.awssdk.services.gamesparks.paginators.ListStagesPublisher;

/**
 * Service client for accessing GameSparks asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GameSparksAsyncClient extends AwsClient {
    String SERVICE_NAME = "gamesparks";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "gamesparks";

    /**
     * <p>
     * Creates a new game with an empty configuration. After creating your game, you can update the configuration using
     * <code>UpdateGameConfiguration</code> or <code>ImportGameConfiguration</code>.
     * </p>
     *
     * @param createGameRequest
     * @return A Java Future containing the result of the CreateGame operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>ServiceQuotaExceededException The request would result in exceeding service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.CreateGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateGame" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGameResponse> createGame(CreateGameRequest createGameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new game with an empty configuration. After creating your game, you can update the configuration using
     * <code>UpdateGameConfiguration</code> or <code>ImportGameConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGameRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGameRequest#builder()}
     * </p>
     *
     * @param createGameRequest
     *        A {@link Consumer} that will call methods on {@link CreateGameRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGame operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>ServiceQuotaExceededException The request would result in exceeding service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.CreateGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateGame" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGameResponse> createGame(Consumer<CreateGameRequest.Builder> createGameRequest) {
        return createGame(CreateGameRequest.builder().applyMutation(createGameRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of the game configuration.
     * </p>
     *
     * @param createSnapshotRequest
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of the game configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSnapshotRequest#builder()}
     * </p>
     *
     * @param createSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(Consumer<CreateSnapshotRequest.Builder> createSnapshotRequest) {
        return createSnapshot(CreateSnapshotRequest.builder().applyMutation(createSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new stage for stage-by-stage game development and deployment.
     * </p>
     *
     * @param createStageRequest
     * @return A Java Future containing the result of the CreateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.CreateStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStageResponse> createStage(CreateStageRequest createStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new stage for stage-by-stage game development and deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStageRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStageRequest#builder()}
     * </p>
     *
     * @param createStageRequest
     *        A {@link Consumer} that will call methods on {@link CreateStageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.CreateStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStageResponse> createStage(Consumer<CreateStageRequest.Builder> createStageRequest) {
        return createStage(CreateStageRequest.builder().applyMutation(createStageRequest).build());
    }

    /**
     * <p>
     * Deletes a game.
     * </p>
     *
     * @param deleteGameRequest
     * @return A Java Future containing the result of the DeleteGame operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.DeleteGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DeleteGame" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGameResponse> deleteGame(DeleteGameRequest deleteGameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a game.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGameRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGameRequest#builder()}
     * </p>
     *
     * @param deleteGameRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGameRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGame operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.DeleteGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DeleteGame" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGameResponse> deleteGame(Consumer<DeleteGameRequest.Builder> deleteGameRequest) {
        return deleteGame(DeleteGameRequest.builder().applyMutation(deleteGameRequest).build());
    }

    /**
     * <p>
     * Deletes a stage from a game, along with the associated game runtime.
     * </p>
     *
     * @param deleteStageRequest
     * @return A Java Future containing the result of the DeleteStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.DeleteStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DeleteStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStageResponse> deleteStage(DeleteStageRequest deleteStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a stage from a game, along with the associated game runtime.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStageRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStageRequest#builder()}
     * </p>
     *
     * @param deleteStageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.DeleteStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DeleteStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStageResponse> deleteStage(Consumer<DeleteStageRequest.Builder> deleteStageRequest) {
        return deleteStage(DeleteStageRequest.builder().applyMutation(deleteStageRequest).build());
    }

    /**
     * <p>
     * Disconnects a player from the game runtime.
     * </p>
     * <p>
     * If a player has multiple connections, this operation attempts to close all of them.
     * </p>
     *
     * @param disconnectPlayerRequest
     * @return A Java Future containing the result of the DisconnectPlayer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.DisconnectPlayer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DisconnectPlayer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisconnectPlayerResponse> disconnectPlayer(DisconnectPlayerRequest disconnectPlayerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disconnects a player from the game runtime.
     * </p>
     * <p>
     * If a player has multiple connections, this operation attempts to close all of them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisconnectPlayerRequest.Builder} avoiding the need
     * to create one manually via {@link DisconnectPlayerRequest#builder()}
     * </p>
     *
     * @param disconnectPlayerRequest
     *        A {@link Consumer} that will call methods on {@link DisconnectPlayerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisconnectPlayer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.DisconnectPlayer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DisconnectPlayer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisconnectPlayerResponse> disconnectPlayer(
            Consumer<DisconnectPlayerRequest.Builder> disconnectPlayerRequest) {
        return disconnectPlayer(DisconnectPlayerRequest.builder().applyMutation(disconnectPlayerRequest).build());
    }

    /**
     * <p>
     * Exports a game configuration snapshot.
     * </p>
     *
     * @param exportSnapshotRequest
     * @return A Java Future containing the result of the ExportSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ExportSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ExportSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExportSnapshotResponse> exportSnapshot(ExportSnapshotRequest exportSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports a game configuration snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link ExportSnapshotRequest#builder()}
     * </p>
     *
     * @param exportSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link ExportSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ExportSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ExportSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ExportSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExportSnapshotResponse> exportSnapshot(Consumer<ExportSnapshotRequest.Builder> exportSnapshotRequest) {
        return exportSnapshot(ExportSnapshotRequest.builder().applyMutation(exportSnapshotRequest).build());
    }

    /**
     * <p>
     * Gets details about a specified extension.
     * </p>
     *
     * @param getExtensionRequest
     * @return A Java Future containing the result of the GetExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetExtensionResponse> getExtension(GetExtensionRequest getExtensionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a specified extension.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExtensionRequest.Builder} avoiding the need to
     * create one manually via {@link GetExtensionRequest#builder()}
     * </p>
     *
     * @param getExtensionRequest
     *        A {@link Consumer} that will call methods on {@link GetExtensionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetExtensionResponse> getExtension(Consumer<GetExtensionRequest.Builder> getExtensionRequest) {
        return getExtension(GetExtensionRequest.builder().applyMutation(getExtensionRequest).build());
    }

    /**
     * <p>
     * Gets details about a specified extension version.
     * </p>
     *
     * @param getExtensionVersionRequest
     * @return A Java Future containing the result of the GetExtensionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetExtensionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetExtensionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetExtensionVersionResponse> getExtensionVersion(
            GetExtensionVersionRequest getExtensionVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a specified extension version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExtensionVersionRequest.Builder} avoiding the
     * need to create one manually via {@link GetExtensionVersionRequest#builder()}
     * </p>
     *
     * @param getExtensionVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetExtensionVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetExtensionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetExtensionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetExtensionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetExtensionVersionResponse> getExtensionVersion(
            Consumer<GetExtensionVersionRequest.Builder> getExtensionVersionRequest) {
        return getExtensionVersion(GetExtensionVersionRequest.builder().applyMutation(getExtensionVersionRequest).build());
    }

    /**
     * <p>
     * Gets details about a game.
     * </p>
     *
     * @param getGameRequest
     * @return A Java Future containing the result of the GetGame operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGame" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGameResponse> getGame(GetGameRequest getGameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a game.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGameRequest.Builder} avoiding the need to create
     * one manually via {@link GetGameRequest#builder()}
     * </p>
     *
     * @param getGameRequest
     *        A {@link Consumer} that will call methods on {@link GetGameRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGame operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGame" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGameResponse> getGame(Consumer<GetGameRequest.Builder> getGameRequest) {
        return getGame(GetGameRequest.builder().applyMutation(getGameRequest).build());
    }

    /**
     * <p>
     * Gets the configuration of the game.
     * </p>
     *
     * @param getGameConfigurationRequest
     * @return A Java Future containing the result of the GetGameConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetGameConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGameConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGameConfigurationResponse> getGameConfiguration(
            GetGameConfigurationRequest getGameConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the configuration of the game.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGameConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetGameConfigurationRequest#builder()}
     * </p>
     *
     * @param getGameConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetGameConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetGameConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetGameConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGameConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGameConfigurationResponse> getGameConfiguration(
            Consumer<GetGameConfigurationRequest.Builder> getGameConfigurationRequest) {
        return getGameConfiguration(GetGameConfigurationRequest.builder().applyMutation(getGameConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets details about a job that is generating code for a snapshot.
     * </p>
     *
     * @param getGeneratedCodeJobRequest
     * @return A Java Future containing the result of the GetGeneratedCodeJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetGeneratedCodeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGeneratedCodeJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGeneratedCodeJobResponse> getGeneratedCodeJob(
            GetGeneratedCodeJobRequest getGeneratedCodeJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a job that is generating code for a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGeneratedCodeJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetGeneratedCodeJobRequest#builder()}
     * </p>
     *
     * @param getGeneratedCodeJobRequest
     *        A {@link Consumer} that will call methods on {@link GetGeneratedCodeJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetGeneratedCodeJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetGeneratedCodeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGeneratedCodeJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGeneratedCodeJobResponse> getGeneratedCodeJob(
            Consumer<GetGeneratedCodeJobRequest.Builder> getGeneratedCodeJobRequest) {
        return getGeneratedCodeJob(GetGeneratedCodeJobRequest.builder().applyMutation(getGeneratedCodeJobRequest).build());
    }

    /**
     * <p>
     * Gets the status of a player's connection to the game runtime.
     * </p>
     * <p>
     * It's possible for a single player to have multiple connections to the game runtime. If a player is not connected,
     * this operation returns an empty list.
     * </p>
     *
     * @param getPlayerConnectionStatusRequest
     * @return A Java Future containing the result of the GetPlayerConnectionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetPlayerConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetPlayerConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPlayerConnectionStatusResponse> getPlayerConnectionStatus(
            GetPlayerConnectionStatusRequest getPlayerConnectionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of a player's connection to the game runtime.
     * </p>
     * <p>
     * It's possible for a single player to have multiple connections to the game runtime. If a player is not connected,
     * this operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlayerConnectionStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetPlayerConnectionStatusRequest#builder()}
     * </p>
     *
     * @param getPlayerConnectionStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetPlayerConnectionStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPlayerConnectionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetPlayerConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetPlayerConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPlayerConnectionStatusResponse> getPlayerConnectionStatus(
            Consumer<GetPlayerConnectionStatusRequest.Builder> getPlayerConnectionStatusRequest) {
        return getPlayerConnectionStatus(GetPlayerConnectionStatusRequest.builder()
                .applyMutation(getPlayerConnectionStatusRequest).build());
    }

    /**
     * <p>
     * Gets a copy of the game configuration in a snapshot.
     * </p>
     *
     * @param getSnapshotRequest
     * @return A Java Future containing the result of the GetSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSnapshotResponse> getSnapshot(GetSnapshotRequest getSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a copy of the game configuration in a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link GetSnapshotRequest#builder()}
     * </p>
     *
     * @param getSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link GetSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSnapshotResponse> getSnapshot(Consumer<GetSnapshotRequest.Builder> getSnapshotRequest) {
        return getSnapshot(GetSnapshotRequest.builder().applyMutation(getSnapshotRequest).build());
    }

    /**
     * <p>
     * Gets information about a stage.
     * </p>
     *
     * @param getStageRequest
     * @return A Java Future containing the result of the GetStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStageResponse> getStage(GetStageRequest getStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStageRequest.Builder} avoiding the need to
     * create one manually via {@link GetStageRequest#builder()}
     * </p>
     *
     * @param getStageRequest
     *        A {@link Consumer} that will call methods on {@link GetStageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStageResponse> getStage(Consumer<GetStageRequest.Builder> getStageRequest) {
        return getStage(GetStageRequest.builder().applyMutation(getStageRequest).build());
    }

    /**
     * <p>
     * Gets information about a stage deployment.
     * </p>
     *
     * @param getStageDeploymentRequest
     * @return A Java Future containing the result of the GetStageDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetStageDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetStageDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStageDeploymentResponse> getStageDeployment(GetStageDeploymentRequest getStageDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a stage deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStageDeploymentRequest.Builder} avoiding the
     * need to create one manually via {@link GetStageDeploymentRequest#builder()}
     * </p>
     *
     * @param getStageDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link GetStageDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetStageDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.GetStageDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetStageDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStageDeploymentResponse> getStageDeployment(
            Consumer<GetStageDeploymentRequest.Builder> getStageDeploymentRequest) {
        return getStageDeployment(GetStageDeploymentRequest.builder().applyMutation(getStageDeploymentRequest).build());
    }

    /**
     * <p>
     * Imports a game configuration.
     * </p>
     * <p>
     * This operation replaces the current configuration of the game with the provided input. This is not a reversible
     * operation. If you want to preserve the previous configuration, use <code>CreateSnapshot</code> to make a new
     * snapshot before importing.
     * </p>
     *
     * @param importGameConfigurationRequest
     * @return A Java Future containing the result of the ImportGameConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>ServiceQuotaExceededException The request would result in exceeding service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ImportGameConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ImportGameConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportGameConfigurationResponse> importGameConfiguration(
            ImportGameConfigurationRequest importGameConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a game configuration.
     * </p>
     * <p>
     * This operation replaces the current configuration of the game with the provided input. This is not a reversible
     * operation. If you want to preserve the previous configuration, use <code>CreateSnapshot</code> to make a new
     * snapshot before importing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportGameConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link ImportGameConfigurationRequest#builder()}
     * </p>
     *
     * @param importGameConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link ImportGameConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ImportGameConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>ServiceQuotaExceededException The request would result in exceeding service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ImportGameConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ImportGameConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportGameConfigurationResponse> importGameConfiguration(
            Consumer<ImportGameConfigurationRequest.Builder> importGameConfigurationRequest) {
        return importGameConfiguration(ImportGameConfigurationRequest.builder().applyMutation(importGameConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Gets a paginated list of available versions for the extension.
     * </p>
     * <p>
     * Each time an API change is made to an extension, the version is incremented. The list retrieved by this operation
     * shows the versions that are currently available.
     * </p>
     *
     * @param listExtensionVersionsRequest
     * @return A Java Future containing the result of the ListExtensionVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListExtensionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListExtensionVersionsResponse> listExtensionVersions(
            ListExtensionVersionsRequest listExtensionVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of available versions for the extension.
     * </p>
     * <p>
     * Each time an API change is made to an extension, the version is incremented. The list retrieved by this operation
     * shows the versions that are currently available.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExtensionVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListExtensionVersionsRequest#builder()}
     * </p>
     *
     * @param listExtensionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListExtensionVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListExtensionVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListExtensionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListExtensionVersionsResponse> listExtensionVersions(
            Consumer<ListExtensionVersionsRequest.Builder> listExtensionVersionsRequest) {
        return listExtensionVersions(ListExtensionVersionsRequest.builder().applyMutation(listExtensionVersionsRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of available versions for the extension.
     * </p>
     * <p>
     * Each time an API change is made to an extension, the version is incremented. The list retrieved by this operation
     * shows the versions that are currently available.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExtensionVersions(software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionVersionsPublisher publisher = client.listExtensionVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionVersionsPublisher publisher = client.listExtensionVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExtensionVersions(software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listExtensionVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListExtensionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExtensionVersionsPublisher listExtensionVersionsPaginator(
            ListExtensionVersionsRequest listExtensionVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of available versions for the extension.
     * </p>
     * <p>
     * Each time an API change is made to an extension, the version is incremented. The list retrieved by this operation
     * shows the versions that are currently available.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExtensionVersions(software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionVersionsPublisher publisher = client.listExtensionVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionVersionsPublisher publisher = client.listExtensionVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExtensionVersions(software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExtensionVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListExtensionVersionsRequest#builder()}
     * </p>
     *
     * @param listExtensionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListExtensionVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListExtensionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExtensionVersionsPublisher listExtensionVersionsPaginator(
            Consumer<ListExtensionVersionsRequest.Builder> listExtensionVersionsRequest) {
        return listExtensionVersionsPaginator(ListExtensionVersionsRequest.builder().applyMutation(listExtensionVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a paginated list of available extensions.
     * </p>
     * <p>
     * Extensions provide features that games can use from scripts.
     * </p>
     *
     * @param listExtensionsRequest
     * @return A Java Future containing the result of the ListExtensions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExtensionsResponse> listExtensions(ListExtensionsRequest listExtensionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of available extensions.
     * </p>
     * <p>
     * Extensions provide features that games can use from scripts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExtensionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExtensionsRequest#builder()}
     * </p>
     *
     * @param listExtensionsRequest
     *        A {@link Consumer} that will call methods on {@link ListExtensionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListExtensions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExtensionsResponse> listExtensions(Consumer<ListExtensionsRequest.Builder> listExtensionsRequest) {
        return listExtensions(ListExtensionsRequest.builder().applyMutation(listExtensionsRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of available extensions.
     * </p>
     * <p>
     * Extensions provide features that games can use from scripts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExtensions(software.amazon.awssdk.services.gamesparks.model.ListExtensionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionsPublisher publisher = client.listExtensionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionsPublisher publisher = client.listExtensionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamesparks.model.ListExtensionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamesparks.model.ListExtensionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExtensions(software.amazon.awssdk.services.gamesparks.model.ListExtensionsRequest)} operation.</b>
     * </p>
     *
     * @param listExtensionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExtensionsPublisher listExtensionsPaginator(ListExtensionsRequest listExtensionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of available extensions.
     * </p>
     * <p>
     * Extensions provide features that games can use from scripts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExtensions(software.amazon.awssdk.services.gamesparks.model.ListExtensionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionsPublisher publisher = client.listExtensionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionsPublisher publisher = client.listExtensionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamesparks.model.ListExtensionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamesparks.model.ListExtensionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExtensions(software.amazon.awssdk.services.gamesparks.model.ListExtensionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExtensionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExtensionsRequest#builder()}
     * </p>
     *
     * @param listExtensionsRequest
     *        A {@link Consumer} that will call methods on {@link ListExtensionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExtensionsPublisher listExtensionsPaginator(Consumer<ListExtensionsRequest.Builder> listExtensionsRequest) {
        return listExtensionsPaginator(ListExtensionsRequest.builder().applyMutation(listExtensionsRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of games.
     * </p>
     *
     * @param listGamesRequest
     * @return A Java Future containing the result of the ListGames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListGames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGames" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGamesResponse> listGames(ListGamesRequest listGamesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of games.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGamesRequest.Builder} avoiding the need to
     * create one manually via {@link ListGamesRequest#builder()}
     * </p>
     *
     * @param listGamesRequest
     *        A {@link Consumer} that will call methods on {@link ListGamesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListGames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGames" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGamesResponse> listGames(Consumer<ListGamesRequest.Builder> listGamesRequest) {
        return listGames(ListGamesRequest.builder().applyMutation(listGamesRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of games.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGames(software.amazon.awssdk.services.gamesparks.model.ListGamesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGamesPublisher publisher = client.listGamesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGamesPublisher publisher = client.listGamesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamesparks.model.ListGamesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamesparks.model.ListGamesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGames(software.amazon.awssdk.services.gamesparks.model.ListGamesRequest)} operation.</b>
     * </p>
     *
     * @param listGamesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListGames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGames" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGamesPublisher listGamesPaginator(ListGamesRequest listGamesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of games.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGames(software.amazon.awssdk.services.gamesparks.model.ListGamesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGamesPublisher publisher = client.listGamesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGamesPublisher publisher = client.listGamesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamesparks.model.ListGamesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamesparks.model.ListGamesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGames(software.amazon.awssdk.services.gamesparks.model.ListGamesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGamesRequest.Builder} avoiding the need to
     * create one manually via {@link ListGamesRequest#builder()}
     * </p>
     *
     * @param listGamesRequest
     *        A {@link Consumer} that will call methods on {@link ListGamesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListGames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGames" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGamesPublisher listGamesPaginator(Consumer<ListGamesRequest.Builder> listGamesRequest) {
        return listGamesPaginator(ListGamesRequest.builder().applyMutation(listGamesRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of code generation jobs for a snapshot.
     * </p>
     *
     * @param listGeneratedCodeJobsRequest
     * @return A Java Future containing the result of the ListGeneratedCodeJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListGeneratedCodeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGeneratedCodeJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGeneratedCodeJobsResponse> listGeneratedCodeJobs(
            ListGeneratedCodeJobsRequest listGeneratedCodeJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of code generation jobs for a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeneratedCodeJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGeneratedCodeJobsRequest#builder()}
     * </p>
     *
     * @param listGeneratedCodeJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListGeneratedCodeJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGeneratedCodeJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListGeneratedCodeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGeneratedCodeJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGeneratedCodeJobsResponse> listGeneratedCodeJobs(
            Consumer<ListGeneratedCodeJobsRequest.Builder> listGeneratedCodeJobsRequest) {
        return listGeneratedCodeJobs(ListGeneratedCodeJobsRequest.builder().applyMutation(listGeneratedCodeJobsRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of code generation jobs for a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGeneratedCodeJobs(software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGeneratedCodeJobsPublisher publisher = client.listGeneratedCodeJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGeneratedCodeJobsPublisher publisher = client.listGeneratedCodeJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGeneratedCodeJobs(software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGeneratedCodeJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListGeneratedCodeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGeneratedCodeJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGeneratedCodeJobsPublisher listGeneratedCodeJobsPaginator(
            ListGeneratedCodeJobsRequest listGeneratedCodeJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of code generation jobs for a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGeneratedCodeJobs(software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGeneratedCodeJobsPublisher publisher = client.listGeneratedCodeJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGeneratedCodeJobsPublisher publisher = client.listGeneratedCodeJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGeneratedCodeJobs(software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeneratedCodeJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGeneratedCodeJobsRequest#builder()}
     * </p>
     *
     * @param listGeneratedCodeJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListGeneratedCodeJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListGeneratedCodeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGeneratedCodeJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGeneratedCodeJobsPublisher listGeneratedCodeJobsPaginator(
            Consumer<ListGeneratedCodeJobsRequest.Builder> listGeneratedCodeJobsRequest) {
        return listGeneratedCodeJobsPaginator(ListGeneratedCodeJobsRequest.builder().applyMutation(listGeneratedCodeJobsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a paginated list of snapshot summaries from the game.
     * </p>
     *
     * @param listSnapshotsRequest
     * @return A Java Future containing the result of the ListSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSnapshotsResponse> listSnapshots(ListSnapshotsRequest listSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of snapshot summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSnapshotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSnapshotsRequest#builder()}
     * </p>
     *
     * @param listSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link ListSnapshotsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSnapshotsResponse> listSnapshots(Consumer<ListSnapshotsRequest.Builder> listSnapshotsRequest) {
        return listSnapshots(ListSnapshotsRequest.builder().applyMutation(listSnapshotsRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of snapshot summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSnapshots(software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListSnapshotsPublisher publisher = client.listSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListSnapshotsPublisher publisher = client.listSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamesparks.model.ListSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamesparks.model.ListSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSnapshots(software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest)} operation.</b>
     * </p>
     *
     * @param listSnapshotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSnapshotsPublisher listSnapshotsPaginator(ListSnapshotsRequest listSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of snapshot summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSnapshots(software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListSnapshotsPublisher publisher = client.listSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListSnapshotsPublisher publisher = client.listSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamesparks.model.ListSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamesparks.model.ListSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSnapshots(software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSnapshotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSnapshotsRequest#builder()}
     * </p>
     *
     * @param listSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link ListSnapshotsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSnapshotsPublisher listSnapshotsPaginator(Consumer<ListSnapshotsRequest.Builder> listSnapshotsRequest) {
        return listSnapshotsPaginator(ListSnapshotsRequest.builder().applyMutation(listSnapshotsRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of stage deployment summaries from the game.
     * </p>
     *
     * @param listStageDeploymentsRequest
     * @return A Java Future containing the result of the ListStageDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListStageDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStageDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStageDeploymentsResponse> listStageDeployments(
            ListStageDeploymentsRequest listStageDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of stage deployment summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStageDeploymentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStageDeploymentsRequest#builder()}
     * </p>
     *
     * @param listStageDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link ListStageDeploymentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStageDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListStageDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStageDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStageDeploymentsResponse> listStageDeployments(
            Consumer<ListStageDeploymentsRequest.Builder> listStageDeploymentsRequest) {
        return listStageDeployments(ListStageDeploymentsRequest.builder().applyMutation(listStageDeploymentsRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of stage deployment summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStageDeployments(software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStageDeploymentsPublisher publisher = client.listStageDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStageDeploymentsPublisher publisher = client.listStageDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStageDeployments(software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStageDeploymentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListStageDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStageDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStageDeploymentsPublisher listStageDeploymentsPaginator(ListStageDeploymentsRequest listStageDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of stage deployment summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStageDeployments(software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStageDeploymentsPublisher publisher = client.listStageDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStageDeploymentsPublisher publisher = client.listStageDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStageDeployments(software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStageDeploymentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStageDeploymentsRequest#builder()}
     * </p>
     *
     * @param listStageDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link ListStageDeploymentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListStageDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStageDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStageDeploymentsPublisher listStageDeploymentsPaginator(
            Consumer<ListStageDeploymentsRequest.Builder> listStageDeploymentsRequest) {
        return listStageDeploymentsPaginator(ListStageDeploymentsRequest.builder().applyMutation(listStageDeploymentsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a paginated list of stage summaries from the game.
     * </p>
     *
     * @param listStagesRequest
     * @return A Java Future containing the result of the ListStages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListStages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStagesResponse> listStages(ListStagesRequest listStagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of stage summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListStagesRequest#builder()}
     * </p>
     *
     * @param listStagesRequest
     *        A {@link Consumer} that will call methods on {@link ListStagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListStages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListStages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStagesResponse> listStages(Consumer<ListStagesRequest.Builder> listStagesRequest) {
        return listStages(ListStagesRequest.builder().applyMutation(listStagesRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of stage summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStages(software.amazon.awssdk.services.gamesparks.model.ListStagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStagesPublisher publisher = client.listStagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStagesPublisher publisher = client.listStagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamesparks.model.ListStagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamesparks.model.ListStagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStages(software.amazon.awssdk.services.gamesparks.model.ListStagesRequest)} operation.</b>
     * </p>
     *
     * @param listStagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListStages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStagesPublisher listStagesPaginator(ListStagesRequest listStagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of stage summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStages(software.amazon.awssdk.services.gamesparks.model.ListStagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStagesPublisher publisher = client.listStagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStagesPublisher publisher = client.listStagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamesparks.model.ListStagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamesparks.model.ListStagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStages(software.amazon.awssdk.services.gamesparks.model.ListStagesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListStagesRequest#builder()}
     * </p>
     *
     * @param listStagesRequest
     *        A {@link Consumer} that will call methods on {@link ListStagesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListStages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStagesPublisher listStagesPaginator(Consumer<ListStagesRequest.Builder> listStagesRequest) {
        return listStagesPaginator(ListStagesRequest.builder().applyMutation(listStagesRequest).build());
    }

    /**
     * <p>
     * Lists the tags associated with a GameSparks resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags associated with a GameSparks resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous process that generates client code for system-defined and custom messages. The resulting
     * code is collected as a .zip file and uploaded to a pre-signed Amazon S3 URL.
     * </p>
     *
     * @param startGeneratedCodeJobRequest
     * @return A Java Future containing the result of the StartGeneratedCodeJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.StartGeneratedCodeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/StartGeneratedCodeJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartGeneratedCodeJobResponse> startGeneratedCodeJob(
            StartGeneratedCodeJobRequest startGeneratedCodeJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous process that generates client code for system-defined and custom messages. The resulting
     * code is collected as a .zip file and uploaded to a pre-signed Amazon S3 URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartGeneratedCodeJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartGeneratedCodeJobRequest#builder()}
     * </p>
     *
     * @param startGeneratedCodeJobRequest
     *        A {@link Consumer} that will call methods on {@link StartGeneratedCodeJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartGeneratedCodeJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.StartGeneratedCodeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/StartGeneratedCodeJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartGeneratedCodeJobResponse> startGeneratedCodeJob(
            Consumer<StartGeneratedCodeJobRequest.Builder> startGeneratedCodeJobRequest) {
        return startGeneratedCodeJob(StartGeneratedCodeJobRequest.builder().applyMutation(startGeneratedCodeJobRequest).build());
    }

    /**
     * <p>
     * Deploys a snapshot to the stage and creates a new game runtime.
     * </p>
     * <p>
     * After you call this operation, you can check the deployment status by using <code>GetStageDeployment</code>.
     * </p>
     * <p>
     * If there are any players connected to the previous game runtime, then both runtimes persist. Existing connections
     * to the previous runtime are maintained. When players disconnect and reconnect, they connect to the new runtime.
     * After there are no connections to the previous game runtime, it is deleted.
     * </p>
     *
     * @param startStageDeploymentRequest
     * @return A Java Future containing the result of the StartStageDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.StartStageDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/StartStageDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartStageDeploymentResponse> startStageDeployment(
            StartStageDeploymentRequest startStageDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploys a snapshot to the stage and creates a new game runtime.
     * </p>
     * <p>
     * After you call this operation, you can check the deployment status by using <code>GetStageDeployment</code>.
     * </p>
     * <p>
     * If there are any players connected to the previous game runtime, then both runtimes persist. Existing connections
     * to the previous runtime are maintained. When players disconnect and reconnect, they connect to the new runtime.
     * After there are no connections to the previous game runtime, it is deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartStageDeploymentRequest.Builder} avoiding the
     * need to create one manually via {@link StartStageDeploymentRequest#builder()}
     * </p>
     *
     * @param startStageDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link StartStageDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartStageDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.StartStageDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/StartStageDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartStageDeploymentResponse> startStageDeployment(
            Consumer<StartStageDeploymentRequest.Builder> startStageDeploymentRequest) {
        return startStageDeployment(StartStageDeploymentRequest.builder().applyMutation(startStageDeploymentRequest).build());
    }

    /**
     * <p>
     * Adds tags to a GameSparks resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a GameSparks resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a GameSparks resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a GameSparks resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates details of the game.
     * </p>
     *
     * @param updateGameRequest
     * @return A Java Future containing the result of the UpdateGame operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.UpdateGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateGame" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGameResponse> updateGame(UpdateGameRequest updateGameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates details of the game.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGameRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGameRequest#builder()}
     * </p>
     *
     * @param updateGameRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGameRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGame operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.UpdateGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateGame" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGameResponse> updateGame(Consumer<UpdateGameRequest.Builder> updateGameRequest) {
        return updateGame(UpdateGameRequest.builder().applyMutation(updateGameRequest).build());
    }

    /**
     * <p>
     * Updates one or more sections of the game configuration.
     * </p>
     *
     * @param updateGameConfigurationRequest
     * @return A Java Future containing the result of the UpdateGameConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>ServiceQuotaExceededException The request would result in exceeding service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.UpdateGameConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateGameConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGameConfigurationResponse> updateGameConfiguration(
            UpdateGameConfigurationRequest updateGameConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates one or more sections of the game configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGameConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateGameConfigurationRequest#builder()}
     * </p>
     *
     * @param updateGameConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGameConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGameConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>ServiceQuotaExceededException The request would result in exceeding service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.UpdateGameConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateGameConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGameConfigurationResponse> updateGameConfiguration(
            Consumer<UpdateGameConfigurationRequest.Builder> updateGameConfigurationRequest) {
        return updateGameConfiguration(UpdateGameConfigurationRequest.builder().applyMutation(updateGameConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Updates the metadata of a GameSparks snapshot.
     * </p>
     *
     * @param updateSnapshotRequest
     * @return A Java Future containing the result of the UpdateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.UpdateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSnapshotResponse> updateSnapshot(UpdateSnapshotRequest updateSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the metadata of a GameSparks snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSnapshotRequest#builder()}
     * </p>
     *
     * @param updateSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.UpdateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSnapshotResponse> updateSnapshot(Consumer<UpdateSnapshotRequest.Builder> updateSnapshotRequest) {
        return updateSnapshot(UpdateSnapshotRequest.builder().applyMutation(updateSnapshotRequest).build());
    }

    /**
     * <p>
     * Updates the metadata of a stage.
     * </p>
     *
     * @param updateStageRequest
     * @return A Java Future containing the result of the UpdateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.UpdateStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStageResponse> updateStage(UpdateStageRequest updateStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the metadata of a stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStageRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStageRequest#builder()}
     * </p>
     *
     * @param updateStageRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InternalServerException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameSparksException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameSparksAsyncClient.UpdateStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStageResponse> updateStage(Consumer<UpdateStageRequest.Builder> updateStageRequest) {
        return updateStage(UpdateStageRequest.builder().applyMutation(updateStageRequest).build());
    }

    @Override
    default GameSparksServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link GameSparksAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GameSparksAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GameSparksAsyncClient}.
     */
    static GameSparksAsyncClientBuilder builder() {
        return new DefaultGameSparksAsyncClientBuilder();
    }
}
