/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the extension version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExtensionVersionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExtensionVersionDetails.Builder, ExtensionVersionDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ExtensionVersionDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(ExtensionVersionDetails::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Schema")
            .getter(getter(ExtensionVersionDetails::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(ExtensionVersionDetails::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NAMESPACE_FIELD,
            SCHEMA_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String namespace;

    private final String schema;

    private final String version;

    private ExtensionVersionDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.namespace = builder.namespace;
        this.schema = builder.schema;
        this.version = builder.version;
    }

    /**
     * <p>
     * The name of the extension.
     * </p>
     * 
     * @return The name of the extension.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The namespace (qualifier) of the extension.
     * </p>
     * 
     * @return The namespace (qualifier) of the extension.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The model that defines the interface for this extension version.
     * </p>
     * 
     * @return The model that defines the interface for this extension version.
     */
    public final String schema() {
        return schema;
    }

    /**
     * <p>
     * The version of the extension.
     * </p>
     * 
     * @return The version of the extension.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtensionVersionDetails)) {
            return false;
        }
        ExtensionVersionDetails other = (ExtensionVersionDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(schema(), other.schema()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExtensionVersionDetails").add("Name", name()).add("Namespace", namespace())
                .add("Schema", schema()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExtensionVersionDetails, T> g) {
        return obj -> g.apply((ExtensionVersionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExtensionVersionDetails> {
        /**
         * <p>
         * The name of the extension.
         * </p>
         * 
         * @param name
         *        The name of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The namespace (qualifier) of the extension.
         * </p>
         * 
         * @param namespace
         *        The namespace (qualifier) of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The model that defines the interface for this extension version.
         * </p>
         * 
         * @param schema
         *        The model that defines the interface for this extension version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * The version of the extension.
         * </p>
         * 
         * @param version
         *        The version of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String namespace;

        private String schema;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtensionVersionDetails model) {
            name(model.name);
            namespace(model.namespace);
            schema(model.schema);
            version(model.version);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public ExtensionVersionDetails build() {
            return new ExtensionVersionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
