/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geomaps;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.geomaps.model.GetGlyphsRequest;
import software.amazon.awssdk.services.geomaps.model.GetGlyphsResponse;
import software.amazon.awssdk.services.geomaps.model.GetSpritesRequest;
import software.amazon.awssdk.services.geomaps.model.GetSpritesResponse;
import software.amazon.awssdk.services.geomaps.model.GetStaticMapRequest;
import software.amazon.awssdk.services.geomaps.model.GetStaticMapResponse;
import software.amazon.awssdk.services.geomaps.model.GetStyleDescriptorRequest;
import software.amazon.awssdk.services.geomaps.model.GetStyleDescriptorResponse;
import software.amazon.awssdk.services.geomaps.model.GetTileRequest;
import software.amazon.awssdk.services.geomaps.model.GetTileResponse;

/**
 * Service client for accessing Amazon Location Service Maps V2 asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Integrate high-quality base map data into your applications using <a href="https://maplibre.org">MapLibre</a>.
 * Capabilities include:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Access to comprehensive base map data, allowing you to tailor the map display to your specific needs.
 * </p>
 * </li>
 * <li>
 * <p>
 * Multiple pre-designed map styles suited for various application types, such as navigation, logistics, or data
 * visualization.
 * </p>
 * </li>
 * <li>
 * <p>
 * Generation of static map images for scenarios where interactive maps aren't suitable, such as:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Embedding in emails or documents
 * </p>
 * </li>
 * <li>
 * <p>
 * Displaying in low-bandwidth environments
 * </p>
 * </li>
 * <li>
 * <p>
 * Creating printable maps
 * </p>
 * </li>
 * <li>
 * <p>
 * Enhancing application performance by reducing client-side rendering
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GeoMapsAsyncClient extends AwsClient {
    String SERVICE_NAME = "geo-maps";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "geo-maps";

    /**
     * <p>
     * Returns the map's glyphs.
     * </p>
     *
     * @param getGlyphsRequest
     * @return A Java Future containing the result of the GetGlyphs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoMapsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoMapsAsyncClient.GetGlyphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetGlyphs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGlyphsResponse> getGlyphs(GetGlyphsRequest getGlyphsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the map's glyphs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGlyphsRequest.Builder} avoiding the need to
     * create one manually via {@link GetGlyphsRequest#builder()}
     * </p>
     *
     * @param getGlyphsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geomaps.model.GetGlyphsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGlyphs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoMapsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoMapsAsyncClient.GetGlyphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetGlyphs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGlyphsResponse> getGlyphs(Consumer<GetGlyphsRequest.Builder> getGlyphsRequest) {
        return getGlyphs(GetGlyphsRequest.builder().applyMutation(getGlyphsRequest).build());
    }

    /**
     * <p>
     * Returns the map's sprites.
     * </p>
     *
     * @param getSpritesRequest
     * @return A Java Future containing the result of the GetSprites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoMapsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoMapsAsyncClient.GetSprites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetSprites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSpritesResponse> getSprites(GetSpritesRequest getSpritesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the map's sprites.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSpritesRequest.Builder} avoiding the need to
     * create one manually via {@link GetSpritesRequest#builder()}
     * </p>
     *
     * @param getSpritesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geomaps.model.GetSpritesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSprites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoMapsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoMapsAsyncClient.GetSprites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetSprites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSpritesResponse> getSprites(Consumer<GetSpritesRequest.Builder> getSpritesRequest) {
        return getSprites(GetSpritesRequest.builder().applyMutation(getSpritesRequest).build());
    }

    /**
     * <p>
     * Provides high-quality static map images with customizable options. You can modify the map's appearance and
     * overlay additional information. It's an ideal solution for applications requiring tailored static map snapshots.
     * </p>
     *
     * @param getStaticMapRequest
     * @return A Java Future containing the result of the GetStaticMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoMapsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoMapsAsyncClient.GetStaticMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetStaticMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStaticMapResponse> getStaticMap(GetStaticMapRequest getStaticMapRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides high-quality static map images with customizable options. You can modify the map's appearance and
     * overlay additional information. It's an ideal solution for applications requiring tailored static map snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStaticMapRequest.Builder} avoiding the need to
     * create one manually via {@link GetStaticMapRequest#builder()}
     * </p>
     *
     * @param getStaticMapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geomaps.model.GetStaticMapRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetStaticMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoMapsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoMapsAsyncClient.GetStaticMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetStaticMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStaticMapResponse> getStaticMap(Consumer<GetStaticMapRequest.Builder> getStaticMapRequest) {
        return getStaticMap(GetStaticMapRequest.builder().applyMutation(getStaticMapRequest).build());
    }

    /**
     * <p>
     * Returns information about the style.
     * </p>
     *
     * @param getStyleDescriptorRequest
     * @return A Java Future containing the result of the GetStyleDescriptor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoMapsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoMapsAsyncClient.GetStyleDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetStyleDescriptor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStyleDescriptorResponse> getStyleDescriptor(GetStyleDescriptorRequest getStyleDescriptorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the style.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStyleDescriptorRequest.Builder} avoiding the
     * need to create one manually via {@link GetStyleDescriptorRequest#builder()}
     * </p>
     *
     * @param getStyleDescriptorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geomaps.model.GetStyleDescriptorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetStyleDescriptor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoMapsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoMapsAsyncClient.GetStyleDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetStyleDescriptor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStyleDescriptorResponse> getStyleDescriptor(
            Consumer<GetStyleDescriptorRequest.Builder> getStyleDescriptorRequest) {
        return getStyleDescriptor(GetStyleDescriptorRequest.builder().applyMutation(getStyleDescriptorRequest).build());
    }

    /**
     * <p>
     * Returns a tile. Map tiles are used by clients to render a map. they're addressed using a grid arrangement with an
     * X coordinate, Y coordinate, and Z (zoom) level.
     * </p>
     *
     * @param getTileRequest
     * @return A Java Future containing the result of the GetTile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoMapsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoMapsAsyncClient.GetTile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetTile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTileResponse> getTile(GetTileRequest getTileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a tile. Map tiles are used by clients to render a map. they're addressed using a grid arrangement with an
     * X coordinate, Y coordinate, and Z (zoom) level.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTileRequest.Builder} avoiding the need to create
     * one manually via {@link GetTileRequest#builder()}
     * </p>
     *
     * @param getTileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geomaps.model.GetTileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because of insufficient access or permissions. Check
     *         with an administrator to verify your permissions.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoMapsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoMapsAsyncClient.GetTile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetTile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTileResponse> getTile(Consumer<GetTileRequest.Builder> getTileRequest) {
        return getTile(GetTileRequest.builder().applyMutation(getTileRequest).build());
    }

    @Override
    default GeoMapsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link GeoMapsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GeoMapsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GeoMapsAsyncClient}.
     */
    static GeoMapsAsyncClientBuilder builder() {
        return new DefaultGeoMapsAsyncClientBuilder();
    }
}
