/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Integrate high-quality base map data into your applications using <a href="https://maplibre.org">MapLibre</a>.
 * Capabilities include:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Access to comprehensive base map data, allowing you to tailor the map display to your specific needs.
 * </p>
 * </li>
 * <li>
 * <p>
 * Multiple pre-designed map styles suited for various application types, such as navigation, logistics, or data
 * visualization.
 * </p>
 * </li>
 * <li>
 * <p>
 * Generation of static map images for scenarios where interactive maps aren't suitable, such as:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Embedding in emails or documents
 * </p>
 * </li>
 * <li>
 * <p>
 * Displaying in low-bandwidth environments
 * </p>
 * </li>
 * <li>
 * <p>
 * Creating printable maps
 * </p>
 * </li>
 * <li>
 * <p>
 * Enhancing application performance by reducing client-side rendering
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 */
package software.amazon.awssdk.services.geomaps;