/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geomaps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.geomaps.model.ColorScheme;
import software.amazon.awssdk.services.geomaps.model.GeoMapsRequest;
import software.amazon.awssdk.services.geomaps.model.MapStyle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStyleDescriptorRequest
extends GeoMapsRequest
implements ToCopyableBuilder<Builder, GetStyleDescriptorRequest> {
    private static final SdkField<String> STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Style").getter(GetStyleDescriptorRequest.getter(GetStyleDescriptorRequest::styleAsString)).setter(GetStyleDescriptorRequest.setter(Builder::style)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Style").build()}).build();
    private static final SdkField<String> COLOR_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorScheme").getter(GetStyleDescriptorRequest.getter(GetStyleDescriptorRequest::colorSchemeAsString)).setter(GetStyleDescriptorRequest.setter(Builder::colorScheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("color-scheme").build()}).build();
    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoliticalView").getter(GetStyleDescriptorRequest.getter(GetStyleDescriptorRequest::politicalView)).setter(GetStyleDescriptorRequest.setter(Builder::politicalView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("political-view").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(GetStyleDescriptorRequest.getter(GetStyleDescriptorRequest::key)).setter(GetStyleDescriptorRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STYLE_FIELD, COLOR_SCHEME_FIELD, POLITICAL_VIEW_FIELD, KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetStyleDescriptorRequest.memberNameToFieldInitializer();
    private final String style;
    private final String colorScheme;
    private final String politicalView;
    private final String key;

    private GetStyleDescriptorRequest(BuilderImpl builder) {
        super(builder);
        this.style = builder.style;
        this.colorScheme = builder.colorScheme;
        this.politicalView = builder.politicalView;
        this.key = builder.key;
    }

    public final MapStyle style() {
        return MapStyle.fromValue(this.style);
    }

    public final String styleAsString() {
        return this.style;
    }

    public final ColorScheme colorScheme() {
        return ColorScheme.fromValue(this.colorScheme);
    }

    public final String colorSchemeAsString() {
        return this.colorScheme;
    }

    public final String politicalView() {
        return this.politicalView;
    }

    public final String key() {
        return this.key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.styleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStyleDescriptorRequest)) {
            return false;
        }
        GetStyleDescriptorRequest other = (GetStyleDescriptorRequest)((Object)obj);
        return Objects.equals(this.styleAsString(), other.styleAsString()) && Objects.equals(this.colorSchemeAsString(), other.colorSchemeAsString()) && Objects.equals(this.politicalView(), other.politicalView()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"GetStyleDescriptorRequest").add("Style", (Object)this.styleAsString()).add("ColorScheme", (Object)this.colorSchemeAsString()).add("PoliticalView", (Object)this.politicalView()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Style": {
                return Optional.ofNullable(clazz.cast(this.styleAsString()));
            }
            case "ColorScheme": {
                return Optional.ofNullable(clazz.cast(this.colorSchemeAsString()));
            }
            case "PoliticalView": {
                return Optional.ofNullable(clazz.cast(this.politicalView()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Style", STYLE_FIELD);
        map.put("color-scheme", COLOR_SCHEME_FIELD);
        map.put("political-view", POLITICAL_VIEW_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStyleDescriptorRequest, T> g) {
        return obj -> g.apply((GetStyleDescriptorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoMapsRequest.BuilderImpl
    implements Builder {
        private String style;
        private String colorScheme;
        private String politicalView;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStyleDescriptorRequest model) {
            super(model);
            this.style(model.style);
            this.colorScheme(model.colorScheme);
            this.politicalView(model.politicalView);
            this.key(model.key);
        }

        public final String getStyle() {
            return this.style;
        }

        public final void setStyle(String style) {
            this.style = style;
        }

        @Override
        public final Builder style(String style) {
            this.style = style;
            return this;
        }

        @Override
        public final Builder style(MapStyle style) {
            this.style(style == null ? null : style.toString());
            return this;
        }

        public final String getColorScheme() {
            return this.colorScheme;
        }

        public final void setColorScheme(String colorScheme) {
            this.colorScheme = colorScheme;
        }

        @Override
        public final Builder colorScheme(String colorScheme) {
            this.colorScheme = colorScheme;
            return this;
        }

        @Override
        public final Builder colorScheme(ColorScheme colorScheme) {
            this.colorScheme(colorScheme == null ? null : colorScheme.toString());
            return this;
        }

        public final String getPoliticalView() {
            return this.politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetStyleDescriptorRequest build() {
            return new GetStyleDescriptorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GeoMapsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStyleDescriptorRequest> {
        public Builder style(String var1);

        public Builder style(MapStyle var1);

        public Builder colorScheme(String var1);

        public Builder colorScheme(ColorScheme var1);

        public Builder politicalView(String var1);

        public Builder key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

