/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geomaps;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.geomaps.model.AccessDeniedException;
import software.amazon.awssdk.services.geomaps.model.GeoMapsException;
import software.amazon.awssdk.services.geomaps.model.GetGlyphsRequest;
import software.amazon.awssdk.services.geomaps.model.GetGlyphsResponse;
import software.amazon.awssdk.services.geomaps.model.GetSpritesRequest;
import software.amazon.awssdk.services.geomaps.model.GetSpritesResponse;
import software.amazon.awssdk.services.geomaps.model.GetStaticMapRequest;
import software.amazon.awssdk.services.geomaps.model.GetStaticMapResponse;
import software.amazon.awssdk.services.geomaps.model.GetStyleDescriptorRequest;
import software.amazon.awssdk.services.geomaps.model.GetStyleDescriptorResponse;
import software.amazon.awssdk.services.geomaps.model.GetTileRequest;
import software.amazon.awssdk.services.geomaps.model.GetTileResponse;
import software.amazon.awssdk.services.geomaps.model.InternalServerException;
import software.amazon.awssdk.services.geomaps.model.ResourceNotFoundException;
import software.amazon.awssdk.services.geomaps.model.ThrottlingException;
import software.amazon.awssdk.services.geomaps.model.ValidationException;

/**
 * Service client for accessing Amazon Location Service Maps V2. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Integrate high-quality base map data into your applications using <a href="https://maplibre.org">MapLibre</a>.
 * Capabilities include:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Access to comprehensive base map data, allowing you to tailor the map display to your specific needs.
 * </p>
 * </li>
 * <li>
 * <p>
 * Multiple pre-designed map styles suited for various application types, such as navigation, logistics, or data
 * visualization.
 * </p>
 * </li>
 * <li>
 * <p>
 * Generation of static map images for scenarios where interactive maps aren't suitable, such as:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Embedding in emails or documents
 * </p>
 * </li>
 * <li>
 * <p>
 * Displaying in low-bandwidth environments
 * </p>
 * </li>
 * <li>
 * <p>
 * Creating printable maps
 * </p>
 * </li>
 * <li>
 * <p>
 * Enhancing application performance by reducing client-side rendering
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GeoMapsClient extends AwsClient {
    String SERVICE_NAME = "geo-maps";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "geo-maps";

    /**
     * <p>
     * <code>GetGlyphs</code> returns the map's glyphs.
     * </p>
     *
     * @param getGlyphsRequest
     * @return Result of the GetGlyphs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoMapsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoMapsClient.GetGlyphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetGlyphs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGlyphsResponse getGlyphs(GetGlyphsRequest getGlyphsRequest) throws AwsServiceException, SdkClientException,
            GeoMapsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>GetGlyphs</code> returns the map's glyphs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGlyphsRequest.Builder} avoiding the need to
     * create one manually via {@link GetGlyphsRequest#builder()}
     * </p>
     *
     * @param getGlyphsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geomaps.model.GetGlyphsRequest.Builder} to create a request.
     * @return Result of the GetGlyphs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoMapsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoMapsClient.GetGlyphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetGlyphs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGlyphsResponse getGlyphs(Consumer<GetGlyphsRequest.Builder> getGlyphsRequest) throws AwsServiceException,
            SdkClientException, GeoMapsException {
        return getGlyphs(GetGlyphsRequest.builder().applyMutation(getGlyphsRequest).build());
    }

    /**
     * <p>
     * <code>GetSprites</code> returns the map's sprites.
     * </p>
     *
     * @param getSpritesRequest
     * @return Result of the GetSprites operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoMapsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoMapsClient.GetSprites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetSprites" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSpritesResponse getSprites(GetSpritesRequest getSpritesRequest) throws AwsServiceException, SdkClientException,
            GeoMapsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>GetSprites</code> returns the map's sprites.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSpritesRequest.Builder} avoiding the need to
     * create one manually via {@link GetSpritesRequest#builder()}
     * </p>
     *
     * @param getSpritesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geomaps.model.GetSpritesRequest.Builder} to create a request.
     * @return Result of the GetSprites operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoMapsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoMapsClient.GetSprites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetSprites" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSpritesResponse getSprites(Consumer<GetSpritesRequest.Builder> getSpritesRequest) throws AwsServiceException,
            SdkClientException, GeoMapsException {
        return getSprites(GetSpritesRequest.builder().applyMutation(getSpritesRequest).build());
    }

    /**
     * <p>
     * <code>GetStaticMap</code> provides high-quality static map images with customizable options. You can modify the
     * map's appearance and overlay additional information. It's an ideal solution for applications requiring tailored
     * static map snapshots.
     * </p>
     *
     * @param getStaticMapRequest
     * @return Result of the GetStaticMap operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoMapsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoMapsClient.GetStaticMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetStaticMap" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStaticMapResponse getStaticMap(GetStaticMapRequest getStaticMapRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            GeoMapsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>GetStaticMap</code> provides high-quality static map images with customizable options. You can modify the
     * map's appearance and overlay additional information. It's an ideal solution for applications requiring tailored
     * static map snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStaticMapRequest.Builder} avoiding the need to
     * create one manually via {@link GetStaticMapRequest#builder()}
     * </p>
     *
     * @param getStaticMapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geomaps.model.GetStaticMapRequest.Builder} to create a request.
     * @return Result of the GetStaticMap operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoMapsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoMapsClient.GetStaticMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetStaticMap" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStaticMapResponse getStaticMap(Consumer<GetStaticMapRequest.Builder> getStaticMapRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, GeoMapsException {
        return getStaticMap(GetStaticMapRequest.builder().applyMutation(getStaticMapRequest).build());
    }

    /**
     * <p>
     * <code>GetStyleDescriptor</code> returns information about the style.
     * </p>
     *
     * @param getStyleDescriptorRequest
     * @return Result of the GetStyleDescriptor operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoMapsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoMapsClient.GetStyleDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetStyleDescriptor" target="_top">AWS
     *      API Documentation</a>
     */
    default GetStyleDescriptorResponse getStyleDescriptor(GetStyleDescriptorRequest getStyleDescriptorRequest)
            throws AwsServiceException, SdkClientException, GeoMapsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>GetStyleDescriptor</code> returns information about the style.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStyleDescriptorRequest.Builder} avoiding the
     * need to create one manually via {@link GetStyleDescriptorRequest#builder()}
     * </p>
     *
     * @param getStyleDescriptorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geomaps.model.GetStyleDescriptorRequest.Builder} to create a
     *        request.
     * @return Result of the GetStyleDescriptor operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoMapsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoMapsClient.GetStyleDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetStyleDescriptor" target="_top">AWS
     *      API Documentation</a>
     */
    default GetStyleDescriptorResponse getStyleDescriptor(Consumer<GetStyleDescriptorRequest.Builder> getStyleDescriptorRequest)
            throws AwsServiceException, SdkClientException, GeoMapsException {
        return getStyleDescriptor(GetStyleDescriptorRequest.builder().applyMutation(getStyleDescriptorRequest).build());
    }

    /**
     * <p>
     * <code>GetTile</code> returns a tile. Map tiles are used by clients to render a map. they're addressed using a
     * grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level.
     * </p>
     *
     * @param getTileRequest
     * @return Result of the GetTile operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         Exception thrown when the associated resource could not be found.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoMapsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoMapsClient.GetTile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetTile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTileResponse getTile(GetTileRequest getTileRequest) throws InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            GeoMapsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>GetTile</code> returns a tile. Map tiles are used by clients to render a map. they're addressed using a
     * grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTileRequest.Builder} avoiding the need to create
     * one manually via {@link GetTileRequest#builder()}
     * </p>
     *
     * @param getTileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.geomaps.model.GetTileRequest.Builder} to create a request.
     * @return Result of the GetTile operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ResourceNotFoundException
     *         Exception thrown when the associated resource could not be found.
     * @throws AccessDeniedException
     *         The request was denied because of insufficient access or permissions. Check with an administrator to
     *         verify your permissions.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GeoMapsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GeoMapsClient.GetTile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-maps-2020-11-19/GetTile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTileResponse getTile(Consumer<GetTileRequest.Builder> getTileRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, GeoMapsException {
        return getTile(GetTileRequest.builder().applyMutation(getTileRequest).build());
    }

    /**
     * Create a {@link GeoMapsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GeoMapsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GeoMapsClient}.
     */
    static GeoMapsClientBuilder builder() {
        return new DefaultGeoMapsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default GeoMapsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
